/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.BluetoothBean;
import com.nttdocomo.dojaemu.ktoolbar.BluetoothDeviceBean;
import com.nttdocomo.dojaemu.ktoolbar.BluetoothDeviceDataBean;
import com.nttdocomo.dojaemu.ktoolbar.BluetoothMDEPBean;
import com.nttdocomo.dojaemu.ktoolbar.BluetoothMDEPCsvReader;
import com.nttdocomo.dojaemu.ktoolbar.BluetoothMDEPCsvRecord;
import com.nttdocomo.dojaemu.ktoolbar.BluetoothMDEPCsvWriter;
import com.nttdocomo.dojaemu.ktoolbar.Const;
import com.nttdocomo.dojaemu.ktoolbar.IniFileEntity;
import com.nttdocomo.dojaemu.ktoolbar.LastselectedComparator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class BluetoothManager {
    private static final String MDEP_FILE_NAME = "mdep.dat";
    private static final String INPUT_FILE_NAME = "input.dat";
    public static final int COD_VALUE_PC = 260;
    public static final int COD_VALUE_MOBILE = 516;
    public static final int COD_VALUE_BLOOD_PRESSURE_MONITOR = 7;
    public static final int COD_VALUE_THERMOMETER = 8;
    private static final String DEFAULT_DEVICETYPE = Integer.toString(516);
    private static final String DEFAULT_DEVICEADDR = "112233445566";
    private static final String DEFAULT_DEVICENAME = "StarBluetooth";
    private static final String DEFAULT_HOST = "127.0.0.1";
    private static final String DEFAULT_UUID = "1234";
    private static final String DEFAULT_LOCALNAME = "LocalName";
    private static final String DEFAULT_SPECDATA = "123456";
    private static final String DEFAULT_COUNT = "0";
    private static final String DEFAULT_MAXCONNECTION = "3";
    private static final String SECTION_OWNDEVICE = "OwnDevice";
    private static final String KEY_DEVICENAME = "deviceName";
    private static final String KEY_DEVICETYPE = "deviceType";
    private static final String KEY_SPECDATA = "specData";
    private static final String KEY_LOCALNAME = "localName";
    private static final String KEY_UUID = "uuid";
    private static final String SECTION_DEVICE = "Device";
    private static final String KEY_COUNT = "count";
    private static final String SECTION_DEVICE_PREFIX = "Device_";
    private static final String KEY_DEVICEADDR = "deviceAddr";
    private static final String KEY_SPP = "spp";
    private static final String KEY_HDP = "hdp";
    private static final String KEY_REGISTERED = "registered";
    private static final String KEY_LASTSELECTED = "lastSelected";
    private static final String SECTION_SCANNINGDEVICE = "ScanningDevice";
    private static final String KEY_MAXCONNECTION = "maxConnection";
    private static final String KEY_HOST = "host";
    private static final String KEY_PROJECTNAME = "projectName";
    private static final String BLUETOOTH_FILE_NAME = "bluetooth.ini";
    private static final String BLUETOOTH_FILENAME_PATH = Const.PATH_LIB_BLUETOOTH + "bluetooth.ini";
    private static final String DEVICE_FILE_NAME_SUFFIX = ".ini";
    private static final String REMOTELAUNCH_FILE_NAME = "remotelaunch.ini";
    public static final int MDEP_ID_MIN = 0;
    public static final int MDEP_ID_MAX = 255;

    private BluetoothManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BluetoothBean read() {
        BluetoothBean bluetoothBean = new BluetoothBean();
        Object object = new IniFileEntity(BLUETOOTH_FILENAME_PATH);
        try {
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            try {
                ((IniFileEntity)object).read();
            }
            catch (Exception exception) {
                object5 = new IniFileEntity(BLUETOOTH_FILENAME_PATH);
                ((IniFileEntity)object5).setSectionAttribute(SECTION_OWNDEVICE, KEY_DEVICEADDR, DEFAULT_DEVICEADDR);
                ((IniFileEntity)object5).setSectionAttribute(SECTION_OWNDEVICE, KEY_DEVICENAME, DEFAULT_DEVICENAME);
                ((IniFileEntity)object5).setSectionAttribute(SECTION_OWNDEVICE, KEY_DEVICETYPE, DEFAULT_DEVICETYPE);
                ((IniFileEntity)object5).setSectionAttribute(SECTION_OWNDEVICE, KEY_SPECDATA, DEFAULT_SPECDATA);
                ((IniFileEntity)object5).setSectionAttribute(SECTION_OWNDEVICE, KEY_LOCALNAME, DEFAULT_LOCALNAME);
                ((IniFileEntity)object5).setSectionAttribute(SECTION_OWNDEVICE, KEY_UUID, DEFAULT_UUID);
                ((IniFileEntity)object5).setSectionAttribute(SECTION_DEVICE, KEY_COUNT, DEFAULT_COUNT);
                ((IniFileEntity)object5).setSectionAttribute(SECTION_SCANNINGDEVICE, KEY_MAXCONNECTION, DEFAULT_MAXCONNECTION);
                ((IniFileEntity)object5).setSectionAttribute(SECTION_SCANNINGDEVICE, KEY_HOST, DEFAULT_HOST);
                try {
                    ((IniFileEntity)object5).save();
                }
                catch (Exception exception2) {
                }
                finally {
                    object = object5;
                }
            }
            IniFileEntity.IniSection iniSection = ((IniFileEntity)object).getSection(SECTION_OWNDEVICE);
            object5 = new BluetoothDeviceDataBean(iniSection.getAttribute(KEY_DEVICENAME, ""), iniSection.getAttribute(KEY_DEVICEADDR, ""), iniSection.getAttribute(KEY_DEVICETYPE), iniSection.getAttribute(KEY_SPECDATA, ""), iniSection.getAttribute(KEY_LOCALNAME, ""), iniSection.getAttribute(KEY_UUID, ""));
            ArrayList<BluetoothDeviceBean> arrayList = new ArrayList<BluetoothDeviceBean>();
            int n = 0;
            try {
                n = Integer.parseInt(((IniFileEntity)object).getSectionAttribute(SECTION_DEVICE, KEY_COUNT));
            }
            catch (Exception exception) {
                n = 0;
            }
            for (int i = 1; i <= n; ++i) {
                object4 = SECTION_DEVICE_PREFIX + i;
                IniFileEntity.IniSection iniSection2 = ((IniFileEntity)object).getSection((String)object4);
                object3 = "";
                try {
                    object3 = iniSection2.getAttribute(KEY_DEVICEADDR, "");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if ("".equals(object3)) continue;
                BluetoothDeviceBean bluetoothDeviceBean = new BluetoothDeviceBean((String)object3, iniSection2.getAttribute(KEY_SPP), iniSection2.getAttribute(KEY_HDP), iniSection2.getAttribute(KEY_REGISTERED), iniSection2.getAttribute(KEY_LASTSELECTED), BluetoothManager.readDevice((String)object3));
                object2 = BluetoothManager.readDevice((String)object3);
                if (object2 == null) continue;
                bluetoothDeviceBean.setBluetoothDeviceData((BluetoothDeviceDataBean)object2);
                arrayList.add(bluetoothDeviceBean);
            }
            Collections.sort(arrayList, new LastselectedComparator());
            IniFileEntity.IniSection iniSection3 = ((IniFileEntity)object).getSection(SECTION_SCANNINGDEVICE);
            object4 = BluetoothManager.readRemoteLaunch();
            block14: for (int i = 0; i < object4.size(); ++i) {
                object3 = (List)object4.get(i);
                for (int j = 0; j < arrayList.size(); ++j) {
                    object2 = (BluetoothDeviceBean)arrayList.get(j);
                    if (!((BluetoothDeviceBean)object2).getBluetoothAddress().equals(object3.get(0))) continue;
                    ((BluetoothDeviceBean)object2).setProjectName((String)object3.get(1));
                    continue block14;
                }
            }
            bluetoothBean = new BluetoothBean((BluetoothDeviceDataBean)object5, arrayList, iniSection3.getAttribute(KEY_MAXCONNECTION), iniSection3.getAttribute(KEY_HOST));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bluetoothBean;
    }

    protected static BluetoothDeviceDataBean readDevice(String string) {
        IniFileEntity iniFileEntity = new IniFileEntity(Const.PATH_LIB_BLUETOOTH + string + DEVICE_FILE_NAME_SUFFIX);
        try {
            iniFileEntity.read();
            IniFileEntity.IniSection iniSection = iniFileEntity.getSection(SECTION_DEVICE);
            BluetoothDeviceDataBean bluetoothDeviceDataBean = new BluetoothDeviceDataBean(iniSection.getAttribute(KEY_DEVICENAME, ""), string, iniSection.getAttribute(KEY_DEVICETYPE), iniSection.getAttribute(KEY_SPECDATA, ""), iniSection.getAttribute(KEY_LOCALNAME, ""), iniSection.getAttribute(KEY_UUID, ""));
            bluetoothDeviceDataBean.setBluetoothMDEPBeanList(BluetoothManager.readMdep(string));
            return bluetoothDeviceDataBean;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected static List<List<String>> readRemoteLaunch() {
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        IniFileEntity iniFileEntity = new IniFileEntity(Const.PATH_LIB_BLUETOOTH + REMOTELAUNCH_FILE_NAME);
        try {
            iniFileEntity.read();
            int n = Integer.parseInt(iniFileEntity.getSectionAttribute(SECTION_DEVICE, KEY_COUNT));
            for (int i = 1; i <= n; ++i) {
                ArrayList<String> arrayList2 = new ArrayList<String>();
                String string = SECTION_DEVICE_PREFIX + i;
                IniFileEntity.IniSection iniSection = iniFileEntity.getSection(string);
                String string2 = iniSection.getAttribute(KEY_DEVICEADDR, "");
                if ("".equals(string2)) continue;
                arrayList2.add(string2);
                arrayList2.add(iniSection.getAttribute(KEY_PROJECTNAME, ""));
                arrayList.add(arrayList2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    protected static void writeBluetoothFile(BluetoothBean bluetoothBean) throws Exception {
        try {
            IniFileEntity iniFileEntity;
            IniFileEntity iniFileEntity2 = iniFileEntity = new IniFileEntity(BLUETOOTH_FILENAME_PATH);
            iniFileEntity2.getClass();
            IniFileEntity.IniSection iniSection = new IniFileEntity.IniSection(iniFileEntity2, SECTION_OWNDEVICE);
            iniFileEntity.addSection(iniSection);
            iniSection.setAttribute(KEY_DEVICEADDR, bluetoothBean.getOwnBluetoothDeviceData().getBluetoothAddress());
            iniSection.setAttribute(KEY_DEVICENAME, bluetoothBean.getOwnBluetoothDeviceData().getDeviceName());
            iniSection.setAttribute(KEY_DEVICETYPE, bluetoothBean.getOwnBluetoothDeviceData().getDeviceType());
            iniSection.setAttribute(KEY_SPECDATA, bluetoothBean.getOwnBluetoothDeviceData().getSpecData());
            iniSection.setAttribute(KEY_LOCALNAME, bluetoothBean.getOwnBluetoothDeviceData().getLocalname());
            iniSection.setAttribute(KEY_UUID, bluetoothBean.getOwnBluetoothDeviceData().getUuid());
            iniFileEntity.setSectionAttribute(SECTION_DEVICE, KEY_COUNT, Integer.toString(bluetoothBean.getBdbList().size()));
            for (int i = 1; i <= bluetoothBean.getBdbList().size(); ++i) {
                BluetoothDeviceBean bluetoothDeviceBean = bluetoothBean.getBdbList().get(i - 1);
                String string = SECTION_DEVICE_PREFIX + i;
                IniFileEntity iniFileEntity3 = iniFileEntity;
                iniFileEntity3.getClass();
                IniFileEntity.IniSection iniSection2 = new IniFileEntity.IniSection(iniFileEntity3, string);
                iniFileEntity.addSection(iniSection2);
                iniSection2.setAttribute(KEY_DEVICEADDR, bluetoothDeviceBean.getBluetoothAddress());
                iniSection2.setAttribute(KEY_SPP, bluetoothDeviceBean.getSppString());
                iniSection2.setAttribute(KEY_HDP, bluetoothDeviceBean.getHdpString());
                iniSection2.setAttribute(KEY_REGISTERED, bluetoothDeviceBean.getRegisterdString());
                iniSection2.setAttribute(KEY_LASTSELECTED, bluetoothDeviceBean.getLastSelectedString());
            }
            IniFileEntity iniFileEntity4 = iniFileEntity;
            iniFileEntity4.getClass();
            IniFileEntity.IniSection iniSection3 = new IniFileEntity.IniSection(iniFileEntity4, SECTION_SCANNINGDEVICE);
            iniFileEntity.addSection(iniSection3);
            iniSection3.setAttribute(KEY_MAXCONNECTION, bluetoothBean.getMaxConnection());
            iniSection3.setAttribute(KEY_HOST, bluetoothBean.getHostListString());
            iniFileEntity.save();
        }
        catch (Exception exception) {
            throw new Exception(BLUETOOTH_FILE_NAME, exception);
        }
    }

    protected static void writeRemoteLaunchFile(BluetoothBean bluetoothBean) throws Exception {
        try {
            IniFileEntity iniFileEntity = new IniFileEntity(Const.PATH_LIB_BLUETOOTH + REMOTELAUNCH_FILE_NAME);
            iniFileEntity.setSectionAttribute(SECTION_DEVICE, KEY_COUNT, Integer.toString(bluetoothBean.getRemoteLaunch().size()));
            for (int i = 1; i <= bluetoothBean.getRemoteLaunch().size(); ++i) {
                BluetoothDeviceBean bluetoothDeviceBean = bluetoothBean.getRemoteLaunch().get(i - 1);
                String string = SECTION_DEVICE_PREFIX + i;
                IniFileEntity iniFileEntity2 = iniFileEntity;
                iniFileEntity2.getClass();
                IniFileEntity.IniSection iniSection = new IniFileEntity.IniSection(iniFileEntity2, string);
                iniFileEntity.addSection(iniSection);
                iniSection.setAttribute(KEY_DEVICEADDR, bluetoothDeviceBean.getBluetoothAddress());
                iniSection.setAttribute(KEY_PROJECTNAME, bluetoothDeviceBean.getProjectName());
            }
            iniFileEntity.save();
        }
        catch (Exception exception) {
            throw new Exception(REMOTELAUNCH_FILE_NAME, exception);
        }
    }

    protected static void writeDeviceFile(BluetoothBean bluetoothBean) throws Exception {
        Object object;
        Object object2;
        String string;
        BluetoothDeviceBean bluetoothDeviceBean;
        int n;
        for (n = 0; n < bluetoothBean.getBdbList().size(); ++n) {
            bluetoothDeviceBean = bluetoothBean.getBdbList().get(n);
            string = Const.PATH_LIB_BLUETOOTH + bluetoothDeviceBean.getOriginalBluetoothAddress() + DEVICE_FILE_NAME_SUFFIX;
            object2 = Const.PATH_LIB_BLUETOOTH + bluetoothDeviceBean.getBluetoothAddress() + DEVICE_FILE_NAME_SUFFIX;
            if (!bluetoothDeviceBean.isHdp()) continue;
            try {
                if (bluetoothDeviceBean.getBluetoothDeviceData().isBluetoothAddressChanged() && !((File)(object = new File(string))).delete()) {
                    throw new Exception();
                }
            }
            catch (Exception exception) {
                throw new Exception(string, exception);
            }
            try {
                object = new IniFileEntity((String)object2);
                BluetoothDeviceDataBean bluetoothDeviceDataBean = bluetoothDeviceBean.getBluetoothDeviceData();
                ((IniFileEntity)object).setSectionAttribute(SECTION_DEVICE, KEY_DEVICENAME, bluetoothDeviceDataBean.getDeviceName());
                ((IniFileEntity)object).setSectionAttribute(SECTION_DEVICE, KEY_DEVICETYPE, bluetoothDeviceDataBean.getDeviceTypeString());
                ((IniFileEntity)object).setSectionAttribute(SECTION_DEVICE, KEY_SPECDATA, bluetoothDeviceDataBean.getSpecData());
                ((IniFileEntity)object).setSectionAttribute(SECTION_DEVICE, KEY_LOCALNAME, bluetoothDeviceDataBean.getLocalname());
                ((IniFileEntity)object).setSectionAttribute(SECTION_DEVICE, KEY_UUID, bluetoothDeviceDataBean.getUuid());
                ((IniFileEntity)object).save();
            }
            catch (Exception exception) {
                throw new Exception((String)object2, exception);
            }
            BluetoothManager.write(bluetoothDeviceBean);
            continue;
        }
        for (n = 0; n < bluetoothBean.getDeleteBdbList().size(); ++n) {
            bluetoothDeviceBean = bluetoothBean.getDeleteBdbList().get(n);
            string = Const.PATH_LIB_BLUETOOTH + bluetoothDeviceBean.getBluetoothAddress() + DEVICE_FILE_NAME_SUFFIX;
            try {
                object2 = new File(string);
                if (!((File)object2).delete()) {
                    throw new Exception();
                }
            }
            catch (Exception exception) {
                throw new Exception(string, exception);
            }
            object2 = Const.PATH_LIB_BLUETOOTH_HDP + bluetoothDeviceBean.getBluetoothAddress();
            try {
                object = new File((String)object2);
                BluetoothManager.delete((File)object);
                continue;
            }
            catch (Exception exception) {
                throw new Exception((String)object2, exception);
            }
        }
        bluetoothBean.getDeleteBdbList().clear();
    }

    private static void delete(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            file.delete();
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                BluetoothManager.delete(fileArray[i]);
            }
            file.delete();
        }
    }

    public static void write(BluetoothBean bluetoothBean) throws Exception {
        BluetoothManager.writeBluetoothFile(bluetoothBean);
        BluetoothManager.writeRemoteLaunchFile(bluetoothBean);
        BluetoothManager.writeDeviceFile(bluetoothBean);
    }

    protected static void createDeviceAddressDir(BluetoothDeviceDataBean bluetoothDeviceDataBean) throws Exception {
        File file = null;
        try {
            file = new File(Const.PATH_LIB_BLUETOOTH_HDP + bluetoothDeviceDataBean.getBluetoothAddress());
            if (!file.exists() && !file.mkdir()) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            throw new Exception(bluetoothDeviceDataBean.getBluetoothAddress() + File.separator, exception);
        }
    }

    protected static void renameMdepIdDir(String string, BluetoothMDEPBean bluetoothMDEPBean) throws Exception {
        File file = null;
        try {
            String string2 = Const.PATH_LIB_BLUETOOTH_HDP + string + File.separator;
            file = bluetoothMDEPBean.isMdepidChanged() ? new File(string2 + bluetoothMDEPBean.getOrignalMdepId()) : new File(string2 + bluetoothMDEPBean.getMdepId());
            if (file.exists() && file.isDirectory()) {
                if (!file.renameTo(new File(string2 + bluetoothMDEPBean.getMdepId()))) {
                    throw new Exception();
                }
            } else if (file.exists() && !file.isDirectory()) {
                file.delete();
                file.mkdir();
            } else if (!file.exists()) {
                file.mkdir();
            }
            bluetoothMDEPBean.setOriginalMdepId();
        }
        catch (Exception exception) {
            throw new Exception(file.getCanonicalPath() + File.separator, exception);
        }
    }

    protected static void createInputDataFile(String string, BluetoothMDEPBean bluetoothMDEPBean) throws Exception {
        File file = null;
        try {
            file = new File(Const.PATH_LIB_BLUETOOTH_HDP + string + File.separator + bluetoothMDEPBean.getMdepId() + File.separator + INPUT_FILE_NAME);
            if (!file.exists() && !file.createNewFile()) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            throw new Exception(file.getCanonicalPath(), exception);
        }
    }

    public static void checkRepetitionMdepId(List<BluetoothMDEPBean> list, int n) throws Exception {
        if (list == null) {
            return;
        }
        for (BluetoothMDEPBean bluetoothMDEPBean : list) {
            if (bluetoothMDEPBean.getMdepId() != n) continue;
            throw new Exception();
        }
    }

    protected static void renameDeviceNameDir(BluetoothDeviceDataBean bluetoothDeviceDataBean) throws Exception {
        block4: {
            File file = null;
            try {
                file = new File(Const.PATH_LIB_BLUETOOTH_HDP + bluetoothDeviceDataBean.getOriginalBluetoothAddress());
                if (file.exists() && file.isDirectory()) {
                    if (!file.renameTo(new File(Const.PATH_LIB_BLUETOOTH_HDP + bluetoothDeviceDataBean.getBluetoothAddress()))) {
                        throw new Exception();
                    }
                    break block4;
                }
                throw new Exception();
            }
            catch (Exception exception) {
                throw new Exception(bluetoothDeviceDataBean.getBluetoothAddress() + File.separator, exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List<BluetoothMDEPBean> readMdep(String string) {
        ArrayList<BluetoothMDEPBean> arrayList = new ArrayList<BluetoothMDEPBean>();
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        BluetoothMDEPCsvReader bluetoothMDEPCsvReader = null;
        try {
            BluetoothMDEPCsvRecord bluetoothMDEPCsvRecord;
            inputStreamReader = new FileReader(new File(Const.PATH_LIB_BLUETOOTH_HDP + string + File.separator + MDEP_FILE_NAME));
            bufferedReader = new BufferedReader(inputStreamReader);
            bluetoothMDEPCsvReader = new BluetoothMDEPCsvReader(bufferedReader);
            while ((bluetoothMDEPCsvRecord = bluetoothMDEPCsvReader.readRecord()) != null) {
                if (bluetoothMDEPCsvRecord.getMdepId() < 0 || bluetoothMDEPCsvRecord.getMdepId() > 255) {
                    throw new Exception();
                }
                BluetoothManager.checkRepetitionMdepId(arrayList, bluetoothMDEPCsvRecord.getMdepId());
                BluetoothMDEPBean bluetoothMDEPBean = new BluetoothMDEPBean(bluetoothMDEPCsvRecord.getMdepId());
                bluetoothMDEPBean.setType(bluetoothMDEPCsvRecord.getType());
                bluetoothMDEPBean.setRole(bluetoothMDEPCsvRecord.getRole());
                arrayList.add(bluetoothMDEPBean);
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                bluetoothMDEPCsvReader.close();
                bufferedReader.close();
                inputStreamReader.close();
            }
            catch (Exception exception) {}
        }
        return arrayList;
    }

    protected static void writeMdep(BluetoothDeviceDataBean bluetoothDeviceDataBean) throws Exception {
        OutputStreamWriter outputStreamWriter = null;
        BufferedWriter bufferedWriter = null;
        BluetoothMDEPCsvWriter bluetoothMDEPCsvWriter = null;
        String string = Const.PATH_LIB_BLUETOOTH_HDP + bluetoothDeviceDataBean.getBluetoothAddress() + File.separator + MDEP_FILE_NAME;
        try {
            ArrayList<BluetoothMDEPCsvRecord> arrayList = new ArrayList<BluetoothMDEPCsvRecord>();
            for (BluetoothMDEPBean object : bluetoothDeviceDataBean.getBluetoothMDEPBeanList()) {
                BluetoothMDEPCsvRecord bluetoothMDEPCsvRecord = new BluetoothMDEPCsvRecord();
                bluetoothMDEPCsvRecord.setMdepId(object.getMdepId());
                bluetoothMDEPCsvRecord.setType(object.getType());
                bluetoothMDEPCsvRecord.setRole(object.getRole());
                arrayList.add(bluetoothMDEPCsvRecord);
            }
            outputStreamWriter = new FileWriter(new File(string));
            bufferedWriter = new BufferedWriter(outputStreamWriter);
            bluetoothMDEPCsvWriter = new BluetoothMDEPCsvWriter(bufferedWriter);
            for (BluetoothMDEPCsvRecord bluetoothMDEPCsvRecord : arrayList) {
                bluetoothMDEPCsvWriter.writeRecord(bluetoothMDEPCsvRecord);
            }
        }
        catch (Exception exception) {
            throw new Exception(string, exception);
        }
        finally {
            try {
                bluetoothMDEPCsvWriter.close();
                bufferedWriter.close();
                outputStreamWriter.close();
            }
            catch (Exception exception) {}
        }
    }

    protected static void write(BluetoothDeviceBean bluetoothDeviceBean) throws Exception {
        if (bluetoothDeviceBean.getBluetoothDeviceData().isBluetoothAddressChanged()) {
            BluetoothManager.renameDeviceNameDir(bluetoothDeviceBean.getBluetoothDeviceData());
        } else {
            BluetoothManager.createDeviceAddressDir(bluetoothDeviceBean.getBluetoothDeviceData());
        }
        bluetoothDeviceBean.getBluetoothDeviceData().setOriginalBluetoothAddress();
        BluetoothManager.writeMdep(bluetoothDeviceBean.getBluetoothDeviceData());
        for (BluetoothMDEPBean bluetoothMDEPBean : bluetoothDeviceBean.getBluetoothDeviceData().getBluetoothMDEPBeanList()) {
            BluetoothManager.renameMdepIdDir(bluetoothDeviceBean.getBluetoothDeviceData().getBluetoothAddress(), bluetoothMDEPBean);
            BluetoothManager.createInputDataFile(bluetoothDeviceBean.getBluetoothDeviceData().getBluetoothAddress(), bluetoothMDEPBean);
        }
        for (int i = 0; i < bluetoothDeviceBean.getBluetoothDeviceData().getDeleteMdepBeanList().size(); ++i) {
            BluetoothMDEPBean bluetoothMDEPBean;
            bluetoothMDEPBean = bluetoothDeviceBean.getBluetoothDeviceData().getDeleteMdepBeanList().get(i);
            String string = Const.PATH_LIB_BLUETOOTH_HDP + bluetoothDeviceBean.getBluetoothAddress() + File.separator + bluetoothMDEPBean.getMdepId();
            try {
                File file = new File(string);
                BluetoothManager.delete(file);
                continue;
            }
            catch (Exception exception) {
                throw new Exception(string, exception);
            }
        }
        bluetoothDeviceBean.getBluetoothDeviceData().getDeleteMdepBeanList().clear();
    }
}

