/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

class BuildErrorTable
extends JTable {
    static final int ORDER_NUMBER = 0;
    static final int ORDER_FILE = 1;
    static final int ORDER_LINE = 2;
    static final int ORDER_MESSAGE = 3;
    static final int TYPE_ATTR_RELATIVE_PATH = 0;
    private final int MAX_WIDTH_NUMBER = 30;
    private final int MAX_WIDTH_LINE = 60;
    private final String[] columnNames = new String[]{Resource.getString("BUILD_ERROR_TBL_NO"), Resource.getString("BUILD_ERROR_TBL_SOURCE"), Resource.getString("BUILD_ERROR_TBL_LINE"), Resource.getString("BUILD_ERROR_TBL_MESSAGE")};
    private BuildErrorTblModel tblModel = new BuildErrorTblModel(this.columnNames);
    private String editorPath;
    private String editorArgs;
    private String curPath;

    public BuildErrorTable() {
        this.setModel(this.tblModel);
        this.editorPath = null;
        this.editorArgs = null;
        this.curPath = null;
        this.setShowHorizontalLines(false);
        this.setShowVerticalLines(false);
        this.setAutoResizeMode(3);
        this.tableHeader.setReorderingAllowed(false);
        this.tableHeader.setResizingAllowed(true);
        this.tableHeader.setDefaultRenderer(new ErrorHeaderRenderer(this.tableHeader.getDefaultRenderer()));
        this.setDefaultRenderer(Object.class, new ErrorCellRenderer());
        this.setSelectionMode(0);
        TableColumn tableColumn = this.getColumnModel().getColumn(0);
        TableColumn tableColumn2 = this.getColumnModel().getColumn(2);
        tableColumn.setMaxWidth(30);
        tableColumn2.setMaxWidth(60);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    BuildErrorTable.this.open(BuildErrorTable.this.getSelectedRow());
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    BuildErrorTable.this.open(BuildErrorTable.this.getSelectedRow());
                    keyEvent.consume();
                }
            }
        });
    }

    private void open(int n) {
        if (n < 0 || this.editorPath == null || this.editorPath.length() == 0) {
            return;
        }
        String string = (String)this.tblModel.getValueAt(n, 1);
        String string2 = (String)this.tblModel.getValueAt(n, 2);
        if (string == null || string2 == null) {
            return;
        }
        String string3 = null;
        if (this.editorArgs == null || this.editorArgs.length() == 0) {
            string3 = this.editorPath + " " + string;
        } else {
            String string4 = this.editorArgs;
            String[] stringArray = new String[]{"%L", "%F"};
            String[] stringArray2 = new String[]{string2, string};
            StringBuffer stringBuffer = new StringBuffer(string4);
            for (int i = 0; i < stringArray.length; ++i) {
                int n2 = string4.indexOf(stringArray[i], 0);
                if (n2 < 0) continue;
                stringBuffer.replace(n2, n2 + stringArray[i].length(), stringArray2[i]);
                string4 = stringBuffer.toString();
            }
            string3 = this.editorPath + " " + stringBuffer.toString();
        }
        try {
            Runtime.getRuntime().exec(string3);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean setRowAttribute(int n, int n2, Object object) {
        boolean bl = false;
        if (n == 1 && n2 == 0 && object instanceof String) {
            this.curPath = (String)object;
            bl = true;
        }
        return bl;
    }

    public void setEditor(String string) {
        this.editorPath = string;
    }

    public void setEditorArgs(String string) {
        this.editorArgs = string;
    }

    public void clear() {
        this.tblModel.setRowCount(0);
    }

    class ErrorCellRenderer
    extends JLabel
    implements TableCellRenderer {
        ErrorCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object == null) {
                return this;
            }
            int n3 = 0;
            if (n2 == 0 || n2 == 2) {
                this.setHorizontalAlignment(0);
            } else if (n2 == 1) {
                this.setHorizontalAlignment(2);
                if (BuildErrorTable.this.curPath != null) {
                    n3 = BuildErrorTable.this.curPath.length();
                    object = "./" + ((String)object).substring(n3 - 1);
                }
            } else {
                this.setHorizontalAlignment(2);
            }
            this.setOpaque(true);
            if (bl) {
                this.setBackground(Color.black);
                this.setForeground(Color.white);
            } else {
                if (n % 2 == 0) {
                    this.setBackground(Color.white);
                } else {
                    this.setBackground(new Color(238, 238, 238));
                }
                this.setForeground(Color.black);
            }
            this.setText((String)object);
            return this;
        }
    }

    class ErrorHeaderRenderer
    implements TableCellRenderer {
        private final TableCellRenderer tcr;

        public ErrorHeaderRenderer(TableCellRenderer tableCellRenderer) {
            this.tcr = tableCellRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)this.tcr.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            jLabel.setHorizontalAlignment(0);
            return jLabel;
        }
    }

    class BuildErrorTblModel
    extends DefaultTableModel {
        BuildErrorTblModel(String[] stringArray) {
            super(stringArray, 0);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (0 <= n && n < this.dataVector.size()) {
                return super.getValueAt(n, n2);
            }
            return null;
        }
    }
}

