/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.ADF;
import com.nttdocomo.dojaemu.ktoolbar.ADFNeedChecker;
import com.nttdocomo.dojaemu.ktoolbar.BuildException;
import com.nttdocomo.dojaemu.ktoolbar.DeployWindow;
import com.nttdocomo.dojaemu.ktoolbar.Environment;
import com.nttdocomo.dojaemu.ktoolbar.ExecuteProcess;
import com.nttdocomo.dojaemu.ktoolbar.FilesystemSizeCounter;
import com.nttdocomo.dojaemu.ktoolbar.IAppliChecker;
import com.nttdocomo.dojaemu.ktoolbar.JarAccess;
import com.nttdocomo.dojaemu.ktoolbar.JavaFileSelector;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.ReadWindowClassTag;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.Setting;
import com.nttdocomo.dojaemu.ktoolbar.SourceChecker;
import com.nttdocomo.dojaemu.ktoolbar.StarDoJaChecker;
import com.nttdocomo.dojaemu.ktoolbar.StringChecker;
import com.nttdocomo.dojaemu.ktoolbar.iapplibrary.IAppLibInclude;
import com.nttdocomo.dojaemu.ktoolbar.starfileschecker.StarFilesChecker;
import com.nttdocomo.dojaemu.ktoolbar.starfileschecker.StarFilesCheckerException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

class BuildProject
implements Runnable {
    private ADF adf;
    private ADF fullAdf;
    private ADF miniAdf;
    private String classpath;
    private String fullClasspath;
    private String miniClasspath;
    private File srcDir;
    private File resDir;
    private File binDir;
    private File libDir;
    private File fullSrcDir;
    private File fullResDir;
    private File fullBinDir;
    private File fullLibDir;
    private File miniSrcDir;
    private File miniResDir;
    private File miniBinDir;
    private File miniLibDir;
    private File jamFile;
    private File jarFile;
    private File fullJamFile;
    private File fullJarFile;
    private File miniJamFile;
    private File miniJarFile;
    private File jarCompFile;
    private File fullJarCompFile;
    private File miniJarCompFile;
    private File verifiedClassDir = null;
    private File fullVerifiedClassDir = null;
    private File miniVerifiedClassDir = null;
    private File unverifiedClassDir = null;
    private File fullUnverifiedClassDir = null;
    private File miniUnverifiedClassDir = null;
    private File stubDir = null;
    private File fullStubDir = null;
    private File miniStubDir = null;
    private MainWindow parent;
    private File downloadFile;
    private File fullDownloadFile;
    private File miniDownloadFile;
    private String projectName;
    private String fullProjectName;
    private String miniProjectName;
    private int launchType;
    private int fullLaunchType;
    private int miniLaunchType;
    private boolean isOnlyReqClass = true;
    private boolean fullIsOnlyReqClass = true;
    private boolean miniIsOnlyReqClass = true;
    private Vector includeLibList = new Vector();
    private Vector fullIncludeLibList = new Vector();
    private Vector miniIncludeLibList = new Vector();
    private Vector unUsedLibList = new Vector();
    private Vector fullUnUsedLibList = new Vector();
    private Vector miniUnUsedLibList = new Vector();
    private File iAppLibInDir = null;
    private File fullIAppLibInDir = null;
    private File miniIAppLibInDir = null;
    private Vector overWriteInfo = new Vector();
    private Vector fullOverWriteInfo = new Vector();
    private Vector miniOverWriteInfo = new Vector();
    private static final int MAX_COLUMN = 4;
    private static final String DOWNLOADHTML = "Download.html";
    private static final String DOWNLOADHTML_TEMP = "Download.txt";
    private static final String PROJECTNAME = "PROJECTNAME";
    private static final String ATTRIBUTE = "ATTRIBUTE";
    private static final String PACKAGEURL = "PACKAGEURL";
    private int buildSwitch = 0;
    private int fullBuildSwitch = 0;
    private int miniBuildSwitch = 0;
    private Setting projectSetting;
    private Setting fullProjectSetting;
    private Setting miniProjectSetting;
    private Hashtable unpackedList;
    private Hashtable fullUnpackedList;
    private Hashtable miniUnpackedList;
    private ArrayList warningList;
    private ArrayList fullWarningList;
    private ArrayList miniWarningList;
    private boolean useFlagDisabledMiniAppAPI;
    private boolean fullUseFlagDisabledMiniAppAPI;
    private boolean miniUseFlagDisabledMiniAppAPI;
    private String javaLibPath;
    private String fullJavaLibPath;
    private String miniJavaLibPath;
    public static final int BUILDSTATUS_RESET = 0;
    public static final int BUILDSTATUS_NOMAL_START = 1;
    public static final int BUILDSTATUS_FULLMINI_START = 2;
    public static final int BUILDSTATUS_FULLAPP = 3;
    public static final int BUILDSTATUS_MINIAPP = 4;
    public static final int BUILDSTATUS_FULLMINIJAR = 5;
    public static final int BUILDSTATUS_END = 6;
    public static final int BUILDSTATUS_BOOKMARK_START = 7;
    int buildStatus = 0;
    private final int FULL_MAX_JAR_SIZE = 0xA00000;
    private final int MINI_MAX_JAR_SIZE = 51200;
    private final int BOOKMARK_MAX_JAR_SIZE = 102400;
    private final int BOOKMARK_MIN_JAR_SIZE = 0;
    public static final String MANIFEST_KEY_IAPPLI_CREATED_BY = "iappli-Created-By";
    public static final String MANIFEST_KEY_PREVERIFIED = "preverified";
    public static final String MANIFEST_VALUE_PREVERIFIED = "false";

    BuildProject(File file, String string, int n, MainWindow mainWindow) throws BuildException {
        this.setFullMiniBuildStatas(mainWindow);
        this.BuildProjectSetting(file, string, n, mainWindow);
    }

    void BuildProjectSetting(File file, String string, int n, MainWindow mainWindow) throws BuildException {
        Object object;
        this.jamFile = file;
        this.classpath = string;
        this.launchType = n;
        this.parent = mainWindow;
        switch (this.buildStatus) {
            case 2: {
                try {
                    this.adf = new ADF(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new BuildException(Resource.format("NOT_FOUND_ERR", file.getPath()));
                }
                catch (IOException iOException) {
                    throw new BuildException(Resource.format("READ_ERR", file.getPath()));
                }
                return;
            }
            case 3: {
                this.projectSetting = mainWindow.getFullAppProjectSetting();
                break;
            }
            case 4: {
                this.projectSetting = mainWindow.getMiniAppProjectSetting();
                break;
            }
            case 1: {
                this.projectSetting = mainWindow.getProjectSetting();
            }
        }
        this.buildSwitch = this.projectSetting != null ? ((object = this.projectSetting.getProperty("componentCreate")) != null && ((String)object).equals("true") ? 1 : 0) : 0;
        try {
            this.adf = new ADF(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new BuildException(Resource.format("NOT_FOUND_ERR", file.getPath()));
        }
        catch (IOException iOException) {
            throw new BuildException(Resource.format("READ_ERR", file.getPath()));
        }
        object = file.getParentFile().getParentFile();
        this.srcDir = new File((File)object, "src");
        this.resDir = new File((File)object, "res");
        this.binDir = new File((File)object, "bin");
        this.libDir = new File((File)object, "lib");
        if (!this.libDir.exists()) {
            this.libDir = null;
        }
        try {
            this.verifiedClassDir = File.createTempFile("class", "verified");
            this.unverifiedClassDir = File.createTempFile("class", "unverified");
            this.verifiedClassDir.delete();
            this.verifiedClassDir.mkdir();
            this.unverifiedClassDir.delete();
            this.unverifiedClassDir.mkdir();
            if (this.buildSwitch != 1) {
                this.unpackJarDir(this.verifiedClassDir);
                this.iAppLibInDir = this.verifiedClassDir;
            } else {
                String string2 = this.projectSetting.getProperty("componentName");
                if (string2 != null) {
                    if (string2.length() == 0) {
                        this.deleteAllTmpDir();
                        throw new BuildException(Resource.getString("NOT_FOUND_COMPJAR_ERR"));
                    }
                    if (!new StringChecker(string2).isFileName()) {
                        this.deleteAllTmpDir();
                        throw new BuildException(Resource.getString("PROP_ERR"));
                    }
                } else {
                    this.deleteAllTmpDir();
                    throw new BuildException(Resource.getString("NOT_FOUND_COMPJAR_ERR"));
                }
                this.stubDir = File.createTempFile("class", "stub");
                this.stubDir.delete();
                this.stubDir.mkdir();
                this.unpackJarDir(this.stubDir);
                this.iAppLibInDir = this.stubDir;
                String string3 = this.projectSetting.getProperty("componentName");
                this.jarCompFile = new File(this.binDir, string3 + ".jar");
            }
        }
        catch (IOException iOException) {
            this.deleteAllTmpDir();
            throw new BuildException(Resource.getString("MAKE_TMP_FILE_ERR"));
        }
        String string4 = file.getPath();
        String string5 = string4.substring(0, string4.lastIndexOf(".")) + ".jar";
        this.jarFile = new File(string5);
        this.projectName = ((File)object).getName();
        String string6 = file.getParentFile().getPath() + File.separator + DOWNLOADHTML;
        this.downloadFile = new File(string6);
        this.warningList = new ArrayList();
        this.initDisabledMiniAppAPI(this.adf, this.projectSetting);
    }

    void BuildProjectSetting() throws BuildException {
        if (5 == this.buildStatus) {
            this.projectSetting = this.parent.getProjectSetting();
        }
        this.jamFile = new File(this.parent.getJamPath(this.parent.getProjectName()));
        try {
            this.adf = new ADF(this.jamFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new BuildException(Resource.format("NOT_FOUND_ERR", this.jamFile.getPath()));
        }
        catch (IOException iOException) {
            throw new BuildException(Resource.format("READ_ERR", this.jamFile.getPath()));
        }
        File file = this.jamFile.getParentFile().getParentFile();
        this.binDir = new File(file, "bin");
        this.resDir = new File(file, "res");
        String string = this.jamFile.getPath();
        String string2 = string.substring(0, string.lastIndexOf(".")) + ".jar";
        this.jarFile = new File(string2);
        this.projectName = file.getName();
        String string3 = this.jamFile.getParentFile().getPath() + File.separator + DOWNLOADHTML;
        this.downloadFile = new File(string3);
    }

    private void backUpAppInfo(int n) {
        if (3 == n) {
            this.fullJamFile = this.jamFile;
            this.fullClasspath = this.classpath;
            this.fullLaunchType = this.launchType;
            this.fullBuildSwitch = this.buildSwitch;
            this.fullAdf = this.adf;
            this.fullSrcDir = this.srcDir;
            this.fullResDir = this.resDir;
            this.fullBinDir = this.binDir;
            this.fullLibDir = this.libDir;
            this.fullVerifiedClassDir = this.verifiedClassDir;
            this.fullUnverifiedClassDir = this.unverifiedClassDir;
            this.fullIAppLibInDir = this.iAppLibInDir;
            this.fullStubDir = this.stubDir;
            this.fullJarCompFile = this.jarCompFile;
            this.fullJarFile = this.jarFile;
            this.fullProjectName = this.projectName;
            this.fullDownloadFile = this.downloadFile;
            this.fullWarningList = this.warningList;
            this.fullIsOnlyReqClass = this.isOnlyReqClass;
            this.fullIncludeLibList = this.includeLibList;
            this.fullUnUsedLibList = this.unUsedLibList;
            this.fullOverWriteInfo = this.overWriteInfo;
            this.fullProjectSetting = this.projectSetting;
            this.fullUnpackedList = this.unpackedList;
            this.fullUseFlagDisabledMiniAppAPI = this.useFlagDisabledMiniAppAPI;
            this.fullJavaLibPath = this.javaLibPath;
        } else if (4 == n) {
            this.miniJamFile = this.jamFile;
            this.miniClasspath = this.classpath;
            this.miniLaunchType = this.launchType;
            this.miniBuildSwitch = this.buildSwitch;
            this.miniAdf = this.adf;
            this.miniSrcDir = this.srcDir;
            this.miniResDir = this.resDir;
            this.miniBinDir = this.binDir;
            this.miniLibDir = this.libDir;
            this.miniVerifiedClassDir = this.verifiedClassDir;
            this.miniUnverifiedClassDir = this.unverifiedClassDir;
            this.miniIAppLibInDir = this.iAppLibInDir;
            this.miniStubDir = this.stubDir;
            this.miniJarCompFile = this.jarCompFile;
            this.miniJarFile = this.jarFile;
            this.miniProjectName = this.projectName;
            this.miniDownloadFile = this.downloadFile;
            this.miniWarningList = this.warningList;
            this.miniIsOnlyReqClass = this.isOnlyReqClass;
            this.miniIncludeLibList = this.includeLibList;
            this.miniUnUsedLibList = this.unUsedLibList;
            this.miniOverWriteInfo = this.overWriteInfo;
            this.miniProjectSetting = this.projectSetting;
            this.miniUnpackedList = this.unpackedList;
            this.miniUseFlagDisabledMiniAppAPI = this.useFlagDisabledMiniAppAPI;
            this.miniJavaLibPath = this.javaLibPath;
        }
    }

    private void reSetAppInfo(int n) {
        if (3 == n) {
            this.jamFile = this.fullJamFile;
            this.classpath = this.fullClasspath;
            this.launchType = this.fullLaunchType;
            this.buildSwitch = this.fullBuildSwitch;
            this.adf = this.fullAdf;
            this.srcDir = this.fullSrcDir;
            this.resDir = this.fullResDir;
            this.binDir = this.fullBinDir;
            this.libDir = this.fullLibDir;
            this.verifiedClassDir = this.fullVerifiedClassDir;
            this.unverifiedClassDir = this.fullUnverifiedClassDir;
            this.iAppLibInDir = this.fullIAppLibInDir;
            this.stubDir = this.fullStubDir;
            this.jarCompFile = this.fullJarCompFile;
            this.jarFile = this.fullJarFile;
            this.projectName = this.fullProjectName;
            this.downloadFile = this.fullDownloadFile;
            this.warningList = this.fullWarningList;
            this.isOnlyReqClass = this.fullIsOnlyReqClass;
            this.includeLibList = this.fullIncludeLibList;
            this.unUsedLibList = this.fullUnUsedLibList;
            this.overWriteInfo = this.fullOverWriteInfo;
            this.projectSetting = this.fullProjectSetting;
            this.unpackedList = this.fullUnpackedList;
            this.useFlagDisabledMiniAppAPI = this.fullUseFlagDisabledMiniAppAPI;
            this.javaLibPath = this.fullJavaLibPath;
        } else if (4 == n) {
            this.jamFile = this.miniJamFile;
            this.classpath = this.miniClasspath;
            this.launchType = this.miniLaunchType;
            this.buildSwitch = this.miniBuildSwitch;
            this.adf = this.miniAdf;
            this.srcDir = this.miniSrcDir;
            this.resDir = this.miniResDir;
            this.binDir = this.miniBinDir;
            this.libDir = this.miniLibDir;
            this.verifiedClassDir = this.miniVerifiedClassDir;
            this.unverifiedClassDir = this.miniUnverifiedClassDir;
            this.iAppLibInDir = this.miniIAppLibInDir;
            this.stubDir = this.miniStubDir;
            this.jarCompFile = this.miniJarCompFile;
            this.jarFile = this.miniJarFile;
            this.projectName = this.miniProjectName;
            this.downloadFile = this.miniDownloadFile;
            this.warningList = this.miniWarningList;
            this.isOnlyReqClass = this.miniIsOnlyReqClass;
            this.includeLibList = this.miniIncludeLibList;
            this.unUsedLibList = this.miniUnUsedLibList;
            this.overWriteInfo = this.miniOverWriteInfo;
            this.projectSetting = this.miniProjectSetting;
            this.unpackedList = this.miniUnpackedList;
            this.useFlagDisabledMiniAppAPI = this.miniUseFlagDisabledMiniAppAPI;
            this.javaLibPath = this.miniJavaLibPath;
        }
    }

    private boolean deleteTmpDir(File file) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                this.deleteTmpDir(fileArray[i]);
                continue;
            }
            fileArray[i].delete();
        }
        return file.delete();
    }

    private boolean deleteAllTmpDir() {
        boolean bl = true;
        try {
            if (this.verifiedClassDir != null && !this.deleteTmpDir(this.verifiedClassDir)) {
                this.verifiedClassDir.deleteOnExit();
                bl = false;
            }
            if (this.unverifiedClassDir != null && !this.deleteTmpDir(this.unverifiedClassDir)) {
                this.unverifiedClassDir.deleteOnExit();
                bl = false;
            }
            if (this.stubDir != null && !this.deleteTmpDir(this.stubDir)) {
                this.stubDir.deleteOnExit();
                bl = false;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    private void unpackJarDir(File file) {
        if (!file.exists()) {
            return;
        }
        String[] stringArray = this.loadListFile();
        this.unpackedList = new Hashtable();
        for (int i = stringArray.length - 1; i >= 0; --i) {
            JarAccess jarAccess = new JarAccess(stringArray[i]);
            jarAccess.unpack(file.getPath(), false);
            this.MakeOverWriteMessage(stringArray[i], jarAccess.getOverWriteFiles());
            Collection collection = jarAccess.getUnpackedList();
            if (collection == null) continue;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.unpackedList.put((String)iterator.next(), stringArray[i]);
            }
        }
    }

    private void MakeOverWriteMessage(String string, Collection collection) {
        int n;
        if (collection.size() == 0) {
            return;
        }
        String string2 = "";
        if ((string != null || string.length() != 0) && (n = string.lastIndexOf(File.separator)) != -1) {
            string2 = string.substring(n + 1, string.length());
            string2 = string2 + " : ";
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.overWriteInfo.add(string2 + (String)iterator.next());
        }
    }

    private String[] makeJarCommand(String string, String string2) throws BuildException {
        String string3 = Resource.JAR;
        if (!new File(string3).exists()) {
            throw new BuildException(Resource.getString("JDK_HOME_ERR"));
        }
        Vector<String> vector = new Vector<String>();
        vector.add(string3);
        vector.add(string);
        vector.add(this.jarFile.getPath());
        vector.add("-C");
        vector.add(string2);
        vector.add(".");
        return vector.toArray(new String[0]);
    }

    private String[] makeJarCommand(String string, String string2, String string3, boolean bl) throws BuildException {
        String string4 = Resource.JAR;
        if (!new File(string4).exists()) {
            throw new BuildException(Resource.getString("JDK_HOME_ERR"));
        }
        Vector<String> vector = new Vector<String>();
        vector.add(string4);
        vector.add(string);
        vector.add(string3);
        if (bl) {
            vector.add("-C");
            vector.add(string2);
            vector.add(".");
        } else {
            vector.add(string2);
        }
        return vector.toArray(new String[0]);
    }

    private String[] makeJarCommand(String string, File file, File file2) throws BuildException {
        String string2 = Resource.JAR;
        if (!new File(string2).exists()) {
            throw new BuildException(Resource.getString("JDK_HOME_ERR"));
        }
        Vector<String> vector = new Vector<String>();
        vector.add(string2);
        vector.add(string);
        vector.add(file.getPath());
        vector.add(file2.getPath());
        return vector.toArray(new String[0]);
    }

    private String[] makeJarCommand(String string, String string2, String string3, String string4, String string5) throws BuildException {
        String string6 = Resource.JAR;
        if (!new File(string6).exists()) {
            throw new BuildException(Resource.getString("JDK_HOME_ERR"));
        }
        Vector<String> vector = new Vector<String>();
        vector.add(string6);
        vector.add(string);
        vector.add(this.jarFile.getPath());
        vector.add("-C");
        vector.add(string3);
        vector.add(string2);
        vector.add("-C");
        vector.add(string5);
        vector.add(string4);
        return vector.toArray(new String[0]);
    }

    private String getDate() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss", Environment.getLocale());
        String string = simpleDateFormat.format(new Date());
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (2 == this.buildStatus) {
                this.fullminiBuild();
                System.out.println(Resource.getString("START_BUILD_COMPATI_MSG"));
            } else if (1 == this.buildStatus) {
                String string = this.adf.getProperty("AppType").toUpperCase();
                if (this.isPreScript()) {
                    System.out.println(Resource.getString("EXECUTION_PRE_SCRIPT"));
                    this.doScript("optimize_script1.bat");
                }
                this.doJavac();
                if (string.equals("MINIAPP")) {
                    this.checkDisabledMiniAppAPI(1, 1, this.unverifiedClassDir.getPath(), null);
                }
                this.choiceLibClass();
                String[] stringArray = this.iAppLibInDir.list();
                if (stringArray != null && stringArray.length > 0 && string.equals("MINIAPP")) {
                    this.checkDisabledMiniAppAPI(1, 2, this.iAppLibInDir.getPath(), this.unpackedList);
                }
                if (this.useFlagDisabledMiniAppAPI && string.equals("MINIAPP")) {
                    System.out.println(Resource.getString("WARNING_DISABLED_MINI_APP_PROC_START"));
                    System.out.println(Resource.getString("WARNING_DISABLED_MINI_APP_PROC_END"));
                }
                this.doMove();
                long l = this.jarFile.lastModified();
                this.printLibInfo();
                this.doJar();
                if (this.isPostScript()) {
                    System.out.println(Resource.getString("EXECUTION_POST_SCRIPT"));
                    this.doScript("optimize_script2.bat");
                }
                this.updateJam();
                this.makeDownloadHtml(l);
                this.setProjectInfo();
                System.out.println(Resource.getString("FINISH_BUILD"));
                NumberFormat numberFormat = NumberFormat.getNumberInstance();
                System.out.println(Resource.format("LAST_JARFILE", this.jarFile.getName()) + Resource.format("LAST_JARSIZE", numberFormat.format(this.jarFile.length())));
                this.doJarSizeCheck();
                this.doDeploy();
                this.doIAppliCheck();
                this.doADFNeedCheck();
                System.out.println(Resource.getString("START_BUILD_COMPATI_MSG"));
            } else if (7 == this.buildStatus) {
                FilesystemSizeCounter filesystemSizeCounter = new FilesystemSizeCounter();
                filesystemSizeCounter.accept(this.resDir);
                if (filesystemSizeCounter.getTotal() != 0L) {
                    this.doJarBookmark();
                    System.out.println(Resource.format("MAKE_FILE", this.jarFile.getPath()));
                    if (this.isPreScript()) {
                        System.out.println(Resource.getString("EXECUTION_PRE_SCRIPT"));
                        this.doScript("optimize_script1.bat");
                    }
                    if (this.isPostScript()) {
                        System.out.println(Resource.getString("EXECUTION_POST_SCRIPT"));
                        this.doScript("optimize_script2.bat");
                    }
                    this.updateJamFileBookmarkOk();
                    System.out.println(Resource.getString("FINISH_BUILD"));
                    NumberFormat numberFormat = NumberFormat.getNumberInstance();
                    System.out.println(Resource.format("LAST_JARFILE", this.jarFile.getName()) + Resource.format("LAST_JARSIZE", numberFormat.format(this.jarFile.length())));
                    if (this.jarFile.length() > 102400L) {
                        this.parent.showDialog(Resource.getString("BOOKMARKAPP_JAR_SIZE_WNG"), this.parent, 2);
                    }
                    this.doDeploy();
                    this.doADFNeedCheckSingle();
                } else {
                    System.out.println(Resource.getString("START_BUILD_FORBIDDEN"));
                    this.updateJamFileBookmarkNg();
                }
            }
        }
        catch (BuildException buildException) {
            System.err.println(buildException.getMessage());
            System.out.println(Resource.getString("STOP_BUILD"));
        }
        finally {
            this.deleteAllTmpDir();
            this.parent.setOperatable(true);
        }
    }

    private void runSummaryFullMiniBuild() throws BuildException {
        if (this.isPreScript()) {
            System.out.println(Resource.getString("EXECUTION_PRE_SCRIPT"));
            this.doScript("optimize_script1.bat");
        }
        long l = this.jarFile.lastModified();
        this.doJarFullMini();
        if (this.isPostScript()) {
            System.out.println(Resource.getString("EXECUTION_POST_SCRIPT"));
            this.doScript("optimize_script2.bat");
        }
        this.updateJamFullMini();
        this.makeDownloadHtml(l);
        this.setProjectInfo();
        System.out.println(Resource.getString("FINISH_BUILD"));
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        System.out.println(Resource.format("LAST_JARFILE", this.jarFile.getName()) + Resource.format("LAST_JARSIZE", numberFormat.format(this.jarFile.length())));
        this.doJarSizeCheck();
        this.doDeploy();
        this.doIAppliCheck();
        this.doADFNeedCheckSingle();
    }

    private void runSummaryBuildCheck() throws BuildException {
        if (3 == this.buildStatus) {
            System.out.println(Resource.format("START_FULL_BUILD", this.jarFile.getName()));
        } else if (4 == this.buildStatus) {
            System.out.println(Resource.format("START_MINI_BUILD", this.jarFile.getName()));
        }
        this.doJavac();
        if (this.buildStatus == 4) {
            this.checkDisabledMiniAppAPI(1, 1, this.unverifiedClassDir.getPath(), null);
        }
        this.choiceLibClass();
        String[] stringArray = this.iAppLibInDir.list();
        if (stringArray != null && stringArray.length > 0 && this.buildStatus == 4) {
            this.checkDisabledMiniAppAPI(1, 2, this.iAppLibInDir.getPath(), this.unpackedList);
        }
        if (this.useFlagDisabledMiniAppAPI && this.buildStatus == 4) {
            System.out.println(Resource.getString("WARNING_DISABLED_MINI_APP_PROC_START"));
            System.out.println(Resource.getString("WARNING_DISABLED_MINI_APP_PROC_END"));
        }
        if (3 == this.buildStatus) {
            System.out.println(Resource.format("FINISH_FULL_BUILD", this.jarFile.getName()));
        } else if (4 == this.buildStatus) {
            System.out.println(Resource.format("FINISH_MINI_BUILD", this.jarFile.getName()));
        }
    }

    private void runSummaryBuildJar() throws BuildException {
        if (3 == this.buildStatus) {
            System.out.println(Resource.format("START_FULL_PACKAGING", this.jarFile.getName()));
        } else if (4 == this.buildStatus) {
            System.out.println(Resource.format("START_MINI_PACKAGING", this.jarFile.getName()));
        }
        this.doMove();
        long l = this.jarFile.lastModified();
        this.printLibInfo();
        this.doJar();
        this.updateJam();
        this.makeDownloadHtml(l);
        this.setProjectInfo();
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        if (3 == this.buildStatus) {
            System.out.println(Resource.format("FULL_LAST_JARFILE", this.jarFile.getName()) + Resource.format("LAST_JARSIZE", numberFormat.format(this.jarFile.length())));
        } else if (4 == this.buildStatus) {
            System.out.println(Resource.format("MINI_LAST_JARFILE", this.jarFile.getName()) + Resource.format("LAST_JARSIZE", numberFormat.format(this.jarFile.length())));
        }
        this.doDeploy();
        this.doIAppliCheck();
        this.doTrustedNeedCheck();
        if (3 == this.buildStatus) {
            System.out.println(Resource.getString("FINISH_FULL_PACKAGING"));
        } else if (4 == this.buildStatus) {
            System.out.println(Resource.getString("FINISH_MINI_PACKAGING"));
        }
    }

    private void fullminiBuild() throws BuildException {
        boolean bl = true;
        boolean bl2 = true;
        this.buildStatus = 3;
        this.jamFile = new File(this.parent.getJamPath(this.parent.getFullAppProjectName()));
        this.classpath = Environment.getClasspath(this.parent.getProjectPath(this.parent.getFullAppProjectName()));
        this.BuildProjectSetting(this.jamFile, this.classpath, this.launchType, this.parent);
        if ((JavaFileSelector.get(this.srcDir) == null || JavaFileSelector.get(this.srcDir).size() == 0) && this.jarFile.exists()) {
            bl = false;
        }
        if (bl) {
            this.parent.setBuildErrorTable(this.parent.getFullAppProjectName(), this.parent.getProjectPath(this.parent.getFullAppProjectName()));
            this.runSummaryBuildCheck();
        }
        this.backUpAppInfo(3);
        this.buildStatus = 4;
        this.jamFile = new File(this.parent.getJamPath(this.parent.getMiniAppProjectName()));
        this.classpath = Environment.getClasspath(this.parent.getProjectPath(this.parent.getMiniAppProjectName()));
        this.BuildProjectSetting(this.jamFile, this.classpath, this.launchType, this.parent);
        if ((JavaFileSelector.get(this.srcDir) == null || JavaFileSelector.get(this.srcDir).size() == 0) && this.jarFile.exists()) {
            bl2 = false;
        }
        if (bl2) {
            this.parent.setBuildErrorTable(this.parent.getMiniAppProjectName(), this.parent.getProjectPath(this.parent.getMiniAppProjectName()));
            this.runSummaryBuildCheck();
        }
        this.backUpAppInfo(4);
        if (bl) {
            this.reSetAppInfo(3);
            this.buildStatus = 3;
            this.runSummaryBuildJar();
            this.backUpAppInfo(3);
        }
        if (bl2) {
            this.reSetAppInfo(4);
            this.buildStatus = 4;
            this.runSummaryBuildJar();
            this.backUpAppInfo(4);
        }
        this.buildStatus = 5;
        this.BuildProjectSetting();
        this.runSummaryFullMiniBuild();
    }

    void doJavac() throws BuildException {
        String string = Resource.JAVAC;
        String string2 = Resource.STAR_CONV;
        if (!new File(string).exists()) {
            throw new BuildException(Resource.getString("JDK_HOME_ERR"));
        }
        if (!new File(string2).exists()) {
            throw new BuildException(Resource.format("NOT_FOUND_ERR", string2));
        }
        Vector vector = JavaFileSelector.get(this.srcDir);
        if (vector == null || vector.size() == 0) {
            throw new BuildException(Resource.getString("SRC_NOT_FOUND_ERR"));
        }
        Vector<String> vector2 = new Vector<String>();
        vector2.add(string);
        vector2.add("-J-Xbootclasspath/a:" + string2);
        vector2.add("-target");
        vector2.add("1.2");
        vector2.add("-source");
        vector2.add("1.3");
        vector2.add("-encoding");
        vector2.add("SJIS_i");
        vector2.add("-bootclasspath");
        vector2.add(this.classpath);
        vector2.add("-d");
        vector2.add(this.unverifiedClassDir.getPath());
        vector2.add("-classpath");
        vector2.add(this.unverifiedClassDir.getPath());
        vector2.add("-g:none");
        vector2.addAll(vector);
        String[] stringArray = vector2.toArray(new String[0]);
        try {
            ExecuteProcess executeProcess = new ExecuteProcess(stringArray, this.parent, 1);
            if (executeProcess.execute() != 0) {
                throw new BuildException(Resource.getString("JAVAC_ERR"));
            }
        }
        catch (Exception exception) {
            throw new BuildException(Resource.getString("JAVAC_ERR"));
        }
    }

    void doMove() {
        String[] stringArray = this.getFileInDir(this.verifiedClassDir);
        String[] stringArray2 = this.getFileInDir(this.unverifiedClassDir);
        for (int i = 0; i < stringArray2.length; ++i) {
            File file = new File(this.unverifiedClassDir.getPath() + File.separator + stringArray2[i]);
            File file2 = new File(this.verifiedClassDir.getPath() + File.separator + stringArray2[i]);
            if (file2.exists()) {
                file2.delete();
            }
            if (file.renameTo(file2)) continue;
            int n = file2.getPath().lastIndexOf(File.separator);
            String string = file2.getPath().substring(0, n);
            if (!new File(string).mkdirs()) continue;
            file.renameTo(file2);
        }
        this.overWriteMessage(stringArray, stringArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void makeManifest() throws BuildException {
        String string;
        String string2;
        String string3;
        BufferedWriter bufferedWriter = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string4 = this.projectSetting.getProperty("componentTitle");
        if (string4 != null && string4.length() != 0) {
            hashtable.put("Specification-Title", string4);
        } else {
            string4 = this.projectSetting.getProperty("componentName");
            if (string4 != null) {
                hashtable.put("Specification-Title", string4);
            }
        }
        String string5 = this.projectSetting.getProperty("componentVersion");
        if (string5 != null) {
            hashtable.put("Specification-Version", string5);
        }
        if ((string3 = this.projectSetting.getProperty("componentVendor")) != null) {
            hashtable.put("Specification-Vendor", string3);
        }
        if ((string2 = this.projectSetting.getProperty("componentAuthor")) != null) {
            hashtable.put("Created-By", string2);
        }
        if ((string = new String(StarDoJaChecker.getBuildTargetProfile())) != null) {
            hashtable.put("Build-By", string);
        }
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.stubDir, "manifest.mf")), "UTF-8"));
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string6 = (String)enumeration.nextElement();
                String string7 = (String)hashtable.get(string6);
                String string8 = string6.trim() + ": " + string7.trim() + "\r\n";
                bufferedWriter.write(string8);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                bufferedWriter.close();
            }
            catch (Exception exception) {}
        }
    }

    File makeCompatiManifest() throws BuildException {
        BufferedWriter bufferedWriter = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put(MANIFEST_KEY_IAPPLI_CREATED_BY, Resource.getString("EMULATOR_VERSION"));
        hashtable.put(MANIFEST_KEY_PREVERIFIED, MANIFEST_VALUE_PREVERIFIED);
        try {
            File file = File.createTempFile("temp", "manifest");
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            Object object = hashtable.keys();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                String string2 = (String)hashtable.get(string);
                String string3 = string.trim() + ": " + string2.trim() + "\r\n";
                bufferedWriter.write(string3);
            }
            object = file;
            return object;
        }
        catch (Exception exception) {
            throw new BuildException(Resource.getString("MAKE_TMP_FILE_ERR"));
        }
        finally {
            try {
                bufferedWriter.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    String[] loadListFile() {
        var1_1 = null;
        var1_1 = this.buildStatus == 4 ? this.parent.getProjectPath(this.parent.getMiniAppProjectName()) + File.separator + "component.list" : (this.buildStatus == 3 ? this.parent.getProjectPath(this.parent.getFullAppProjectName()) + File.separator + "component.list" : this.parent.getProjectPath(this.parent.getProjectName()) + File.separator + "component.list");
        var2_2 = new File(var1_1);
        if (!var2_2.exists()) {
            return new String[0];
        }
        var3_3 = 0;
        var4_4 = null;
        var5_5 = null;
        var6_6 = null;
        var7_7 = null;
        var8_8 = new Vector<String>();
        try {
            var7_7 = new BufferedReader(new InputStreamReader(new FileInputStream(var2_2)));
            var9_9 = 0;
            while ((var4_4 = var7_7.readLine()) != null) {
                var4_4 = var4_4.trim();
                if (var9_9 != 0) ** GOTO lbl25
                if (var4_4.equals("true")) {
                    this.isOnlyReqClass = true;
                } else if (var4_4.equals("false")) {
                    this.isOnlyReqClass = false;
                } else {
                    this.isOnlyReqClass = true;
lbl25:
                    // 2 sources

                    if ((var3_3 = var4_4.lastIndexOf(32)) >= 0) {
                        var5_5 = var4_4.substring(0, var3_3).trim();
                        var6_6 = var4_4.substring(var3_3 + 1);
                        if (var6_6.length() == 1 && !var6_6.equals("0")) {
                            var8_8.addElement(var5_5);
                        }
                    }
                }
                ++var9_9;
            }
        }
        catch (FileNotFoundException var9_11) {
            var10_14 = null;
            return var10_14;
        }
        catch (IOException var9_12) {
            var10_15 = null;
            return var10_15;
        }
        catch (Exception var9_13) {
            var10_16 = null;
            return var10_16;
            {
                catch (Throwable var12_20) {
                    throw var12_20;
                }
            }
        }
        finally {
            try {
                var7_7.close();
            }
            catch (Exception var11_17) {}
        }
        if (var8_8.size() > 0) {
            return var8_8.toArray(new String[0]);
        }
        return new String[0];
    }

    void doJar() throws BuildException {
        block26: {
            this.jarFile.delete();
            if (this.buildSwitch == 1) {
                this.jarCompFile.delete();
                String string = this.projectSetting.getProperty("stubSourceName");
                int n = string.indexOf(".java");
                String string2 = string.substring(0, n) + ".class";
                String[] stringArray = this.getFileInDir(this.stubDir);
                File file = new File(this.verifiedClassDir, string2);
                File file2 = new File(this.stubDir, string2);
                if (file2.exists()) {
                    file2.delete();
                }
                if (!file.renameTo(file2)) {
                    throw new BuildException(Resource.getString("JAR_ERR"));
                }
                String[] stringArray2 = new String[]{string2};
                this.overWriteMessage(stringArray, stringArray2);
                try {
                    if (this.verifiedClassDir.list().length == 0) {
                        throw new BuildException(Resource.getString("JAR_ERR"));
                    }
                    String[] stringArray3 = this.makeJarCommand("cfM", this.verifiedClassDir.getPath(), this.jarCompFile.getPath(), true);
                    ExecuteProcess executeProcess = new ExecuteProcess(stringArray3);
                    if (executeProcess.execute() != 0) {
                        throw new BuildException(Resource.getString("JAR_ERR"));
                    }
                    stringArray3 = this.makeJarCommand("ufM", this.resDir.getPath(), this.jarCompFile.getPath(), true);
                    executeProcess = new ExecuteProcess(stringArray3);
                    if (executeProcess.execute() != 0) {
                        throw new BuildException(Resource.getString("JAR_ERR"));
                    }
                    JarAccess jarAccess = new JarAccess(this.jarCompFile.getPath());
                    jarAccess.unpack(this.stubDir.getPath());
                    stringArray3 = this.makeJarCommand("cfM", this.stubDir.getPath(), this.jarFile.getPath(), true);
                    executeProcess = new ExecuteProcess(stringArray3);
                    if (executeProcess.execute() != 0) {
                        throw new BuildException(Resource.getString("JAR_ERR"));
                    }
                    this.makeManifest();
                    stringArray3 = this.makeJarCommand("ufm", new File(this.stubDir, "manifest.mf").getPath(), this.jarCompFile.getPath(), false);
                    executeProcess = new ExecuteProcess(stringArray3);
                    if (executeProcess.execute() != 0) {
                        throw new BuildException(Resource.getString("JAR_ERR"));
                    }
                    break block26;
                }
                catch (BuildException buildException) {
                    throw buildException;
                }
                catch (Exception exception) {
                    throw new BuildException(Resource.format("MAKE_JAR_ERR", this.jarFile.getPath()));
                }
            }
            File file = null;
            try {
                String[] stringArray = this.makeJarCommand("cfM", this.verifiedClassDir.getPath());
                ExecuteProcess executeProcess = new ExecuteProcess(stringArray);
                if (executeProcess.execute() != 0) {
                    throw new BuildException(Resource.getString("JAR_ERR"));
                }
                stringArray = this.makeJarCommand("ufM", this.resDir.getPath());
                executeProcess = new ExecuteProcess(stringArray);
                if (executeProcess.execute() != 0) {
                    throw new BuildException(Resource.getString("JAR_ERR"));
                }
                if (this.libDir != null && (executeProcess = new ExecuteProcess(stringArray = this.makeJarCommand("ufM", this.libDir.getPath()))).execute() != 0) {
                    throw new BuildException(Resource.getString("JAR_ERR"));
                }
                file = this.makeCompatiManifest();
                stringArray = this.makeJarCommand("umf", file, this.jarFile);
                executeProcess = new ExecuteProcess(stringArray);
                if (executeProcess.execute() != 0) {
                    throw new BuildException(Resource.getString("JAR_ERR"));
                }
            }
            catch (BuildException buildException) {
                throw buildException;
            }
            catch (Exception exception) {
                throw new BuildException(Resource.format("MAKE_JAR_ERR", this.jarFile.getPath()));
            }
            finally {
                try {
                    file.delete();
                }
                catch (Exception exception) {}
            }
        }
        System.out.println(Resource.format("MAKE_FILE", this.jarFile.getPath()));
        if (this.buildSwitch == 1) {
            System.out.println(Resource.format("MAKE_FILE", this.jarCompFile.getPath()));
        }
    }

    void doJarFullMini() throws BuildException {
        this.jarFile.delete();
        this.checkDisabledMiniAppAPI(2, 1, this.miniJarFile.getPath(), null);
        File file = null;
        try {
            String[] stringArray = this.makeJarCommand("cfM", this.fullJarFile.getName(), this.fullJarFile.getParent(), this.miniJarFile.getName(), this.miniJarFile.getParent());
            ExecuteProcess executeProcess = new ExecuteProcess(stringArray);
            if (executeProcess.execute() != 0) {
                throw new BuildException(Resource.getString("JAR_ERR"));
            }
            if (this.resDir.exists() && (executeProcess = new ExecuteProcess(stringArray = this.makeJarCommand("ufM", this.resDir.getPath()))).execute() != 0) {
                throw new BuildException(Resource.getString("JAR_ERR"));
            }
            file = this.makeCompatiManifest();
            stringArray = this.makeJarCommand("umf", file, this.jarFile);
            executeProcess = new ExecuteProcess(stringArray);
            if (executeProcess.execute() != 0) {
                throw new BuildException(Resource.getString("JAR_ERR"));
            }
        }
        catch (BuildException buildException) {
            throw buildException;
        }
        catch (Exception exception) {
            throw new BuildException(Resource.format("MAKE_JAR_ERR", this.jarFile.getPath()));
        }
        finally {
            try {
                file.delete();
            }
            catch (Exception exception) {}
        }
        System.out.println(Resource.format("MAKE_FILE", this.jarFile.getPath()));
    }

    void doJarBookmark() throws BuildException {
        this.jarFile.delete();
        try {
            String[] stringArray = this.makeJarCommand("cfM", this.resDir.getPath());
            ExecuteProcess executeProcess = new ExecuteProcess(stringArray, this.resDir);
            if (executeProcess.execute() != 0) {
                throw new BuildException(Resource.getString("JAR_ERR"));
            }
        }
        catch (BuildException buildException) {
            throw buildException;
        }
        catch (Exception exception) {
            throw new BuildException(Resource.format("MAKE_JAR_ERR", this.jarFile.getPath()));
        }
    }

    void updateJam() throws BuildException {
        String string = this.adf.getProperty("AppName");
        String string2 = this.adf.getProperty("AppClass");
        this.adf.setProperty("AppSize", String.valueOf(this.jarFile.length()));
        this.adf.setProperty("LastModified", this.getDate());
        try {
            if (string == null || string.equals("") || string2 == null || string2.equals("")) {
                SourceChecker sourceChecker = new SourceChecker();
                ArrayList arrayList = sourceChecker.getSourceList(this.srcDir.getPath());
                for (int i = 0; i < arrayList.size(); ++i) {
                    System.out.println(arrayList.get(i));
                }
                if (sourceChecker.checkMainClass(arrayList)) {
                    if (string == null) {
                        this.adf.setProperty("AppName", sourceChecker.getClassName());
                        System.out.println(Resource.format("UPDATE_ADFKEY", "AppName"));
                    }
                    if (string2 == null) {
                        if (sourceChecker.getPackageName().length() == 0) {
                            this.adf.setProperty("AppClass", sourceChecker.getClassName());
                        } else {
                            this.adf.setProperty("AppClass", sourceChecker.getPackageName() + "." + sourceChecker.getClassName());
                        }
                        System.out.println(Resource.format("UPDATE_ADFKEY", "AppClass"));
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.parent.saveProject(this.projectName, this.adf) == 0) {
            System.out.println(Resource.format("UPDATE_FILE", this.jamFile.getPath()));
        }
    }

    void updateJamFullMini() throws BuildException {
        String string = this.adf.getProperty("AppName");
        try {
            if (this.parent.getAppType() == 8) {
                this.adf.setProperty("InnerAppSize", this.fullJarFile.length() + "," + this.miniJarFile.length());
                this.adf.setProperty("InnerPackageName", this.fullJarFile.getName() + "," + this.miniJarFile.getName());
                this.adf.setProperty("AppClass", this.fullAdf.getProperty("AppClass") + "," + this.miniAdf.getProperty("AppClass"));
            } else if (this.parent.getAppType() == 16) {
                this.adf.setProperty("InnerAppSize", this.miniJarFile.length() + "," + this.fullJarFile.length());
                this.adf.setProperty("InnerPackageName", this.miniJarFile.getName() + "," + this.fullJarFile.getName());
                this.adf.setProperty("AppClass", this.miniAdf.getProperty("AppClass") + "," + this.fullAdf.getProperty("AppClass"));
            }
            if (string == null) {
                this.adf.setProperty("AppName", this.parent.getProjectName());
            }
            this.adf.setProperty("AppSize", String.valueOf(this.jarFile.length()));
            this.adf.setProperty("LastModified", this.getDate());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.parent.saveProject(this.projectName, this.adf) == 0) {
            System.out.println(Resource.format("UPDATE_FILE", this.jamFile.getPath()));
        }
    }

    void updateJamFileBookmarkOk() throws BuildException {
        try {
            String string = this.adf.getProperty("AppName");
            if (string == null || string.equals("")) {
                this.adf.setProperty("AppName", this.projectName);
                System.out.println(Resource.format("UPDATE_ADFKEY", "AppName"));
            }
            this.adf.setProperty("BookmarkSize", Long.toString(this.jarFile.length()));
            System.out.println(Resource.format("UPDATE_ADFKEY", "BookmarkSize"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.parent.saveProject(this.projectName, this.adf) == 0) {
            System.out.println(Resource.format("UPDATE_FILE", this.jamFile.getPath()));
        }
    }

    void updateJamFileBookmarkNg() throws BuildException {
        try {
            this.adf.removeBookmarkSize();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.parent.saveProject(this.projectName, this.adf) == 0) {
            System.out.println(Resource.format("UPDATE_FILE", this.jamFile.getPath()));
        }
    }

    void makeDownloadHtml(long l) throws BuildException {
        try {
            String string;
            String string2 = System.getProperty("emu.home") + File.separator + "lib" + File.separator + "template" + File.separator + DOWNLOADHTML_TEMP;
            if (this.downloadFile.exists() && l > 0L) {
                long l2 = this.downloadFile.lastModified() / 1000L;
                long l3 = Math.abs((l /= 1000L) - l2);
                if (l3 > 5L) {
                    return;
                }
                if (!this.checkDownloadHtml(this.downloadFile.toString(), string2)) {
                    return;
                }
            }
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.downloadFile.toString())));
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string2)));
            while ((string = bufferedReader.readLine()) != null) {
                string = this.replaceKeyword(string);
                bufferedWriter.write(string + "\r\n");
            }
            bufferedWriter.close();
            bufferedReader.close();
            System.out.println(Resource.format("MAKE_FILE", this.downloadFile.getPath()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkDownloadHtml(String string, String string2) {
        boolean bl = true;
        BufferedReader bufferedReader = null;
        BufferedReader bufferedReader2 = null;
        try {
            String string3;
            String string4;
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
            bufferedReader2 = new BufferedReader(new InputStreamReader(new FileInputStream(string2)));
            while (bl && (string4 = bufferedReader.readLine()) != null) {
                string3 = bufferedReader2.readLine();
                if (string3 != null) {
                    if (!bl || this.compare(string3, string4)) continue;
                    bl = false;
                    break;
                }
                bl = false;
                break;
            }
            if (bl && (string3 = bufferedReader2.readLine()) != null) {
                bl = false;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    bl = false;
                }
            }
            if (bufferedReader2 != null) {
                try {
                    bufferedReader2.close();
                }
                catch (Exception exception) {
                    bl = false;
                }
            }
            bufferedReader = null;
            bufferedReader2 = null;
        }
        return bl;
    }

    String replaceKeyword(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while ((n = string.indexOf("{", n3)) != -1 && (n2 = string.indexOf("}", n3)) != -1) {
            String string2;
            String string3 = string.substring(n + 1, n2);
            if (string3.equals(PROJECTNAME)) {
                string = string.substring(0, n) + this.projectName + string.substring(n2 + 1);
                n3 = n + this.projectName.length();
                continue;
            }
            if (string3.equals(PACKAGEURL)) {
                string2 = this.adf.getProperty("PackageURL");
                string = string.substring(0, n) + string2.substring(0, string2.lastIndexOf(".")) + ".jam" + string.substring(n2 + 1);
                n3 = n + string2.substring(0, string2.lastIndexOf(".")).length() + 4;
                continue;
            }
            if (string3.equals(ATTRIBUTE)) {
                string2 = "ijam";
                if (this.launchType == 5) {
                    string2 = "ista";
                }
                string = string.substring(0, n) + string2 + string.substring(n2 + 1);
                n3 = n + string2.length();
                continue;
            }
            n3 = n2;
        }
        return string;
    }

    boolean compare(String string, String string2) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        String string3 = null;
        try {
            while ((n = string.indexOf("{", n3)) != -1 && (n2 = string.indexOf("}", n3)) != -1) {
                String string4 = string.substring(n + 1, n2);
                n5 = string4.equals(PROJECTNAME) || string4.equals(PACKAGEURL) || string4.equals(ATTRIBUTE) ? n - n3 : n2 - n3;
                if (!string.regionMatches(n3, string2, n4, n5)) {
                    return false;
                }
                n3 = n2 + 1;
                n = string.indexOf("{", n3);
                string3 = n == -1 ? string.substring(n3) : string.substring(n3, n);
                n4 = string2.indexOf(string3, n4 + n5);
                if (n4 != -1) continue;
                return false;
            }
            if (!string.regionMatches(n3, string2, n4, string.length() - n3)) {
                return false;
            }
            if (string.length() - n3 != string2.length() - n4) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private void setProjectInfo() {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        int n = 128;
        String string5 = "@info";
        try {
            string4 = this.projectSetting.getProperty("projectInfo");
            ADF aDF = new ADF(this.jamFile);
            string2 = aDF.getProperty("AppClass");
            string3 = this.getAppClassSrcPath(string2);
            if (new File(string3).exists()) {
                ReadWindowClassTag readWindowClassTag = new ReadWindowClassTag(string3);
                readWindowClassTag.set(string5);
                string = readWindowClassTag.getTagText(n);
            } else {
                SourceChecker sourceChecker = new SourceChecker();
                ArrayList arrayList = sourceChecker.getSourceList(this.srcDir.getPath());
                if (sourceChecker.checkMainClass(arrayList)) {
                    string2 = sourceChecker.getPackageName().length() == 0 ? sourceChecker.getClassName() : sourceChecker.getPackageName() + "." + sourceChecker.getClassName();
                    string3 = this.getAppClassSrcPath(string2);
                    if (string3.length() != 0) {
                        ReadWindowClassTag readWindowClassTag = new ReadWindowClassTag(string3);
                        readWindowClassTag.set(string5);
                        string = readWindowClassTag.getTagText(n);
                    } else {
                        string = "";
                    }
                } else {
                    if (string4 == null) {
                        return;
                    }
                    string = "";
                }
            }
            if (string == null && string4 == null) {
                return;
            }
            if (string == null) {
                string = "";
            }
            this.projectSetting.setProperty("projectInfo", string);
            this.parent.saveProjectSetting(this.projectSetting);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getAppClassSrcPath(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "";
        if (string == null) {
            return "";
        }
        if (string.length() == 0) {
            return "";
        }
        try {
            String string3;
            String string4;
            Object object;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".", true);
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken();
                if (((String)object).equals(".")) {
                    stringBuffer.append(File.separator);
                    continue;
                }
                stringBuffer.append((String)object);
            }
            stringBuffer.append(".java");
            string2 = this.srcDir.getPath() + File.separator + stringBuffer.toString();
            object = new File(string2);
            if (!(((File)object).exists() || ((File)(object = new File(string2 = (string4 = this.srcDir.getParent()) + File.separator + stringBuffer.toString()))).exists() || ((File)(object = new File(string2 = (string3 = this.srcDir.getParentFile().getParent()) + File.separator + stringBuffer.toString()))).exists())) {
                string2 = "";
            }
        }
        catch (Exception exception) {
            string2 = "";
        }
        return string2;
    }

    private boolean isPreScript() {
        int n = this.parent.getBuildSetting();
        return n == 1 || n == 3;
    }

    private boolean isPostScript() {
        int n = this.parent.getBuildSetting();
        return n == 2 || n == 3;
    }

    private void doScript(String string) throws BuildException {
        String string2 = System.getProperty("emu.home") + File.separator + "lib" + File.separator + string;
        this.jamFile.getParentFile().getParentFile();
        if (!new File(string2).exists()) {
            throw new BuildException(Resource.format("NOT_FOUND_ERR", string2));
        }
        String[] stringArray = new String[]{string2};
        String[] stringArray2 = new String[]{"PROJECT_NAME=" + this.parent.getProjectName(), "JAR_PATH=" + Resource.JAR, "APP_CLASS=" + this.getAppClass()};
        try {
            ExecuteProcess executeProcess = new ExecuteProcess(stringArray, stringArray2, this.binDir);
            if (executeProcess.execute() != 0) {
                throw new BuildException(Resource.getString("SCRIPT_ERR"));
            }
        }
        catch (Exception exception) {
            throw new BuildException(Resource.getString("SCRIPT_ERR"));
        }
    }

    private String getAppClass() {
        String string = this.adf.getProperty("AppClass");
        try {
            SourceChecker sourceChecker = new SourceChecker();
            ArrayList arrayList = sourceChecker.getSourceList(this.srcDir.getPath());
            if (sourceChecker.checkMainClass(arrayList) && string == null) {
                string = sourceChecker.getPackageName().length() == 0 ? sourceChecker.getClassName() : sourceChecker.getPackageName() + "." + sourceChecker.getClassName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string == null) {
            string = "";
        }
        return string;
    }

    void doIAppliCheck() {
        try {
            IAppliChecker iAppliChecker = new IAppliChecker();
            iAppliChecker.iAppliChecker(this.jarFile.getPath());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void choiceLibClass() throws BuildException {
        String[] stringArray = this.iAppLibInDir.list();
        if (stringArray == null || stringArray.length == 0) {
            this.isOnlyReqClass = false;
            return;
        }
        if (this.isOnlyReqClass) {
            IAppLibInclude iAppLibInclude = new IAppLibInclude();
            Vector vector = new Vector();
            try {
                iAppLibInclude.setClassesList(this.unverifiedClassDir.getPath(), this.iAppLibInDir.getPath());
                vector.addAll(iAppLibInclude.getNoUseClass());
                this.includeLibList.addAll(iAppLibInclude.getNeedClassName());
                this.unUsedLibList.addAll(iAppLibInclude.getNoUseClassName());
            }
            catch (Exception exception) {
                System.out.println(Resource.getString("BLD_COMP_INCLUDE_ERR"));
                this.isOnlyReqClass = false;
            }
            if (this.isOnlyReqClass) {
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    File file = new File((String)enumeration.nextElement());
                    if (!file.exists()) continue;
                    file.delete();
                }
                this.deleteEmptyDir(this.iAppLibInDir);
            }
        }
    }

    private boolean deleteEmptyDir(File file) {
        boolean bl = true;
        try {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].isDirectory()) continue;
                this.deleteEmptyDir(fileArray[i]);
                File[] fileArray2 = fileArray[i].listFiles();
                if (fileArray2.length != 0 || fileArray[i].delete()) continue;
                bl = false;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    void doADFNeedCheck() {
        this.jamFile = new File(this.parent.getJamPath(this.parent.getProjectName()));
        try {
            ADFNeedChecker aDFNeedChecker = new ADFNeedChecker(this.parent);
            aDFNeedChecker.ADFNeedCheck(this.jamFile.getPath(), this.jarFile.getPath());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void doADFNeedCheckSingle() {
        this.jamFile = new File(this.parent.getJamPath(this.parent.getProjectName()));
        try {
            ADFNeedChecker aDFNeedChecker = new ADFNeedChecker(this.parent);
            aDFNeedChecker.ADFNeedCheck(this.jamFile.getPath());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void doTrustedNeedCheck() {
        this.jamFile = new File(this.parent.getJamPath(this.parent.getProjectName()));
        try {
            ADFNeedChecker aDFNeedChecker = new ADFNeedChecker(this.parent);
            aDFNeedChecker.TrustedNeedCheck(this.jamFile.getPath(), this.jarFile.getPath());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void doDeploy() {
        if (!this.parent.getSimultaneousWithBuild()) {
            return;
        }
        DeployWindow deployWindow = new DeployWindow(this.parent, this.projectSetting, false);
        if (deployWindow.saveSetting()) {
            deployWindow.deployFiles();
        }
        deployWindow.dispose();
        deployWindow = null;
    }

    private void overWriteMessage(String[] stringArray, String[] stringArray2) {
        if (stringArray == null || stringArray2 == null) {
            return;
        }
        Arrays.sort(stringArray);
        Arrays.sort(stringArray2);
        try {
            for (int i = 0; i < stringArray2.length; ++i) {
                if (Arrays.binarySearch(stringArray, stringArray2[i]) < 0) continue;
                System.out.println(Resource.format("OVERWRITE_FILE", stringArray2[i]));
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    private String[] getFileInDir(File file) {
        int n;
        File[] fileArray;
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        String string = "";
        String string2 = "";
        int n2 = 0;
        if (this.buildSwitch == 1) {
            string2 = this.stubDir.toString();
        }
        String[] stringArray = new String[]{this.verifiedClassDir.toString(), this.unverifiedClassDir.toString(), string2};
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(file.toString())) continue;
            n2 = file.toString().length() + File.separator.length();
            break;
        }
        if ((fileArray = file.listFiles()) == null) {
            return null;
        }
        if (fileArray.length == 0) {
            return null;
        }
        for (n = 0; n < fileArray.length; ++n) {
            if (fileArray[n].isDirectory()) {
                String[] stringArray2 = this.getFileInDir(fileArray[n]);
                if (stringArray2 == null) continue;
                for (int i = 0; i < stringArray2.length; ++i) {
                    vector.addElement(stringArray2[i]);
                }
                continue;
            }
            vector.addElement(fileArray[n].getPath());
        }
        vector.trimToSize();
        if (vector.size() == 0) {
            return null;
        }
        for (n = 0; n < vector.size(); ++n) {
            string = ((String)vector.get(n)).substring(n2);
            vector2.addElement(string);
        }
        vector2.trimToSize();
        return vector2.toArray(new String[0]);
    }

    void printLibInfo() {
        if (this.isOnlyReqClass) {
            StringBuffer stringBuffer = new StringBuffer(Resource.getString("BLD_COMP_START_SEPARATE"));
            if (this.overWriteInfo.size() != 0) {
                Enumeration enumeration = this.overWriteInfo.elements();
                while (enumeration.hasMoreElements()) {
                    stringBuffer.append(Resource.format("BLD_COMP_OVERWRITE_CLS", (String)enumeration.nextElement()));
                }
            }
            int n = 1;
            int n2 = this.includeLibList.size();
            stringBuffer.append(Resource.getString("BLD_COMP_USE_CLASS"));
            int n3 = 0;
            while (n3 < n2) {
                stringBuffer.append((String)this.includeLibList.get(n3));
                if (n < 4) {
                    if (n3 < n2 - 1) {
                        stringBuffer.append(", ");
                    } else {
                        stringBuffer.append("\n");
                    }
                } else if (n == 4) {
                    stringBuffer.append("\n");
                    n = 0;
                }
                ++n3;
                ++n;
            }
            n = 1;
            n2 = this.unUsedLibList.size();
            stringBuffer.append(Resource.getString("BLD_COMP_UNUSED_CLASS"));
            n3 = 0;
            while (n3 < n2) {
                stringBuffer.append((String)this.unUsedLibList.get(n3));
                if (n < 4) {
                    if (n3 < n2 - 1) {
                        stringBuffer.append(", ");
                    } else {
                        stringBuffer.append("\n");
                    }
                } else if (n == 4) {
                    stringBuffer.append("\n");
                    n = 0;
                }
                ++n3;
                ++n;
            }
            stringBuffer.append(Resource.getString("BLD_COMP_END_SEPARATE"));
            System.out.println(stringBuffer.toString());
        } else if (this.overWriteInfo.size() != 0) {
            StringBuffer stringBuffer = new StringBuffer(Resource.getString("BLD_COMP_START_SEPARATE"));
            Enumeration enumeration = this.overWriteInfo.elements();
            while (enumeration.hasMoreElements()) {
                stringBuffer.append(Resource.format("BLD_COMP_OVERWRITE_CLS", (String)enumeration.nextElement()));
            }
            stringBuffer.append(Resource.getString("BLD_COMP_END_SEPARATE"));
            System.out.println(stringBuffer.toString());
        }
    }

    private void outputWarningMessage() {
        int n = 0;
        if (this.useFlagDisabledMiniAppAPI) {
            if (this.warningList == null) {
                return;
            }
            n = this.warningList.size();
            System.out.println(Resource.getString("WARNING_DISABLED_MINI_APP_PROC_START"));
            for (int i = 0; i < n; ++i) {
                String[] stringArray = (String[])this.warningList.get(i);
                for (int j = 0; j < stringArray.length; ++j) {
                    System.out.println(stringArray[j]);
                }
            }
            System.out.println(Resource.getString("WARNING_DISABLED_MINI_APP_PROC_END"));
        }
    }

    private void checkDisabledMiniAppAPI(int n, int n2, String string, Object object) throws BuildException {
        StarFilesChecker starFilesChecker = null;
        if (this.useFlagDisabledMiniAppAPI) {
            try {
                starFilesChecker = new StarFilesChecker(n, n2, string, object);
                String[] stringArray = starFilesChecker.doCheck();
                if (stringArray != null && stringArray.length > 0) {
                    this.warningList.add(stringArray);
                    this.outputWarningMessage();
                    throw new BuildException(Resource.getString("WARNING_DISABLED_MINI_APP_BREAK"));
                }
            }
            catch (StarFilesCheckerException starFilesCheckerException) {
                throw new BuildException(starFilesCheckerException.getMessage());
            }
        }
    }

    private void initDisabledMiniAppAPI(ADF aDF, Setting setting) {
        int n = 0;
        String string = null;
        String string2 = null;
        String string3 = null;
        this.useFlagDisabledMiniAppAPI = false;
        this.javaLibPath = null;
        n = this.parent.getCheckSetting();
        if ((n & 4) != 0) {
            this.useFlagDisabledMiniAppAPI = true;
        }
        if (aDF == null || setting == null) {
            return;
        }
        string = aDF.getProperty("AppType");
        string2 = aDF.getProperty("LibADFURL");
        if (string != null && string.length() > 0 && (string = string.toUpperCase()).equals("FULLAPP") && string2 != null && string2.length() > 0 && (string3 = setting.getProperty("classpath")) != null && string3.length() > 0 && new File(string3).exists()) {
            this.javaLibPath = string3;
        }
    }

    void setFullMiniBuildStatas(MainWindow mainWindow) {
        if (this.buildStatus == 0) {
            this.buildStatus = mainWindow.getAppType() == 8 || mainWindow.getAppType() == 16 ? 2 : (mainWindow.getAppType() == 32 ? 7 : 1);
        }
    }

    void doJarSizeCheck() {
        String string;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Object[] objectArray = null;
        StringTokenizer stringTokenizer = null;
        ArrayList<String> arrayList = null;
        boolean bl = false;
        String string2 = this.adf.getProperty("AppType").toUpperCase();
        if ((string2.equals("FULLAPP,MINIAPP") || string2.equals("MINIAPP,FULLAPP")) && this.adf.getProperty("InnerAppSize") != null) {
            string = this.adf.getProperty("InnerAppSize");
            String[] stringArray = string.split(",");
            try {
                if (string2.equals("FULLAPP,MINIAPP")) {
                    n3 = Integer.parseInt(stringArray[0]);
                    n4 = Integer.parseInt(stringArray[1]);
                } else if (string2.equals("MINIAPP,FULLAPP")) {
                    n4 = Integer.parseInt(stringArray[0]);
                    n3 = Integer.parseInt(stringArray[1]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            if (n3 > 0xA00000) {
                this.parent.showDialog(Resource.getString("INNER_FULLAPP_JAR_SIZE_WNG"), this.parent, 2);
                bl = true;
            }
            if (n4 > 51200) {
                this.parent.showDialog(Resource.getString("INNER_MINIAPP_JAR_SIZE_WNG"), this.parent, 2);
                bl = true;
            }
        }
        if (!bl) {
            if (this.adf.getProperty("SPsize") != null && (string2.equals("FULLAPP") || string2.equals("FULLAPP,MINIAPP") || string2.equals("MINIAPP,FULLAPP"))) {
                string = this.adf.getProperty("SPsize");
                arrayList = new ArrayList<String>();
                stringTokenizer = new StringTokenizer(string, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(stringTokenizer.nextToken());
                }
                objectArray = arrayList.toArray();
                if (objectArray.length > 16) {
                    return;
                }
                for (int i = 0; i < objectArray.length; ++i) {
                    try {
                        int n5 = Integer.parseInt((String)objectArray[i]);
                        if (n5 < 0) {
                            return;
                        }
                        n2 += n5;
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return;
                    }
                }
            }
            if (this.adf.getProperty("AppSize") != null) {
                try {
                    n = Integer.parseInt(this.adf.getProperty("AppSize"));
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
            }
            if (string2.equals("FULLAPP") || string2.equals("FULLAPP,MINIAPP") || string2.equals("MINIAPP,FULLAPP")) {
                if (n + n2 > 0xA00000) {
                    this.parent.showDialog(Resource.getString("FULLAPP_JAR_SIZE_WNG"), this.parent, 2);
                }
            } else if (string2.equals("MINIAPP") && n > 51200) {
                this.parent.showDialog(Resource.getString("MINIAPP_JAR_SIZE_WNG"), this.parent, 2);
            }
        }
    }
}

