/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.CustomWindowsComboBoxUI;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.plaf.ComboBoxUI;

class ComPortEditWindow
extends AbstractWindow {
    private static final int FRAME_WIDTH = 200;
    private static final int FRAME_HEIGHT = 100;
    private static final int MAX_PORT_NAME_COUNT = 10;
    private Hashtable comPortHash;
    private Integer portNo;
    private String portName;
    private MainWindow parent;
    private JComboBox portNoList;
    private JComboBox portNameList;
    private boolean edited;

    ComPortEditWindow(MainWindow mainWindow, Integer n, String string, Hashtable hashtable) {
        super(mainWindow, Resource.getString("COM_PORT_EDIT_FOR_UART_WINDOW_TITLE"));
        this.parent = mainWindow;
        this.comPortHash = hashtable;
        this.portNo = n;
        this.portName = string;
        this.edited = false;
        this.addWindowListener();
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new FlowLayout(1));
        this.portNoList = new JComboBox();
        this.portNoList.setUI((ComboBoxUI)((Object)new CustomWindowsComboBoxUI()));
        this.getPortNoList();
        jPanel.add(this.portNoList);
        this.portNameList = new JComboBox();
        this.portNameList.setUI((ComboBoxUI)((Object)new CustomWindowsComboBoxUI()));
        this.getPortNameList();
        jPanel.add(this.portNameList);
        Dimension dimension = new Dimension(this.portNameList.getPreferredSize().width, this.portNameList.getPreferredSize().height);
        this.portNoList.setPreferredSize(dimension);
        JPanel jPanel2 = new JPanel(new FlowLayout(1));
        JButton jButton = new JButton(Resource.getString("SET"));
        JButton jButton2 = new JButton(Resource.getString("CANCEL"));
        jButton.setActionCommand("set");
        jButton2.setActionCommand("cancel");
        jButton.addActionListener(actionDispatcher);
        jButton2.addActionListener(actionDispatcher);
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add(jPanel);
        JPanel jPanel4 = new JPanel();
        jPanel4.add(jPanel2);
        container.add("Center", jPanel3);
        container.add("South", jPanel4);
        this.setResizable(false);
        this.setSize(200, 100);
    }

    void set() {
        if (-1 == this.portNoList.getSelectedIndex() || -1 == this.portNameList.getSelectedIndex()) {
            return;
        }
        try {
            Integer n = Integer.valueOf((String)this.portNoList.getSelectedItem());
            String string = (String)this.portNameList.getSelectedItem();
            if (null == this.portNo) {
                if (this.comPortHash.containsKey(n) && ((String)this.comPortHash.get(n)).startsWith("COM")) {
                    this.parent.showDialog(Resource.getString("COM_PORT_NO_DUPLICATION"), this, 2);
                    return;
                }
                if (this.comPortHash.contains(string)) {
                    this.parent.showDialog(Resource.getString("COM_PORT_NAME_DUPLICATION"), this, 2);
                    return;
                }
            } else {
                Enumeration enumeration = this.comPortHash.keys();
                while (enumeration.hasMoreElements()) {
                    Integer n2 = null;
                    Object k = enumeration.nextElement();
                    if (k == null || !(k instanceof Integer) || n.equals(n2 = (Integer)k) || !string.equals((String)this.comPortHash.get(n2))) continue;
                    this.parent.showDialog(Resource.getString("COM_PORT_NAME_DUPLICATION"), this, 2);
                    return;
                }
            }
            this.comPortHash.put(n, string);
            this.edited = true;
            this.setVisible(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    boolean isEdited() {
        return this.edited;
    }

    void cancel() {
        this.setVisible(false);
    }

    private void getPortNoList() {
        Integer n = null;
        int n2 = 0;
        for (int i = 0; i < 1; ++i) {
            n = new Integer(i);
            this.portNoList.addItem(n.toString());
            if (null == this.portNo || !n.equals(this.portNo)) continue;
            n2 = i;
        }
        this.portNoList.setSelectedIndex(n2);
        if (this.portNo != null) {
            this.portNoList.setEnabled(false);
        }
    }

    private void getPortNameList() {
        int n = 0;
        String string = null;
        for (int i = 0; i < 10; ++i) {
            string = "COM" + (i + 1);
            this.portNameList.addItem(string);
            if (null == this.portName || !string.equals(this.portName)) continue;
            n = i;
        }
        this.portNameList.setSelectedIndex(n);
    }
}

