/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow2;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher2;
import com.nttdocomo.dojaemu.ktoolbar.CompassCsvRecord;
import com.nttdocomo.dojaemu.ktoolbar.CompassDataUtil;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.StringDocument;
import com.nttdocomo.dojaemu.ktoolbar.swing.BasicAbstractWindowWindowListener;
import com.nttdocomo.dojaemu.ktoolbar.swing.EditWindowInterface;
import com.nttdocomo.dojaemu.ktoolbar.swing.JButtonUtil;
import com.nttdocomo.dojaemu.ktoolbar.swing.JTextFieldUtil;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.WindowEvent;
import java.math.BigDecimal;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CompassDataEditWindow
extends AbstractWindow2
implements EditWindowInterface {
    private MainWindow parent = null;
    private CompassCsvRecord record = null;
    private JTextField txtYAxis;
    private JTextField txtXAxis;
    private static final int maxAngle = 360;
    private static final int columns = 15;
    private static final int maxLen = 10;
    private JButton buttonSet;
    private JButton buttonCancel;

    public CompassDataEditWindow(MainWindow mainWindow, CompassCsvRecord compassCsvRecord, int n) {
        super(mainWindow, Resource.getString("Compass.editWindow"));
        this.parent = mainWindow;
        this.setResizable(false);
        ActionDispatcher2 actionDispatcher2 = new ActionDispatcher2(this);
        this.addWindowListener(new BasicAbstractWindowWindowListener(mainWindow, this){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                CompassDataEditWindow.this.cancel();
            }
        });
        this.record = compassCsvRecord;
        JPanel jPanel = new JPanel();
        this.buttonSet = JButtonUtil.createBasicButton(Resource.getString("SET"), "set", actionDispatcher2);
        this.buttonCancel = JButtonUtil.createBasicButton(Resource.getString("CANCEL"), "cancel", actionDispatcher2);
        jPanel.add(this.buttonSet);
        jPanel.add(this.buttonCancel);
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        JPanel jPanel4 = new JPanel(new FlowLayout(0));
        JPanel jPanel5 = new JPanel(new FlowLayout(0));
        JPanel jPanel6 = new JPanel(new FlowLayout(0));
        JPanel jPanel7 = new JPanel(new GridLayout(2, 1));
        JPanel jPanel8 = new JPanel(new GridLayout(2, 1));
        JLabel jLabel = new JLabel(Resource.getString("Compass.table.yAxis"));
        JLabel jLabel2 = new JLabel(Resource.getString("Compass.table.xAxis"));
        this.txtYAxis = JTextFieldUtil.createBasicTextField(15, new StringDocument(10));
        this.txtXAxis = JTextFieldUtil.createBasicTextField(15, new StringDocument(10));
        if (n != -1) {
            this.txtYAxis.setText(compassCsvRecord.getYAxis().toString());
            this.txtXAxis.setText(compassCsvRecord.getXAxis().toString());
        }
        jPanel3.add(jLabel);
        jPanel4.add(jLabel2);
        jPanel5.add(this.txtYAxis);
        jPanel6.add(this.txtXAxis);
        jPanel7.add(jPanel3);
        jPanel7.add(jPanel4);
        jPanel8.add(jPanel5);
        jPanel8.add(jPanel6);
        jPanel2.add(jPanel7);
        jPanel2.add(jPanel8);
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        container.add(jPanel2);
        container.add(jPanel);
        this.pack();
    }

    @Override
    public void checkInput() throws Exception {
        if ("".equals(this.txtYAxis.getText())) {
            throw new Exception(Resource.format("Compass.error.empty", Resource.getString("Compass.label.yaxis")));
        }
        if ("".equals(this.txtXAxis.getText())) {
            throw new Exception(Resource.format("Compass.error.empty", Resource.getString("Compass.label.xaxis")));
        }
    }

    @Override
    public void checkFormat() throws Exception {
        if (!CompassDataUtil.isBigDecimal(this.txtYAxis.getText())) {
            throw new Exception(Resource.format("Compass.error.value", Resource.getString("Compass.label.yaxis")));
        }
        if (!CompassDataUtil.isBigDecimal(this.txtXAxis.getText())) {
            throw new Exception(Resource.format("Compass.error.value", Resource.getString("Compass.label.xaxis")));
        }
    }

    public void checkSize() throws Exception {
        BigDecimal bigDecimal;
        if (CompassDataUtil.isBigDecimal(this.txtYAxis.getText()) && ((bigDecimal = CompassDataUtil.toBigDecimal(this.txtYAxis.getText())).intValue() < 0 || bigDecimal.intValue() > 360)) {
            throw new Exception(Resource.format("Compass.error.value", Resource.getString("Compass.label.yaxis")));
        }
        if (CompassDataUtil.isBigDecimal(this.txtXAxis.getText()) && ((bigDecimal = CompassDataUtil.toBigDecimal(this.txtXAxis.getText())).intValue() < 0 || bigDecimal.intValue() > 360)) {
            throw new Exception(Resource.format("Compass.error.value", Resource.getString("Compass.label.xaxis")));
        }
    }

    public void checkLength() throws Exception {
        if (CompassDataUtil.checkPeriod(this.txtYAxis.getText()) && !CompassDataUtil.checkLength(this.txtYAxis.getText())) {
            throw new Exception(Resource.format("Compass.error.value", Resource.getString("Compass.label.yaxis")));
        }
        if (CompassDataUtil.checkPeriod(this.txtXAxis.getText()) && !CompassDataUtil.checkLength(this.txtXAxis.getText())) {
            throw new Exception(Resource.format("Compass.error.value", Resource.getString("Compass.label.xaxis")));
        }
    }

    void set() {
        try {
            this.checkInput();
            this.checkFormat();
            this.checkSize();
            this.checkLength();
            String string = null;
            String string2 = null;
            BigDecimal bigDecimal = null;
            BigDecimal bigDecimal2 = null;
            string = this.txtYAxis.getText();
            bigDecimal = CompassDataUtil.toBigDecimal(string);
            string2 = this.txtXAxis.getText();
            bigDecimal2 = CompassDataUtil.toBigDecimal(string2);
            this.record.setYAxis(bigDecimal);
            this.record.setXAxis(bigDecimal2);
            this.setVisible(false);
            this.dispose();
        }
        catch (Exception exception) {
            this.parent.showDialog(exception.getMessage(), this, 2);
        }
    }

    void cancel() {
        this.record = null;
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public boolean isCanceled() {
        return this.record == null;
    }
}

