/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

public class DTVScheduleEntry {
    private int id = 0;
    private String scheduleType = null;
    private String serviceName = null;
    private String serviceId = null;
    private String frequency = null;
    private String affiliationId = null;
    private Calendar startTime = null;
    private Calendar endTime = null;
    private String eventName = null;
    private boolean selectFlg = false;
    private String repeatType = null;
    private static final int TYPE_WATCH = 0;
    private static final int TYPE_RECORD = 1;
    private static final int REPEAT_TYPE_ONETIME = 1;
    private static final int REPEAT_TYPE_DAILY = 2;
    private static final int REPEAT_TYPE_WEEKLY = 4;
    private static final int REPEAT_TYPE_MONTHLY = 8;
    private static final int REPEAT_TYPE_YEARLY = 16;
    private static final int YEAR_MIN = 1970;
    private static final int YEAR_MAX = 2500;

    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }

    public String getScheduleType() {
        return this.scheduleType;
    }

    public void setScheduleType(String string) {
        this.scheduleType = string;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String string) {
        this.serviceName = string;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String string) {
        this.serviceId = string;
    }

    public String getFrequency() {
        return this.frequency;
    }

    public void setFrequency(String string) {
        this.frequency = string;
    }

    public String getAffiliationId() {
        return this.affiliationId;
    }

    public void setAffiliationId(String string) {
        this.affiliationId = string;
    }

    public Calendar getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Calendar calendar) {
        this.startTime = calendar;
    }

    public Calendar getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Calendar calendar) {
        this.endTime = calendar;
    }

    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String string) {
        this.eventName = string;
    }

    public String getRepeatType() {
        return this.repeatType;
    }

    public void setRepeatType(String string) {
        this.repeatType = string;
    }

    public boolean isSelected() {
        return this.selectFlg;
    }

    public void setSelected(boolean bl) {
        this.selectFlg = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int load(String string) {
        int n = 0;
        BufferedReader bufferedReader = null;
        InputStreamReader inputStreamReader = null;
        FileInputStream fileInputStream = null;
        Calendar calendar = Calendar.getInstance();
        try {
            fileInputStream = new FileInputStream(string);
            inputStreamReader = new InputStreamReader(fileInputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            this.scheduleType = bufferedReader.readLine();
            if (!this.isScheduleType(this.scheduleType)) {
                throw new IllegalArgumentException();
            }
            this.serviceName = bufferedReader.readLine();
            this.serviceId = bufferedReader.readLine();
            this.frequency = bufferedReader.readLine();
            this.affiliationId = bufferedReader.readLine();
            String string2 = bufferedReader.readLine();
            String string3 = bufferedReader.readLine();
            this.eventName = bufferedReader.readLine();
            this.repeatType = bufferedReader.readLine();
            if (!this.isRepeatType(this.repeatType)) {
                throw new IllegalArgumentException();
            }
            this.startTime = Calendar.getInstance();
            if (Integer.parseInt(this.scheduleType) == 1) {
                this.endTime = Calendar.getInstance();
            }
            this.setCalendarDate(string2, this.startTime, string3, this.endTime);
            if (Integer.parseInt(this.scheduleType) == 1 && (this.endTime.before(this.startTime) || this.endTime.equals(this.startTime))) {
                throw new IllegalArgumentException();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            n = 1;
        }
        catch (IOException iOException) {
            n = 2;
        }
        catch (Exception exception) {
            n = 3;
        }
        finally {
            try {
                bufferedReader.close();
                inputStreamReader.close();
                fileInputStream.close();
            }
            catch (IOException iOException) {}
        }
        return n;
    }

    public String getScheduleTypeStringForDisplay() {
        String string = "";
        if (String.valueOf(0).equals(this.scheduleType)) {
            string = Resource.getString("DTV_BOOKING_TYPE_WATCH");
        } else if (String.valueOf(1).equals(this.scheduleType)) {
            string = Resource.getString("DTV_BOOKING_TYPE_RECORD");
        }
        return string;
    }

    public String getDateStringForDisplay(Calendar calendar) {
        String string = "";
        if (calendar == null) {
            return string;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd(EEE) HH:mm", Locale.ENGLISH);
        string = simpleDateFormat.format(calendar.getTime());
        return string;
    }

    public String getRepeatTypeStringForDisplay(String string) {
        String string2 = "";
        switch (Integer.parseInt(string)) {
            case 1: {
                string2 = Resource.getString("DTV_BOOKING_REPEAT_TYPE_ONETIME");
                break;
            }
            case 2: {
                string2 = Resource.getString("DTV_BOOKING_REPEAT_TYPE_DAILY");
                break;
            }
            case 4: {
                string2 = Resource.getString("DTV_BOOKING_REPEAT_TYPE_WEEKLY");
                break;
            }
            case 8: {
                string2 = Resource.getString("DTV_BOOKING_REPEAT_TYPE_MONTHLY");
                break;
            }
            case 16: {
                string2 = Resource.getString("DTV_BOOKING_REPEAT_TYPE_YEARLY");
            }
        }
        return string2;
    }

    private int[] getDateVal(String string) {
        int[] nArray = new int[6];
        int n = 0;
        int[] nArray2 = new int[5];
        for (int i = 0; i < nArray2.length; ++i) {
            int n2 = string.indexOf(47, n);
            if (n2 == -1) {
                throw new IllegalArgumentException();
            }
            nArray2[i] = n2;
            n = n2 + 1;
        }
        switch (Integer.parseInt(this.repeatType)) {
            case 1: {
                nArray[0] = Integer.parseInt(string.substring(0, nArray2[0]));
                if (nArray[0] < 1970 || nArray[0] > 2500) {
                    throw new IllegalArgumentException();
                }
            }
            case 16: {
                nArray[1] = Integer.parseInt(string.substring(nArray2[0] + 1, nArray2[1]));
                if (nArray[1] < 0 || nArray[1] > 11) {
                    throw new IllegalArgumentException();
                }
            }
            case 8: {
                nArray[3] = Integer.parseInt(string.substring(nArray2[2] + 1, nArray2[3]));
                if (nArray[3] < 1 || nArray[3] > 31) {
                    throw new IllegalArgumentException();
                }
            }
            case 2: {
                break;
            }
            case 4: {
                nArray[2] = Integer.parseInt(string.substring(nArray2[1] + 1, nArray2[2]));
            }
        }
        nArray[4] = Integer.parseInt(string.substring(nArray2[3] + 1, nArray2[4]));
        if (nArray[4] < 0 || nArray[4] > 23) {
            throw new IllegalArgumentException();
        }
        nArray[5] = Integer.parseInt(string.substring(nArray2[4] + 1));
        if (nArray[5] < 0 || nArray[5] > 59) {
            throw new IllegalArgumentException();
        }
        return nArray;
    }

    private void setCalendarDate(String string, Calendar calendar, String string2, Calendar calendar2) {
        int[] nArray = this.getDateVal(string);
        int[] nArray2 = null;
        if (Integer.parseInt(this.scheduleType) == 1) {
            nArray2 = this.getDateVal(string2);
        }
        Calendar calendar3 = Calendar.getInstance();
        calendar.set(11, nArray[4]);
        calendar.set(12, nArray[5]);
        calendar.set(13, 0);
        calendar.set(14, 0);
        if (Integer.parseInt(this.scheduleType) == 1) {
            calendar2.set(11, nArray2[4]);
            calendar2.set(12, nArray2[5]);
            calendar2.set(13, 0);
            calendar2.set(14, 0);
        }
        switch (Integer.parseInt(this.repeatType)) {
            case 1: {
                calendar.set(1, nArray[0]);
                calendar.set(2, nArray[1]);
                calendar.set(5, nArray[3]);
                if (Integer.parseInt(this.scheduleType) != 1) break;
                calendar2.set(1, nArray2[0]);
                calendar2.set(2, nArray2[1]);
                calendar2.set(5, nArray2[3]);
                break;
            }
            case 16: {
                calendar.set(2, nArray[1]);
                if (Integer.parseInt(this.scheduleType) == 1) {
                    calendar2.set(2, nArray2[1]);
                }
                calendar.set(5, nArray[3]);
                if (Integer.parseInt(this.scheduleType) == 1) {
                    calendar2.set(5, nArray2[3]);
                }
                if (!calendar.before(calendar3)) break;
                calendar.add(1, 1);
                if (Integer.parseInt(this.scheduleType) != 1) break;
                calendar2.add(1, 1);
                break;
            }
            case 8: {
                calendar.set(5, nArray[3]);
                if (Integer.parseInt(this.scheduleType) == 1) {
                    calendar2.set(5, nArray2[3]);
                }
                if (!calendar.before(calendar3)) break;
                calendar.add(2, 1);
                if (Integer.parseInt(this.scheduleType) != 1) break;
                calendar2.add(2, 1);
                break;
            }
            case 2: {
                if (!calendar.before(calendar3)) break;
                calendar.add(5, 1);
                if (Integer.parseInt(this.scheduleType) != 1) break;
                calendar2.add(5, 1);
                break;
            }
            case 4: {
                int n = nArray[2];
                int n2 = calendar3.get(7);
                int n3 = 0;
                if (n > n2) {
                    n3 = n - n2;
                } else if (n == n2) {
                    if (calendar.before(calendar3)) {
                        n3 = 7 - (n2 - n);
                    }
                } else {
                    n3 = 7 - (n2 - n);
                }
                calendar.add(5, n3);
                if (Integer.parseInt(this.scheduleType) != 1) break;
                calendar2.add(5, n3);
            }
        }
        if (Integer.parseInt(this.scheduleType) == 1 && Integer.parseInt(this.repeatType) != 1 && (calendar2.equals(calendar) || calendar2.before(calendar))) {
            Calendar calendar4 = Calendar.getInstance();
            calendar4.setTime(calendar.getTime());
            calendar4.add(5, 1);
            calendar4.set(11, calendar2.get(11));
            calendar4.set(12, calendar2.get(12));
            calendar2.setTime(calendar4.getTime());
        }
    }

    private boolean isScheduleType(String string) {
        int n = Integer.parseInt(string);
        return n == 0 || n == 1;
    }

    private boolean isRepeatType(String string) {
        int n = Integer.parseInt(string);
        return n == 1 || n == 2 || n == 4 || n == 8 || n == 16;
    }
}

