/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;

class DebugTraceWindow
extends AbstractWindow {
    private final int FRAME_WIDTH = 270;
    private final int FRAME_HEIGHT = 230;
    private MainWindow parent;
    private JList trace_list;
    private static boolean isMini;
    private JScrollPane jspn;
    private ButtonGroup traceButtonGroup;
    private JRadioButton traceOffRadioButton;
    private JRadioButton traceOnAllRadioButton;
    private JRadioButton traceOnSelectRadioButton;
    private JButton setButton;
    private JButton cancelButton;
    private String[] debug_items = null;
    private static String debug_param;
    private static int selected_item;
    private static int[] selected_index;

    DebugTraceWindow(MainWindow mainWindow) {
        super(mainWindow, Resource.getString("DEBUG_TRACE_WINDOW_TITLE"));
        this.parent = mainWindow;
        this.addWindowListener();
        this.trace_list = new JList();
        this.debug_items = new String[2];
        this.debug_items[0] = new String("-verbose:class");
        this.debug_items[1] = new String("-verbose:gc");
        this.trace_list.setListData(this.debug_items);
        this.trace_list.setVisibleRowCount(5);
        this.trace_list.setFixedCellWidth(160);
        if (selected_index != null) {
            this.trace_list.setSelectedIndices(selected_index);
        }
        this.jspn = new JScrollPane(this.trace_list);
        JLabel jLabel = new JLabel(Resource.getString("OUTPUT_DEBUG_TRACE"));
        JLabel jLabel2 = new JLabel(Resource.getString("DEBUG_TRACE_TYPE"));
        this.setButton = new JButton(Resource.getString("SET"));
        this.cancelButton = new JButton(Resource.getString("CANCEL"));
        this.traceOffRadioButton = new JRadioButton(Resource.getString("DEBUG_TRACE_OFF"));
        this.traceOnAllRadioButton = new JRadioButton(Resource.getString("DEBUG_TRACE_ON_ALL"));
        this.traceOnSelectRadioButton = new JRadioButton(Resource.getString("DEBUG_TRACE_ON_SELECT"));
        this.traceButtonGroup = new ButtonGroup();
        this.traceButtonGroup.add(this.traceOffRadioButton);
        this.traceButtonGroup.add(this.traceOnAllRadioButton);
        this.traceButtonGroup.add(this.traceOnSelectRadioButton);
        switch (selected_item) {
            case 1: {
                this.traceOnAllRadioButton.setSelected(true);
                this.trace_list.setEnabled(false);
                break;
            }
            case 2: {
                this.traceOnSelectRadioButton.setSelected(true);
                this.trace_list.setEnabled(true);
                break;
            }
            default: {
                this.traceOffRadioButton.setSelected(true);
                this.trace_list.setEnabled(false);
            }
        }
        Container container = this.getContentPane();
        container.setLayout(new FlowLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel2.setLayout(new BorderLayout());
        jPanel3.setLayout(new BorderLayout());
        jPanel4.add(this.traceOffRadioButton);
        jPanel4.add(this.traceOnAllRadioButton);
        jPanel4.add(this.traceOnSelectRadioButton);
        jPanel2.add("North", this.getFlowPanel(jLabel, 0));
        jPanel2.add("South", jPanel4);
        jPanel3.add("North", this.getFlowPanel(jLabel2, 0));
        jPanel3.add("South", this.jspn);
        jPanel5.add(this.setButton);
        jPanel5.add(this.cancelButton);
        jPanel.add("North", jPanel2);
        jPanel.add("Center", jPanel3);
        jPanel.add("South", jPanel5);
        container.add(jPanel);
        this.setButton.setActionCommand("set");
        this.cancelButton.setActionCommand("cancel");
        this.traceOffRadioButton.setActionCommand("traceoff");
        this.traceOnAllRadioButton.setActionCommand("traceall");
        this.traceOnSelectRadioButton.setActionCommand("tracesel");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.setButton.addActionListener(actionDispatcher);
        this.cancelButton.addActionListener(actionDispatcher);
        this.traceOffRadioButton.addActionListener(actionDispatcher);
        this.traceOnAllRadioButton.addActionListener(actionDispatcher);
        this.traceOnSelectRadioButton.addActionListener(actionDispatcher);
        this.setResizable(false);
        this.setSize(270, 230);
    }

    void set() {
        if (this.traceOffRadioButton.isSelected()) {
            selected_item = 0;
            debug_param = null;
        } else if (this.traceOnAllRadioButton.isSelected()) {
            selected_item = 1;
            debug_param = new String("-verbose:class,gc");
        } else if (this.traceOnSelectRadioButton.isSelected()) {
            selected_item = 2;
            if (!this.trace_list.isSelectionEmpty()) {
                debug_param = new String();
                Object[] objectArray = this.trace_list.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    debug_param = debug_param + new String((String)objectArray[i]);
                }
                if (objectArray.length == this.debug_items.length) {
                    debug_param = "-verbose:class,gc";
                }
            } else {
                debug_param = null;
            }
        }
        selected_index = this.trace_list.getSelectedIndices();
        this.parent.closeWindow(this);
    }

    void cancel() {
        this.parent.closeWindow(this);
    }

    void traceoff() {
        this.trace_list.setEnabled(false);
    }

    void traceall() {
        this.trace_list.setEnabled(false);
    }

    void tracesel() {
        this.trace_list.setEnabled(true);
    }

    private JPanel getFlowPanel(JComponent jComponent, int n) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(n));
        jPanel.add(jComponent);
        return jPanel;
    }

    public static byte[] getDebugParam() {
        byte[] byArray = new byte[]{0};
        byArray = debug_param != null && !isMini ? (MainWindow.getStartTimeParam() + " " + debug_param + '\u0000').getBytes() : (MainWindow.getStartTimeParam() + '\u0000').getBytes();
        return byArray;
    }

    static void setMiniApp(boolean bl) {
        isMini = bl;
    }

    static {
        debug_param = null;
        selected_item = 0;
        selected_index = null;
    }
}

