/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.HtmlFileFilter;
import com.nttdocomo.dojaemu.ktoolbar.JamFileFilter;
import com.nttdocomo.dojaemu.ktoolbar.JarFileFilter;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.Setting;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class DeployWindow
extends AbstractWindow {
    private boolean enabledWindow;
    private Setting setting;
    private JLabel labelPlaceOfJarFile;
    private JLabel labelPlaceOfJamFile;
    private JLabel labelPlaceOfHtmlFile;
    private JTextField inPlaceOfJar;
    private JTextField inPlaceOfJam;
    private JTextField inPlaceOfHtml;
    private JCheckBox inSimultaneousWithBuild;
    private String placeOfJar;
    private String placeOfJam;
    private String placeOfHtml;
    private boolean simultaneousWithBuild;
    private String defaultPlace;
    private String defaultNameOfJar;
    private String defaultNameOfJam;
    private String defaultNameOfHtml;

    DeployWindow(MainWindow mainWindow, Setting setting, boolean bl) {
        super(mainWindow, Resource.getString("DEPLOY_WINDOW_TITLE"));
        this.setting = setting;
        this.enabledWindow = bl;
        this.getDefaultPlace();
        this.getCurrentSetting();
        if (!this.enabledWindow) {
            return;
        }
        this.addWindowListener();
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.labelPlaceOfJarFile = new JLabel(Resource.format("DEPLOY_PLACE", Resource.getString("PLACE_OF_JAR")));
        this.labelPlaceOfJamFile = new JLabel(Resource.format("DEPLOY_PLACE", Resource.getString("PLACE_OF_JAM")));
        this.labelPlaceOfHtmlFile = new JLabel(Resource.format("DEPLOY_PLACE", Resource.getString("PLACE_OF_HTML")));
        this.inPlaceOfJar = new JTextField(this.placeOfJar, 30);
        this.inPlaceOfJam = new JTextField(this.placeOfJam, 30);
        this.inPlaceOfHtml = new JTextField(this.placeOfHtml, 30);
        this.inSimultaneousWithBuild = new JCheckBox(Resource.getString("SIMULTANEOUS_WITH_BUILD"), this.simultaneousWithBuild);
        JButton jButton = new JButton(Resource.getString("SELECT_DIR"));
        JButton jButton2 = new JButton(Resource.getString("SELECT_DIR"));
        JButton jButton3 = new JButton(Resource.getString("SELECT_DIR"));
        JButton jButton4 = new JButton(Resource.getString("EDIT"));
        jButton.setActionCommand("setPlaceOfJarFile");
        jButton2.setActionCommand("setPlaceOfJamFile");
        jButton3.setActionCommand("setPlaceOfHtmlFile");
        jButton4.setActionCommand("editHtmlFile");
        JButton jButton5 = new JButton(Resource.getString("DEPLOY"));
        JButton jButton6 = new JButton(Resource.getString("SET"));
        JButton jButton7 = new JButton(Resource.getString("CANCEL"));
        jButton5.setActionCommand("deploy");
        jButton6.setActionCommand("set");
        jButton7.setActionCommand("cancel");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        jButton.addActionListener(actionDispatcher);
        jButton2.addActionListener(actionDispatcher);
        jButton3.addActionListener(actionDispatcher);
        jButton4.addActionListener(actionDispatcher);
        jButton5.addActionListener(actionDispatcher);
        jButton6.addActionListener(actionDispatcher);
        jButton7.addActionListener(actionDispatcher);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.labelPlaceOfJarFile, gridBagConstraints);
        jPanel.add(this.labelPlaceOfJarFile);
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.inPlaceOfJar, gridBagConstraints);
        jPanel.add(this.inPlaceOfJar);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jButton, gridBagConstraints);
        jPanel.add(jButton);
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.labelPlaceOfJamFile, gridBagConstraints);
        jPanel.add(this.labelPlaceOfJamFile);
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.inPlaceOfJam, gridBagConstraints);
        jPanel.add(this.inPlaceOfJam);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jButton2, gridBagConstraints);
        jPanel.add(jButton2);
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.labelPlaceOfHtmlFile, gridBagConstraints);
        jPanel.add(this.labelPlaceOfHtmlFile);
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.inPlaceOfHtml, gridBagConstraints);
        jPanel.add(this.inPlaceOfHtml);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jButton3, gridBagConstraints);
        jPanel.add(jButton3);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jButton4, gridBagConstraints);
        jPanel.add(jButton4);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 1;
        JSeparator jSeparator = new JSeparator();
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jSeparator, gridBagConstraints);
        jPanel.add(jSeparator);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.inSimultaneousWithBuild, gridBagConstraints);
        jPanel.add(this.inSimultaneousWithBuild);
        jPanel2.add(jButton5);
        jPanel2.add(jButton6);
        jPanel2.add(jButton7);
        container.add(jPanel);
        container.add(jPanel2);
        this.setResizable(false);
        this.pack();
    }

    private void getDefaultPlace() {
        String string = this.parent.getProjectName();
        this.defaultPlace = this.parent.getProjectPath(string) + File.separator + "bin" + File.separator;
        this.defaultNameOfJar = string + ".jar";
        this.defaultNameOfJam = string + ".jam";
        this.defaultNameOfHtml = "Download.html";
    }

    private void getCurrentSetting() {
        this.placeOfJar = this.parent.getPlaceOfJar();
        this.placeOfJam = this.parent.getPlaceOfJam();
        this.placeOfHtml = this.parent.getPlaceOfHtml();
        this.simultaneousWithBuild = this.parent.getSimultaneousWithBuild();
    }

    void deploy() {
        if (this.saveSetting()) {
            this.deployFiles();
            this.cancel();
        }
    }

    void deployFiles() {
        boolean bl = this.parent.deployFiles(this.defaultPlace + this.defaultNameOfJar, this.placeOfJar, Resource.getString("PLACE_OF_JAR"));
        if (!bl) {
            return;
        }
        bl = this.parent.deployFiles(this.defaultPlace + this.defaultNameOfJam, this.placeOfJam, Resource.getString("PLACE_OF_JAM"));
        if (!bl) {
            return;
        }
        bl = this.parent.updatePackageUrl(this.placeOfJam, this.placeOfJar, this.defaultPlace + this.defaultNameOfJam, this.defaultNameOfJar);
        if (!bl) {
            return;
        }
        this.parent.deployFiles(this.defaultPlace + this.defaultNameOfHtml, this.placeOfHtml, Resource.getString("PLACE_OF_HTML"));
    }

    void set() {
        if (this.saveSetting()) {
            this.cancel();
        }
    }

    boolean saveSetting() {
        String string = null;
        if (this.enabledWindow) {
            this.placeOfJar = this.inPlaceOfJar.getText().trim();
            this.placeOfJam = this.inPlaceOfJam.getText().trim();
            this.placeOfHtml = this.inPlaceOfHtml.getText().trim();
            this.simultaneousWithBuild = this.inSimultaneousWithBuild.isSelected();
        }
        string = Resource.getString("PLACE_OF_JAR");
        if (this.checkLength(this.placeOfJar)) {
            if (!this.checkSetting(this.placeOfJar, new String[]{".jar"}, string)) {
                return false;
            }
            if (this.isDir(this.placeOfJar)) {
                this.placeOfJar = this.placeOfJar + File.separator + this.defaultNameOfJar;
            }
            try {
                this.placeOfJar = new File(this.placeOfJar).getCanonicalPath();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return false;
            }
        }
        string = Resource.getString("PLACE_OF_JAM");
        if (this.checkLength(this.placeOfJam)) {
            if (!this.checkSetting(this.placeOfJam, new String[]{".jam"}, string)) {
                return false;
            }
            if (this.isDir(this.placeOfJam)) {
                this.placeOfJam = this.placeOfJam + File.separator + this.defaultNameOfJam;
            }
            try {
                this.placeOfJam = new File(this.placeOfJam).getCanonicalPath();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return false;
            }
        }
        string = Resource.getString("PLACE_OF_HTML");
        if (this.checkLength(this.placeOfHtml)) {
            if (!this.checkSetting(this.placeOfHtml, new String[]{".html", ".htm"}, string)) {
                return false;
            }
            if (this.isDir(this.placeOfHtml)) {
                this.placeOfHtml = this.placeOfHtml + File.separator + this.defaultNameOfHtml;
            }
            try {
                this.placeOfHtml = new File(this.placeOfHtml).getCanonicalPath();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return false;
            }
        }
        if (this.enabledWindow) {
            this.inPlaceOfJar.setText(this.placeOfJar);
            this.inPlaceOfJam.setText(this.placeOfJam);
            this.inPlaceOfHtml.setText(this.placeOfHtml);
        }
        this.setting.setProperty("placeOfJar", this.placeOfJar);
        this.setting.setProperty("placeOfJam", this.placeOfJam);
        this.setting.setProperty("placeOfHtml", this.placeOfHtml);
        this.setting.setProperty("simultaneousWithBuild", String.valueOf(this.simultaneousWithBuild));
        this.parent.saveProjectSetting(this.setting);
        System.out.println(Resource.getString("SAVE_DEPLOY_SETTING"));
        return true;
    }

    boolean checkSetting(String string, String[] stringArray, String string2) {
        if (!this.isAbsolute(string, string2)) {
            return false;
        }
        if (!this.isDir(string)) {
            if (!this.checkExtension(string, stringArray, string2)) {
                return false;
            }
            if (!this.checkParentDir(string, string2)) {
                return false;
            }
        }
        return true;
    }

    private boolean checkLength(String string) {
        return string.length() > 0;
    }

    private boolean isAbsolute(String string, String string2) {
        if (new File(string.toLowerCase()).isAbsolute()) {
            return true;
        }
        try {
            String string3 = Resource.format("NOT_ABSOLUTE_PATH", Resource.format("DEPLOY_PLACE", string2));
            if (this.enabledWindow) {
                this.parent.showDialog(string3, this, 2);
            } else {
                System.out.println(string3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    boolean isDir(String string) {
        return new File(string.toLowerCase()).isDirectory();
    }

    private boolean checkExtension(String string, String[] stringArray, String string2) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.toLowerCase().endsWith(stringArray[i])) continue;
            return true;
        }
        try {
            String string3 = Resource.format("ERROR_IN_EXTENSION", Resource.format("DEPLOY_PLACE", string2));
            if (this.enabledWindow) {
                this.parent.showDialog(string3, this, 2);
            } else {
                System.out.println(string3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    private boolean checkParentDir(String string, String string2) {
        if (new File(string).getParentFile().isDirectory()) {
            return true;
        }
        try {
            String string3 = Resource.format("DIRECTORY_NOT_FOUND", Resource.format("DEPLOY_PLACE", string2));
            if (this.enabledWindow) {
                this.parent.showDialog(string3, this, 2);
            } else {
                System.out.println(string3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    void cancel() {
        this.parent.closeWindow(this);
    }

    void setPlaceOfJarFile() {
        this.select(this.inPlaceOfJar, new JarFileFilter());
    }

    void setPlaceOfJamFile() {
        this.select(this.inPlaceOfJam, new JamFileFilter());
    }

    void setPlaceOfHtmlFile() {
        this.select(this.inPlaceOfHtml, new HtmlFileFilter());
    }

    private void select(JTextField jTextField, FileFilter fileFilter) {
        JFileChooser jFileChooser = null;
        File file = new File(jTextField.getText());
        jFileChooser = jTextField.getText() == null || jTextField.getText().length() == 0 ? new JFileChooser(this.defaultPlace) : (!file.exists() ? new JFileChooser(this.defaultPlace) : new JFileChooser(file.getAbsolutePath()));
        jFileChooser.setDialogTitle(Resource.getString("DEPLOY_DIALOG"));
        jFileChooser.setDialogType(0);
        jFileChooser.setFileSelectionMode(2);
        jFileChooser.setFileFilter(fileFilter);
        jFileChooser.setMultiSelectionEnabled(false);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            jTextField.setText(jFileChooser.getSelectedFile().toString());
        }
    }

    void editHtmlFile() {
        this.parent.editHtml(this.defaultPlace + this.defaultNameOfHtml);
    }
}

