/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.Const;
import com.nttdocomo.dojaemu.ktoolbar.HalfNumberDocument;
import com.nttdocomo.dojaemu.ktoolbar.IniFileEntity;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.TabPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class DevelopmentSupportInfoWindow
extends TabPanel
implements DocumentListener,
ItemListener {
    private static final int DEFAULT_GRAPH_INTERVAL = 100;
    private static final int MAX_GRAPH_INTERVAL = 99999;
    private static final int MIN_GRAPH_INTERVAL = 10;
    private static final int DEFAULT_GRAPH_ASSIST_LINE_STEP = 25;
    private static final int MAX_GRAPH_ASSIST_LINE_STEP = 100;
    private static final int MIN_GRAPH_ASSIST_LINE_STEP = 5;
    private static final int DEFAULT_CPU_THRESHOLD = 80;
    private static final int MAX_CPU_THRESHOLD = 100;
    private static final int MIN_CPU_THRESHOLD = 0;
    private static final int DEFAULT_CPU_THRESHOLD_LINE_COLOR = 0xFFFF00;
    private static final int MIN_RGB_COLOR = 0;
    private static final int MAX_RGB_COLOR = 0xFFFFFF;
    private static final int[] DEFAULT_GRAPH_COLOR = new int[]{0xFF0000, 0xFFFF00, 65280};
    private static final int[] DEFAULT_GRAPH_RANGE_THRESHOLD = new int[]{80, 50, 0};
    private static final String[] LABEL_RGB_COLOR = new String[]{"R", "G", "B"};
    private static final String[] LABEL_GRAPH_RANGE = new String[]{"High", "Mid", "Low"};
    private static final int GRAPH_RANGE_NUM = 3;
    private static final int GRAPH_RANGE_THRESHOLD_NUM = 2;
    private static final int RGB_COLOR_NUM = 3;
    private static final String UNIT_LABEL_PERCENT = "%";
    private static final String HYPHEN = " - ";
    private static final String DEV_SUPPORT_INFO_FILE_INI = Const.PATH_LIB + "DevSupportInfo.ini";
    private static final String SECTION_CPU_THRESHOLD_SETTING = "CpuThresholdSetting";
    private static final String SECTION_GRAPH_SETTING = "GraphSetting";
    private static final String KEY_CPU_THRESHOLD = "CpuThreshold";
    private static final String KEY_STACK_TRACE_ENABLED = "StackTraceEnabled";
    private static final String KEY_GRAPH_UPDATE_INERVAL = "GraphUpdateInterval";
    private static final String KEY_GRAPH_ASSIST_LINE_STEP = "GraphAssitLineStep";
    private static final String KEY_CPU_THRESHOLD_LINE_COLOR = "CpuThresholdLineColor";
    private static final String KEY_GRAPH_LINE_COLOR = "GraphLineColor_";
    private static final String KEY_CPU_GRAPH_COLOR_THRESHOLD = "CpuGraphColorThreshold_";
    private static final String KEY_HEAP_GRAPH_COLOR_THRESHOLD = "HeapGraphColorThreshold_";
    private static final String KEY_SEND_GRAPH_COLOR_THRESHOLD = "SendGraphColorThreshold_";
    private static final String KEY_RECEIVE_GRAPH_COLOR_THRESHOLD = "ReceiveGraphColorThreshold_";
    private static final String KEY_POWER_GRAPH_COLOR_THRESHOLD = "PowerGraphColorThreshold_";
    private static final boolean DEFAULT_OUTPUT_STACK_TRACE_ENABLED = false;
    private JTextField cpuThresholdField;
    private JCheckBox outputStackTraceCheckBox;
    private JTextField graphIntervalField;
    private JTextField graphAssistLineStepField;
    private JTextField[] cpuThresholdLineColorField;
    private JTextField[][] graphLineColorField;
    private JTextField[] cpuGraphColorThresholdField;
    private JTextField[] heapGraphColorThresholdField;
    private JTextField[] sendGraphColorThresholdField;
    private JTextField[] receiveGraphColorThresholdField;
    private JTextField[] powerGraphColorThresholdField;

    DevelopmentSupportInfoWindow(AbstractWindow abstractWindow) {
        super(abstractWindow);
        int n;
        int n2;
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JLabel jLabel = new JLabel(Resource.getString("DevelopmentSupportInformation.common.caption.ThresholdOfUtilizationRates"));
        this.cpuThresholdField = new JTextField(3);
        this.cpuThresholdField.setDocument(new HalfNumberDocument(3));
        this.cpuThresholdField.getDocument().addDocumentListener(this);
        this.outputStackTraceCheckBox = new JCheckBox(Resource.getString("DevelopmentSupportInformation.common.caption.OutputStackTrace"), false);
        JLabel jLabel2 = new JLabel(Resource.getString("DevelopmentSupportInformation.common.caption.UpdateInterval"));
        this.graphIntervalField = new JTextField(5);
        this.graphIntervalField.setDocument(new HalfNumberDocument(5));
        this.graphIntervalField.getDocument().addDocumentListener(this);
        JLabel jLabel3 = new JLabel(Resource.getString("DevelopmentSupportInformation.common.caption.AssistLineStep"));
        this.graphAssistLineStepField = new JTextField(3);
        this.graphAssistLineStepField.setDocument(new HalfNumberDocument(3));
        this.graphAssistLineStepField.getDocument().addDocumentListener(this);
        JLabel jLabel4 = new JLabel(Resource.getString("DevelopmentSupportInformation.common.caption.ColorOfThresholdLine"));
        this.cpuThresholdLineColorField = new JTextField[3];
        for (int i = 0; i < 3; ++i) {
            this.cpuThresholdLineColorField[i] = new JTextField(3);
            this.cpuThresholdLineColorField[i].setDocument(new HalfNumberDocument(3));
            this.cpuThresholdLineColorField[i].getDocument().addDocumentListener(this);
        }
        JLabel jLabel5 = new JLabel(Resource.getString("DevelopmentSupportInformation.common.caption.GraphColorSetting"));
        JLabel jLabel6 = new JLabel(Resource.getString("DevelopmentSupportInformation.common.caption.GraphColor"));
        this.graphLineColorField = new JTextField[3][3];
        for (int i = 0; i < 3; ++i) {
            for (n2 = 0; n2 < 3; ++n2) {
                this.graphLineColorField[i][n2] = new JTextField(3);
                this.graphLineColorField[i][n2].setDocument(new HalfNumberDocument(3));
                this.graphLineColorField[i][n2].getDocument().addDocumentListener(this);
            }
        }
        JLabel jLabel7 = new JLabel(Resource.getString("DevelopmentSupportInformation.common.caption.ThresholdOfGraphColorSetting"));
        this.cpuGraphColorThresholdField = new JTextField[2];
        for (n2 = 0; n2 < 2; ++n2) {
            this.cpuGraphColorThresholdField[n2] = new JTextField(3);
            this.cpuGraphColorThresholdField[n2].setDocument(new HalfNumberDocument(3));
            this.cpuGraphColorThresholdField[n2].getDocument().addDocumentListener(this);
        }
        this.heapGraphColorThresholdField = new JTextField[2];
        for (n2 = 0; n2 < 2; ++n2) {
            this.heapGraphColorThresholdField[n2] = new JTextField(3);
            this.heapGraphColorThresholdField[n2].setDocument(new HalfNumberDocument(3));
            this.heapGraphColorThresholdField[n2].getDocument().addDocumentListener(this);
        }
        this.sendGraphColorThresholdField = new JTextField[2];
        for (n2 = 0; n2 < 2; ++n2) {
            this.sendGraphColorThresholdField[n2] = new JTextField(3);
            this.sendGraphColorThresholdField[n2].setDocument(new HalfNumberDocument(3));
            this.sendGraphColorThresholdField[n2].getDocument().addDocumentListener(this);
        }
        this.receiveGraphColorThresholdField = new JTextField[2];
        for (n2 = 0; n2 < 2; ++n2) {
            this.receiveGraphColorThresholdField[n2] = new JTextField(3);
            this.receiveGraphColorThresholdField[n2].setDocument(new HalfNumberDocument(3));
            this.receiveGraphColorThresholdField[n2].getDocument().addDocumentListener(this);
        }
        this.powerGraphColorThresholdField = new JTextField[2];
        for (n2 = 0; n2 < 2; ++n2) {
            this.powerGraphColorThresholdField[n2] = new JTextField(3);
            this.powerGraphColorThresholdField[n2].setDocument(new HalfNumberDocument(3));
            this.powerGraphColorThresholdField[n2].getDocument().addDocumentListener(this);
        }
        this.outputStackTraceCheckBox.addItemListener(this);
        this.loadData();
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("DevelopmentSupportInformation.common.caption.ThresholdOfUtilizationRatesSetting")));
        jPanel3.setLayout(new GridBagLayout());
        jPanel3.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("DevelopmentSupportInformation.common.caption.GraphSetting")));
        GridBagConstraints gridBagConstraints = this.getDefaultConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 1;
        jPanel2.add((Component)this.getFieldWithUnitPanel(this.cpuThresholdField, new JLabel(UNIT_LABEL_PERCENT)), gridBagConstraints);
        for (n = gridBagConstraints.gridx; n < 8; ++n) {
            ++gridBagConstraints.gridx;
            gridBagConstraints.gridwidth = 1;
            jPanel2.add(Box.createHorizontalStrut(10), gridBagConstraints);
        }
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        jPanel2.add((Component)this.outputStackTraceCheckBox, gridBagConstraints);
        for (n = gridBagConstraints.gridx; n < 8; ++n) {
            ++gridBagConstraints.gridx;
            gridBagConstraints.gridwidth = 2;
            jPanel2.add(Box.createHorizontalStrut(10), gridBagConstraints);
        }
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        jPanel3.add((Component)jLabel2, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 1;
        jPanel3.add((Component)this.getFieldWithUnitPanel(this.graphIntervalField, new JLabel(Resource.getString("INTERVAL_UNIT"))), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        jPanel3.add((Component)jLabel3, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 1;
        jPanel3.add((Component)this.getFieldWithUnitPanel(this.graphAssistLineStepField, new JLabel(UNIT_LABEL_PERCENT)), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(8, 2, 4, 2);
        jPanel3.add((Component)jLabel5, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(2, 20, 2, 2);
        jPanel3.add((Component)this.getRGBColorPanel(Resource.getString("DevelopmentSupportInformation.common.caption.ColorOfThresholdLine"), this.cpuThresholdLineColorField), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        jPanel3.add((Component)this.getGraphColorPanel(Resource.getString("DevelopmentSupportInformation.common.caption.GraphColor"), this.graphLineColorField), gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(8, 2, 4, 2);
        jPanel3.add((Component)jLabel7, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(2, 20, 2, 2);
        jPanel3.add((Component)this.getGraphColorThresholdPanel(Resource.getString("DevelopmentSupportInformation.common.caption.UtilizationRatesGraph"), this.cpuGraphColorThresholdField), gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridx += 2;
        gridBagConstraints.gridwidth = 2;
        jPanel3.add((Component)this.getGraphColorThresholdPanel(Resource.getString("DevelopmentSupportInformation.common.caption.HeapSizeGraph"), this.heapGraphColorThresholdField), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(2, 20, 2, 2);
        jPanel3.add((Component)this.getGraphColorThresholdPanel(Resource.getString("DevelopmentSupportInformation.common.caption.SendPacketSizeGraph"), this.sendGraphColorThresholdField), gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridx += 2;
        gridBagConstraints.gridwidth = 2;
        jPanel3.add((Component)this.getGraphColorThresholdPanel(Resource.getString("DevelopmentSupportInformation.common.caption.ReceivePacketSizeGraph"), this.receiveGraphColorThresholdField), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(2, 20, 2, 2);
        jPanel3.add((Component)this.getGraphColorThresholdPanel(Resource.getString("DevelopmentSupportInformation.common.caption.PowerConsumptionGraph"), this.powerGraphColorThresholdField), gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        this.setLayout(new BorderLayout());
        this.add("North", jPanel);
    }

    @Override
    boolean set() {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int[] nArray = new int[3];
        int[] nArray2 = new int[2];
        int[] nArray3 = new int[2];
        int[] nArray4 = new int[2];
        int[] nArray5 = new int[2];
        int[] nArray6 = new int[2];
        if (this.cpuThresholdField.getText() == null || this.cpuThresholdField.getText().equals("")) {
            this.parent.showDialog(Resource.getString("DevelopmentSupportInformation.wrn.message.GraphThresholdOfUtilizationRatesNoinput"), this.tabwin, 2);
            return false;
        }
        n3 = Integer.valueOf(this.cpuThresholdField.getText());
        if (n3 > 100 || n3 < 0) {
            this.parent.showDialog(Resource.getString("DevelopmentSupportInformation.wrn.message.GraphThresholdOfUtilizationRatesRange"), this.tabwin, 2);
            return false;
        }
        if (this.graphIntervalField.getText() == null || this.graphIntervalField.getText().equals("")) {
            this.parent.showDialog(Resource.getString("DevelopmentSupportInformation.wrn.message.GraphUpdateIntervalNoinput"), this.tabwin, 2);
            return false;
        }
        n4 = Integer.valueOf(this.graphIntervalField.getText());
        if (n4 > 99999 || n4 < 10) {
            this.parent.showDialog(Resource.getString("DevelopmentSupportInformation.wrn.message.GraphUpdateIntervalRange"), this.tabwin, 2);
            return false;
        }
        if (this.graphAssistLineStepField.getText() == null || this.graphAssistLineStepField.getText().equals("")) {
            this.parent.showDialog(Resource.getString("DevelopmentSupportInformation.wrn.message.GraphAssistLineStepNoinput"), this.tabwin, 2);
            return false;
        }
        n5 = Integer.valueOf(this.graphAssistLineStepField.getText());
        if (n5 > 100 || n5 < 5) {
            this.parent.showDialog(Resource.getString("DevelopmentSupportInformation.wrn.message.GraphAssistLineStepRange"), this.tabwin, 2);
            return false;
        }
        for (n2 = 0; n2 < 3; ++n2) {
            if (this.cpuThresholdLineColorField[n2].getText() != null && !this.cpuThresholdLineColorField[n2].getText().equals("")) continue;
            this.parent.showDialog(Resource.getString("DevelopmentSupportInformation.wrn.message.GraphColorOfThresholdLineNoinput"), this.tabwin, 2);
            return false;
        }
        for (n2 = 0; n2 < 3; ++n2) {
            int n7 = Integer.valueOf(this.cpuThresholdLineColorField[n2].getText());
            if (n7 > 255 || n7 < 0) {
                this.parent.showDialog(Resource.getString("DevelopmentSupportInformation.wrn.message.GraphColorOfThresholdLineRange"), this.tabwin, 2);
                return false;
            }
            n6 |= n7 << (2 - n2) * 8;
        }
        for (n2 = 0; n2 < 3; ++n2) {
            int n8;
            nArray[n2] = 0;
            JTextField[] jTextFieldArray = this.graphLineColorField[n2];
            for (n8 = 0; n8 < 3; ++n8) {
                if (jTextFieldArray[n8].getText() != null && !jTextFieldArray[n8].getText().equals("")) continue;
                this.parent.showDialog(Resource.format("DevelopmentSupportInformation.wrn.message.Noinput", Resource.getString("DevelopmentSupportInformation.common.caption.GraphSetting") + HYPHEN + Resource.getString("DevelopmentSupportInformation.common.caption.GraphColorSetting") + HYPHEN + LABEL_GRAPH_RANGE[n2].toUpperCase()), this.tabwin, 2);
                return false;
            }
            for (n8 = 0; n8 < 3; ++n8) {
                int n9 = Integer.valueOf(jTextFieldArray[n8].getText());
                if (n9 > 255 || n9 < 0) {
                    this.parent.showDialog(Resource.format("DevelopmentSupportInformation.wrn.message.255Range", Resource.getString("DevelopmentSupportInformation.common.caption.GraphSetting") + HYPHEN + Resource.getString("DevelopmentSupportInformation.common.caption.GraphColorSetting") + HYPHEN + LABEL_GRAPH_RANGE[n2].toUpperCase()), this.tabwin, 2);
                    return false;
                }
                int n10 = n2;
                nArray[n10] = nArray[n10] | n9 << (2 - n8) * 8;
            }
        }
        for (n2 = 0; n2 < 2; ++n2) {
            if (this.cpuGraphColorThresholdField[n2] == null || this.cpuGraphColorThresholdField[n2].getText().equals("")) {
                this.parent.showDialog(Resource.format("DevelopmentSupportInformation.wrn.message.Noinput", Resource.getString("DevelopmentSupportInformation.common.caption.GraphSetting") + HYPHEN + Resource.getString("DevelopmentSupportInformation.common.caption.ThresholdOfGraphColorSetting") + HYPHEN + Resource.getString("DevelopmentSupportInformation.common.caption.UtilizationRatesGraph") + HYPHEN + LABEL_GRAPH_RANGE[n2].toUpperCase()), this.tabwin, 2);
                return false;
            }
            int n11 = Integer.valueOf(this.cpuGraphColorThresholdField[n2].getText());
            if (n11 > 100 || n11 < 0) {
                this.parent.showDialog(Resource.format("DevelopmentSupportInformation.wrn.message.100Range", Resource.getString("DevelopmentSupportInformation.common.caption.GraphSetting") + HYPHEN + Resource.getString("DevelopmentSupportInformation.common.caption.ThresholdOfGraphColorSetting") + HYPHEN + Resource.getString("DevelopmentSupportInformation.common.caption.UtilizationRatesGraph") + HYPHEN + LABEL_GRAPH_RANGE[n2].toUpperCase()), this.tabwin, 2);
                return false;
            }
            nArray2[n2] = n11;
        }
        for (n2 = 0; n2 < 2; ++n2) {
            for (int i = n2 + 1; i < 2; ++i) {
                if (nArray2[n2] >= nArray2[i]) continue;
                Object[] objectArray = new String[]{Resource.getString("DevelopmentSupportInformation.common.caption.GraphSetting") + HYPHEN + Resource.getString("DevelopmentSupportInformation.common.caption.ThresholdOfGraphColorSetting") + HYPHEN + Resource.getString("DevelopmentSupportInformation.common.caption.UtilizationRatesGraph") + " : ", LABEL_GRAPH_RANGE[i].toUpperCase()};
                this.parent.showDialog(Resource.format("DevelopmentSupportInformation.wrn.message.Range", objectArray), this.tabwin, 2);
                return false;
            }
        }
        for (n2 = 0; n2 < 2; ++n2) {
            if (this.heapGraphColorThresholdField[n2] == null || this.heapGraphColorThresholdField[n2].getText().equals("")) {
                this.parent.showDialog(Resource.format("DevelopmentSupportInformation.wrn.message.Noinput", Resource.getString("DevelopmentSupportInformation.common.caption.GraphSetting") + HYPHEN + Resource.getString("DevelopmentSupportInformation.common.caption.ThresholdOfGraphColorSetting") + HYPHEN + Resource.getString("DevelopmentSupportInformation.common.caption.HeapSizeGraph") + HYPHEN + LABEL_GRAPH_RANGE[n2].toUpperCase()), this.tabwin, 2);
                return false;
            }
            int n12 = Integer.valueOf(this.heapGraphColorThresholdField[n2].getText());
            if (n12 > 100 || n12 < 0) {
                this.parent.showDialog(Resource.format("DevelopmentSupportInformation.wrn.message.100Range", Resource.getString("DevelopmentSupportInformation.common.caption.GraphSetting") + HYPHEN + Resource.getString("DevelopmentSupportInformation.common.caption.ThresholdOfGraphColorSetting") + HYPHEN + Resource.getString("DevelopmentSupportInformation.common.caption.HeapSizeGraph") + HYPHEN + LABEL_GRAPH_RANGE[n2].toUpperCase()), this.tabwin, 2);
                return false;
            }
            nArray3[n2] = n12;
        }
        for (n2 = 0; n2 < 2; ++n2) {
            for (int i = n2 + 1; i < 2; ++i) {
                if (nArray3[n2] >= nArray3[i]) continue;
                Object[] objectArray = new String[]{Resource.getString("DevelopmentSupportInformation.common.caption.GraphSetting") + HYPHEN + Resource.getString("DevelopmentSupportInformation.common.caption.ThresholdOfGraphColorSetting") + HYPHEN + Resource.getString("DevelopmentSupportInformation.common.caption.HeapSizeGraph") + " : ", LABEL_GRAPH_RANGE[i].toUpperCase()};
                this.parent.showDialog(Resource.format("DevelopmentSupportInformation.wrn.message.Range", objectArray), this.tabwin, 2);
                return false;
            }
        }
        for (n2 = 0; n2 < 2; ++n2) {
            if (this.sendGraphColorThresholdField[n2] == null || this.sendGraphColorThresholdField[n2].getText().equals("")) {
                this.parent.showDialog(Resource.format("DevelopmentSupportInformation.wrn.message.Noinput", Resource.getString("DevelopmentSupportInformation.common.caption.GraphSetting") + HYPHEN + Resource.getString("DevelopmentSupportInformation.common.caption.ThresholdOfGraphColorSetting") + HYPHEN + Resource.getString("DevelopmentSupportInformation.common.caption.SendPacketSizeGraph") + HYPHEN + LABEL_GRAPH_RANGE[n2].toUpperCase()), this.tabwin, 2);
                return false;
            }
            int n13 = Integer.valueOf(this.sendGraphColorThresholdField[n2].getText());
            if (n13 > 100 || n13 < 0) {
                this.parent.showDialog(Resource.format("DevelopmentSupportInformation.wrn.message.100Range", Resource.getString("DevelopmentSupportInformation.common.caption.GraphSetting") + HYPHEN + Resource.getString("DevelopmentSupportInformation.common.caption.ThresholdOfGraphColorSetting") + HYPHEN + Resource.getString("DevelopmentSupportInformation.common.caption.SendPacketSizeGraph") + HYPHEN + LABEL_GRAPH_RANGE[n2].toUpperCase()), this.tabwin, 2);
                return false;
            }
            nArray4[n2] = n13;
        }
        for (n2 = 0; n2 < 2; ++n2) {
            for (int i = n2 + 1; i < 2; ++i) {
                if (nArray4[n2] >= nArray4[i]) continue;
                Object[] objectArray = new String[]{Resource.getString("DevelopmentSupportInformation.common.caption.GraphSetting") + HYPHEN + Resource.getString("DevelopmentSupportInformation.common.caption.ThresholdOfGraphColorSetting") + HYPHEN + Resource.getString("DevelopmentSupportInformation.common.caption.SendPacketSizeGraph") + " : ", LABEL_GRAPH_RANGE[i].toUpperCase()};
                this.parent.showDialog(Resource.format("DevelopmentSupportInformation.wrn.message.Range", objectArray), this.tabwin, 2);
                return false;
            }
        }
        for (n2 = 0; n2 < 2; ++n2) {
            if (this.receiveGraphColorThresholdField[n2] == null || this.receiveGraphColorThresholdField[n2].getText().equals("")) {
                this.parent.showDialog(Resource.format("DevelopmentSupportInformation.wrn.message.Noinput", Resource.getString("DevelopmentSupportInformation.common.caption.GraphSetting") + HYPHEN + Resource.getString("DevelopmentSupportInformation.common.caption.ThresholdOfGraphColorSetting") + HYPHEN + Resource.getString("DevelopmentSupportInformation.common.caption.ReceivePacketSizeGraph") + HYPHEN + LABEL_GRAPH_RANGE[n2].toUpperCase()), this.tabwin, 2);
                return false;
            }
            int n14 = Integer.valueOf(this.receiveGraphColorThresholdField[n2].getText());
            if (n14 > 100 || n14 < 0) {
                this.parent.showDialog(Resource.format("DevelopmentSupportInformation.wrn.message.100Range", Resource.getString("DevelopmentSupportInformation.common.caption.GraphSetting") + HYPHEN + Resource.getString("DevelopmentSupportInformation.common.caption.ThresholdOfGraphColorSetting") + HYPHEN + Resource.getString("DevelopmentSupportInformation.common.caption.ReceivePacketSizeGraph") + HYPHEN + LABEL_GRAPH_RANGE[n2].toUpperCase()), this.tabwin, 2);
                return false;
            }
            nArray5[n2] = n14;
        }
        for (n2 = 0; n2 < 2; ++n2) {
            for (int i = n2 + 1; i < 2; ++i) {
                if (nArray5[n2] >= nArray5[i]) continue;
                Object[] objectArray = new String[]{Resource.getString("DevelopmentSupportInformation.common.caption.GraphSetting") + HYPHEN + Resource.getString("DevelopmentSupportInformation.common.caption.ThresholdOfGraphColorSetting") + HYPHEN + Resource.getString("DevelopmentSupportInformation.common.caption.ReceivePacketSizeGraph") + " : ", LABEL_GRAPH_RANGE[i].toUpperCase()};
                this.parent.showDialog(Resource.format("DevelopmentSupportInformation.wrn.message.Range", objectArray), this.tabwin, 2);
                return false;
            }
        }
        for (n2 = 0; n2 < 2; ++n2) {
            if (this.powerGraphColorThresholdField[n2] == null || this.powerGraphColorThresholdField[n2].getText().equals("")) {
                this.parent.showDialog(Resource.format("DevelopmentSupportInformation.wrn.message.Noinput", Resource.getString("DevelopmentSupportInformation.common.caption.GraphSetting") + HYPHEN + Resource.getString("DevelopmentSupportInformation.common.caption.ThresholdOfGraphColorSetting") + HYPHEN + Resource.getString("DevelopmentSupportInformation.common.caption.PowerConsumptionGraph") + HYPHEN + LABEL_GRAPH_RANGE[n2].toUpperCase()), this.tabwin, 2);
                return false;
            }
            int n15 = Integer.valueOf(this.powerGraphColorThresholdField[n2].getText());
            if (n15 > 100 || n15 < 0) {
                this.parent.showDialog(Resource.format("DevelopmentSupportInformation.wrn.message.100Range", Resource.getString("DevelopmentSupportInformation.common.caption.GraphSetting") + HYPHEN + Resource.getString("DevelopmentSupportInformation.common.caption.ThresholdOfGraphColorSetting") + HYPHEN + Resource.getString("DevelopmentSupportInformation.common.caption.PowerConsumptionGraph") + HYPHEN + LABEL_GRAPH_RANGE[n2].toUpperCase()), this.tabwin, 2);
                return false;
            }
            nArray6[n2] = n15;
        }
        for (n2 = 0; n2 < 2; ++n2) {
            for (int i = n2 + 1; i < 2; ++i) {
                if (nArray6[n2] >= nArray6[i]) continue;
                Object[] objectArray = new String[]{Resource.getString("DevelopmentSupportInformation.common.caption.GraphSetting") + HYPHEN + Resource.getString("DevelopmentSupportInformation.common.caption.ThresholdOfGraphColorSetting") + HYPHEN + Resource.getString("DevelopmentSupportInformation.common.caption.PowerConsumptionGraph") + " : ", LABEL_GRAPH_RANGE[i].toUpperCase()};
                this.parent.showDialog(Resource.format("DevelopmentSupportInformation.wrn.message.Range", objectArray), this.tabwin, 2);
                return false;
            }
        }
        IniFileEntity iniFileEntity = new IniFileEntity(DEV_SUPPORT_INFO_FILE_INI);
        iniFileEntity.setSectionAttribute(SECTION_CPU_THRESHOLD_SETTING, KEY_CPU_THRESHOLD, String.valueOf(n3));
        iniFileEntity.setSectionAttribute(SECTION_CPU_THRESHOLD_SETTING, KEY_STACK_TRACE_ENABLED, String.valueOf(this.outputStackTraceCheckBox.isSelected()));
        iniFileEntity.setSectionAttribute(SECTION_GRAPH_SETTING, KEY_GRAPH_UPDATE_INERVAL, String.valueOf(n4));
        iniFileEntity.setSectionAttribute(SECTION_GRAPH_SETTING, KEY_GRAPH_ASSIST_LINE_STEP, String.valueOf(n5));
        iniFileEntity.setSectionAttribute(SECTION_GRAPH_SETTING, KEY_CPU_THRESHOLD_LINE_COLOR, String.valueOf(n6));
        for (n = 0; n < 3; ++n) {
            iniFileEntity.setSectionAttribute(SECTION_GRAPH_SETTING, KEY_GRAPH_LINE_COLOR + LABEL_GRAPH_RANGE[n], String.valueOf(nArray[n]));
        }
        for (n = 0; n < 2; ++n) {
            iniFileEntity.setSectionAttribute(SECTION_GRAPH_SETTING, KEY_CPU_GRAPH_COLOR_THRESHOLD + LABEL_GRAPH_RANGE[n], String.valueOf(nArray2[n]));
            iniFileEntity.setSectionAttribute(SECTION_GRAPH_SETTING, KEY_HEAP_GRAPH_COLOR_THRESHOLD + LABEL_GRAPH_RANGE[n], String.valueOf(nArray3[n]));
            iniFileEntity.setSectionAttribute(SECTION_GRAPH_SETTING, KEY_SEND_GRAPH_COLOR_THRESHOLD + LABEL_GRAPH_RANGE[n], String.valueOf(nArray4[n]));
            iniFileEntity.setSectionAttribute(SECTION_GRAPH_SETTING, KEY_RECEIVE_GRAPH_COLOR_THRESHOLD + LABEL_GRAPH_RANGE[n], String.valueOf(nArray5[n]));
            iniFileEntity.setSectionAttribute(SECTION_GRAPH_SETTING, KEY_POWER_GRAPH_COLOR_THRESHOLD + LABEL_GRAPH_RANGE[n], String.valueOf(nArray6[n]));
        }
        try {
            iniFileEntity.save();
        }
        catch (Exception exception) {
            System.err.println(Resource.format("WRITE_ERR", iniFileEntity.getName()));
            return true;
        }
        return true;
    }

    @Override
    void cancel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadData() {
        int n;
        int n2 = -1;
        String string = "";
        IniFileEntity iniFileEntity = new IniFileEntity(DEV_SUPPORT_INFO_FILE_INI);
        try {
            iniFileEntity.read();
        }
        catch (Exception exception) {
            int n3;
            IniFileEntity iniFileEntity2 = new IniFileEntity(DEV_SUPPORT_INFO_FILE_INI);
            iniFileEntity2.setSectionAttribute(SECTION_CPU_THRESHOLD_SETTING, KEY_STACK_TRACE_ENABLED, String.valueOf(false));
            iniFileEntity2.setSectionAttribute(SECTION_CPU_THRESHOLD_SETTING, KEY_CPU_THRESHOLD, String.valueOf(80));
            iniFileEntity2.setSectionAttribute(SECTION_GRAPH_SETTING, KEY_GRAPH_UPDATE_INERVAL, String.valueOf(100));
            iniFileEntity2.setSectionAttribute(SECTION_GRAPH_SETTING, KEY_GRAPH_ASSIST_LINE_STEP, String.valueOf(25));
            iniFileEntity2.setSectionAttribute(SECTION_GRAPH_SETTING, KEY_CPU_THRESHOLD_LINE_COLOR, String.valueOf(0xFFFF00));
            for (n3 = 0; n3 < 3; ++n3) {
                iniFileEntity2.setSectionAttribute(SECTION_GRAPH_SETTING, KEY_GRAPH_LINE_COLOR + LABEL_GRAPH_RANGE[n3], String.valueOf(DEFAULT_GRAPH_COLOR[n3]));
            }
            for (n3 = 0; n3 < 2; ++n3) {
                iniFileEntity2.setSectionAttribute(SECTION_GRAPH_SETTING, KEY_CPU_GRAPH_COLOR_THRESHOLD + LABEL_GRAPH_RANGE[n3], String.valueOf(DEFAULT_GRAPH_RANGE_THRESHOLD[n3]));
                iniFileEntity2.setSectionAttribute(SECTION_GRAPH_SETTING, KEY_HEAP_GRAPH_COLOR_THRESHOLD + LABEL_GRAPH_RANGE[n3], String.valueOf(DEFAULT_GRAPH_RANGE_THRESHOLD[n3]));
                iniFileEntity2.setSectionAttribute(SECTION_GRAPH_SETTING, KEY_SEND_GRAPH_COLOR_THRESHOLD + LABEL_GRAPH_RANGE[n3], String.valueOf(DEFAULT_GRAPH_RANGE_THRESHOLD[n3]));
                iniFileEntity2.setSectionAttribute(SECTION_GRAPH_SETTING, KEY_RECEIVE_GRAPH_COLOR_THRESHOLD + LABEL_GRAPH_RANGE[n3], String.valueOf(DEFAULT_GRAPH_RANGE_THRESHOLD[n3]));
                iniFileEntity2.setSectionAttribute(SECTION_GRAPH_SETTING, KEY_POWER_GRAPH_COLOR_THRESHOLD + LABEL_GRAPH_RANGE[n3], String.valueOf(DEFAULT_GRAPH_RANGE_THRESHOLD[n3]));
            }
            try {
                iniFileEntity2.save();
            }
            catch (Exception exception2) {
            }
            finally {
                iniFileEntity = iniFileEntity2;
            }
        }
        string = iniFileEntity.getSectionAttribute(SECTION_CPU_THRESHOLD_SETTING, KEY_CPU_THRESHOLD);
        n2 = this.strToInt(string, 80);
        if (n2 < 0 || n2 > 100) {
            n2 = 80;
        }
        this.cpuThresholdField.setText(String.valueOf(n2));
        this.outputStackTraceCheckBox.setSelected(iniFileEntity.getSectionAttributeBool(SECTION_CPU_THRESHOLD_SETTING, KEY_STACK_TRACE_ENABLED, false));
        string = iniFileEntity.getSectionAttribute(SECTION_GRAPH_SETTING, KEY_GRAPH_UPDATE_INERVAL);
        n2 = this.strToInt(string, 100);
        if (n2 < 10 || n2 > 99999) {
            n2 = 100;
        }
        this.graphIntervalField.setText(String.valueOf(n2));
        string = iniFileEntity.getSectionAttribute(SECTION_GRAPH_SETTING, KEY_GRAPH_ASSIST_LINE_STEP);
        n2 = this.strToInt(string, 25);
        if (n2 < 5 || n2 > 100) {
            n2 = 25;
        }
        this.graphAssistLineStepField.setText(String.valueOf(n2));
        string = iniFileEntity.getSectionAttribute(SECTION_GRAPH_SETTING, KEY_CPU_THRESHOLD_LINE_COLOR);
        n2 = this.strToInt(string, 0xFFFF00);
        if (n2 < 0 || n2 > 0xFFFFFF) {
            n2 = 0xFFFF00;
        }
        for (n = 0; n < 3; ++n) {
            this.cpuThresholdLineColorField[n].setText(String.valueOf(this.getRGBPartValue(n, n2)));
        }
        for (n = 0; n < 3; ++n) {
            string = iniFileEntity.getSectionAttribute(SECTION_GRAPH_SETTING, KEY_GRAPH_LINE_COLOR + LABEL_GRAPH_RANGE[n]);
            n2 = this.strToInt(string, DEFAULT_GRAPH_COLOR[n]);
            if (n2 < 0 || n2 > 0xFFFFFF) {
                n2 = DEFAULT_GRAPH_COLOR[n];
            }
            for (int i = 0; i < 3; ++i) {
                this.graphLineColorField[n][i].setText(String.valueOf(this.getRGBPartValue(i, n2)));
            }
        }
        for (n = 0; n < 2; ++n) {
            this.cpuGraphColorThresholdField[n].setText(this.getGraphColorThresholdString(iniFileEntity, KEY_CPU_GRAPH_COLOR_THRESHOLD, n));
            this.heapGraphColorThresholdField[n].setText(this.getGraphColorThresholdString(iniFileEntity, KEY_HEAP_GRAPH_COLOR_THRESHOLD, n));
            this.sendGraphColorThresholdField[n].setText(this.getGraphColorThresholdString(iniFileEntity, KEY_SEND_GRAPH_COLOR_THRESHOLD, n));
            this.receiveGraphColorThresholdField[n].setText(this.getGraphColorThresholdString(iniFileEntity, KEY_RECEIVE_GRAPH_COLOR_THRESHOLD, n));
            this.powerGraphColorThresholdField[n].setText(this.getGraphColorThresholdString(iniFileEntity, KEY_POWER_GRAPH_COLOR_THRESHOLD, n));
        }
        this.compParam(this.cpuGraphColorThresholdField);
        this.compParam(this.heapGraphColorThresholdField);
        this.compParam(this.sendGraphColorThresholdField);
        this.compParam(this.receiveGraphColorThresholdField);
        this.compParam(this.powerGraphColorThresholdField);
    }

    private String getGraphColorThresholdString(IniFileEntity iniFileEntity, String string, int n) {
        int n2 = -1;
        String string2 = "";
        string2 = iniFileEntity.getSectionAttribute(SECTION_GRAPH_SETTING, string + LABEL_GRAPH_RANGE[n]);
        n2 = this.strToInt(string2, DEFAULT_GRAPH_RANGE_THRESHOLD[n]);
        if (n2 < 0 || n2 > 100) {
            n2 = DEFAULT_GRAPH_RANGE_THRESHOLD[n];
        }
        return String.valueOf(n2);
    }

    private GridBagConstraints getDefaultConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        return gridBagConstraints;
    }

    private JPanel getComponentPanel(JComponent[] jComponentArray) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = this.getDefaultConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        for (int i = 0; i < jComponentArray.length; ++i) {
            if (i != 0) {
                ++gridBagConstraints.gridx;
            }
            jPanel.add((Component)jComponentArray[i], gridBagConstraints);
        }
        return jPanel;
    }

    private JPanel getFieldWithUnitPanel(JTextField jTextField, JLabel jLabel) {
        JComponent[] jComponentArray = new JComponent[]{jTextField, jLabel};
        return this.getComponentPanel(jComponentArray);
    }

    private JPanel getRGBColorPanel(JTextField[] jTextFieldArray) {
        JComponent[] jComponentArray = new JComponent[6];
        for (int i = 0; i < 3; ++i) {
            jComponentArray[i * 2] = new JLabel(LABEL_RGB_COLOR[i]);
            jComponentArray[i * 2 + 1] = jTextFieldArray[i];
        }
        return this.getComponentPanel(jComponentArray);
    }

    private JPanel getRGBColorPanel(String string, JTextField[] jTextFieldArray) {
        JPanel jPanel = this.getRGBColorPanel(jTextFieldArray);
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), string));
        return jPanel;
    }

    private JPanel getGraphColorPanel(String string, JTextField[][] jTextFieldArray) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), string));
        GridBagConstraints gridBagConstraints = this.getDefaultConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        for (int i = 0; i < 3; ++i) {
            if (i != 0) {
                ++gridBagConstraints.gridy;
            }
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 10;
            jPanel.add((Component)new JLabel(LABEL_GRAPH_RANGE[i].toUpperCase()), gridBagConstraints);
            gridBagConstraints.anchor = 17;
            ++gridBagConstraints.gridx;
            gridBagConstraints.gridwidth = 1;
            jPanel.add((Component)this.getRGBColorPanel(jTextFieldArray[i]), gridBagConstraints);
        }
        return jPanel;
    }

    private JPanel getGraphColorThresholdPanel(String string, JTextField[] jTextFieldArray) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), string));
        GridBagConstraints gridBagConstraints = this.getDefaultConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        for (int i = 0; i < 2; ++i) {
            if (i != 0) {
                ++gridBagConstraints.gridx;
            }
            gridBagConstraints.anchor = 10;
            jPanel.add((Component)new JLabel(" " + LABEL_GRAPH_RANGE[i].toUpperCase() + " "), gridBagConstraints);
            gridBagConstraints.anchor = 17;
            ++gridBagConstraints.gridx;
            jPanel.add((Component)jTextFieldArray[i], gridBagConstraints);
            ++gridBagConstraints.gridx;
            jPanel.add((Component)new JLabel("% "), gridBagConstraints);
        }
        return jPanel;
    }

    private int getRGBPartValue(int n, int n2) {
        return n2 >> (2 - n) * 8 & 0xFF;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 1, 0);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 1, 0);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 1, 0);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 1, 0);
        }
    }

    private boolean byteCheck(String string) {
        return string.getBytes().length == string.length();
    }

    private int strToInt(String string, int n) {
        if (string == null || string.length() < 1 || !this.byteCheck(string)) {
            return n;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return n;
        }
    }

    private void compParam(JTextField[] jTextFieldArray) {
        int n;
        int n2 = Integer.parseInt(jTextFieldArray[0].getText());
        if (n2 < (n = Integer.parseInt(jTextFieldArray[1].getText()))) {
            jTextFieldArray[0].setText(String.valueOf(DEFAULT_GRAPH_RANGE_THRESHOLD[0]));
            jTextFieldArray[1].setText(String.valueOf(DEFAULT_GRAPH_RANGE_THRESHOLD[1]));
        }
    }
}

