/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.Const;
import com.nttdocomo.dojaemu.ktoolbar.DeviceDisplayEditWindow;
import com.nttdocomo.dojaemu.ktoolbar.DeviceDisplayInfo;
import com.nttdocomo.dojaemu.ktoolbar.DeviceOptionUtil;
import com.nttdocomo.dojaemu.ktoolbar.JAMManager;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.SettingProperty;
import com.nttdocomo.dojaemu.ktoolbar.TabPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

class DeviceDisplayWindow
extends TabPanel {
    private static final int FRAME_WIDTH = 480;
    private static final int FRAME_HEIGHT = 200;
    private static final int BUTTON_WIDTH = 10;
    private static final int BUTTON_HEIGHT = 10;
    private static final int BUTTON_INTERVAL = 5;
    private JTable deviceDsiplayTable;
    private String[] deviceNames;
    private Vector deviceList = new Vector();
    private JScrollPane scrollpane;
    private static final String[] TEMPLATE_DEVICE_NAME = new String[]{"device1", "device2"};
    public static final String FULL_KEYBOARD = "1";
    private static final String deviceDisplayPath = System.getProperty("emu.home") + File.separator + "lib" + File.separator + "skin" + File.separator + "deviceinfo";

    DeviceDisplayWindow(AbstractWindow abstractWindow, MainWindow mainWindow) {
        super(abstractWindow);
        this.parent = mainWindow;
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        JButton jButton = new JButton(Resource.getString("ADD"));
        JButton jButton2 = new JButton(Resource.getString("EDIT"));
        JButton jButton3 = new JButton(Resource.getString("REMOVE"));
        jButton.setActionCommand("add");
        jButton2.setActionCommand("edit");
        jButton3.setActionCommand("remove");
        jButton.addActionListener(actionDispatcher);
        jButton2.addActionListener(actionDispatcher);
        jButton3.addActionListener(actionDispatcher);
        jButton.setSize(10, 10);
        jButton2.setSize(10, 10);
        jButton3.setSize(10, 10);
        if (JAMManager.getState() == 4) {
            jButton.setEnabled(true);
            jButton2.setEnabled(true);
            jButton3.setEnabled(true);
        } else {
            jButton.setEnabled(false);
            jButton2.setEnabled(false);
            jButton3.setEnabled(false);
        }
        jPanel3.add(Box.createVerticalStrut(5));
        jPanel3.add(jButton);
        jPanel3.add(Box.createVerticalStrut(5));
        jPanel3.add(jButton2);
        jPanel3.add(Box.createVerticalStrut(5));
        jPanel3.add(jButton3);
        jPanel3.add(Box.createHorizontalStrut(10));
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add(jPanel3);
        jPanel2.add(Box.createHorizontalStrut(5));
        this.refreshDeviceDisplayList();
        this.deviceDsiplayTable = this.createdeviceDsiplayTable();
        this.scrollpane = new JScrollPane(this.deviceDsiplayTable);
        this.add("East", jPanel2);
        this.add("Center", this.scrollpane);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(480, 200);
    }

    private JTable createdeviceDsiplayTable() {
        Object object;
        Serializable serializable;
        String[] stringArray = new String[]{Resource.getString("DISPLAY_DEVICE"), Resource.getString("DISPLAY_CLM_MAIN_W"), Resource.getString("DISPLAY_CLM_MAIN_H"), Resource.getString("DISPLAY_CLM_SUB_W"), Resource.getString("DISPLAY_CLM_SUB_H"), Resource.getString("DISPLAY_CLM_KEYBOARD")};
        deviceDsiplayTableModel deviceDsiplayTableModel2 = new deviceDsiplayTableModel(stringArray, 0);
        for (int i = 0; i < this.deviceList.size(); ++i) {
            DeviceDisplayInfo deviceDisplayInfo = (DeviceDisplayInfo)this.deviceList.get(i);
            serializable = new Vector<String>();
            ((Vector)serializable).addElement(deviceDisplayInfo.getDeviceName());
            ((Vector)serializable).addElement(deviceDisplayInfo.getMainWidth());
            ((Vector)serializable).addElement(deviceDisplayInfo.getMainHeight());
            ((Vector)serializable).addElement(deviceDisplayInfo.getSubWidth());
            ((Vector)serializable).addElement(deviceDisplayInfo.getSubHeight());
            object = deviceDisplayInfo.getKeyboardType();
            if (FULL_KEYBOARD.equals(object)) {
                ((Vector)serializable).addElement(Resource.getString("DISPLAY_FULL_KEYBOARD"));
            } else {
                ((Vector)serializable).addElement(Resource.getString("DISPLAY_12_KEYBOARD"));
            }
            deviceDsiplayTableModel2.addRow((Vector<?>)serializable);
        }
        JTable jTable = new JTable(deviceDsiplayTableModel2);
        jTable.getTableHeader().setReorderingAllowed(false);
        jTable.getTableHeader().setResizingAllowed(false);
        jTable.setDefaultRenderer(Object.class, new deviceDsiplayTableCellRenderer());
        TableColumn tableColumn = jTable.getColumnModel().getColumn(1);
        tableColumn.setMinWidth(69);
        tableColumn.setMaxWidth(69);
        serializable = jTable.getColumnModel().getColumn(2);
        ((TableColumn)serializable).setMinWidth(72);
        ((TableColumn)serializable).setMaxWidth(72);
        object = jTable.getColumnModel().getColumn(3);
        ((TableColumn)object).setMinWidth(67);
        ((TableColumn)object).setMaxWidth(67);
        TableColumn tableColumn2 = jTable.getColumnModel().getColumn(4);
        tableColumn2.setMinWidth(70);
        tableColumn2.setMaxWidth(70);
        jTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2 && JAMManager.getState() == 4) {
                    DeviceDisplayWindow.this.edit();
                }
            }
        });
        jTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10 && JAMManager.getState() == 4) {
                    DeviceDisplayWindow.this.edit();
                }
            }
        });
        return jTable;
    }

    private void refreshDeviceDisplayList() {
        BufferedReader bufferedReader = null;
        try {
            File file = new File(deviceDisplayPath);
            this.deviceNames = file.list();
            for (int i = 0; i < this.deviceNames.length; ++i) {
                String string;
                bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(deviceDisplayPath + File.separator + this.deviceNames[i])));
                while ((string = bufferedReader.readLine()) != null) {
                    try {
                        DeviceDisplayInfo deviceDisplayInfo = new DeviceDisplayInfo(string);
                        deviceDisplayInfo.setDeviceOptionBeanList(DeviceOptionUtil.read(Const.PATH_LIB_OPTIONAL_FUNCTION + deviceDisplayInfo.deviceName));
                        this.deviceList.add(deviceDisplayInfo);
                    }
                    catch (Exception exception) {
                        System.err.println(Resource.format("READ_ERR", deviceDisplayPath));
                    }
                }
                bufferedReader.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println(Resource.format("NOT_FOUND_ERR", deviceDisplayPath));
        }
        catch (IOException iOException) {
            System.err.println(Resource.format("READ_ERR", deviceDisplayPath));
        }
        catch (Exception exception) {
            System.err.println(Resource.format("READ_ERR", deviceDisplayPath));
        }
    }

    void add() {
        DeviceDisplayInfo deviceDisplayInfo = new DeviceDisplayInfo();
        DeviceDisplayEditWindow deviceDisplayEditWindow = new DeviceDisplayEditWindow(this.parent, deviceDisplayInfo, this.deviceList);
        deviceDisplayEditWindow.setLocation(this.parent.getShowLocation(deviceDisplayEditWindow.getWidth(), deviceDisplayEditWindow.getHeight(), this.tabwin));
        deviceDisplayEditWindow.setVisible(true);
        if (deviceDisplayEditWindow.isEdited() && this.listener != null) {
            this.listener.tabPanelEvent(this, 2, 0);
            this.deviceList.add(deviceDisplayInfo);
        }
        deviceDisplayEditWindow.dispose();
        this.setVisible(false);
        this.remove(this.scrollpane);
        this.scrollpane = null;
        this.deviceDsiplayTable = null;
        this.deviceDsiplayTable = this.createdeviceDsiplayTable();
        this.scrollpane = new JScrollPane(this.deviceDsiplayTable);
        this.add("Center", this.scrollpane);
        this.setVisible(true);
    }

    void edit() {
        int[] nArray = this.deviceDsiplayTable.getSelectedRows();
        if (nArray.length != 1) {
            return;
        }
        if (!this.tenmplateCheck(nArray)) {
            return;
        }
        DeviceDisplayInfo deviceDisplayInfo = (DeviceDisplayInfo)this.deviceList.get(nArray[0]);
        DeviceDisplayEditWindow deviceDisplayEditWindow = new DeviceDisplayEditWindow(this.parent, deviceDisplayInfo, this.deviceList);
        deviceDisplayEditWindow.setLocation(this.parent.getShowLocation(deviceDisplayEditWindow.getWidth(), deviceDisplayEditWindow.getHeight(), this.tabwin));
        deviceDisplayEditWindow.setVisible(true);
        if (deviceDisplayEditWindow.isEdited() && this.listener != null) {
            this.listener.tabPanelEvent(this, 2, 0);
            this.deviceList.set(nArray[0], deviceDisplayInfo);
        }
        deviceDisplayEditWindow.dispose();
        this.setVisible(false);
        this.remove(this.scrollpane);
        this.scrollpane = null;
        this.deviceDsiplayTable = null;
        this.deviceDsiplayTable = this.createdeviceDsiplayTable();
        this.scrollpane = new JScrollPane(this.deviceDsiplayTable);
        this.add("Center", this.scrollpane);
        this.setVisible(true);
    }

    void remove() {
        int[] nArray = this.deviceDsiplayTable.getSelectedRows();
        if (nArray.length < 1) {
            return;
        }
        if (!this.tenmplateCheck(nArray)) {
            return;
        }
        for (int i = nArray.length - 1; i >= 0; --i) {
            this.deviceList.remove(nArray[i]);
        }
        this.setVisible(false);
        this.remove(this.scrollpane);
        this.scrollpane = null;
        this.deviceDsiplayTable = null;
        this.deviceDsiplayTable = this.createdeviceDsiplayTable();
        this.scrollpane = new JScrollPane(this.deviceDsiplayTable);
        this.add("Center", this.scrollpane);
        this.setVisible(true);
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 2, 0);
        }
    }

    private boolean tenmplateCheck(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            DeviceDisplayInfo deviceDisplayInfo = (DeviceDisplayInfo)this.deviceList.get(nArray[i]);
            for (int j = 0; j < TEMPLATE_DEVICE_NAME.length; ++j) {
                if (!TEMPLATE_DEVICE_NAME[j].equals(deviceDisplayInfo.getDeviceName())) continue;
                this.parent.showDialog(Resource.format("DISPLAY_NOT_EDITABLE", TEMPLATE_DEVICE_NAME[j]), this, 2);
                return false;
            }
        }
        return true;
    }

    @Override
    void cancel() {
    }

    @Override
    boolean set() {
        this.saveSetting();
        return true;
    }

    void saveSetting() {
        BufferedWriter bufferedWriter = null;
        DeviceDisplayInfo deviceDisplayInfo = null;
        File file = null;
        File file2 = null;
        try {
            int n;
            for (n = 0; n < this.deviceNames.length; ++n) {
                file2 = new File(Const.PATH_LIB_OPTIONAL_FUNCTION + this.deviceNames[n]);
                if (!file2.delete() && file2.exists()) continue;
                file = new File(deviceDisplayPath + File.separator + this.deviceNames[n]);
                file.delete();
            }
            for (n = 0; n < this.deviceList.size(); ++n) {
                deviceDisplayInfo = (DeviceDisplayInfo)this.deviceList.get(n);
                bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(deviceDisplayPath + File.separator + deviceDisplayInfo.getDeviceName())));
                bufferedWriter.write(deviceDisplayInfo.getDeviceName() + "," + deviceDisplayInfo.getMainWidth() + "," + deviceDisplayInfo.getMainHeight() + "," + deviceDisplayInfo.getSubWidth() + "," + deviceDisplayInfo.getSubHeight() + "," + deviceDisplayInfo.getKeyboardType() + "," + deviceDisplayInfo.getResolution() + "," + deviceDisplayInfo.getParallax() + "," + deviceDisplayInfo.getParallaxChange() + "," + deviceDisplayInfo.getIntensityLevel());
                bufferedWriter.close();
                try {
                    DeviceOptionUtil.write(deviceDisplayInfo.getDeviceOptionBeanList(), Const.PATH_LIB_OPTIONAL_FUNCTION + deviceDisplayInfo.getDeviceName());
                    continue;
                }
                catch (Exception exception) {
                    System.err.println(Resource.format("WRITE_ERR", new StringBuffer(Const.PATH_LIB_OPTIONAL_FUNCTION).deleteCharAt(Const.PATH_LIB_OPTIONAL_FUNCTION.length() - 1)));
                    return;
                }
            }
        }
        catch (Exception exception) {
            System.err.println(Resource.format("WRITE_ERR", deviceDisplayPath));
            return;
        }
        File file3 = new File(deviceDisplayPath);
        this.deviceNames = file3.list();
        SettingProperty.devices = file3.list();
        this.parent.resetDeviceMenu();
    }

    class deviceDsiplayTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        deviceDsiplayTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            if (bl) {
                this.setBackground(Color.black);
                this.setForeground(Color.white);
            } else {
                if (n % 2 == 0) {
                    this.setBackground(Color.white);
                } else {
                    this.setBackground(new Color(238, 238, 238));
                }
                this.setForeground(Color.black);
            }
            this.setText((String)object);
            return this;
        }
    }

    class deviceDsiplayTableModel
    extends DefaultTableModel {
        deviceDsiplayTableModel(String[] stringArray, int n) {
            super(stringArray, n);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

