/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.DeviceOptionBean;
import com.nttdocomo.dojaemu.ktoolbar.DeviceOptionUtil;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.StringDocument;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

class DeviceOptionEditWindow
extends AbstractWindow {
    private static final int FRAME_WIDTH = 480;
    private static final int FRAME_HEIGHT = 620;
    private static final int TEXT_WIDTH = 20;
    private static final int HGAP = 3;
    private static final int VGAP = 10;
    private static final int INPUT_MAX_SIZE = 80;
    private JScrollPane scrollPane;
    private JTextField filterWordField;
    private int filterCondition = 2;
    private Color evenNumColor;
    private JPanel centerPanel = new JPanel();
    private ArrayList<DeviceOptionBean> dobList = null;
    private ArrayList<Boolean> supportList = new ArrayList();

    public DeviceOptionEditWindow(MainWindow mainWindow, ArrayList<DeviceOptionBean> arrayList) {
        super(mainWindow, Resource.getString("OptionalFunctionSetting.common.caption.OptionalFunctionSettingWindow"), true);
        this.dobList = arrayList;
        for (int i = 0; i < arrayList.size(); ++i) {
            this.supportList.add(arrayList.get(i).isSupport());
        }
        JLabel jLabel = new JLabel(Resource.getString("OptionalFunctionSetting.common.caption.Filter"));
        JLabel jLabel2 = new JLabel(Resource.getString("OptionalFunctionSetting.common.caption.Keyword"));
        JLabel jLabel3 = new JLabel(Resource.getString("OptionalFunctionSetting.common.caption.Status"));
        this.filterWordField = new JTextField("", 20);
        this.filterWordField.setDocument(new StringDocument(80));
        this.filterWordField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                DeviceOptionEditWindow.this.filteringDraw();
            }
        });
        JRadioButton jRadioButton = new JRadioButton(Resource.getString("OptionalFunctionSetting.common.caption.Support"));
        JRadioButton jRadioButton2 = new JRadioButton(Resource.getString("OptionalFunctionSetting.common.caption.UnSupported"));
        JRadioButton jRadioButton3 = new JRadioButton(Resource.getString("OptionalFunctionSetting.common.caption.All"));
        JButton jButton = new JButton(Resource.getString("SET"));
        JButton jButton2 = new JButton(Resource.getString("CANCEL"));
        jRadioButton.setActionCommand("supportFilter");
        jRadioButton2.setActionCommand("unSupportedFilter");
        jRadioButton3.setActionCommand("allDisp");
        jButton.setActionCommand("save");
        jButton2.setActionCommand("cancel");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        jRadioButton.addActionListener(actionDispatcher);
        jRadioButton2.addActionListener(actionDispatcher);
        jRadioButton3.addActionListener(actionDispatcher);
        jButton.addActionListener(actionDispatcher);
        jButton2.addActionListener(actionDispatcher);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        jPanel.add(jLabel2);
        jPanel.add(this.filterWordField);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton3);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.add(jLabel3);
        jPanel2.add(jRadioButton);
        jPanel2.add(jRadioButton2);
        jPanel2.add(jRadioButton3);
        jRadioButton3.setSelected(true);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add("North", jPanel);
        jPanel3.add("South", jPanel2);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(2, 40, 8));
        jPanel4.add(jLabel);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout());
        jPanel5.add("West", jPanel4);
        jPanel5.add("Center", jPanel3);
        this.backColor();
        this.drawOptionWindow(arrayList);
        this.scrollPane = new JScrollPane(this.centerPanel, 22, 31);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(25);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new FlowLayout(1));
        jPanel6.add(jButton);
        jPanel6.add(jButton2);
        container.add("North", jPanel5);
        container.add("Center", this.scrollPane);
        container.add("South", jPanel6);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                DeviceOptionEditWindow.this.cancelData();
            }
        });
        this.setResizable(false);
        this.setSize(480, 620);
    }

    private void drawOptionWindow(ArrayList<DeviceOptionBean> arrayList) {
        this.centerPanel.removeAll();
        this.centerPanel.setLayout(new GridLayout(arrayList.size(), 1));
        for (int i = 0; i < arrayList.size(); ++i) {
            final DeviceOptionBean deviceOptionBean = arrayList.get(i);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.setPreferredSize(new Dimension(3, 25));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new FlowLayout(0, 3, 7));
            JLabel jLabel = new JLabel(deviceOptionBean.getOptionName());
            jPanel2.add(jLabel);
            jPanel.add("West", jPanel2);
            JRadioButton jRadioButton = new JRadioButton(Resource.getString("OptionalFunctionSetting.common.caption.Support"));
            JRadioButton jRadioButton2 = new JRadioButton(Resource.getString("OptionalFunctionSetting.common.caption.UnSupported"));
            jRadioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    deviceOptionBean.setSupport(true);
                }
            });
            jRadioButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    deviceOptionBean.setSupport(false);
                }
            });
            if (deviceOptionBean.isSupport()) {
                jRadioButton.setSelected(true);
            } else {
                jRadioButton2.setSelected(true);
            }
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(jRadioButton);
            buttonGroup.add(jRadioButton2);
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new FlowLayout(2));
            jPanel3.add(jRadioButton);
            jPanel3.add(jRadioButton2);
            jPanel3.setLayout(new FlowLayout(0, 3, 2));
            if (i % 2 != 0) {
                jPanel2.setBackground(this.evenNumColor);
                jRadioButton.setBackground(this.evenNumColor);
                jRadioButton2.setBackground(this.evenNumColor);
                jPanel3.setBackground(this.evenNumColor);
                jPanel.setBackground(this.evenNumColor);
            }
            jPanel.add("East", jPanel3);
            this.centerPanel.add(jPanel);
        }
    }

    void filteringDraw() {
        this.scrollPane.setViewportView(null);
        this.drawOptionWindow(DeviceOptionUtil.filter(this.filterWordField.getText(), this.filterCondition, this.dobList));
        this.scrollPane.setViewportView(this.centerPanel);
        this.scrollPane.repaint();
    }

    void supportFilter() {
        this.filterCondition = 0;
        this.filteringDraw();
    }

    void unSupportedFilter() {
        this.filterCondition = 1;
        this.filteringDraw();
    }

    void allDisp() {
        this.filterCondition = 2;
        this.filteringDraw();
    }

    void save() {
        this.setVisible(false);
    }

    void cancel() {
        this.cancelData();
        this.setVisible(false);
    }

    public void cancelData() {
        for (int i = 0; i < this.dobList.size(); ++i) {
            DeviceOptionBean deviceOptionBean = this.dobList.get(i);
            deviceOptionBean.setSupport(this.supportList.get(i));
        }
    }

    private void backColor() {
        Color color = this.centerPanel.getBackground();
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        if (n > 220 || n2 > 220 || n3 > 220) {
            n -= 35;
            n2 -= 35;
            n3 -= 35;
        } else if (n < 70 || n2 < 70 || n3 < 70) {
            n += 70;
            n2 += 70;
            n3 += 70;
        } else {
            n += 13;
            n2 += 13;
            n3 += 13;
        }
        this.evenNumColor = new Color(n, n2, n3);
    }
}

