/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.DeviceOptionBean;
import com.nttdocomo.dojaemu.ktoolbar.DeviceOptionProperty;
import com.nttdocomo.dojaemu.ktoolbar.IniFileEntity;
import java.io.IOException;
import java.util.ArrayList;

public final class DeviceOptionUtil {
    private static final String OPTION_SECTION = "Optional_function_Setting";
    private static final String SUPPORTED = "1";
    private static final String UNSUPPORTED = "0";
    public static final int FILTER_ON = 0;
    public static final int FILTER_OFF = 1;
    public static final int FILTER_ALL = 2;

    private DeviceOptionUtil() {
    }

    public static ArrayList<DeviceOptionBean> read(String string) {
        ArrayList<DeviceOptionBean> arrayList = DeviceOptionProperty.getDeviceOptionBeanDefaultList();
        IniFileEntity iniFileEntity = new IniFileEntity(string);
        try {
            iniFileEntity.read();
            for (int i = 0; i < arrayList.size(); ++i) {
                String string2 = iniFileEntity.getSectionAttribute(OPTION_SECTION, arrayList.get(i).getOptionName());
                if (string2 == null || !string2.equals(UNSUPPORTED)) continue;
                arrayList.get(i).setSupport(false);
            }
        }
        catch (Exception exception) {
            arrayList = DeviceOptionProperty.getDeviceOptionBeanDefaultList();
        }
        return arrayList;
    }

    public static void write(ArrayList<DeviceOptionBean> arrayList, String string) throws IOException {
        IniFileEntity iniFileEntity;
        IniFileEntity iniFileEntity2 = iniFileEntity = new IniFileEntity(string);
        iniFileEntity2.getClass();
        IniFileEntity.IniSection iniSection = new IniFileEntity.IniSection(iniFileEntity2, OPTION_SECTION);
        iniFileEntity.addSection(iniSection);
        for (int i = 0; i < arrayList.size(); ++i) {
            DeviceOptionBean deviceOptionBean = arrayList.get(i);
            if (!deviceOptionBean.isSupport()) {
                iniFileEntity.setSectionAttribute(OPTION_SECTION, deviceOptionBean.getOptionName(), UNSUPPORTED);
                continue;
            }
            iniFileEntity.setSectionAttribute(OPTION_SECTION, deviceOptionBean.getOptionName(), SUPPORTED);
        }
        iniFileEntity.save();
    }

    public static ArrayList<DeviceOptionBean> filter(String string, int n, ArrayList<DeviceOptionBean> arrayList) {
        ArrayList<DeviceOptionBean> arrayList2 = new ArrayList();
        arrayList2 = DeviceOptionUtil.wordFliter(arrayList, string);
        arrayList2 = DeviceOptionUtil.supportFilter(arrayList2, n);
        return arrayList2;
    }

    private static ArrayList<DeviceOptionBean> wordFliter(ArrayList<DeviceOptionBean> arrayList, String string) {
        ArrayList<DeviceOptionBean> arrayList2 = new ArrayList<DeviceOptionBean>();
        if (string != null && string.length() > 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                if (arrayList.get(i).getOptionName().toLowerCase().indexOf(string.toLowerCase()) <= -1) continue;
                arrayList2.add(arrayList.get(i));
            }
        } else {
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList2.add(arrayList.get(i));
            }
        }
        return arrayList2;
    }

    private static ArrayList<DeviceOptionBean> supportFilter(ArrayList<DeviceOptionBean> arrayList, int n) {
        boolean bl = true;
        if (n == 0) {
            bl = true;
        } else if (n == 1) {
            bl = false;
        } else {
            n = 2;
        }
        if (n != 2) {
            for (int i = 0; i < arrayList.size(); ++i) {
                if (arrayList.get(i).isSupport() == bl) continue;
                arrayList.remove(arrayList.get(i));
                --i;
            }
        }
        return arrayList;
    }
}

