/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.AsciiDocument;
import com.nttdocomo.dojaemu.ktoolbar.EditorFileFilter;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.TabPanel;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class EditorWindow
extends TabPanel
implements DocumentListener {
    public static final String NOTEPAD = "NOTEPAD.EXE";
    private JTextField editorField;
    private JTextField paramsField;

    EditorWindow(AbstractWindow abstractWindow) {
        super(abstractWindow);
        JLabel jLabel = new JLabel(Resource.getString("EDITOR"));
        JLabel jLabel2 = new JLabel(Resource.getString("EDITOR_ARGS"));
        JLabel jLabel3 = new JLabel(Resource.getString("EDITOR_ARGS_NOTE"));
        JButton jButton = new JButton(Resource.getString("SET"));
        JButton jButton2 = new JButton(Resource.getString("CANCEL"));
        JButton jButton3 = new JButton(Resource.getString("FILE_SELECT"));
        jButton3.setMnemonic(82);
        jButton3.setActionCommand("select");
        this.editorField = new JTextField(36);
        this.editorField.setText(this.parent.getSourceEditor());
        this.editorField.getDocument().addDocumentListener(this);
        this.paramsField = new JTextField(36);
        this.paramsField.setDocument(new AsciiDocument(128));
        this.paramsField.getDocument().addDocumentListener(this);
        this.paramsField.setText(this.parent.getSourceEditorArgs());
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        jPanel.add(jLabel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.add(this.editorField);
        jPanel2.add(jButton3);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add(jPanel);
        jPanel3.add(jPanel2);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(0));
        jPanel4.add(jLabel2);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(0));
        jPanel5.add(this.paramsField);
        jPanel5.add(jLabel3);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        jPanel6.add(jPanel4);
        jPanel6.add(jPanel5);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BoxLayout(jPanel7, 1));
        jPanel7.add(jPanel3);
        jPanel7.add(jPanel6);
        this.add("North", jPanel7);
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        jButton3.addActionListener(actionDispatcher);
    }

    @Override
    boolean set() {
        if (!this.checkEditor()) {
            return false;
        }
        this.parent.setSourceEditor(this.editorField.getText().trim());
        this.parent.setSourceEditorArgs(this.paramsField.getText().trim());
        return true;
    }

    private boolean checkEditor() {
        String string = this.editorField.getText();
        if (string.trim().length() == 0) {
            return true;
        }
        if (!new File(string).isFile()) {
            try {
                this.parent.showDialog(Resource.getString("NOT_EDITOR_WNG"), this.tabwin, 2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    @Override
    void cancel() {
    }

    void select() {
        JFileChooser jFileChooser = null;
        File file = new File(this.editorField.getText());
        if (this.editorField.getText() == null || this.editorField.getText().length() == 0) {
            jFileChooser = new JFileChooser();
        } else {
            if (!file.exists()) {
                this.parent.showDialog(Resource.getString("FILE_CHOOSER_MSG_INVALID"), this.tabwin, 2);
                return;
            }
            jFileChooser = new JFileChooser(file.getAbsolutePath());
        }
        jFileChooser.setDialogTitle(Resource.getString("EDITOR_DIALOG"));
        jFileChooser.setDialogType(0);
        jFileChooser.setFileSelectionMode(2);
        jFileChooser.setFileFilter(new EditorFileFilter());
        jFileChooser.setMultiSelectionEnabled(false);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            this.editorField.setText(jFileChooser.getSelectedFile().toString());
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 1, 0);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 1, 0);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 1, 0);
        }
    }
}

