/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.DecimalDocument;
import com.nttdocomo.dojaemu.ktoolbar.GyroSensorDataEntry;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.Container;
import java.awt.FlowLayout;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class GyroSensorAngleWindow
extends AbstractWindow {
    private MainWindow parent = null;
    private GyroSensorDataEntry entry = null;
    private JTextField angleMinXField;
    private JTextField angleMaxXField;
    private JTextField angleMinYField;
    private JTextField angleMaxYField;
    private JTextField angleMinZField;
    private JTextField angleMaxZField;
    private JButton setButton;
    private JButton cancelButton;
    private final int TXTFIELD_X = 1;
    private final int TXTFIELD_Y = 2;
    private final int TXTFIELD_Z = 3;

    GyroSensorAngleWindow(MainWindow mainWindow, GyroSensorDataEntry gyroSensorDataEntry) {
        super(mainWindow, Resource.getString("GYRO_ANGLE_DATA_RANGE_TITLE"));
        this.parent = mainWindow;
        this.addWindowListener();
        this.entry = gyroSensorDataEntry;
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = new JLabel(Resource.getString("GYRO_LBL_ANGLE_RATE_X"));
        JLabel jLabel2 = new JLabel(Resource.getString("GYRO_LBL_ANGLE_DATA_MIN"));
        JLabel jLabel3 = new JLabel(Resource.getString("GYRO_LBL_ANGLE_DATA_MAX"));
        JLabel jLabel4 = new JLabel(Resource.getString("GYRO_LBL_ANGLE_RATE_Y"));
        JLabel jLabel5 = new JLabel(Resource.getString("GYRO_LBL_ANGLE_DATA_MIN"));
        JLabel jLabel6 = new JLabel(Resource.getString("GYRO_LBL_ANGLE_DATA_MAX"));
        JLabel jLabel7 = new JLabel(Resource.getString("GYRO_LBL_ANGLE_RATE_Z"));
        JLabel jLabel8 = new JLabel(Resource.getString("GYRO_LBL_ANGLE_DATA_MIN"));
        JLabel jLabel9 = new JLabel(Resource.getString("GYRO_LBL_ANGLE_DATA_MAX"));
        this.angleMinXField = new JTextField(8);
        this.angleMaxXField = new JTextField(8);
        this.angleMinYField = new JTextField(8);
        this.angleMaxYField = new JTextField(8);
        this.angleMinZField = new JTextField(8);
        this.angleMaxZField = new JTextField(8);
        this.angleMinXField.setDocument(new DecimalDocument(5));
        this.angleMaxXField.setDocument(new DecimalDocument(5));
        this.angleMinYField.setDocument(new DecimalDocument(5));
        this.angleMaxYField.setDocument(new DecimalDocument(5));
        this.angleMinZField.setDocument(new DecimalDocument(5));
        this.angleMaxZField.setDocument(new DecimalDocument(5));
        this.angleMinXField.setHorizontalAlignment(2);
        this.angleMaxXField.setHorizontalAlignment(2);
        this.angleMinYField.setHorizontalAlignment(2);
        this.angleMaxYField.setHorizontalAlignment(2);
        this.angleMinZField.setHorizontalAlignment(2);
        this.angleMaxZField.setHorizontalAlignment(2);
        String[] stringArray = gyroSensorDataEntry.getAngleValuesX();
        String[] stringArray2 = gyroSensorDataEntry.getAngleValuesY();
        String[] stringArray3 = gyroSensorDataEntry.getAngleValuesZ();
        this.angleMinXField.setText(stringArray[0]);
        this.angleMaxXField.setText(stringArray[1]);
        this.angleMinYField.setText(stringArray2[0]);
        this.angleMaxYField.setText(stringArray2[1]);
        this.angleMinZField.setText(stringArray3[0]);
        this.angleMaxZField.setText(stringArray3[1]);
        this.setButton = new JButton(Resource.getString("SET"));
        this.cancelButton = new JButton(Resource.getString("CANCEL"));
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout());
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout());
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout());
        jPanel3.add(jLabel);
        jPanel3.add(jLabel2);
        jPanel3.add(this.angleMinXField);
        jPanel3.add(new JLabel("  "));
        jPanel3.add(jLabel3);
        jPanel3.add(this.angleMaxXField);
        jPanel4.add(jLabel4);
        jPanel4.add(jLabel5);
        jPanel4.add(this.angleMinYField);
        jPanel4.add(new JLabel("  "));
        jPanel4.add(jLabel6);
        jPanel4.add(this.angleMaxYField);
        jPanel5.add(jLabel7);
        jPanel5.add(jLabel8);
        jPanel5.add(this.angleMinZField);
        jPanel5.add(new JLabel("  "));
        jPanel5.add(jLabel9);
        jPanel5.add(this.angleMaxZField);
        jPanel2.add(jPanel3);
        jPanel2.add(jPanel4);
        jPanel2.add(jPanel5);
        jPanel.add(this.setButton);
        jPanel.add(this.cancelButton);
        container.add(jPanel2);
        container.add(jPanel);
        this.setButton.setActionCommand("set");
        this.cancelButton.setActionCommand("cancel");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.setButton.addActionListener(actionDispatcher);
        this.cancelButton.addActionListener(actionDispatcher);
        this.pack();
        this.setResizable(false);
    }

    private boolean checkRangeAngle(int n, String string, String string2) throws IllegalArgumentException {
        block16: {
            if (string.equals("") || string2.equals("")) {
                throw new IllegalArgumentException(Resource.getString("GYRO_VAL_NOT_INPUT_WNG"));
            }
            try {
                int n2;
                int n3;
                try {
                    n3 = Integer.parseInt(string);
                    n2 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new Exception("");
                }
                if (n3 < -9999 || n2 > 9999) {
                    throw new Exception("");
                }
                if (n3 > n2) {
                    throw new Exception("");
                }
                String string3 = "";
                if (n == 1) {
                    string3 = "VALUE_X";
                } else if (n == 2) {
                    string3 = "VALUE_Y";
                } else if (n == 3) {
                    string3 = "VALUE_Z";
                }
                int n4 = this.entry.getCount();
                if (n4 > 0) {
                    ArrayList arrayList = this.entry.getData();
                    for (int i = 0; i < n4; ++i) {
                        Hashtable hashtable = (Hashtable)arrayList.get(i);
                        String string4 = (String)hashtable.get(string3);
                        int n5 = Integer.parseInt(string4);
                        if (n3 <= n5 && n2 >= n5) continue;
                        throw new Exception("");
                    }
                }
            }
            catch (Exception exception) {
                if (n == 1) {
                    throw new IllegalArgumentException(Resource.format("GYRO_VAL_OVER_RANGE_WNG", Resource.getString("GYRO_LBL_DATA_X")));
                }
                if (n == 2) {
                    throw new IllegalArgumentException(Resource.format("GYRO_VAL_OVER_RANGE_WNG", Resource.getString("GYRO_LBL_DATA_Y")));
                }
                if (n != 3) break block16;
                throw new IllegalArgumentException(Resource.format("GYRO_VAL_OVER_RANGE_WNG", Resource.getString("GYRO_LBL_DATA_Z")));
            }
        }
        return true;
    }

    void set() {
        String[] stringArray = new String[]{"", ""};
        String[] stringArray2 = new String[]{"", ""};
        String[] stringArray3 = new String[]{"", ""};
        try {
            if (this.checkRangeAngle(1, this.angleMinXField.getText(), this.angleMaxXField.getText())) {
                stringArray[0] = this.angleMinXField.getText();
                stringArray[1] = this.angleMaxXField.getText();
            }
            if (this.checkRangeAngle(2, this.angleMinYField.getText(), this.angleMaxYField.getText())) {
                stringArray2[0] = this.angleMinYField.getText();
                stringArray2[1] = this.angleMaxYField.getText();
            }
            if (this.checkRangeAngle(3, this.angleMinZField.getText(), this.angleMaxZField.getText())) {
                stringArray3[0] = this.angleMinZField.getText();
                stringArray3[1] = this.angleMaxZField.getText();
            }
            this.entry.setAngleValuesX(stringArray);
            this.entry.setAngleValuesY(stringArray2);
            this.entry.setAngleValuesZ(stringArray3);
            this.entry.save();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.parent.showDialog(illegalArgumentException.getMessage(), this, 2);
            return;
        }
        catch (IOException iOException) {
            System.err.println(Resource.format("WRITE_ERR", "gyrosensor.dat"));
            return;
        }
        this.setVisible(false);
        this.dispose();
    }

    void cancel() {
        this.setVisible(false);
        this.dispose();
    }
}

