/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.DecimalDocument;
import com.nttdocomo.dojaemu.ktoolbar.GyroSensorDataEntry;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class GyroSensorDataWindow
extends AbstractWindow {
    private MainWindow parent = null;
    private GyroSensorDataEntry entry = null;
    private int rowSelect = -1;
    private JTextField angleXField;
    private JTextField angleYField;
    private JTextField angleZField;
    private JButton setButton;
    private JButton cancelButton;
    private final int TXTFIELD_X = 1;
    private final int TXTFIELD_Y = 2;
    private final int TXTFIELD_Z = 3;
    private static final int FRAME_WIDTH = 210;
    private static final int FRAME_HEIGHT = 170;

    GyroSensorDataWindow(MainWindow mainWindow, GyroSensorDataEntry gyroSensorDataEntry, int n) {
        super(mainWindow, Resource.getString("GYRO_DATA_SET_TITLE"));
        Object object;
        Object object2;
        Object object3;
        Serializable serializable;
        Serializable serializable2;
        this.parent = mainWindow;
        this.addWindowListener();
        this.entry = gyroSensorDataEntry;
        this.rowSelect = n;
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = new JLabel(Resource.getString("GYRO_LBL_DATA_X"));
        JLabel jLabel2 = new JLabel(Resource.getString("GYRO_LBL_DATA_SIGN"));
        JLabel jLabel3 = new JLabel(Resource.getString("GYRO_LBL_DATA_Y"));
        JLabel jLabel4 = new JLabel(Resource.getString("GYRO_LBL_DATA_SIGN"));
        JLabel jLabel5 = new JLabel(Resource.getString("GYRO_LBL_DATA_Z"));
        JLabel jLabel6 = new JLabel(Resource.getString("GYRO_LBL_DATA_SIGN"));
        this.angleXField = new JTextField(8);
        this.angleYField = new JTextField(8);
        this.angleZField = new JTextField(8);
        this.angleXField.setDocument(new DecimalDocument(5));
        this.angleYField.setDocument(new DecimalDocument(5));
        this.angleZField.setDocument(new DecimalDocument(5));
        this.angleXField.setHorizontalAlignment(2);
        this.angleYField.setHorizontalAlignment(2);
        this.angleZField.setHorizontalAlignment(2);
        if (n != -1) {
            serializable2 = gyroSensorDataEntry.getData();
            serializable = (Hashtable)((ArrayList)serializable2).get(n);
            object3 = (String)((Hashtable)serializable).get("VALUE_X");
            object2 = (String)((Hashtable)serializable).get("VALUE_Y");
            object = (String)((Hashtable)serializable).get("VALUE_Z");
            this.angleXField.setText((String)object3);
            this.angleYField.setText((String)object2);
            this.angleZField.setText((String)object);
        }
        this.setButton = new JButton(Resource.getString("SET"));
        this.cancelButton = new JButton(Resource.getString("CANCEL"));
        serializable2 = this.getContentPane();
        ((Container)serializable2).setLayout(new BoxLayout((Container)serializable2, 1));
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        serializable = new JPanel();
        ((Container)serializable).setLayout(new FlowLayout());
        object3 = new JPanel();
        ((Container)object3).setLayout(new FlowLayout());
        object2 = new JPanel();
        ((Container)object2).setLayout(new FlowLayout());
        ((Container)serializable).add(jLabel);
        ((Container)serializable).add(this.angleXField);
        ((Container)serializable).add(jLabel2);
        ((Container)object3).add(jLabel3);
        ((Container)object3).add(this.angleYField);
        ((Container)object3).add(jLabel4);
        ((Container)object2).add(jLabel5);
        ((Container)object2).add(this.angleZField);
        ((Container)object2).add(jLabel6);
        jPanel2.add((Component)serializable);
        jPanel2.add((Component)object3);
        jPanel2.add((Component)object2);
        jPanel.add(this.setButton);
        jPanel.add(this.cancelButton);
        ((Container)serializable2).add(jPanel2);
        ((Container)serializable2).add(jPanel);
        this.setButton.setActionCommand("set");
        this.cancelButton.setActionCommand("cancel");
        object = new ActionDispatcher(this);
        this.setButton.addActionListener((ActionListener)object);
        this.cancelButton.addActionListener((ActionListener)object);
        this.pack();
        this.setResizable(false);
        this.setSize(210, 170);
    }

    private boolean checkAngle(int n, String string) throws IllegalArgumentException {
        block15: {
            if (string.equals("")) {
                throw new IllegalArgumentException(Resource.getString("GYRO_VAL_NOT_INPUT_WNG"));
            }
            try {
                int n2;
                try {
                    n2 = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new Exception("");
                }
                String string2 = "";
                if (n == 1) {
                    String[] stringArray = this.entry.getAngleValuesX();
                    int n3 = Integer.parseInt(stringArray[0]);
                    int n4 = Integer.parseInt(stringArray[1]);
                    if (n2 < n3 || n2 > n4) {
                        throw new Exception("");
                    }
                } else if (n == 2) {
                    String[] stringArray = this.entry.getAngleValuesY();
                    int n5 = Integer.parseInt(stringArray[0]);
                    int n6 = Integer.parseInt(stringArray[1]);
                    if (n2 < n5 || n2 > n6) {
                        throw new Exception("");
                    }
                } else if (n == 3) {
                    String[] stringArray = this.entry.getAngleValuesZ();
                    int n7 = Integer.parseInt(stringArray[0]);
                    int n8 = Integer.parseInt(stringArray[1]);
                    if (n2 < n7 || n2 > n8) {
                        throw new Exception("");
                    }
                }
            }
            catch (Exception exception) {
                if (n == 1) {
                    throw new IllegalArgumentException(Resource.format("GYRO_VAL_OVER_RANGE_WNG", Resource.getString("GYRO_LBL_DATA_X")));
                }
                if (n == 2) {
                    throw new IllegalArgumentException(Resource.format("GYRO_VAL_OVER_RANGE_WNG", Resource.getString("GYRO_LBL_DATA_Y")));
                }
                if (n != 3) break block15;
                throw new IllegalArgumentException(Resource.format("GYRO_VAL_OVER_RANGE_WNG", Resource.getString("GYRO_LBL_DATA_Z")));
            }
        }
        return true;
    }

    void set() {
        String string = "";
        String string2 = "";
        String string3 = "";
        try {
            if (this.checkAngle(1, this.angleXField.getText())) {
                string = this.angleXField.getText();
            }
            if (this.checkAngle(2, this.angleYField.getText())) {
                string2 = this.angleYField.getText();
            }
            if (this.checkAngle(3, this.angleZField.getText())) {
                string3 = this.angleZField.getText();
            }
            if (this.rowSelect != -1) {
                ArrayList arrayList = this.entry.getData();
                Hashtable hashtable = (Hashtable)arrayList.get(this.rowSelect);
                hashtable.put("VALUE_X", string);
                hashtable.put("VALUE_Y", string2);
                hashtable.put("VALUE_Z", string3);
                arrayList.set(this.rowSelect, hashtable);
                this.entry.setData(arrayList);
            } else {
                int n = this.entry.getCount();
                this.entry.setCount(++n);
                ArrayList arrayList = n == 1 ? new ArrayList() : this.entry.getData();
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                hashtable.put("VALUE_X", string);
                hashtable.put("VALUE_Y", string2);
                hashtable.put("VALUE_Z", string3);
                arrayList.add(hashtable);
                this.entry.setData(arrayList);
            }
            this.entry.save();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.parent.showDialog(illegalArgumentException.getMessage(), this, 2);
            return;
        }
        catch (IOException iOException) {
            System.err.println(Resource.format("WRITE_ERR", "gyrosensor.dat"));
            return;
        }
        this.setVisible(false);
        this.dispose();
    }

    void cancel() {
        this.setVisible(false);
        this.dispose();
    }
}

