/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.HyperMultiPropUtil;
import com.nttdocomo.dojaemu.ktoolbar.JAMManager;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.TabPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

class HyperMultiSettingWindow
extends TabPanel
implements ActionListener {
    private JCheckBox enabledChange;
    private ButtonGroup radioButtonGroup;
    private JRadioButton modeAButton;
    private JRadioButton modeBButton;
    private JRadioButton modeABButton;
    private JRadioButton noneButton;
    private static final int MODE_A = 1;
    private static final int MODE_B = 2;
    private static final int MODE_A_B = 3;
    private boolean initEnable = false;
    private int initMode = 3;
    private boolean isAppRunning = false;
    private HyperMultiPropUtil prop = null;

    HyperMultiSettingWindow(AbstractWindow abstractWindow) {
        super(abstractWindow);
        JPanel jPanel = new JPanel();
        this.enabledChange = new JCheckBox(Resource.getString("HYPER_MULTI_FUNCTION"));
        this.radioButtonGroup = new ButtonGroup();
        this.modeAButton = new JRadioButton(Resource.getString("HYPER_MULTI_MODE_A"));
        this.modeBButton = new JRadioButton(Resource.getString("HYPER_MULTI_MODE_B"));
        this.modeABButton = new JRadioButton(Resource.getString("HYPER_MULTI_MODE_A_B"));
        this.noneButton = new JRadioButton("none");
        this.noneButton.setVisible(false);
        this.radioButtonGroup.add(this.modeAButton);
        this.radioButtonGroup.add(this.modeBButton);
        this.radioButtonGroup.add(this.modeABButton);
        this.radioButtonGroup.add(this.noneButton);
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("HYPER_MULTI_BORDER_TITLE")));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(3, 0, 3, 3);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        jPanel.add((Component)this.enabledChange, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)this.modeAButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.modeBButton, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jPanel.add((Component)this.modeABButton, gridBagConstraints);
        this.prop = new HyperMultiPropUtil();
        this.initEnable = this.prop.getEnabled();
        this.initMode = this.prop.getMode();
        this.setMode(this.initEnable, this.initMode);
        this.setRadioButtonEnabled();
        if (!this.initEnable) {
            this.noneButton.setSelected(true);
        }
        this.isAppRunning = JAMManager.getState() != 4;
        this.setLayout(new BorderLayout());
        this.add("North", jPanel);
        this.enabledChange.addActionListener(this);
        this.modeAButton.addActionListener(this);
        this.modeBButton.addActionListener(this);
        this.modeABButton.addActionListener(this);
    }

    @Override
    void cancel() {
    }

    @Override
    boolean set() {
        if (this.isAppRunning) {
            return true;
        }
        boolean bl = false;
        int n = 3;
        if (this.enabledChange.isSelected()) {
            bl = true;
            n = this.modeAButton.isSelected() ? 1 : (this.modeBButton.isSelected() ? 2 : (this.modeABButton.isSelected() ? 3 : 3));
        } else {
            bl = false;
            n = 3;
        }
        this.prop.setEnabled(bl);
        this.prop.setMode(n);
        if (this.prop.save() != 0) {
            this.parent.showDialog(Resource.getString("HYPERMULTI_SETTING_ERR"), this.tabwin, 2);
            return false;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isAppRunning) {
            this.setMode(this.initEnable, this.initMode);
            this.parent.showDialog(Resource.getString("NOT_HYPERMULTI_WNG"), this.tabwin, 2);
            return;
        }
        if (actionEvent.getSource() == this.enabledChange) {
            this.setRadioButtonEnabled();
            if (this.enabledChange.isSelected() && this.noneButton.isSelected()) {
                this.modeABButton.setSelected(true);
            }
        }
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 2, 0);
        }
    }

    private void setMode(boolean bl, int n) {
        if (bl) {
            this.enabledChange.setSelected(true);
            switch (n) {
                case 1: {
                    this.modeAButton.setSelected(true);
                    break;
                }
                case 2: {
                    this.modeBButton.setSelected(true);
                    break;
                }
                case 3: {
                    this.modeABButton.setSelected(true);
                    break;
                }
                default: {
                    this.modeABButton.setSelected(true);
                    break;
                }
            }
        } else {
            this.enabledChange.setSelected(false);
        }
    }

    private void setRadioButtonEnabled() {
        boolean bl = this.enabledChange.isSelected();
        this.modeAButton.setEnabled(bl);
        this.modeBButton.setEnabled(bl);
        this.modeABButton.setEnabled(bl);
    }
}

