/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.HalfNumberDocument;
import com.nttdocomo.dojaemu.ktoolbar.LocationEntry;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.PhoneBookEntry;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class LocationSelectIdWindow
extends AbstractWindow {
    private MainWindow parent = null;
    private LocationEntry entry = null;
    private int launchType = -1;
    private JTextField entryIdField;
    private JButton confirmButton;
    private JButton cancelButton;
    private static final int ACCURACY_COARSE = Integer.MAX_VALUE;
    private static final int ACCURACY_NORMAL = 299;
    private static final int ACCURACY_FINE = 49;
    private static final File phoneBookDir = new File(System.getProperty("emu.home") + File.separator + "lib" + File.separator + "phonebook");
    private static final File locationDir = new File(System.getProperty("emu.home") + File.separator + "lib" + File.separator + "location" + File.separator + "location_information");
    private String phoneBookPath = null;

    LocationSelectIdWindow(MainWindow mainWindow, int n) {
        super(mainWindow, null);
        this.parent = mainWindow;
        this.addWindowListener();
        this.launchType = n;
        if (n == 14) {
            this.setTitle(Resource.getString("DISP_LOCATION_IMAGE"));
        } else if (n == 15) {
            this.setTitle(Resource.getString("DISP_LOCATION_PHONEBOOK"));
        } else {
            this.setTitle(Resource.getString("DISP_LOCATION_INFO"));
        }
        JLabel jLabel = new JLabel(Resource.getString("LOCATION_IMAGE_ID") + " : ");
        this.confirmButton = new JButton(Resource.getString("CONFIRM"));
        this.cancelButton = new JButton(Resource.getString("CANCEL"));
        this.entryIdField = new JTextField(4);
        this.entryIdField.setDocument(new HalfNumberDocument(3));
        this.entryIdField.setHorizontalAlignment(4);
        Container container = this.getContentPane();
        container.setLayout(new FlowLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel3.setLayout(new GridLayout(1, 1));
        jPanel4.setLayout(new GridLayout(1, 1));
        jPanel6.add(this.entryIdField);
        jPanel3.add(this.getFlowPanel(jLabel, 2));
        jPanel4.add(this.getFlowPanel(this.entryIdField, 0));
        jPanel5.add(this.confirmButton);
        jPanel5.add(this.cancelButton);
        jPanel2.add(jPanel3);
        jPanel2.add(jPanel4);
        jPanel.add("North", jPanel2);
        jPanel.add("South", jPanel5);
        container.add(jPanel);
        this.confirmButton.setActionCommand("confirm");
        this.cancelButton.setActionCommand("cancel");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.confirmButton.addActionListener(actionDispatcher);
        this.cancelButton.addActionListener(actionDispatcher);
        this.setResizable(false);
        this.pack();
    }

    void confirm() {
        LocationEntry locationEntry = new LocationEntry();
        PhoneBookEntry phoneBookEntry = new PhoneBookEntry();
        String string = this.entryIdField.getText();
        if (string == null || string.trim().length() == 0) {
            this.parent.showDialog(Resource.format("WRNG_VAL_WNG", Resource.getString("LOCATION_IMAGE_ID")), this, 2);
            return;
        }
        try {
            Integer.parseInt(string);
        }
        catch (Exception exception) {
            this.parent.showDialog(Resource.format("WRNG_VAL_WNG", Resource.getString("LOCATION_IMAGE_ID")), this, 2);
            return;
        }
        if (this.launchType == 13) {
            String string2 = locationDir.getPath() + File.separator + string + ".loc";
            try {
                if (!locationEntry.load(string2)) {
                    this.parent.showDialog(Resource.getString("SET_LOCATION_ENTRY_ERR"), this, 2);
                    return;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println(Resource.format("NOT_FOUND_ERR", string2));
            }
            catch (IOException iOException) {
                System.err.println(Resource.format("READ_ERR", string2));
            }
        } else if (this.launchType == 14) {
            String string3 = locationDir.getPath() + File.separator + string + ".lmg";
            try {
                if (!locationEntry.load(string3)) {
                    this.parent.showDialog(Resource.getString("SET_LOCATION_IMAGEENTRY_ERR"), this, 2);
                    return;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println(Resource.format("NOT_FOUND_ERR", string3));
            }
            catch (IOException iOException) {
                System.err.println(Resource.format("READ_ERR", string3));
            }
        } else {
            phoneBookEntry = this.getPhonebookEntry(string);
            if (phoneBookEntry == null) {
                this.parent.showDialog(Resource.getString("SET_LOCATION_PHONEENTRY_ERR"), this, 2);
                return;
            }
            TimeZone timeZone = TimeZone.getTimeZone("GMT");
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTimeZone(timeZone);
            if (phoneBookEntry.getTimeStamp().length() == 0) {
                this.parent.showDialog(Resource.getString("SET_LOCATION_PHONEENTRY_ERR"), this, 2);
                return;
            }
            long l = Long.parseLong(phoneBookEntry.getTimeStamp());
            gregorianCalendar.setTime(new Date(l));
            locationEntry.setTimeStampYearPart(Integer.toString(gregorianCalendar.get(1)));
            locationEntry.setTimeStampMonthPart(locationEntry.fillZero(Integer.toString(gregorianCalendar.get(2) + 1), 2));
            locationEntry.setTimeStampDayPart(locationEntry.fillZero(Integer.toString(gregorianCalendar.get(5)), 2));
            locationEntry.setTimeStampHourPart(locationEntry.fillZero(Integer.toString(gregorianCalendar.get(11)), 2));
            locationEntry.setTimeStampMinutePart(locationEntry.fillZero(Integer.toString(gregorianCalendar.get(12)), 2));
            locationEntry.setTimeStampSecondPart(locationEntry.fillZero(Integer.toString(gregorianCalendar.get(13)), 2));
            locationEntry.setTimeStampMilliSecondPart(locationEntry.fillZero(Integer.toString(gregorianCalendar.get(14)), 3));
            String string4 = "";
            int n = 0;
            if (phoneBookEntry.getAccuracy().length() != 0) {
                n = Integer.parseInt(phoneBookEntry.getAccuracy());
            }
            switch (n) {
                case 0x7FFFFFFF: {
                    string4 = "1";
                    break;
                }
                case 299: {
                    string4 = "2";
                    break;
                }
                case 49: {
                    string4 = "3";
                    break;
                }
                default: {
                    string4 = "UNKNOWN";
                }
            }
            locationEntry.setInfoLevel(string4);
            locationEntry.parseDmsString(phoneBookEntry.getLatitude(), 0);
            locationEntry.parseDmsString(phoneBookEntry.getLongitude(), 1);
            locationEntry.setDatum(phoneBookEntry.getAltitude());
            locationEntry.setDatum(phoneBookEntry.getDatum());
        }
        this.parent.lce(locationEntry, this.launchType, Integer.parseInt(string));
        this.dispose();
    }

    void cancel() {
        this.parent.closeWindow(this);
    }

    private PhoneBookEntry getPhonebookEntry(String string) {
        String[] stringArray = phoneBookDir.list(new PhoneBookFilter());
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.phoneBookPath = phoneBookDir.getPath() + File.separator + stringArray[i];
            int n = stringArray[i].indexOf(95);
            try {
                int n2 = Integer.parseInt(stringArray[i].substring(0, n));
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            try {
                PhoneBookEntry phoneBookEntry = new PhoneBookEntry();
                phoneBookEntry.load(this.phoneBookPath);
                if (!phoneBookEntry.getMemoryNo().equals(string)) continue;
                return phoneBookEntry;
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println(Resource.format("NOT_FOUND_ERR", this.phoneBookPath));
                continue;
            }
            catch (IOException iOException) {
                System.err.println(Resource.format("READ_ERR", this.phoneBookPath));
            }
        }
        return null;
    }

    private JPanel getFlowPanel(JComponent jComponent, int n) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(n));
        jPanel.add(jComponent);
        return jPanel;
    }

    class PhoneBookFilter
    implements FilenameFilter {
        PhoneBookFilter() {
        }

        @Override
        public boolean accept(File file, String string) {
            if (file.equals(phoneBookDir)) {
                return string.endsWith(".tel");
            }
            return false;
        }
    }
}

