/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractFrame;
import com.nttdocomo.dojaemu.ktoolbar.DebugTraceWindow;
import com.nttdocomo.dojaemu.ktoolbar.JAMManager;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.Container;
import java.awt.GridLayout;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class MailerWindow
extends AbstractFrame {
    static final int FRAME_WIDTH = 400;
    static final int FRAME_HEIGHT = 400;
    private static final int MAX_PARAM_NUM = 16;
    private static final int MAX_PARAM_LEN = 20480;
    private static final File mailDir = new File(System.getProperty("emu.home") + File.separator + "lib" + File.separator + "mail");
    private static String[] mailFiles;
    private Hashtable parameters = new Hashtable();
    private int paramLen;
    private String allowedMailAddress;
    private JList mailList;
    private JEditorPane editorPane;

    MailerWindow(MainWindow mainWindow) {
        super(mainWindow, Resource.getString("MAILER_WINDOW_TITLE"));
        this.addWindowListener();
        if (!this.getAllMail()) {
            return;
        }
        Container container = this.getContentPane();
        container.setLayout(new GridLayout(2, 1));
        JScrollPane jScrollPane = new JScrollPane(this.mailList);
        JScrollPane jScrollPane2 = new JScrollPane(this.editorPane);
        MailerWindowListSelectionListener mailerWindowListSelectionListener = new MailerWindowListSelectionListener();
        MailerWindowHyperlinkListener mailerWindowHyperlinkListener = new MailerWindowHyperlinkListener(this);
        this.mailList.addListSelectionListener(mailerWindowListSelectionListener);
        this.mailList.setSelectedIndex(0);
        this.mailList.setSelectionMode(0);
        this.editorPane.setEditable(false);
        this.editorPane.addHyperlinkListener(mailerWindowHyperlinkListener);
        container.add(jScrollPane);
        container.add(jScrollPane2);
        this.setSize(400, 400);
        this.setIconImage(MainWindow.titlebarIconImage.getImage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getAllMail() {
        String string = "";
        mailFiles = mailDir.list(new MailFilter());
        String[] stringArray = new String[mailFiles.length];
        this.parameters.clear();
        this.paramLen = 0;
        String string2 = "";
        for (int i = 0; i < mailFiles.length; ++i) {
            String string3 = mailDir.getPath() + File.separator + mailFiles[i];
            stringArray[i] = "";
            BufferedReader bufferedReader = null;
            try {
                String string4;
                bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string3)));
                String string5 = "";
                boolean bl = false;
                while ((string4 = bufferedReader.readLine()) != null) {
                    if (string4.toLowerCase().indexOf("from:") == 0) {
                        string2 = string4.substring(6);
                        continue;
                    }
                    if (string4.toLowerCase().indexOf("to:") == 0) continue;
                    if (string4.toLowerCase().indexOf("subject:") == 0) {
                        stringArray[i] = stringArray[i] + string4.substring(9);
                        continue;
                    }
                    if (string4.toLowerCase().indexOf("date:") == 0) {
                        if (stringArray[i].length() == 0) {
                            stringArray[i] = string4.substring(6) + " ";
                            continue;
                        }
                        stringArray[i] = string4.substring(6) + " " + stringArray[i];
                        continue;
                    }
                    if (i != 0) continue;
                    if (string4.indexOf("--B") == 0) {
                        bl = true;
                        this.allowedMailAddress = string2;
                        continue;
                    }
                    if (!bl) {
                        if (string4.length() == 0) {
                            string = string + string4;
                            continue;
                        }
                        string = string + "<BR>" + string4;
                        continue;
                    }
                    if (string4.toLowerCase().indexOf("text=") == 0) {
                        string5 = string4.substring(6, string4.length() - 1);
                        continue;
                    }
                    if (string4.toLowerCase().indexOf("adf=") == 0) {
                        string = string + "<BR><A HREF=" + string4.substring(4) + ">" + string5 + "</A>";
                        continue;
                    }
                    int n = string4.toLowerCase().indexOf("\"=\"");
                    if (n == -1) {
                        System.err.println(Resource.format("PARAM_ERR", string4));
                        continue;
                    }
                    String string6 = string4.substring(0, n + 1);
                    String string7 = string4.substring(n + 2, string4.length());
                    if (string6.indexOf("\"") != 0 || string6.lastIndexOf("\"") != string6.length() - 1 || string7.indexOf("\"") != 0 || string7.lastIndexOf("\"") != string7.length() - 1) {
                        System.err.println(Resource.format("PARAM_ERR", string4));
                        continue;
                    }
                    if (string6.equals("\"\"")) {
                        System.err.println(Resource.format("PARAM_ERR", string4));
                        continue;
                    }
                    string6 = string6.substring(1, string6.length() - 1);
                    string7 = string7.equals("\"\"") ? "" : string7.substring(1, string7.length() - 1);
                    this.parameters.put(string6, string7);
                    this.paramLen = this.paramLen + string6.getBytes().length + string7.getBytes().length;
                }
                continue;
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println(Resource.format("NOT_FOUND_ERR", string3));
                boolean bl = false;
                return bl;
            }
            catch (IOException iOException) {
                System.err.println(Resource.format("READ_ERR", string3));
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.editorPane = new JEditorPane("text/html", string);
        this.mailList = new JList<String>(stringArray);
        return true;
    }

    class MailerWindowHyperlinkListener
    implements HyperlinkListener {
        private MailerWindow window;

        MailerWindowHyperlinkListener(MailerWindow mailerWindow2) {
            this.window = mailerWindow2;
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                if (JAMManager.getState() != 4) {
                    String string = Resource.getString("EXIT_CONNECT_WNG");
                    MailerWindow.this.parent.showDialog(string, this.window, 2);
                    return;
                }
                String string = "";
                if (hyperlinkEvent.getURL() != null) {
                    string = hyperlinkEvent.getURL().toString();
                    StringBuffer stringBuffer = new StringBuffer("");
                    if (JAMManager.check(0, string, MailerWindow.this.allowedMailAddress, stringBuffer) && MailerWindow.this.parameters.size() <= 16 && MailerWindow.this.paramLen <= 20480) {
                        String string2 = null;
                        string2 = JAMManager.getGpsState() && JAMManager.isGPSAppli(string) ? Resource.getString("LOCATION_SECURITY_WNG") : Resource.getString("LAUNCH_APPLICATION");
                        JOptionPane jOptionPane = new JOptionPane(string2, 3, 0);
                        JDialog jDialog = jOptionPane.createDialog(this.window, Resource.getString("CONFIRM"));
                        jDialog.setResizable(false);
                        jDialog.setVisible(true);
                        Object object = jOptionPane.getValue();
                        if (object instanceof Integer) {
                            if ((Integer)object != 0) {
                                return;
                            }
                        } else {
                            return;
                        }
                        try {
                            MailerWindow.this.parent.setVisibleInvoker(0, false);
                            JAMManager.invokeApplication(MailerWindow.this.parent.getAppType(), JAMManager.getAdfPath(), JAMManager.getJarPath(), 6, JAMManager.getParams(MailerWindow.this.parameters), MailerWindow.this.parent.getDeviceName(), MailerWindow.this.parent.getAdfUrl(), JAMManager.getProjectName(), DebugTraceWindow.getDebugParam());
                            MailerWindow.this.parent.setEnabledDeviceMenu(false);
                        }
                        catch (Exception exception) {
                            MailerWindow.this.parent.setVisibleInvoker(0, true);
                            MailerWindow.this.parent.showDialog(Resource.getString("NOT_LAUNCH_ERR"), this.window, 0);
                            return;
                        }
                    } else {
                        String string3 = Resource.getString("NOT_LAUNCH_APPLICATION_WNG2");
                        MailerWindow.this.parent.showDialog(string3, this.window, 2);
                    }
                }
            }
        }
    }

    class MailFilter
    implements FilenameFilter {
        MailFilter() {
        }

        @Override
        public boolean accept(File file, String string) {
            if (file.equals(mailDir)) {
                int n = string.lastIndexOf(".");
                return string.endsWith(".mail");
            }
            return false;
        }
    }

    class MailerWindowListSelectionListener
    implements ListSelectionListener {
        MailerWindowListSelectionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                int n = MailerWindow.this.mailList.getSelectedIndex();
                if (n == -1) {
                    MailerWindow.this.editorPane.setText("");
                    return;
                }
                String string = "";
                String string2 = mailDir.getPath() + File.separator + mailFiles[n];
                BufferedReader bufferedReader = null;
                try {
                    String string3;
                    bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string2)));
                    String string4 = "";
                    boolean bl = false;
                    MailerWindow.this.paramLen = 0;
                    MailerWindow.this.parameters.clear();
                    while ((string3 = bufferedReader.readLine()) != null) {
                        if (string3.toLowerCase().indexOf("from:") == 0) {
                            MailerWindow.this.allowedMailAddress = string3.substring(6);
                            continue;
                        }
                        if (string3.toLowerCase().indexOf("to:") == 0 || string3.toLowerCase().indexOf("subject:") == 0 || string3.toLowerCase().indexOf("date:") == 0) continue;
                        if (string3.indexOf("--B") == 0) {
                            bl = true;
                            continue;
                        }
                        if (!bl) {
                            if (string3.length() == 0) {
                                string = string + string3;
                                continue;
                            }
                            string = string + "<BR>" + string3;
                            continue;
                        }
                        if (string3.toLowerCase().indexOf("text=") == 0) {
                            string4 = string3.substring(6, string3.length() - 1);
                            continue;
                        }
                        if (string3.toLowerCase().indexOf("adf=") == 0) {
                            string = string + "<BR><A HREF=" + string3.substring(4) + ">" + string4 + "</A>";
                            continue;
                        }
                        int n2 = string3.toLowerCase().indexOf("\"=\"");
                        if (n2 == -1) {
                            System.err.println(Resource.format("PARAM_ERR", string3));
                            continue;
                        }
                        String string5 = string3.substring(0, n2 + 1);
                        String string6 = string3.substring(n2 + 2, string3.length());
                        if (string5.indexOf("\"") != 0 || string5.lastIndexOf("\"") != string5.length() - 1 || string6.indexOf("\"") != 0 || string6.lastIndexOf("\"") != string6.length() - 1) {
                            System.err.println(Resource.format("PARAM_ERR", string3));
                            continue;
                        }
                        if (string5.equals("\"\"")) {
                            System.err.println(Resource.format("PARAM_ERR", string3));
                            continue;
                        }
                        string5 = string5.substring(1, string5.length() - 1);
                        string6 = string6.equals("\"\"") ? "" : string6.substring(1, string6.length() - 1);
                        MailerWindow.this.parameters.put(string5, string6);
                        MailerWindow.this.paramLen = MailerWindow.this.paramLen + string5.getBytes().length + string6.getBytes().length;
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.err.println(Resource.format("NOT_FOUND_ERR", string2));
                    return;
                }
                catch (IOException iOException) {
                    System.err.println(Resource.format("READ_ERR", string2));
                    return;
                }
                finally {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        return;
                    }
                }
                MailerWindow.this.editorPane.setText(string);
            }
        }
    }
}

