/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow2;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher2;
import com.nttdocomo.dojaemu.ktoolbar.Const;
import com.nttdocomo.dojaemu.ktoolbar.DecimalDocument;
import com.nttdocomo.dojaemu.ktoolbar.ImageFileChooser;
import com.nttdocomo.dojaemu.ktoolbar.ImageFileChooserUtil;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.MusicContentsBean;
import com.nttdocomo.dojaemu.ktoolbar.MusicContentsManager;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.StringDocument;
import com.nttdocomo.dojaemu.ktoolbar.swing.BasicAbstractWindowWindowListener;
import com.nttdocomo.dojaemu.ktoolbar.swing.EditWindowInterface;
import com.nttdocomo.dojaemu.ktoolbar.swing.JButtonUtil;
import com.nttdocomo.dojaemu.ktoolbar.swing.JTextFieldUtil;
import com.nttdocomo.dojaemu.ktoolbar.swing.document.WindowsFilenameDocument;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MusicContentsEditWindow
extends AbstractWindow2
implements EditWindowInterface {
    private static final GridLayout GRID_LAYOUT = new GridLayout(9, 1);
    private static final int SIZE_TEXTFIELD_LONG = 15;
    private static final int SIZE_TEXTFIELD_SHORT = 3;
    private static final int MAXBYTES_MIN = 3;
    private static final int MAXBYTES_SEC = 2;
    private static final int MAXBYTES_MSEC = 3;
    private JTextField txtFileName;
    private JTextField txtTitle;
    private JTextField txtArtist;
    private JTextField txtAlbum;
    private JTextField txtGenre;
    private JTextField txtJacketImage;
    private JTextField txtStandbyImage1;
    private JTextField txtStandbyImage2;
    private JTextField txtMinute;
    private JTextField txtSecond;
    private JTextField txtMilliSecond;
    private JButton buttonJacketImage;
    private JCheckBox chkJacketImage;
    private JButton buttonStandbyImage1;
    private JCheckBox chkStandbyImage1;
    private JButton btnStandbyImage2;
    private JCheckBox chkStandbyImage2;
    private JButton buttonSet;
    private JButton buttonCancel;
    private MusicContentsBean musicContentsBean = null;

    public MusicContentsEditWindow(MainWindow mainWindow) {
        this(mainWindow, new MusicContentsBean(""));
    }

    public MusicContentsEditWindow(MainWindow mainWindow, MusicContentsBean musicContentsBean) {
        super(mainWindow, Resource.getString("MusicPlayer.common.caption.musicContentsEditWindow"));
        this.parent = mainWindow;
        this.setResizable(false);
        this.addWindowListener(new BasicAbstractWindowWindowListener(mainWindow, this){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MusicContentsEditWindow.this.cancel();
            }
        });
        this.musicContentsBean = musicContentsBean;
        ActionDispatcher2 actionDispatcher2 = new ActionDispatcher2(this);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        JPanel jPanel4 = new JPanel(new FlowLayout(0));
        JPanel jPanel5 = new JPanel(new FlowLayout(0));
        JPanel jPanel6 = new JPanel(new FlowLayout(0));
        JPanel jPanel7 = new JPanel(new FlowLayout(0));
        JPanel jPanel8 = new JPanel(new FlowLayout(0));
        JPanel jPanel9 = new JPanel(new FlowLayout(0));
        JPanel jPanel10 = new JPanel(new FlowLayout(0));
        JPanel jPanel11 = new JPanel(new FlowLayout(0));
        JPanel jPanel12 = new JPanel(new FlowLayout(0));
        JPanel jPanel13 = new JPanel(new FlowLayout(0));
        JPanel jPanel14 = new JPanel(new FlowLayout(0));
        JPanel jPanel15 = new JPanel(new FlowLayout(0));
        JPanel jPanel16 = new JPanel(new FlowLayout(0));
        JPanel jPanel17 = new JPanel(new FlowLayout(0));
        JPanel jPanel18 = new JPanel(new FlowLayout(0));
        JPanel jPanel19 = new JPanel(new FlowLayout(0));
        JPanel jPanel20 = new JPanel(GRID_LAYOUT);
        JPanel jPanel21 = new JPanel(GRID_LAYOUT);
        JLabel jLabel = new JLabel(Resource.getString("MusicPlayer.common.caption.filename"));
        JLabel jLabel2 = new JLabel(Resource.getString("MusicPlayer.common.caption.title"));
        JLabel jLabel3 = new JLabel(Resource.getString("MusicPlayer.common.caption.artist"));
        JLabel jLabel4 = new JLabel(Resource.getString("MusicPlayer.common.caption.album"));
        JLabel jLabel5 = new JLabel(Resource.getString("MusicPlayer.common.caption.genre"));
        JLabel jLabel6 = new JLabel(Resource.getString("MusicPlayer.common.caption.jacketImage"));
        JLabel jLabel7 = new JLabel(Resource.getString("MusicPlayer.common.caption.standbyImage1"));
        JLabel jLabel8 = new JLabel(Resource.getString("MusicPlayer.common.caption.standbyImage2"));
        JLabel jLabel9 = new JLabel(Resource.getString("MusicPlayer.common.caption.saving"));
        JLabel jLabel10 = new JLabel(Resource.getString("MusicPlayer.common.caption.saving"));
        JLabel jLabel11 = new JLabel(Resource.getString("MusicPlayer.common.caption.saving"));
        JLabel jLabel12 = new JLabel(Resource.getString("MusicPlayer.common.caption.playtime"));
        JLabel jLabel13 = new JLabel(Resource.getString("MusicPlayer.common.caption.min"));
        JLabel jLabel14 = new JLabel(Resource.getString("MusicPlayer.common.caption.sec"));
        JLabel jLabel15 = new JLabel(Resource.getString("MusicPlayer.common.caption.msec"));
        this.txtFileName = JTextFieldUtil.createBasicTextField(15, new WindowsFilenameDocument(215 - ".properties".length(), false));
        this.txtTitle = JTextFieldUtil.createBasicTextField(15, new StringDocument(254));
        this.txtArtist = JTextFieldUtil.createBasicTextField(15, new StringDocument(254));
        this.txtAlbum = JTextFieldUtil.createBasicTextField(15, new StringDocument(254));
        this.txtGenre = JTextFieldUtil.createBasicTextField(15, new StringDocument(254));
        this.txtJacketImage = JTextFieldUtil.createBasicTextField(15, new WindowsFilenameDocument(215, true));
        this.txtStandbyImage1 = JTextFieldUtil.createBasicTextField(15, new WindowsFilenameDocument(215, true));
        this.txtStandbyImage2 = JTextFieldUtil.createBasicTextField(15, new WindowsFilenameDocument(215, true));
        this.txtMinute = JTextFieldUtil.createBasicTextField(3, new DecimalDocument(3));
        this.txtSecond = JTextFieldUtil.createBasicTextField(3, new DecimalDocument(2));
        this.txtMilliSecond = JTextFieldUtil.createBasicTextField(3, new DecimalDocument(3));
        this.buttonJacketImage = JButtonUtil.createBasicButton(Resource.getString("MusicPlayer.common.caption.fileSetting"), "imageDialogJacket", actionDispatcher2);
        this.buttonStandbyImage1 = JButtonUtil.createBasicButton(Resource.getString("MusicPlayer.common.caption.fileSetting"), "imageDialogStandby1", actionDispatcher2);
        this.btnStandbyImage2 = JButtonUtil.createBasicButton(Resource.getString("MusicPlayer.common.caption.fileSetting"), "imageDialogStandby2", actionDispatcher2);
        this.chkJacketImage = new JCheckBox();
        this.chkStandbyImage1 = new JCheckBox();
        this.chkStandbyImage2 = new JCheckBox();
        jPanel2.add(jLabel);
        jPanel3.add(jLabel2);
        jPanel4.add(jLabel3);
        jPanel5.add(jLabel4);
        jPanel6.add(jLabel5);
        jPanel7.add(jLabel6);
        jPanel8.add(jLabel7);
        jPanel9.add(jLabel8);
        jPanel10.add(jLabel12);
        jPanel11.add(this.txtFileName);
        jPanel12.add(this.txtTitle);
        jPanel13.add(this.txtArtist);
        jPanel14.add(this.txtAlbum);
        jPanel15.add(this.txtGenre);
        jPanel16.add(this.txtJacketImage);
        jPanel16.add(this.buttonJacketImage);
        jPanel16.add(this.chkJacketImage);
        jPanel16.add(jLabel9);
        jPanel17.add(this.txtStandbyImage1);
        jPanel17.add(this.buttonStandbyImage1);
        jPanel17.add(this.chkStandbyImage1);
        jPanel17.add(jLabel10);
        jPanel18.add(this.txtStandbyImage2);
        jPanel18.add(this.btnStandbyImage2);
        jPanel18.add(this.chkStandbyImage2);
        jPanel18.add(jLabel11);
        jPanel19.add(this.txtMinute);
        jPanel19.add(jLabel13);
        jPanel19.add(this.txtSecond);
        jPanel19.add(jLabel14);
        jPanel19.add(this.txtMilliSecond);
        jPanel19.add(jLabel15);
        jPanel20.add(jPanel2);
        jPanel20.add(jPanel3);
        jPanel20.add(jPanel4);
        jPanel20.add(jPanel5);
        jPanel20.add(jPanel6);
        jPanel20.add(jPanel7);
        jPanel20.add(jPanel8);
        jPanel20.add(jPanel9);
        jPanel20.add(jPanel10);
        jPanel21.add(jPanel11);
        jPanel21.add(jPanel12);
        jPanel21.add(jPanel13);
        jPanel21.add(jPanel14);
        jPanel21.add(jPanel15);
        jPanel21.add(jPanel16);
        jPanel21.add(jPanel17);
        jPanel21.add(jPanel18);
        jPanel21.add(jPanel19);
        jPanel.add(jPanel20);
        jPanel.add(jPanel21);
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        JPanel jPanel22 = new JPanel();
        this.buttonSet = JButtonUtil.createBasicButton(Resource.getString("SET"), "set", actionDispatcher2);
        this.buttonCancel = JButtonUtil.createBasicButton(Resource.getString("CANCEL"), "cancel", actionDispatcher2);
        jPanel22.add(this.buttonSet);
        jPanel22.add(this.buttonCancel);
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        container.add(jPanel);
        container.add(jPanel22);
        this.pack();
        try {
            this.txtFileName.setText(MusicContentsManager.getMusicFileNameWithoutExt(this.musicContentsBean.getFileName()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.txtTitle.setText(this.musicContentsBean.getTitle());
        this.txtArtist.setText(this.musicContentsBean.getArtist());
        this.txtAlbum.setText(this.musicContentsBean.getAlbum());
        this.txtGenre.setText(this.musicContentsBean.getGenre());
        this.txtJacketImage.setText(this.musicContentsBean.getJacketImageFileName());
        this.chkJacketImage.setSelected(this.musicContentsBean.isJacketImageSaving());
        this.txtStandbyImage1.setText(this.musicContentsBean.getStandbyImage1FileName());
        this.chkStandbyImage1.setSelected(this.musicContentsBean.isStandbyImage1Saving());
        this.txtStandbyImage2.setText(this.musicContentsBean.getStandbyImage2FileName());
        this.chkStandbyImage2.setSelected(this.musicContentsBean.isStandbyImage2Saving());
        this.txtMinute.setText(Integer.toString(this.musicContentsBean.getPlayTimeMin()));
        this.txtSecond.setText(Integer.toString(this.musicContentsBean.getPlayTimeSec()));
        this.txtMilliSecond.setText(Integer.toString(this.musicContentsBean.getPlayTimeMsec()));
    }

    private void imageDialogCheck(JTextField jTextField, String string, String string2) {
        if (string != null && !string.equals("")) {
            try {
                ImageFileChooserUtil.check(string, Const.PATH_LIB_AVPLAYER_IMAGE);
                String string3 = new File(string).getCanonicalPath();
                jTextField.setText(string3.replace(Const.PATH_LIB_AVPLAYER_IMAGE, ""));
            }
            catch (Exception exception) {
                Object[] objectArray = new String[]{string2, Const.PATH_LIB_AVPLAYER_IMAGE};
                this.parent.showDialog(Resource.format("MusicPlayer.common.message.select.error.imagePath", objectArray), this, 2);
            }
        }
    }

    void imageDialogJacket() {
        String string = this.imageDialog();
        this.imageDialogCheck(this.txtJacketImage, string, Resource.getString("MusicPlayer.common.caption.jacketImage"));
    }

    void imageDialogStandby1() {
        String string = this.imageDialog();
        this.imageDialogCheck(this.txtStandbyImage1, string, Resource.getString("MusicPlayer.common.caption.standbyImage1"));
    }

    void imageDialogStandby2() {
        String string = this.imageDialog();
        this.imageDialogCheck(this.txtStandbyImage2, string, Resource.getString("MusicPlayer.common.caption.standbyImage2"));
    }

    private String imageDialog() {
        String string = null;
        try {
            ImageFileChooser imageFileChooser = new ImageFileChooser();
            string = imageFileChooser.showImageDialog(Const.PATH_LIB_AVPLAYER_IMAGE);
            if (string == null) {
                string = "";
            }
        }
        catch (Exception exception) {
            string = "";
        }
        return string;
    }

    @Override
    public void checkInput() throws Exception {
        if ("".equals(this.txtFileName.getText())) {
            throw new Exception(Resource.format("EMP_VAL_WNG", Resource.getString("MusicPlayer.common.caption.filename")));
        }
        if ("".equals(this.txtMinute.getText())) {
            throw new Exception(Resource.format("EMP_VAL_WNG", Resource.getString("MusicPlayer.common.caption.playtime")));
        }
        if ("".equals(this.txtSecond.getText())) {
            throw new Exception(Resource.format("EMP_VAL_WNG", Resource.getString("MusicPlayer.common.caption.playtime")));
        }
        if ("".equals(this.txtMilliSecond.getText())) {
            throw new Exception(Resource.format("EMP_VAL_WNG", Resource.getString("MusicPlayer.common.caption.playtime")));
        }
    }

    @Override
    public void checkFormat() throws Exception {
        if (this.txtFileName.getText().getBytes().length > 215 - ".properties".length()) {
            throw new Exception(Resource.format("WRNG_VAL_WNG", Resource.getString("MusicPlayer.common.caption.filename")));
        }
        if (!WindowsFilenameDocument.isFileNameFormat(this.txtFileName.getText(), false)) {
            throw new Exception(Resource.format("WRNG_VAL_WNG", Resource.getString("MusicPlayer.common.caption.filename")));
        }
        if (this.txtTitle.getText().getBytes().length > 254) {
            throw new Exception(Resource.format("WRNG_VAL_WNG", Resource.getString("MusicPlayer.common.caption.title")));
        }
        if (this.txtArtist.getText().getBytes().length > 254) {
            throw new Exception(Resource.format("WRNG_VAL_WNG", Resource.getString("MusicPlayer.common.caption.artist")));
        }
        if (this.txtAlbum.getText().getBytes().length > 254) {
            throw new Exception(Resource.format("WRNG_VAL_WNG", Resource.getString("MusicPlayer.common.caption.album")));
        }
        if (this.txtGenre.getText().getBytes().length > 254) {
            throw new Exception(Resource.format("WRNG_VAL_WNG", Resource.getString("MusicPlayer.common.caption.genre")));
        }
        MusicContentsBean musicContentsBean = new MusicContentsBean("");
        try {
            if (this.txtMinute.getText().getBytes().length > 3 || Integer.parseInt(this.txtMinute.getText()) < 0) {
                throw new Exception();
            }
            if (this.txtSecond.getText().getBytes().length > 2 || Integer.parseInt(this.txtSecond.getText()) < 0) {
                throw new Exception();
            }
            if (this.txtMilliSecond.getText().getBytes().length > 3 || Integer.parseInt(this.txtMilliSecond.getText()) < 0) {
                throw new Exception();
            }
            musicContentsBean.setPlayTimeMin(Integer.parseInt(this.txtMinute.getText()));
            musicContentsBean.setPlayTimeSec(Integer.parseInt(this.txtSecond.getText()));
            musicContentsBean.setPlayTimeMsec(Integer.parseInt(this.txtMilliSecond.getText()));
            if (musicContentsBean.getPlayTime() <= 0) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            throw new Exception(Resource.format("WRNG_VAL_WNG", Resource.getString("MusicPlayer.common.caption.playtime")));
        }
    }

    private void checkFormatImage() throws Exception {
        if (!this.checkImageFilePath(this.txtJacketImage.getText())) {
            Object[] objectArray = new String[]{Resource.getString("MusicPlayer.common.caption.jacketImage"), Const.PATH_LIB_AVPLAYER_IMAGE};
            throw new Exception(Resource.format("MusicPlayer.common.message.select.error.imagePath", objectArray));
        }
        if (!this.checkImageFilePath(this.txtStandbyImage1.getText())) {
            Object[] objectArray = new String[]{Resource.getString("MusicPlayer.common.caption.standbyImage1"), Const.PATH_LIB_AVPLAYER_IMAGE};
            throw new Exception(Resource.format("MusicPlayer.common.message.select.error.imagePath", objectArray));
        }
        if (!this.checkImageFilePath(this.txtStandbyImage2.getText())) {
            Object[] objectArray = new String[]{Resource.getString("MusicPlayer.common.caption.standbyImage2"), Const.PATH_LIB_AVPLAYER_IMAGE};
            throw new Exception(Resource.format("MusicPlayer.common.message.select.error.imagePath", objectArray));
        }
    }

    private boolean checkImageFilePath(String string) {
        try {
            if (!"".equals(string)) {
                ImageFileChooserUtil.check(Const.PATH_LIB_AVPLAYER_IMAGE + string, Const.PATH_LIB_AVPLAYER_IMAGE);
            }
            return WindowsFilenameDocument.isFileNameFormat(string, true);
        }
        catch (Exception exception) {
            return false;
        }
    }

    void set() {
        try {
            this.checkInput();
            this.checkFormat();
            this.checkFormatImage();
            MusicContentsBean musicContentsBean = new MusicContentsBean(this.musicContentsBean.getFileName());
            musicContentsBean.setTitle(this.musicContentsBean.getTitle());
            musicContentsBean.setArtist(this.musicContentsBean.getArtist());
            musicContentsBean.setAlbum(this.musicContentsBean.getAlbum());
            musicContentsBean.setGenre(this.musicContentsBean.getGenre());
            musicContentsBean.setJacketImageFileName(this.musicContentsBean.getJacketImageFileName());
            musicContentsBean.setJacketImageSaving(this.musicContentsBean.isJacketImageSaving());
            musicContentsBean.setStandbyImage1FileName(this.musicContentsBean.getStandbyImage1FileName());
            musicContentsBean.setStandbyImage1Saving(this.musicContentsBean.isStandbyImage1Saving());
            musicContentsBean.setStandbyImage2FileName(this.musicContentsBean.getStandbyImage2FileName());
            musicContentsBean.setStandbyImage2Saving(this.musicContentsBean.isStandbyImage2Saving());
            musicContentsBean.setPlayTime(this.musicContentsBean.getPlayTime());
            this.musicContentsBean.setFileName(MusicContentsManager.getMusicFileNameWithExt(this.txtFileName.getText()));
            this.musicContentsBean.setTitle(this.txtTitle.getText());
            this.musicContentsBean.setArtist(this.txtArtist.getText());
            this.musicContentsBean.setAlbum(this.txtAlbum.getText());
            this.musicContentsBean.setGenre(this.txtGenre.getText());
            this.musicContentsBean.setJacketImageFileName(this.txtJacketImage.getText());
            this.musicContentsBean.setJacketImageSaving(this.chkJacketImage.isSelected());
            this.musicContentsBean.setStandbyImage1FileName(this.txtStandbyImage1.getText());
            this.musicContentsBean.setStandbyImage1Saving(this.chkStandbyImage1.isSelected());
            this.musicContentsBean.setStandbyImage2FileName(this.txtStandbyImage2.getText());
            this.musicContentsBean.setStandbyImage2Saving(this.chkStandbyImage2.isSelected());
            try {
                this.musicContentsBean.setPlayTimeMin(Integer.parseInt(this.txtMinute.getText()));
                this.musicContentsBean.setPlayTimeSec(Integer.parseInt(this.txtSecond.getText()));
                this.musicContentsBean.setPlayTimeMsec(Integer.parseInt(this.txtMilliSecond.getText()));
            }
            catch (Exception exception) {
                this.musicContentsBean.setPlayTime(60000);
            }
            try {
                if (this.musicContentsBean.isFilenameChanged()) {
                    MusicContentsManager.rename(this.musicContentsBean);
                }
                MusicContentsManager.write(this.musicContentsBean);
                this.musicContentsBean = new MusicContentsBean(this.musicContentsBean.getFileName());
                this.musicContentsBean = MusicContentsManager.read(this.musicContentsBean);
            }
            catch (Exception exception) {
                System.err.println(Resource.format("WRITE_ERR", this.musicContentsBean.getFileName()));
                this.musicContentsBean.setFileName(musicContentsBean.getFileName());
                this.musicContentsBean.setTitle(musicContentsBean.getTitle());
                this.musicContentsBean.setArtist(musicContentsBean.getArtist());
                this.musicContentsBean.setAlbum(musicContentsBean.getAlbum());
                this.musicContentsBean.setGenre(musicContentsBean.getGenre());
                this.musicContentsBean.setJacketImageFileName(musicContentsBean.getJacketImageFileName());
                this.musicContentsBean.setJacketImageSaving(musicContentsBean.isJacketImageSaving());
                this.musicContentsBean.setStandbyImage1FileName(musicContentsBean.getStandbyImage1FileName());
                this.musicContentsBean.setStandbyImage1Saving(musicContentsBean.isStandbyImage1Saving());
                this.musicContentsBean.setStandbyImage2FileName(musicContentsBean.getStandbyImage2FileName());
                this.musicContentsBean.setStandbyImage2Saving(musicContentsBean.isStandbyImage2Saving());
                this.musicContentsBean.setPlayTime(musicContentsBean.getPlayTime());
            }
            this.setVisible(false);
            this.dispose();
        }
        catch (Exception exception) {
            this.parent.showDialog(exception.getMessage(), this, 2);
        }
    }

    void cancel() {
        this.musicContentsBean = null;
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public boolean isCanceled() {
        return this.musicContentsBean == null;
    }

    public MusicContentsBean getMusicContentsBean() {
        return this.musicContentsBean;
    }
}

