/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.Const;
import com.nttdocomo.dojaemu.ktoolbar.MusicContentsBean;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

public class MusicContentsManager {
    public static final int DEFAULT_PLAY_TIME = 60000;
    public static final String MUSIC_CONTENTS_FILE_EXT = ".properties";
    private static final String KEY_TITLE = "title";
    private static final String KEY_ARTIST = "artist";
    private static final String KEY_ALBUM = "album";
    private static final String KEY_GENRE = "genre";
    private static final String KEY_JACKET_IMAGE_FILE_NAME = "jacketImageFileName";
    private static final String KEY_JACKET_IMAGE_SAVING = "isSavedJacketImage";
    private static final String KEY_STANDBY_IMAGE1_FILE_NAME = "standbyImage1FileName";
    private static final String KEY_STANDBY_IMAGE1_SAVING = "isSavedStandbyImage1";
    private static final String KEY_STANDBY_IMAGE2_FILE_NAME = "standbyImage2FileName";
    private static final String KEY_STANDBY_IMAGE2_SAVING = "isSavedStandbyImage2";
    private static final String KEY_PLAY_TIME = "playTime";

    private MusicContentsManager() {
    }

    public static MusicContentsBean read(MusicContentsBean musicContentsBean) {
        File file = new File(Const.PATH_LIB_AVPLAYER_CONTENTS + musicContentsBean.getFileName());
        if (file.isFile()) {
            try {
                Properties properties = new Properties();
                FileInputStream fileInputStream = new FileInputStream(file);
                MusicContentsManager.load(fileInputStream, properties);
                ((InputStream)fileInputStream).close();
                MusicContentsManager.setProp(musicContentsBean, properties);
            }
            catch (Exception exception) {
                return null;
            }
        } else {
            return null;
        }
        return musicContentsBean;
    }

    public static List<MusicContentsBean> allContentsRead() {
        ArrayList<MusicContentsBean> arrayList = new ArrayList<MusicContentsBean>();
        File file = null;
        File[] fileArray = null;
        try {
            file = new File(Const.PATH_LIB_AVPLAYER_CONTENTS);
            fileArray = file.listFiles();
            if (fileArray == null) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            return arrayList;
        }
        for (File file2 : fileArray) {
            if (!file2.isFile() || !file2.getName().endsWith(MUSIC_CONTENTS_FILE_EXT)) continue;
            try {
                Properties properties = new Properties();
                FileInputStream fileInputStream = new FileInputStream(file2);
                MusicContentsManager.load(fileInputStream, properties);
                ((InputStream)fileInputStream).close();
                MusicContentsBean musicContentsBean = new MusicContentsBean(file2.getName());
                MusicContentsManager.setProp(musicContentsBean, properties);
                arrayList.add(musicContentsBean);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return arrayList;
    }

    protected static void setProp(MusicContentsBean musicContentsBean, Properties properties) throws Exception {
        int n;
        try {
            n = Integer.parseInt(properties.getProperty(KEY_PLAY_TIME));
            if (n <= 0) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            n = 60000;
        }
        musicContentsBean.setTitle(properties.getProperty(KEY_TITLE, ""));
        musicContentsBean.setArtist(properties.getProperty(KEY_ARTIST, ""));
        musicContentsBean.setAlbum(properties.getProperty(KEY_ALBUM, ""));
        musicContentsBean.setGenre(properties.getProperty(KEY_GENRE, ""));
        musicContentsBean.setJacketImageFileName(properties.getProperty(KEY_JACKET_IMAGE_FILE_NAME, ""));
        musicContentsBean.setJacketImageSaving(Boolean.valueOf(properties.getProperty(KEY_JACKET_IMAGE_SAVING, "")));
        musicContentsBean.setStandbyImage1FileName(properties.getProperty(KEY_STANDBY_IMAGE1_FILE_NAME, ""));
        musicContentsBean.setStandbyImage1Saving(Boolean.valueOf(properties.getProperty(KEY_STANDBY_IMAGE1_SAVING, "")));
        musicContentsBean.setStandbyImage2FileName(properties.getProperty(KEY_STANDBY_IMAGE2_FILE_NAME, ""));
        musicContentsBean.setStandbyImage2Saving(Boolean.valueOf(properties.getProperty(KEY_STANDBY_IMAGE2_SAVING, "")));
        musicContentsBean.setPlayTime(n);
    }

    public static void delete(MusicContentsBean musicContentsBean) throws Exception {
        File file = null;
        file = new File(Const.PATH_LIB_AVPLAYER_CONTENTS + musicContentsBean.getFileName());
        if (!file.delete()) {
            throw new Exception();
        }
    }

    public static void rename(MusicContentsBean musicContentsBean) throws Exception {
        File file = null;
        file = new File(Const.PATH_LIB_AVPLAYER_CONTENTS + musicContentsBean.getOriginalFileName());
        if (!file.renameTo(new File(Const.PATH_LIB_AVPLAYER_CONTENTS + musicContentsBean.getFileName()))) {
            throw new Exception();
        }
    }

    public static void write(MusicContentsBean musicContentsBean) throws Exception {
        File file = null;
        Properties properties = new Properties();
        OutputStream outputStream = null;
        try {
            file = new File(Const.PATH_LIB_AVPLAYER_CONTENTS + musicContentsBean.getFileName());
            if (!file.exists()) {
                file.createNewFile();
                properties = MusicContentsManager.getDefaultProperties();
            } else {
                properties = new Properties();
                FileInputStream fileInputStream = new FileInputStream(file);
                MusicContentsManager.load(fileInputStream, properties);
                ((InputStream)fileInputStream).close();
            }
            properties.setProperty(KEY_TITLE, musicContentsBean.getTitle());
            properties.setProperty(KEY_ARTIST, musicContentsBean.getArtist());
            properties.setProperty(KEY_ALBUM, musicContentsBean.getAlbum());
            properties.setProperty(KEY_GENRE, musicContentsBean.getGenre());
            properties.setProperty(KEY_JACKET_IMAGE_FILE_NAME, musicContentsBean.getJacketImageFileName());
            properties.setProperty(KEY_JACKET_IMAGE_SAVING, Boolean.toString(musicContentsBean.isJacketImageSaving()));
            properties.setProperty(KEY_STANDBY_IMAGE1_FILE_NAME, musicContentsBean.getStandbyImage1FileName());
            properties.setProperty(KEY_STANDBY_IMAGE1_SAVING, Boolean.toString(musicContentsBean.isStandbyImage1Saving()));
            properties.setProperty(KEY_STANDBY_IMAGE2_FILE_NAME, musicContentsBean.getStandbyImage2FileName());
            properties.setProperty(KEY_STANDBY_IMAGE2_SAVING, Boolean.toString(musicContentsBean.isStandbyImage2Saving()));
            properties.setProperty(KEY_PLAY_TIME, Integer.toString(musicContentsBean.getPlayTime()));
            outputStream = new FileOutputStream(file);
            MusicContentsManager.save(outputStream, properties);
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            try {
                outputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public static Properties getDefaultProperties() {
        Properties properties = new Properties();
        properties.setProperty("fileFormat", "0");
        properties.setProperty("year", "2010");
        properties.setProperty("comment", "comment1");
        properties.setProperty("trackNumber", "1");
        properties.setProperty("totalTrackNumber", "10");
        properties.setProperty("composer", "composer1");
        properties.setProperty("lyricist", "lyricist1");
        properties.setProperty("rightsHolder", "rightsholder1");
        properties.setProperty("sellingAgency", "sellingagency1");
        properties.setProperty("rightsInfo", "rightsinfo1");
        properties.setProperty("label", "label1");
        properties.setProperty("url", "urlname1");
        properties.setProperty("alturl", "alturlname1");
        properties.setProperty("ringToneTypeFull", "true");
        properties.setProperty("ringToneTypeRecommended", "true");
        properties.setProperty("ringToneTypeFree", "true");
        properties.setProperty("restrictCount", "false");
        properties.setProperty("restrictTerm", "false");
        properties.setProperty("restrictTermStart", "2010/01/01 00:00:00");
        properties.setProperty("restrictTermEnd", "2020/01/01 00:00:00");
        properties.setProperty("restrictLimit", "false");
        properties.setProperty("restrictLimitEnd", "2030/01/01 00:00:00");
        properties.setProperty("uimRestrict", "0");
        properties.setProperty("gracePeriod", "2040/01/01 00:00:00");
        properties.setProperty("isFileRestricted", "false");
        properties.setProperty("codecName", "codecname1");
        properties.setProperty("bitrate", "10001");
        properties.setProperty("fileSize", "1024");
        properties.setProperty("originated", "OriginName1");
        properties.setProperty("storedDate", "2010/01/01 00:00:00");
        properties.setProperty("importPermission", "0");
        properties.setProperty("exportPermission", "0");
        properties.setProperty("seekable", "true");
        return properties;
    }

    public static String getMusicFileNameWithoutExt(String string) throws Exception {
        return string.substring(0, string.length() - MUSIC_CONTENTS_FILE_EXT.length());
    }

    public static String getMusicFileNameWithExt(String string) throws Exception {
        if (string == null) {
            throw new Exception();
        }
        return string + MUSIC_CONTENTS_FILE_EXT;
    }

    private static void save(OutputStream outputStream, Properties properties) throws Exception {
        PrintStream printStream = null;
        try {
            printStream = new PrintStream(outputStream);
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                printStream.println(string + " = " + string2);
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            printStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(InputStream inputStream, Properties properties) throws Exception {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                int n = string.indexOf("=");
                if (n <= 0) continue;
                String string2 = string.substring(0, n).trim();
                String string3 = string.substring(n + 1).trim();
                properties.put(string2, string3);
            }
        }
        finally {
            bufferedReader.close();
            inputStreamReader.close();
        }
    }
}

