/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher2;
import com.nttdocomo.dojaemu.ktoolbar.MusicContentsBean;
import com.nttdocomo.dojaemu.ktoolbar.MusicContentsEditWindow;
import com.nttdocomo.dojaemu.ktoolbar.MusicContentsManager;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.TabPanel;
import com.nttdocomo.dojaemu.ktoolbar.swing.JButtonUtil;
import com.nttdocomo.dojaemu.ktoolbar.swing.JTableUtil;
import com.nttdocomo.dojaemu.ktoolbar.swing.WidthBean;
import java.awt.BorderLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

public class MusicContentsWindow
extends TabPanel {
    private JTableUtil jtu;
    private JTable tableMusicContents;
    private JScrollPane scrollPane;
    private JButton buttonAdd;
    private JButton buttonEdit;
    private JButton buttonDelete;
    private static final int COLUMN_WIDTH = 100;
    private List<MusicContentsBean> musicContentsBeanList = null;

    MusicContentsWindow(AbstractWindow abstractWindow) {
        super(abstractWindow);
        this.setLayout(new BorderLayout());
        ActionDispatcher2 actionDispatcher2 = new ActionDispatcher2(this);
        JPanel jPanel = new JPanel();
        this.buttonAdd = JButtonUtil.createBasicButton(Resource.getString("ADD"), "add", actionDispatcher2);
        jPanel.add(this.buttonAdd);
        this.buttonEdit = JButtonUtil.createBasicButton(Resource.getString("EDIT"), "edit", actionDispatcher2);
        jPanel.add(this.buttonEdit);
        this.buttonDelete = JButtonUtil.createBasicButton(Resource.getString("DELETE"), "delete", actionDispatcher2);
        jPanel.add(this.buttonDelete);
        this.musicContentsBeanList = MusicContentsManager.allContentsRead();
        this.createMusicContentsTable();
        this.add("Center", this.scrollPane);
        this.add("South", jPanel);
        this.changeButtonEnabled();
    }

    private List<Vector<String>> convertData(List<MusicContentsBean> list) {
        ArrayList<Vector<String>> arrayList = new ArrayList<Vector<String>>();
        for (int i = 0; i < list.size(); ++i) {
            try {
                Vector<String> vector = new Vector<String>();
                vector.addElement(list.get(i).getTitle());
                vector.addElement(MusicContentsManager.getMusicFileNameWithoutExt(list.get(i).getFileName()));
                vector.addElement(list.get(i).getArtist());
                vector.addElement(list.get(i).getAlbum());
                vector.addElement(list.get(i).getGenre());
                arrayList.add(vector);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return arrayList;
    }

    private void createMusicContentsTable() {
        String[] stringArray = new String[]{Resource.getString("MusicPlayer.common.caption.title"), Resource.getString("MusicPlayer.common.caption.filename"), Resource.getString("MusicPlayer.common.caption.artist"), Resource.getString("MusicPlayer.common.caption.album"), Resource.getString("MusicPlayer.common.caption.genre")};
        ArrayList<WidthBean> arrayList = new ArrayList<WidthBean>();
        arrayList.add(new WidthBean(100, 100));
        this.jtu = new JTableUtil();
        this.tableMusicContents = this.jtu.createBasicTable(stringArray, arrayList, 0, this.convertData(this.musicContentsBeanList));
        this.tableMusicContents.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    MusicContentsWindow.this.edit();
                }
            }
        });
        this.tableMusicContents.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    MusicContentsWindow.this.edit();
                }
            }
        });
        this.scrollPane = new JScrollPane(this.tableMusicContents);
    }

    private void updateMusicContentsTable() {
        this.setVisible(false);
        this.remove(this.scrollPane);
        this.tableMusicContents = this.jtu.updateBasicTable(this.convertData(this.musicContentsBeanList));
        this.scrollPane = new JScrollPane(this.tableMusicContents);
        this.add("Center", this.scrollPane);
        this.setVisible(true);
    }

    void add() {
        MusicContentsEditWindow musicContentsEditWindow = new MusicContentsEditWindow(this.parent);
        musicContentsEditWindow.setLocation(this.parent.getShowLocation(musicContentsEditWindow.getWidth(), musicContentsEditWindow.getHeight(), this.tabwin));
        musicContentsEditWindow.setVisible(true);
        if (!musicContentsEditWindow.isCanceled()) {
            this.musicContentsBeanList.add(musicContentsEditWindow.getMusicContentsBean());
            this.updateMusicContentsTable();
        }
        this.changeButtonEnabled();
    }

    void edit() {
        int[] nArray = this.tableMusicContents.getSelectedRows();
        if (this.tableMusicContents.getSelectedRowCount() == 1) {
            MusicContentsBean musicContentsBean = this.musicContentsBeanList.get(nArray[0]);
            MusicContentsEditWindow musicContentsEditWindow = new MusicContentsEditWindow(this.parent, musicContentsBean);
            musicContentsEditWindow.setLocation(this.parent.getShowLocation(musicContentsEditWindow.getWidth(), musicContentsEditWindow.getHeight(), this.tabwin));
            musicContentsEditWindow.setVisible(true);
            if (!musicContentsEditWindow.isCanceled()) {
                this.updateMusicContentsTable();
            }
        }
        this.changeButtonEnabled();
    }

    void delete() {
        int[] nArray = this.tableMusicContents.getSelectedRows();
        if (this.tableMusicContents.getSelectedRowCount() == 1) {
            JOptionPane jOptionPane = new JOptionPane(Resource.getString("MusicPlayer.common.message.delete.info.musicContents"), 3, 0);
            JDialog jDialog = jOptionPane.createDialog(this, Resource.getString("CONFIRM"));
            jDialog.setResizable(false);
            jDialog.setVisible(true);
            Object object = jOptionPane.getValue();
            if (object instanceof Integer && (Integer)object == 0) {
                try {
                    MusicContentsManager.delete(this.musicContentsBeanList.get(nArray[0]));
                    this.musicContentsBeanList.remove(nArray[0]);
                    this.updateMusicContentsTable();
                }
                catch (Exception exception) {
                    System.err.println(Resource.format("WRITE_ERR", this.musicContentsBeanList.get(nArray[0]).getFileName()));
                }
            }
        }
        this.changeButtonEnabled();
    }

    @Override
    void cancel() {
    }

    @Override
    boolean set() {
        return true;
    }

    private void changeButtonEnabled() {
        if (this.musicContentsBeanList != null && this.musicContentsBeanList.size() > 0) {
            this.buttonEdit.setEnabled(true);
            this.buttonDelete.setEnabled(true);
        } else {
            this.buttonEdit.setEnabled(false);
            this.buttonDelete.setEnabled(false);
        }
    }
}

