/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.CustomWindowsComboBoxUI;
import com.nttdocomo.dojaemu.ktoolbar.HalfNumberDocument;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.PedometerDetailCsvRecord;
import com.nttdocomo.dojaemu.ktoolbar.PedometerUtil;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.swing.EditWindowInterface;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.plaf.ComboBoxUI;

public class PedometerBasicInfoWindow
extends AbstractWindow
implements EditWindowInterface {
    private static final String[] LIST_INTERVAL = new String[]{"60", "120", "180", "240", "300", "360", "600", "720", "900", "1200", "1800", "3600"};
    private static final int MAX_LEN_DATE_YEAR = 4;
    private static final int MAX_LEN_DATE_MONTH = 2;
    private static final int MAX_LEN_DATE_DAY = 2;
    private static final int DATE_YEAR_WIDTH = 6;
    private static final int DATE_MONTH_WIDTH = 4;
    private static final int DATE_DAY_WIDTH = 4;
    private static final int ENABLED_WIDTH = 100;
    private static final int CMB_HEIGHT = 20;
    private static final int FLOW_HGAP = 10;
    private static final int FLOW_VGAP = 10;
    private static final int DAY_SECOND = 86400;
    private JButton setButton = null;
    private JButton cancelButton = null;
    private JTextField txtDateYear = null;
    private JTextField txtDateMonth = null;
    private JTextField txtDateDay = null;
    private JComboBox cmbInterval = null;
    private String dateKey = null;
    private String intervalKey = null;
    private String originalDateKey = null;
    private List<PedometerDetailCsvRecord> listDRecord = new ArrayList<PedometerDetailCsvRecord>();
    private static final String PEDOM_DAT_EXT = ".dat";

    public PedometerBasicInfoWindow(MainWindow mainWindow, String string, String string2, String string3, List<PedometerDetailCsvRecord> list) {
        super(mainWindow, Resource.getString("PEDOMETER_BASIC_INFO_WINDOW_TITLE"));
        Object object;
        this.parent = mainWindow;
        this.dateKey = string;
        this.intervalKey = string2;
        this.originalDateKey = string3;
        this.listDRecord = list;
        this.addWindowListener();
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        JPanel jPanel7 = new JPanel();
        JPanel jPanel8 = new JPanel();
        JPanel jPanel9 = new JPanel();
        JLabel jLabel = new JLabel(Resource.getString("PEDOMETER_LBL_DATE"));
        JLabel jLabel2 = new JLabel(" " + Resource.getString("YEAR") + " ");
        JLabel jLabel3 = new JLabel(" " + Resource.getString("MONTH") + " ");
        JLabel jLabel4 = new JLabel(" " + Resource.getString("DAY") + " ");
        JLabel jLabel5 = new JLabel(Resource.getString("PEDOMETER_LBL_DATE_E_LBL_INTERVAL"));
        JLabel jLabel6 = new JLabel(Resource.getString("PEDOMETER_LBL_DATE_E_LBL_INTERVAL_UNIT"));
        this.txtDateYear = new JTextField(6);
        this.txtDateYear.setDocument(new HalfNumberDocument(4));
        this.txtDateMonth = new JTextField(4);
        this.txtDateMonth.setDocument(new HalfNumberDocument(2));
        this.txtDateDay = new JTextField(4);
        this.txtDateDay.setDocument(new HalfNumberDocument(2));
        if (this.dateKey != null) {
            object = PedometerUtil.getYMDStrings(this.dateKey);
            this.txtDateYear.setText(object[0]);
            this.txtDateMonth.setText(object[1]);
            this.txtDateDay.setText(object[2]);
        }
        this.cmbInterval = new JComboBox<String>(LIST_INTERVAL);
        this.cmbInterval.setUI((ComboBoxUI)((Object)new CustomWindowsComboBoxUI()));
        this.cmbInterval.setPreferredSize(new Dimension(100, 20));
        if (this.originalDateKey != null && this.intervalKey != null) {
            this.cmbInterval.setSelectedItem(this.intervalKey);
            this.cmbInterval.setEnabled(false);
        }
        if (this.originalDateKey == null && this.intervalKey != null) {
            this.cmbInterval.setSelectedItem(this.intervalKey);
        }
        this.setButton = new JButton(Resource.getString("SET"));
        this.cancelButton = new JButton(Resource.getString("CANCEL"));
        object = this.getContentPane();
        ((Container)object).setLayout(new BoxLayout((Container)object, 1));
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel2.setLayout(new GridLayout(1, 1));
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel5.setLayout(new FlowLayout(0, 10, 10));
        jPanel6.setLayout(new FlowLayout(0, 10, 10));
        jPanel7.setLayout(new FlowLayout(0, 10, 10));
        jPanel8.setLayout(new FlowLayout(0, 10, 10));
        jPanel9.setLayout(new FlowLayout(1));
        jPanel5.add(jLabel);
        jPanel6.add(jLabel5);
        jPanel3.add(jPanel5);
        jPanel3.add(jPanel6);
        jPanel7.add(this.txtDateYear);
        jPanel7.add(jLabel2);
        jPanel7.add(this.txtDateMonth);
        jPanel7.add(jLabel3);
        jPanel7.add(this.txtDateDay);
        jPanel7.add(jLabel4);
        jPanel8.add(this.cmbInterval);
        jPanel8.add(jLabel6);
        jPanel4.add(jPanel7);
        jPanel4.add(jPanel8);
        jPanel.add("West", jPanel3);
        jPanel.add("Center", jPanel4);
        jPanel9.add(this.setButton);
        jPanel9.add(this.cancelButton);
        jPanel2.add(jPanel9);
        ((Container)object).add("North", jPanel);
        ((Container)object).add("South", jPanel2);
        this.setButton.setActionCommand("set");
        this.cancelButton.setActionCommand("cancel");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.setButton.addActionListener(actionDispatcher);
        this.cancelButton.addActionListener(actionDispatcher);
        this.pack();
        this.setResizable(false);
    }

    @Override
    public void checkInput() throws Exception {
        String string = this.txtDateYear.getText();
        String string2 = this.txtDateMonth.getText();
        String string3 = this.txtDateDay.getText();
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0 || string3 == null || string3.length() == 0) {
            throw new Exception(Resource.format("PEDOMETER_VAL_NOT_INPUT_WNG", Resource.getString("PEDOMETER_LBL_DATE")));
        }
    }

    @Override
    public void checkFormat() throws Exception {
        String string = this.txtDateYear.getText();
        String string2 = this.txtDateMonth.getText();
        String string3 = this.txtDateDay.getText();
        try {
            PedometerUtil.parse(string, string2, string3);
        }
        catch (Exception exception) {
            throw new Exception(Resource.format("PEDOMETER_DATE_INVALID_FORMAT", Resource.getString("PEDOMETER_LBL_DATE")));
        }
    }

    public boolean set() {
        try {
            this.checkInput();
            this.checkFormat();
            String string = this.txtDateYear.getText();
            String string2 = this.txtDateMonth.getText();
            String string3 = this.txtDateDay.getText();
            int n = Integer.parseInt(string);
            int n2 = Integer.parseInt(string2);
            int n3 = Integer.parseInt(string3);
            Calendar calendar = Calendar.getInstance();
            calendar.set(n, n2 - 1, n3, 0, 0);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd");
            String string4 = simpleDateFormat.format(calendar.getTime());
            int n4 = this.cmbInterval.getSelectedIndex();
            String string5 = LIST_INTERVAL[n4];
            int n5 = Integer.parseInt(string5);
            if (this.originalDateKey != null && this.originalDateKey.equals(string4)) {
                this.cancel();
            } else if (PedometerUtil.checkExists(string4.replace("/", "").concat(PEDOM_DAT_EXT))) {
                this.parent.showDialog(Resource.format("PEDOMETER_DATE_DUPLICATION", Resource.getString("PEDOMETER_LBL_DATE")), this, 2);
                return false;
            }
            this.dateKey = string4;
            this.intervalKey = string5;
            for (int i = 0; i < 86400 / n5; ++i) {
                PedometerDetailCsvRecord pedometerDetailCsvRecord = new PedometerDetailCsvRecord();
                pedometerDetailCsvRecord.setPeriodicNumberOfSteps(0);
                pedometerDetailCsvRecord.setPeriodicDistance(0);
                pedometerDetailCsvRecord.setPeriodicNumberOfAerobicsSteps(0);
                pedometerDetailCsvRecord.setPeriodicAerobicsTime(0);
                pedometerDetailCsvRecord.setPeriodicAmountOfCombustionFat(0);
                pedometerDetailCsvRecord.setPeriodicConsumptionCalorie(0);
                this.listDRecord.add(pedometerDetailCsvRecord);
            }
            this.setVisible(false);
            this.dispose();
        }
        catch (Exception exception) {
            this.parent.showDialog(exception.getMessage(), this, 2);
            return false;
        }
        return true;
    }

    public void cancel() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public boolean isCanceled() {
        return this.dateKey == null;
    }

    public String getDateKey() {
        return this.dateKey;
    }

    public String getIntervalKey() {
        return this.intervalKey;
    }

    public List<PedometerDetailCsvRecord> getListDRecord() {
        return this.listDRecord;
    }
}

