/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.Const;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.PedometerBasicInfoWindow;
import com.nttdocomo.dojaemu.ktoolbar.PedometerDetailCsvReader;
import com.nttdocomo.dojaemu.ktoolbar.PedometerDetailCsvRecord;
import com.nttdocomo.dojaemu.ktoolbar.PedometerDetailCsvWriter;
import com.nttdocomo.dojaemu.ktoolbar.PedometerEditWindow;
import com.nttdocomo.dojaemu.ktoolbar.PedometerSummaryCsvRecord;
import com.nttdocomo.dojaemu.ktoolbar.PedometerUtil;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.swing.BasicTableCellRenderer;
import com.nttdocomo.dojaemu.ktoolbar.swing.InvalidEditTableModel;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;

public class PedometerListWindow
extends AbstractWindow {
    private static final String PEDOM_DAT_EXT = ".dat";
    private JLabel lblDateYear = null;
    private JLabel lblDateMonth = null;
    private JLabel lblDateDay = null;
    private JLabel lblIntervalVal = null;
    private JButton settingButton = null;
    private JTable pedometerTable = null;
    private JScrollPane scrollpane = null;
    private JButton editButton = null;
    private JButton setButton = null;
    private JButton cancelButton = null;
    private JPanel centerPanel = null;
    private List<PedometerSummaryCsvRecord> listSRecord = new ArrayList<PedometerSummaryCsvRecord>();
    private PedometerSummaryCsvRecord sRecord = new PedometerSummaryCsvRecord();
    private List<PedometerDetailCsvRecord> listDRecord = new ArrayList<PedometerDetailCsvRecord>();
    private PedometerDetailCsvRecord dRecord = new PedometerDetailCsvRecord();
    private String dateKey = null;
    private String originalDateKey = null;
    private String intervalKey = null;
    private static final int SCROLL_HEIGHT = 200;
    private static final int SCROLL_WIDTH = 645;
    private static final int DISTANCE_WIDTH = 150;
    private static final int FAT_WIDTH = 257;
    private static final int CALORIE_WIDTH = 167;
    private static final int AST_WIDTH = 258;
    private static final int FLOW_HGAP = 10;
    private static final int FLOW_VGAP = 10;
    private static final int ENABLED_WIDTH = 100;
    private static final int CMB_HEIGHT = 20;
    private static final int DATE_YEAR_WIDTH = 24;
    private static final int DATE_MONTH_WIDTH = 12;
    private static final int DATE_DAY_WIDTH = 12;
    private static final File PEDOM_BASE_DIR = new File(Const.PATH_LIB_PEDOM);

    public PedometerListWindow(MainWindow mainWindow, String string, String string2, String string3) throws ParseException {
        super(mainWindow, Resource.getString("PEDOMETER_ENTRY_WINDOW_TITLE"));
        Object object;
        this.parent = mainWindow;
        this.dateKey = string;
        this.intervalKey = string2;
        this.originalDateKey = string3;
        if (string == null) {
            this.listDRecord = new ArrayList<PedometerDetailCsvRecord>();
        } else {
            this.readCsv();
        }
        this.addWindowListener();
        JPanel jPanel = new JPanel();
        this.centerPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        JPanel jPanel7 = new JPanel();
        JPanel jPanel8 = new JPanel();
        JPanel jPanel9 = new JPanel();
        JPanel jPanel10 = new JPanel();
        JLabel jLabel = new JLabel(Resource.getString("PEDOMETER_LBL_DATE"));
        JLabel jLabel2 = new JLabel(" " + Resource.getString("YEAR") + " ");
        JLabel jLabel3 = new JLabel(" " + Resource.getString("MONTH") + " ");
        JLabel jLabel4 = new JLabel(" " + Resource.getString("DAY") + " ");
        JLabel jLabel5 = new JLabel(Resource.getString("PEDOMETER_LBL_DATE_E_LBL_INTERVAL"));
        JLabel jLabel6 = new JLabel(Resource.getString("PEDOMETER_LBL_DATE_E_LBL_INTERVAL_UNIT"));
        this.lblDateYear = new JLabel();
        this.lblDateYear.setPreferredSize(new Dimension(24, 20));
        this.lblDateMonth = new JLabel();
        this.lblDateMonth.setPreferredSize(new Dimension(12, 20));
        this.lblDateDay = new JLabel();
        this.lblDateDay.setPreferredSize(new Dimension(12, 20));
        this.lblIntervalVal = new JLabel();
        this.lblIntervalVal.setPreferredSize(new Dimension(100, 20));
        if (this.dateKey != null && this.intervalKey != null) {
            object = PedometerUtil.getYMDStrings(this.dateKey);
            this.lblDateYear.setText(object[0]);
            this.lblDateMonth.setText(object[1]);
            this.lblDateDay.setText(object[2]);
            this.lblIntervalVal.setText(this.intervalKey);
        }
        this.pedometerTable = this.createPedometerTable();
        this.scrollpane = new JScrollPane(this.pedometerTable);
        this.scrollpane.setPreferredSize(new Dimension(645, 200));
        this.setButton = new JButton(Resource.getString("SET"));
        this.cancelButton = new JButton(Resource.getString("CANCEL"));
        this.editButton = new JButton(Resource.getString("EDIT"));
        this.settingButton = new JButton(Resource.getString("SET_UP"));
        object = this.getContentPane();
        ((Container)object).setLayout(new BoxLayout((Container)object, 1));
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.centerPanel.setLayout(new FlowLayout(1));
        jPanel2.setLayout(new GridLayout(2, 1));
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel5.setLayout(new FlowLayout(0, 10, 10));
        jPanel6.setLayout(new FlowLayout(0, 10, 10));
        jPanel7.setLayout(new FlowLayout(0, 10, 10));
        jPanel8.setLayout(new FlowLayout(0, 10, 10));
        jPanel9.setLayout(new FlowLayout(1));
        jPanel10.setLayout(new FlowLayout(1));
        jPanel5.add(jLabel);
        jPanel6.add(jLabel5);
        jPanel3.add(jPanel5);
        jPanel3.add(jPanel6);
        jPanel7.add(this.lblDateYear);
        jPanel7.add(jLabel2);
        jPanel7.add(this.lblDateMonth);
        jPanel7.add(jLabel3);
        jPanel7.add(this.lblDateDay);
        jPanel7.add(jLabel4);
        jPanel8.add(this.lblIntervalVal);
        jPanel8.add(jLabel6);
        jPanel8.add(this.settingButton);
        jPanel4.add(jPanel7);
        jPanel4.add(jPanel8);
        jPanel.add("West", jPanel3);
        jPanel.add("Center", jPanel4);
        this.centerPanel.add(this.scrollpane);
        jPanel9.add(this.editButton);
        jPanel10.add(this.setButton);
        jPanel10.add(this.cancelButton);
        jPanel2.add(jPanel9);
        jPanel2.add(jPanel10);
        ((Container)object).add("North", jPanel);
        ((Container)object).add("Center", this.centerPanel);
        ((Container)object).add("South", jPanel2);
        this.setButton.setActionCommand("set");
        this.cancelButton.setActionCommand("cancel");
        this.editButton.setActionCommand("edit");
        this.settingButton.setActionCommand("setting");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.setButton.addActionListener(actionDispatcher);
        this.cancelButton.addActionListener(actionDispatcher);
        this.editButton.addActionListener(actionDispatcher);
        this.settingButton.addActionListener(actionDispatcher);
        this.changeButtonEnabled();
        this.pack();
        this.setResizable(false);
    }

    private JTable createPedometerTable() throws ParseException {
        Object object;
        Serializable serializable;
        Serializable serializable2;
        Object object2;
        Object object3;
        JTable jTable = null;
        InvalidEditTableModel invalidEditTableModel = null;
        String[] stringArray = new String[]{Resource.getString("PEDOMETER_LBL_TIME"), Resource.getString("PEDOMETER_LBL_STEPS"), Resource.getString("PEDOMETER_LBL_DISTANCE"), Resource.getString("PEDOMETER_LBL_AERO_STEPS"), Resource.getString("PEDOMETER_LBL_AERO_TIME"), Resource.getString("PEDOMETER_LBL_FAT"), Resource.getString("PEDOMETER_LBL_CALORIE")};
        invalidEditTableModel = new InvalidEditTableModel(stringArray, 0);
        for (int i = 0; i < this.listDRecord.size(); ++i) {
            object3 = this.lblIntervalVal.getText();
            int n = Integer.parseInt((String)object3);
            object2 = "00:00";
            serializable2 = new SimpleDateFormat("HH:mm");
            serializable = ((DateFormat)serializable2).parse((String)object2);
            object = null;
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime((Date)serializable);
            ((Calendar)gregorianCalendar).add(13, n * i);
            Date date = gregorianCalendar.getTime();
            object = ((DateFormat)serializable2).format(date);
            Vector<String> vector = new Vector<String>();
            vector.addElement((String)object);
            vector.addElement(Integer.toString(this.listDRecord.get(i).getPeriodicNumberOfSteps()));
            vector.addElement(Integer.toString(this.listDRecord.get(i).getPeriodicDistance()));
            vector.addElement(Integer.toString(this.listDRecord.get(i).getPeriodicNumberOfAerobicsSteps()));
            vector.addElement(Integer.toString(this.listDRecord.get(i).getPeriodicAerobicsTime()));
            vector.addElement(Integer.toString(this.listDRecord.get(i).getPeriodicAmountOfCombustionFat()));
            vector.addElement(Integer.toString(this.listDRecord.get(i).getPeriodicConsumptionCalorie()));
            invalidEditTableModel.addRow(vector);
        }
        jTable = new JTable(invalidEditTableModel);
        jTable.getTableHeader().setReorderingAllowed(false);
        jTable.getTableHeader().setResizingAllowed(false);
        TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
        tableColumn.setMaxWidth(100);
        tableColumn.setPreferredWidth(100);
        object3 = jTable.getColumnModel().getColumn(1);
        ((TableColumn)object3).setMaxWidth(100);
        ((TableColumn)object3).setPreferredWidth(100);
        TableColumn tableColumn2 = jTable.getColumnModel().getColumn(2);
        tableColumn2.setMaxWidth(150);
        tableColumn2.setPreferredWidth(150);
        object2 = jTable.getColumnModel().getColumn(3);
        ((TableColumn)object2).setMaxWidth(258);
        ((TableColumn)object2).setPreferredWidth(258);
        serializable2 = jTable.getColumnModel().getColumn(4);
        ((TableColumn)serializable2).setMaxWidth(258);
        ((TableColumn)serializable2).setPreferredWidth(258);
        serializable = jTable.getColumnModel().getColumn(5);
        ((TableColumn)serializable).setMaxWidth(257);
        ((TableColumn)serializable).setPreferredWidth(257);
        object = jTable.getColumnModel().getColumn(6);
        ((TableColumn)object).setMaxWidth(167);
        ((TableColumn)object).setPreferredWidth(167);
        jTable.setDefaultRenderer(Object.class, new BasicTableCellRenderer(0));
        jTable.setSelectionMode(0);
        jTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    try {
                        PedometerListWindow.this.edit();
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }
        });
        jTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    try {
                        PedometerListWindow.this.edit();
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            }
        });
        return jTable;
    }

    public boolean set() throws ParseException {
        String string = this.lblDateYear.getText();
        String string2 = this.lblDateMonth.getText();
        String string3 = this.lblDateDay.getText();
        int n = Integer.parseInt(string);
        int n2 = Integer.parseInt(string2);
        int n3 = Integer.parseInt(string3);
        Calendar calendar = Calendar.getInstance();
        calendar.set(n, n2 - 1, n3, 0, 0);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd");
        String string4 = simpleDateFormat.format(calendar.getTime());
        Date date = simpleDateFormat.parse(string4);
        String string5 = this.lblIntervalVal.getText();
        int n4 = Integer.parseInt(string5);
        int n5 = this.pedometerTable.getRowCount();
        String string6 = null;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < 6; ++j) {
                string6 = (String)this.pedometerTable.getValueAt(i, 1 + j);
                if (j == 0) {
                    n6 += Integer.valueOf(string6).intValue();
                    continue;
                }
                if (j == 1) {
                    n7 += Integer.valueOf(string6).intValue();
                    continue;
                }
                if (j == 2) {
                    n8 += Integer.valueOf(string6).intValue();
                    continue;
                }
                if (j == 3) {
                    n9 += Integer.valueOf(string6).intValue();
                    continue;
                }
                if (j == 4) {
                    n10 += Integer.valueOf(string6).intValue();
                    continue;
                }
                if (j != 5) continue;
                n11 += Integer.valueOf(string6).intValue();
            }
        }
        this.sRecord.setDate(date);
        this.sRecord.setInterval(n4);
        this.sRecord.setNumberOfSteps(n6);
        this.sRecord.setDistance(n7);
        this.sRecord.setNumberOfAerobicsSteps(n8);
        this.sRecord.setAerobicsTime(n9);
        this.sRecord.setAmountOfCombustionFat(n10);
        this.sRecord.setConsumptionCalorie(n11);
        if (this.originalDateKey != null && !this.originalDateKey.equals(string4)) {
            String string7 = this.originalDateKey.replace("/", "").concat(PEDOM_DAT_EXT);
            File file = new File(PEDOM_BASE_DIR.getPath(), string7);
            file.delete();
        }
        this.dateKey = string4;
        this.originalDateKey = string4;
        this.writeCsv();
        this.changeButtonEnabled();
        this.setVisible(false);
        this.dispose();
        return true;
    }

    public void cancel() {
        this.setVisible(false);
        this.dispose();
    }

    public void edit() throws ParseException {
        if (this.pedometerTable.getSelectedRowCount() == 1) {
            int n = this.pedometerTable.getSelectedRow();
            this.dRecord = this.listDRecord.get(n);
            PedometerEditWindow pedometerEditWindow = new PedometerEditWindow(this.parent, this.dRecord);
            pedometerEditWindow.setLocation(this.parent.getShowLocation(pedometerEditWindow.getWidth(), pedometerEditWindow.getHeight(), this));
            pedometerEditWindow.setVisible(true);
            if (!pedometerEditWindow.isCanceled()) {
                this.setVisible(false);
                this.centerPanel.remove(this.scrollpane);
                this.scrollpane = null;
                this.pedometerTable = null;
                this.listDRecord.remove(this.dRecord);
                this.listDRecord.add(n, pedometerEditWindow.getdRecord());
                this.pedometerTable = this.createPedometerTable();
                this.scrollpane = new JScrollPane(this.pedometerTable);
                this.scrollpane.setPreferredSize(new Dimension(645, 200));
                this.centerPanel.add(this.scrollpane);
                this.changeButtonEnabled();
                this.setVisible(true);
            }
        }
    }

    public void setting() throws ParseException {
        PedometerBasicInfoWindow pedometerBasicInfoWindow = new PedometerBasicInfoWindow(this.parent, this.dateKey, this.intervalKey, this.originalDateKey, this.listDRecord);
        pedometerBasicInfoWindow.setLocation(this.parent.getShowLocation(pedometerBasicInfoWindow.getWidth(), pedometerBasicInfoWindow.getHeight(), this));
        pedometerBasicInfoWindow.setVisible(true);
        if (this.dateKey != null && this.intervalKey != null) {
            this.dateKey = pedometerBasicInfoWindow.getDateKey();
            String[] stringArray = PedometerUtil.getYMDStrings(this.dateKey);
            this.lblDateYear.setText(stringArray[0]);
            this.lblDateMonth.setText(stringArray[1]);
            this.lblDateDay.setText(stringArray[2]);
            this.intervalKey = pedometerBasicInfoWindow.getIntervalKey();
            this.lblIntervalVal.setText(this.intervalKey);
            this.setVisible(false);
            this.centerPanel.remove(this.scrollpane);
            this.scrollpane = null;
            this.pedometerTable = null;
            this.listDRecord = pedometerBasicInfoWindow.getListDRecord();
            this.pedometerTable = this.createPedometerTable();
            this.scrollpane = new JScrollPane(this.pedometerTable);
            this.scrollpane.setPreferredSize(new Dimension(645, 200));
            this.centerPanel.add(this.scrollpane);
        } else if (!pedometerBasicInfoWindow.isCanceled()) {
            this.dateKey = pedometerBasicInfoWindow.getDateKey();
            String[] stringArray = PedometerUtil.getYMDStrings(this.dateKey);
            this.lblDateYear.setText(stringArray[0]);
            this.lblDateMonth.setText(stringArray[1]);
            this.lblDateDay.setText(stringArray[2]);
            this.intervalKey = pedometerBasicInfoWindow.getIntervalKey();
            this.lblIntervalVal.setText(this.intervalKey);
            this.setVisible(false);
            this.centerPanel.remove(this.scrollpane);
            this.scrollpane = null;
            this.pedometerTable = null;
            this.listDRecord = pedometerBasicInfoWindow.getListDRecord();
            this.pedometerTable = this.createPedometerTable();
            this.scrollpane = new JScrollPane(this.pedometerTable);
            this.scrollpane.setPreferredSize(new Dimension(645, 200));
            this.centerPanel.add(this.scrollpane);
        }
        this.changeButtonEnabled();
        this.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readCsv() throws ParseException {
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        PedometerDetailCsvReader pedometerDetailCsvReader = null;
        String string = this.dateKey.replace("/", "").concat(PEDOM_DAT_EXT);
        try {
            PedometerDetailCsvRecord pedometerDetailCsvRecord;
            inputStreamReader = new FileReader(new File(PEDOM_BASE_DIR.getPath() + File.separator + string));
            bufferedReader = new BufferedReader(inputStreamReader);
            pedometerDetailCsvReader = new PedometerDetailCsvReader(bufferedReader);
            this.listDRecord = new ArrayList<PedometerDetailCsvRecord>();
            while ((pedometerDetailCsvRecord = pedometerDetailCsvReader.readRecord()) != null) {
                this.listDRecord.add(pedometerDetailCsvRecord);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.listDRecord.clear();
            this.writeCsv();
        }
        catch (Exception exception) {
        }
        finally {
            try {
                pedometerDetailCsvReader.close();
                bufferedReader.close();
                inputStreamReader.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCsv() throws ParseException {
        OutputStreamWriter outputStreamWriter = null;
        BufferedWriter bufferedWriter = null;
        PedometerDetailCsvWriter pedometerDetailCsvWriter = null;
        String string = this.dateKey.replace("/", "").concat(PEDOM_DAT_EXT);
        try {
            outputStreamWriter = new FileWriter(new File(PEDOM_BASE_DIR.getPath() + File.separator + string));
            bufferedWriter = new BufferedWriter(outputStreamWriter);
            pedometerDetailCsvWriter = new PedometerDetailCsvWriter(bufferedWriter);
            for (PedometerDetailCsvRecord pedometerDetailCsvRecord : this.listDRecord) {
                pedometerDetailCsvWriter.writeRecord(pedometerDetailCsvRecord);
            }
        }
        catch (IOException iOException) {
            System.err.println(Resource.format("WRITE_ERR", new File(PEDOM_BASE_DIR.getPath() + File.separator + string)));
        }
        finally {
            try {
                pedometerDetailCsvWriter.close();
                bufferedWriter.close();
                outputStreamWriter.close();
            }
            catch (Exception exception) {}
        }
    }

    private void changeButtonEnabled() {
        if (this.pedometerTable.getRowCount() > 0) {
            this.editButton.setEnabled(true);
            this.setButton.setEnabled(true);
        } else {
            this.editButton.setEnabled(false);
            this.setButton.setEnabled(false);
        }
    }

    public boolean isCanceled() {
        return this.sRecord.getDate() == null;
    }

    public List<PedometerSummaryCsvRecord> getListSRecord() {
        return this.listSRecord;
    }

    public PedometerSummaryCsvRecord getsRecord() {
        return this.sRecord;
    }
}

