/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.Const;
import com.nttdocomo.dojaemu.ktoolbar.JAMManager;
import com.nttdocomo.dojaemu.ktoolbar.PedometerListWindow;
import com.nttdocomo.dojaemu.ktoolbar.PedometerSummaryCsvReader;
import com.nttdocomo.dojaemu.ktoolbar.PedometerSummaryCsvRecord;
import com.nttdocomo.dojaemu.ktoolbar.PedometerSummaryCsvWriter;
import com.nttdocomo.dojaemu.ktoolbar.PedometerUtil;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.TabPanel;
import com.nttdocomo.dojaemu.ktoolbar.swing.BasicTableCellRenderer;
import com.nttdocomo.dojaemu.ktoolbar.swing.InvalidEditTableModel;
import java.awt.BorderLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;

class PedometerWindow
extends TabPanel {
    private static final String SUMMARY_DAT = "summary.dat";
    private JTable pedometerTable;
    private JScrollPane scrollpane;
    private List<PedometerSummaryCsvRecord> listSRecord = new ArrayList<PedometerSummaryCsvRecord>();
    private JButton addButton;
    private JButton editButton;
    private JButton deleteButton;
    private static final int ENABLED_WIDTH = 100;
    private static final File PEDOM_BASE_DIR = new File(Const.PATH_LIB_PEDOM);
    private static final String PEDOM_DAT_EXT = ".dat";

    PedometerWindow(AbstractWindow abstractWindow) {
        super(abstractWindow);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        this.addButton = new JButton(Resource.getString("ADD"));
        this.editButton = new JButton(Resource.getString("EDIT"));
        this.deleteButton = new JButton(Resource.getString("DELETE"));
        this.addButton.setActionCommand("add");
        this.editButton.setActionCommand("edit");
        this.deleteButton.setActionCommand("delete");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.addButton.addActionListener(actionDispatcher);
        this.editButton.addActionListener(actionDispatcher);
        this.deleteButton.addActionListener(actionDispatcher);
        jPanel.add(this.addButton);
        jPanel.add(this.editButton);
        jPanel.add(this.deleteButton);
        this.pedometerTable = this.createPedometerTable();
        this.scrollpane = new JScrollPane(this.pedometerTable);
        this.add("Center", this.scrollpane);
        this.add("South", jPanel);
    }

    private JTable createPedometerTable() {
        JTable jTable = null;
        InvalidEditTableModel invalidEditTableModel = null;
        String[] stringArray = new String[]{Resource.getString("PEDOMETER_LBL_DATE"), Resource.getString("PEDOMETER_LBL_STEPS"), Resource.getString("PEDOMETER_LBL_DISTANCE"), Resource.getString("PEDOMETER_LBL_FAT"), Resource.getString("PEDOMETER_LBL_CALORIE")};
        invalidEditTableModel = new InvalidEditTableModel(stringArray, 0);
        this.readCsv();
        for (PedometerSummaryCsvRecord pedometerSummaryCsvRecord : this.listSRecord) {
            Vector<String> vector = new Vector<String>();
            vector.addElement(PedometerUtil.dateToString(pedometerSummaryCsvRecord.getDate()));
            vector.addElement(Integer.toString(pedometerSummaryCsvRecord.getNumberOfSteps()));
            vector.addElement(Integer.toString(pedometerSummaryCsvRecord.getDistance()));
            vector.addElement(Integer.toString(pedometerSummaryCsvRecord.getAmountOfCombustionFat()));
            vector.addElement(Integer.toString(pedometerSummaryCsvRecord.getConsumptionCalorie()));
            invalidEditTableModel.addRow(vector);
        }
        jTable = new JTable(invalidEditTableModel);
        jTable.getTableHeader().setReorderingAllowed(false);
        jTable.getTableHeader().setResizingAllowed(false);
        TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
        tableColumn.setMaxWidth(100);
        tableColumn.setPreferredWidth(100);
        jTable.setDefaultRenderer(Object.class, new BasicTableCellRenderer(0));
        jTable.setSelectionMode(0);
        this.changeButtonEnabled();
        jTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    try {
                        PedometerWindow.this.edit();
                    }
                    catch (ParseException parseException) {
                        parseException.printStackTrace();
                    }
                }
            }
        });
        jTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    try {
                        PedometerWindow.this.edit();
                    }
                    catch (ParseException parseException) {
                        parseException.printStackTrace();
                    }
                }
            }
        });
        return jTable;
    }

    void add() throws ParseException {
        if (JAMManager.getState() != 4) {
            this.parent.showDialog(Resource.getString("PEDOMETER_WNG_APP_RUNNING"), this, 2);
            return;
        }
        PedometerListWindow pedometerListWindow = new PedometerListWindow(this.parent, null, null, null);
        pedometerListWindow.setLocation(this.parent.getShowLocation(pedometerListWindow.getWidth(), pedometerListWindow.getHeight(), this.tabwin));
        pedometerListWindow.setVisible(true);
        if (!pedometerListWindow.isCanceled()) {
            this.listSRecord.add(pedometerListWindow.getsRecord());
            this.writeCsvAndUpdateTable();
            this.changeButtonEnabled();
        }
    }

    void edit() throws ParseException {
        if (JAMManager.getState() != 4) {
            this.parent.showDialog(Resource.getString("PEDOMETER_WNG_APP_RUNNING"), this, 2);
            return;
        }
        if (this.pedometerTable.getSelectedRowCount() == 1) {
            int n = this.pedometerTable.getSelectedRow();
            String string = (String)this.pedometerTable.getValueAt(n, 0);
            PedometerSummaryCsvRecord pedometerSummaryCsvRecord = this.listSRecord.get(n);
            String string2 = String.valueOf(pedometerSummaryCsvRecord.getInterval());
            PedometerListWindow pedometerListWindow = new PedometerListWindow(this.parent, string, string2, string);
            pedometerListWindow.setLocation(this.parent.getShowLocation(pedometerListWindow.getWidth(), pedometerListWindow.getHeight(), this.tabwin));
            pedometerListWindow.setVisible(true);
            if (!pedometerListWindow.isCanceled()) {
                this.listSRecord.remove(pedometerSummaryCsvRecord);
                this.listSRecord.add(n, pedometerListWindow.getsRecord());
                this.writeCsvAndUpdateTable();
                this.changeButtonEnabled();
            }
        }
    }

    void delete() {
        if (JAMManager.getState() != 4) {
            this.parent.showDialog(Resource.getString("PEDOMETER_WNG_APP_RUNNING"), this, 2);
            return;
        }
        int n = this.pedometerTable.getSelectedRow();
        if (this.pedometerTable.getSelectedRowCount() != 0) {
            JOptionPane jOptionPane = new JOptionPane(Resource.format("PEDOMETER_DELETE_WNG", String.valueOf(this.pedometerTable.getSelectedRowCount())), 3, 0);
            JDialog jDialog = jOptionPane.createDialog(this, Resource.getString("CONFIRM"));
            jDialog.setResizable(false);
            jDialog.setVisible(true);
            Object object = jOptionPane.getValue();
            if (object instanceof Integer && (Integer)object == 0) {
                PedometerSummaryCsvRecord pedometerSummaryCsvRecord = this.listSRecord.get(n);
                this.listSRecord.remove(n);
                this.writeCsvAndUpdateTable();
                String string = PedometerUtil.dateToString(pedometerSummaryCsvRecord.getDate());
                String string2 = string.replace("/", "").concat(PEDOM_DAT_EXT);
                File file = new File(PEDOM_BASE_DIR.getPath(), string2);
                file.delete();
            }
        }
    }

    @Override
    void cancel() {
    }

    @Override
    boolean set() {
        return true;
    }

    private static String getFilePath() {
        return PEDOM_BASE_DIR.getPath() + File.separator + SUMMARY_DAT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readCsv() {
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        PedometerSummaryCsvReader pedometerSummaryCsvReader = null;
        try {
            PedometerSummaryCsvRecord pedometerSummaryCsvRecord;
            fileReader = new FileReader(PedometerWindow.getFilePath());
            bufferedReader = new BufferedReader(fileReader);
            pedometerSummaryCsvReader = new PedometerSummaryCsvReader(bufferedReader);
            this.listSRecord = new ArrayList<PedometerSummaryCsvRecord>();
            while ((pedometerSummaryCsvRecord = pedometerSummaryCsvReader.readRecord()) != null) {
                this.listSRecord.add(pedometerSummaryCsvRecord);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.listSRecord.clear();
            this.writeCsv();
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                pedometerSummaryCsvReader.close();
                bufferedReader.close();
                fileReader.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCsv() {
        FileWriter fileWriter = null;
        BufferedWriter bufferedWriter = null;
        PedometerSummaryCsvWriter pedometerSummaryCsvWriter = null;
        try {
            fileWriter = new FileWriter(PedometerWindow.getFilePath());
            bufferedWriter = new BufferedWriter(fileWriter);
            pedometerSummaryCsvWriter = new PedometerSummaryCsvWriter(bufferedWriter);
            for (PedometerSummaryCsvRecord pedometerSummaryCsvRecord : this.listSRecord) {
                pedometerSummaryCsvWriter.writeRecord(pedometerSummaryCsvRecord);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                pedometerSummaryCsvWriter.close();
                bufferedWriter.close();
                fileWriter.close();
            }
            catch (Exception exception) {}
        }
    }

    private void createTable() {
        this.pedometerTable = this.createPedometerTable();
        this.scrollpane = new JScrollPane(this.pedometerTable);
        this.add("Center", this.scrollpane);
    }

    private void updateTable() {
        this.setVisible(false);
        this.remove(this.scrollpane);
        this.scrollpane = null;
        this.pedometerTable = null;
        this.createTable();
        this.setVisible(true);
    }

    private void writeCsvAndUpdateTable() {
        this.writeCsv();
        this.updateTable();
    }

    private void changeButtonEnabled() {
        if (this.listSRecord != null && this.listSRecord.size() > 0) {
            this.editButton.setEnabled(true);
            this.deleteButton.setEnabled(true);
        } else {
            this.editButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
        }
    }
}

