/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.CustomWindowsComboBoxUI;
import com.nttdocomo.dojaemu.ktoolbar.JAMManager;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.TabPanel;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComboBoxUI;

class PerformanceAdjustmentWindow
extends TabPanel
implements ChangeListener,
ItemListener {
    private static final int REFRESH_RATE = 30;
    private static final int GRAPHICS_PRIMITIVE = 1;
    private static final int NETWORK_SPEED = 9600;
    private static final int SCRATCHPAD_SPEED = 25;
    private static final int OUTMEMORY_SPEED = 2;
    private JCheckBox rateCheckBox;
    private JSlider rateSlider;
    private JLabel rateLabel;
    private JCheckBox primitiveCheckBox;
    private JSlider primitiveSlider;
    private JLabel primitiveLabel;
    private JCheckBox networkCheckBox;
    private JComboBox networkComboBox;
    private JLabel networkLabel;
    private static final String[] networkData = new String[]{"9600", "28800", "64000", "128000", "384000", "3600000", "7200000"};
    private JCheckBox scratchpadCheckBox;
    private JLabel scratchpadLabel;
    private JSlider scratchpadSlider;
    private JCheckBox outmemoryCheckBox;
    private JComboBox outmemoryComboBox;
    private JLabel outmemoryLabel;
    private JSlider outmemorySlider;
    private int rateEnable = JAMManager.getRefreshRateEnable();
    private int primitiveEnable = 0;
    private int networkEnable = 0;
    private int scratchpadEnable = 0;
    private int outmemoryEnable = 0;
    private int rate = JAMManager.getRefreshRate();
    private int primitive = 1;
    private int networkSpeed = 9600;
    private int scratchpadSpeed = 25;
    private int outmemorySpeed = 2;

    PerformanceAdjustmentWindow(AbstractWindow abstractWindow) {
        super(abstractWindow);
        this.primitiveEnable = JAMManager.getGraphicsPrimitiveEnable();
        this.primitive = JAMManager.getGraphicsPrimitive();
        this.networkEnable = JAMManager.getNetworkThroughputEnable();
        this.scratchpadEnable = JAMManager.getScratchPadThroughputEnable();
        this.outmemoryEnable = JAMManager.getOutMemoryThroughputEnable();
        this.networkSpeed = JAMManager.getNetworkThroughput();
        this.scratchpadSpeed = JAMManager.getScratchPadThroughput();
        this.outmemorySpeed = JAMManager.getOutMemoryThroughput();
        this.rateLabel = new JLabel(this.rate + "(" + Resource.getString("SET_PERFORMANCE_UNIT_FPS") + ")");
        this.primitiveLabel = new JLabel(this.primitive + "(" + Resource.getString("SET_PERFORMANCE_UNIT_MS") + ")");
        this.networkLabel = new JLabel("(bps)");
        this.scratchpadLabel = new JLabel(this.scratchpadSpeed + " (Mbps)");
        this.outmemoryLabel = new JLabel(this.outmemorySpeed + " (Mbps)");
        this.rateCheckBox = this.rateEnable == 0 ? new JCheckBox(Resource.getString("SET_PERFORMANCE_ENABLE_REFRESHRATE"), false) : new JCheckBox(Resource.getString("SET_PERFORMANCE_ENABLE_REFRESHRATE"), true);
        this.primitiveCheckBox = this.primitiveEnable == 0 ? new JCheckBox(Resource.getString("SET_PERFORMANCE_ENABLE_PRIMITIVE"), false) : new JCheckBox(Resource.getString("SET_PERFORMANCE_ENABLE_PRIMITIVE"), true);
        this.networkCheckBox = this.networkEnable == 0 ? new JCheckBox(Resource.getString("SET_PERFORMANCE_ENABLE_NETWORK"), false) : new JCheckBox(Resource.getString("SET_PERFORMANCE_ENABLE_NETWORK"), true);
        this.scratchpadCheckBox = this.scratchpadEnable == 0 ? new JCheckBox(Resource.getString("SET_PERFORMANCE_ENABLE_SCRATCHPAD"), false) : new JCheckBox(Resource.getString("SET_PERFORMANCE_ENABLE_SCRATCHPAD"), true);
        this.outmemoryCheckBox = this.outmemoryEnable == 0 ? new JCheckBox(Resource.getString("SET_PERFORMANCE_ENABLE_OUTMEMORY"), false) : new JCheckBox(Resource.getString("SET_PERFORMANCE_ENABLE_OUTMEMORY"), true);
        this.networkComboBox = new JComboBox<String>(networkData);
        this.networkComboBox.setUI((ComboBoxUI)((Object)new CustomWindowsComboBoxUI()));
        for (int i = 0; i < networkData.length; ++i) {
            if (this.networkSpeed != Integer.parseInt(networkData[i])) continue;
            this.networkComboBox.setSelectedIndex(i);
        }
        if (this.networkEnable == 0) {
            this.networkComboBox.setEnabled(false);
        } else {
            this.networkComboBox.setEnabled(true);
        }
        this.rateSlider = new JSlider(0, 1, 50, this.rate);
        this.rateSlider.setMinorTickSpacing(5);
        this.rateSlider.setMajorTickSpacing(49);
        this.rateSlider.setPaintTicks(true);
        this.rateSlider.setPaintLabels(true);
        if (this.rateEnable == 0) {
            this.rateSlider.setEnabled(false);
        } else {
            this.rateSlider.setEnabled(true);
        }
        this.primitiveSlider = new JSlider(0, 1, 50, this.primitive);
        this.primitiveSlider.setMinorTickSpacing(5);
        this.primitiveSlider.setMajorTickSpacing(49);
        this.primitiveSlider.setPaintTicks(true);
        this.primitiveSlider.setPaintLabels(true);
        if (this.primitiveEnable == 0) {
            this.primitiveSlider.setEnabled(false);
        } else {
            this.primitiveSlider.setEnabled(true);
        }
        this.scratchpadSlider = new JSlider(0, 1, 50, this.scratchpadSpeed);
        this.scratchpadSlider.setMinorTickSpacing(5);
        this.scratchpadSlider.setMajorTickSpacing(49);
        this.scratchpadSlider.setPaintTicks(true);
        this.scratchpadSlider.setPaintLabels(true);
        if (this.scratchpadEnable == 0) {
            this.scratchpadSlider.setEnabled(false);
        } else {
            this.scratchpadSlider.setEnabled(true);
        }
        this.outmemorySlider = new JSlider(0, 2, 30, this.outmemorySpeed);
        this.outmemorySlider.setMinorTickSpacing(3);
        this.outmemorySlider.setMajorTickSpacing(28);
        this.outmemorySlider.setPaintTicks(true);
        this.outmemorySlider.setPaintLabels(true);
        if (this.outmemoryEnable == 0) {
            this.outmemorySlider.setEnabled(false);
        } else {
            this.outmemorySlider.setEnabled(true);
        }
        this.rateCheckBox.addItemListener(this);
        this.rateSlider.addChangeListener(this);
        this.primitiveCheckBox.addItemListener(this);
        this.primitiveSlider.addChangeListener(this);
        this.networkCheckBox.addItemListener(this);
        this.networkComboBox.addItemListener(this);
        this.scratchpadCheckBox.addItemListener(this);
        this.scratchpadSlider.addChangeListener(this);
        this.outmemorySlider.addChangeListener(this);
        this.outmemoryCheckBox.addItemListener(this);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("SET_PERFORMANCE_TITLE_DRAWING")));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.add(this.rateCheckBox);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0));
        jPanel3.add(this.rateSlider);
        jPanel3.add(this.rateLabel);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(0));
        jPanel4.add(this.primitiveCheckBox);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(0));
        jPanel5.add(this.primitiveSlider);
        jPanel5.add(this.primitiveLabel);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        jPanel.add(jPanel4);
        jPanel.add(jPanel5);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        jPanel6.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("SET_PERFORMANCE_TITLE_NETWORK")));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new FlowLayout(0));
        jPanel7.add(this.networkCheckBox);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new FlowLayout(0));
        jPanel8.add(this.networkComboBox);
        jPanel8.add(this.networkLabel);
        jPanel6.add(jPanel7);
        jPanel6.add(jPanel8);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BoxLayout(jPanel9, 1));
        jPanel9.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("SET_PERFORMANCE_TITLE_STORAGE")));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new FlowLayout(0));
        jPanel10.add(this.scratchpadCheckBox);
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new FlowLayout(0));
        jPanel11.add(this.scratchpadSlider);
        jPanel11.add(this.scratchpadLabel);
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new FlowLayout(0));
        jPanel12.add(this.outmemoryCheckBox);
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout(new FlowLayout(0));
        jPanel13.add(this.outmemorySlider);
        jPanel13.add(this.outmemoryLabel);
        jPanel9.add(jPanel10);
        jPanel9.add(jPanel11);
        jPanel9.add(jPanel12);
        jPanel9.add(jPanel13);
        this.add("North", jPanel);
        this.add("Center", jPanel6);
        this.add("South", jPanel9);
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
    }

    @Override
    void cancel() {
    }

    @Override
    boolean set() {
        int n = 0;
        int n2 = -1;
        boolean bl = false;
        n = JAMManager.setRefreshRateEnable(this.rateEnable);
        n = JAMManager.setRefreshRate(this.rate);
        n = JAMManager.setGraphicsPrimitiveEnable(this.primitiveEnable);
        n = JAMManager.setGraphicsPrimitive(this.primitive);
        n = JAMManager.setNetworkThroughputEnable(this.networkEnable);
        n = JAMManager.setScratchPadThroughputEnable(this.scratchpadEnable);
        n = JAMManager.setOutMemoryThroughputEnable(this.outmemoryEnable);
        n2 = this.networkComboBox.getSelectedIndex();
        n = JAMManager.setNetworkThroughput(Integer.parseInt(networkData[n2]));
        n = JAMManager.setScratchPadThroughput(this.scratchpadSpeed);
        n = JAMManager.setOutMemoryThroughput(this.outmemorySpeed);
        if (n == 0) {
            bl = true;
        }
        return bl;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        JSlider jSlider = (JSlider)changeEvent.getSource();
        if (jSlider == this.rateSlider) {
            this.rate = jSlider.getValue();
            this.rateLabel.setText(this.rate + "(" + Resource.getString("SET_PERFORMANCE_UNIT_FPS") + ")");
        } else if (jSlider == this.primitiveSlider) {
            this.primitive = jSlider.getValue();
            this.primitiveLabel.setText(this.primitive + "(" + Resource.getString("SET_PERFORMANCE_UNIT_MS") + ")");
        } else if (jSlider == this.scratchpadSlider) {
            this.scratchpadSpeed = jSlider.getValue();
            this.scratchpadLabel.setText(this.scratchpadSpeed + " (Mbps)");
        } else if (jSlider == this.outmemorySlider) {
            this.outmemorySpeed = jSlider.getValue();
            this.outmemoryLabel.setText(this.outmemorySpeed + " (Mbps)");
        }
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 1, 0);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getItemSelectable() == this.rateCheckBox) {
            if (itemEvent.getStateChange() == 1) {
                this.rateSlider.setEnabled(true);
                this.rateEnable = 1;
            } else if (itemEvent.getStateChange() == 2) {
                this.rateSlider.setEnabled(false);
                this.rateEnable = 0;
            }
        } else if (itemEvent.getItemSelectable() == this.primitiveCheckBox) {
            if (itemEvent.getStateChange() == 1) {
                this.primitiveSlider.setEnabled(true);
                this.primitiveEnable = 1;
            } else if (itemEvent.getStateChange() == 2) {
                this.primitiveSlider.setEnabled(false);
                this.primitiveEnable = 0;
            }
        } else if (itemEvent.getItemSelectable() == this.networkCheckBox) {
            if (itemEvent.getStateChange() == 1) {
                this.networkComboBox.setEnabled(true);
                this.networkEnable = 1;
            } else if (itemEvent.getStateChange() == 2) {
                this.networkComboBox.setEnabled(false);
                this.networkEnable = 0;
            }
        } else if (itemEvent.getItemSelectable() == this.scratchpadCheckBox) {
            if (itemEvent.getStateChange() == 1) {
                this.scratchpadSlider.setEnabled(true);
                this.scratchpadEnable = 1;
            } else if (itemEvent.getStateChange() == 2) {
                this.scratchpadSlider.setEnabled(false);
                this.scratchpadEnable = 0;
            }
        } else if (itemEvent.getItemSelectable() == this.outmemoryCheckBox) {
            if (itemEvent.getStateChange() == 1) {
                this.outmemorySlider.setEnabled(true);
                this.outmemoryEnable = 1;
            } else if (itemEvent.getStateChange() == 2) {
                this.outmemorySlider.setEnabled(false);
                this.outmemoryEnable = 0;
            }
        }
        if (this.listener != null) {
            this.listener.tabPanelEvent(this, 1, 0);
        }
    }
}

