/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.CustomWindowsComboBoxUI;
import com.nttdocomo.dojaemu.ktoolbar.DecimalDocument;
import com.nttdocomo.dojaemu.ktoolbar.HalfNumberDocument;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.PhoneBookEntry;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.plaf.ComboBoxUI;

class PhoneBookLocationWindow
extends AbstractWindow {
    private MainWindow parent = null;
    private PhoneBookEntry entry = null;
    private static final File phoneBookDir = new File(System.getProperty("emu.home") + File.separator + "lib" + File.separator + "phonebook");
    private JTextField timestampYearField;
    private JTextField timestampMonthField;
    private JTextField timestampDayField;
    private JTextField timestampHourField;
    private JTextField timestampMinuteField;
    private JTextField timestampSecondField;
    private JTextField timestampMilliSecondField;
    private JComboBox latitudeCombo;
    private JComboBox longitudeCombo;
    private String[] latitudePrefixItems = null;
    private String[] longitudePrefixItems = null;
    private JTextField latitudeDegreeField;
    private JTextField latitudeMinuteField;
    private JTextField latitudeSecondField;
    private JTextField latitudeCentiSecondField;
    private JTextField longitudeDegreeField;
    private JTextField longitudeMinuteField;
    private JTextField longitudeSecondField;
    private JTextField longitudeCentiSecondField;
    private JTextField altitudeField;
    private JComboBox datumCombo;
    private String[] datumItems = null;
    private ButtonGroup accuracyLevelButtonGroup;
    private JRadioButton accuracyNoneRadioButton;
    private JRadioButton accuracyCoarseRadioButton;
    private JRadioButton accuracyNormalRadioButton;
    private JRadioButton accuracyFineRadioButton;
    private JButton setButton;
    private JButton deleteButton;
    private JButton cancelButton;
    private String locationTitleId = null;
    private long locationInfoTimestamp = 0L;
    private int locationInfoLevel = 0;
    private String locationInfoLatitude = null;
    private String locationInfoLongitude = null;
    private int locationInfoDatum = 0;
    private final int ACCURACY_LEVEL_1 = Integer.MAX_VALUE;
    private final int ACCURACY_LEVEL_2 = 299;
    private final int ACCURACY_LEVEL_3 = 49;
    private final int ACCURACY_UNKNOWN = -1;

    PhoneBookLocationWindow(MainWindow mainWindow, PhoneBookEntry phoneBookEntry) {
        super(mainWindow, null);
        Object object;
        this.parent = mainWindow;
        this.entry = phoneBookEntry;
        this.addWindowListener();
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        this.setTitle(Resource.getString("LOCATION_INFO_WINDOW_TITLE"));
        this.latitudePrefixItems = new String[3];
        this.latitudePrefixItems[0] = new String("   ");
        this.latitudePrefixItems[1] = new String("N  ");
        this.latitudePrefixItems[2] = new String("S  ");
        this.longitudePrefixItems = new String[3];
        this.longitudePrefixItems[0] = new String("   ");
        this.longitudePrefixItems[1] = new String("E  ");
        this.longitudePrefixItems[2] = new String("W ");
        this.latitudeCombo = new JComboBox<String>(this.latitudePrefixItems);
        this.longitudeCombo = new JComboBox<String>(this.longitudePrefixItems);
        this.latitudeCombo.setUI((ComboBoxUI)((Object)new CustomWindowsComboBoxUI()));
        this.longitudeCombo.setUI((ComboBoxUI)((Object)new CustomWindowsComboBoxUI()));
        this.datumItems = new String[3];
        this.datumItems[0] = new String("     ");
        this.datumItems[1] = new String(Resource.getString("GPS_DATUM_WGS84"));
        this.datumItems[2] = new String(Resource.getString("GPS_DATUM_TOKYO"));
        this.datumCombo = new JComboBox<String>(this.datumItems);
        this.datumCombo.setUI((ComboBoxUI)((Object)new CustomWindowsComboBoxUI()));
        JLabel jLabel = new JLabel(Resource.getString("LOCATION_INFO_TIMESTAMP"));
        JLabel jLabel2 = new JLabel(Resource.getString("GPS_ACCURACY_LEVEL"));
        JLabel jLabel3 = new JLabel(Resource.getString("GPS_LATITUDE"));
        JLabel jLabel4 = new JLabel(Resource.getString("GPS_LONGITUDE"));
        JLabel jLabel5 = new JLabel(Resource.getString("GPS_ALTITUDE"));
        JLabel jLabel6 = new JLabel(Resource.getString("GPS_DATUM_TYPE"));
        JLabel jLabel7 = new JLabel(".");
        JLabel jLabel8 = new JLabel(".");
        JLabel jLabel9 = new JLabel(".");
        JLabel jLabel10 = new JLabel(".");
        JLabel jLabel11 = new JLabel(".");
        JLabel jLabel12 = new JLabel(".");
        JLabel jLabel13 = new JLabel("/");
        JLabel jLabel14 = new JLabel("/");
        JLabel jLabel15 = new JLabel(" ");
        JLabel jLabel16 = new JLabel(":");
        JLabel jLabel17 = new JLabel(":");
        JLabel jLabel18 = new JLabel(".");
        this.setButton = new JButton(Resource.getString("SET"));
        this.deleteButton = new JButton(Resource.getString("DELETE"));
        this.cancelButton = new JButton(Resource.getString("CANCEL"));
        this.accuracyNoneRadioButton = new JRadioButton(Resource.getString("GPS_ACCURACY_NONE"));
        this.accuracyCoarseRadioButton = new JRadioButton("1");
        this.accuracyNormalRadioButton = new JRadioButton("2");
        this.accuracyFineRadioButton = new JRadioButton("3");
        this.accuracyLevelButtonGroup = new ButtonGroup();
        this.accuracyLevelButtonGroup.add(this.accuracyNoneRadioButton);
        this.accuracyLevelButtonGroup.add(this.accuracyCoarseRadioButton);
        this.accuracyLevelButtonGroup.add(this.accuracyNormalRadioButton);
        this.accuracyLevelButtonGroup.add(this.accuracyFineRadioButton);
        try {
            switch (Integer.parseInt(phoneBookEntry.getAccuracy())) {
                case 0x7FFFFFFF: {
                    this.accuracyCoarseRadioButton.setSelected(true);
                    break;
                }
                case 299: {
                    this.accuracyNormalRadioButton.setSelected(true);
                    break;
                }
                case 49: {
                    this.accuracyFineRadioButton.setSelected(true);
                    break;
                }
                default: {
                    this.accuracyNoneRadioButton.setSelected(true);
                    break;
                }
            }
        }
        catch (Exception exception) {
            this.accuracyNoneRadioButton.setSelected(true);
        }
        this.timestampYearField = new JTextField(4);
        this.timestampMonthField = new JTextField(3);
        this.timestampDayField = new JTextField(3);
        this.timestampHourField = new JTextField(3);
        this.timestampMinuteField = new JTextField(3);
        this.timestampSecondField = new JTextField(3);
        this.timestampMilliSecondField = new JTextField(4);
        this.timestampYearField.setDocument(new HalfNumberDocument(4));
        this.timestampMonthField.setDocument(new HalfNumberDocument(2));
        this.timestampDayField.setDocument(new HalfNumberDocument(2));
        this.timestampHourField.setDocument(new HalfNumberDocument(2));
        this.timestampMinuteField.setDocument(new HalfNumberDocument(2));
        this.timestampSecondField.setDocument(new HalfNumberDocument(2));
        this.timestampMilliSecondField.setDocument(new HalfNumberDocument(3));
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        long l = 0L;
        boolean bl = true;
        try {
            l = Long.parseLong(phoneBookEntry.getTimeStamp());
        }
        catch (Exception exception) {
            l = System.currentTimeMillis();
            bl = false;
        }
        if (bl) {
            object = TimeZone.getTimeZone("GMT");
            gregorianCalendar.setTimeZone((TimeZone)object);
        }
        gregorianCalendar.setTime(new Date(l));
        object = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        String string10 = "";
        String string11 = "";
        object = Integer.toString(gregorianCalendar.get(1));
        string6 = Integer.toString(gregorianCalendar.get(2) + 1);
        string7 = Integer.toString(gregorianCalendar.get(5));
        string8 = Integer.toString(gregorianCalendar.get(11));
        string9 = Integer.toString(gregorianCalendar.get(12));
        string10 = Integer.toString(gregorianCalendar.get(13));
        string11 = Integer.toString(gregorianCalendar.get(14));
        this.timestampYearField.setText((String)object);
        this.timestampMonthField.setText(string6);
        this.timestampDayField.setText(string7);
        this.timestampHourField.setText(string8);
        this.timestampMinuteField.setText(string9);
        this.timestampSecondField.setText(string10);
        this.timestampMilliSecondField.setText(string11);
        this.latitudeDegreeField = new JTextField(4);
        this.latitudeMinuteField = new JTextField(3);
        this.latitudeSecondField = new JTextField(3);
        this.latitudeCentiSecondField = new JTextField(4);
        this.latitudeDegreeField.setDocument(new HalfNumberDocument(2));
        this.latitudeMinuteField.setDocument(new HalfNumberDocument(2));
        this.latitudeSecondField.setDocument(new HalfNumberDocument(2));
        this.latitudeCentiSecondField.setDocument(new HalfNumberDocument(3));
        this.latitudeDegreeField.setHorizontalAlignment(4);
        this.latitudeMinuteField.setHorizontalAlignment(4);
        this.latitudeSecondField.setHorizontalAlignment(4);
        this.latitudeCentiSecondField.setHorizontalAlignment(4);
        string = "";
        string2 = "";
        string3 = "";
        string4 = "";
        string5 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(phoneBookEntry.getLatitude(), ".");
        if (stringTokenizer.countTokens() == 4) {
            try {
                string2 = stringTokenizer.nextToken();
                string = string2.substring(0, 1);
                string2 = string2.substring(1);
                string3 = stringTokenizer.nextToken();
                string4 = stringTokenizer.nextToken();
                string5 = stringTokenizer.nextToken();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string.equals("N")) {
            this.latitudeCombo.setSelectedIndex(1);
        } else if (string.equals("S")) {
            this.latitudeCombo.setSelectedIndex(2);
        } else {
            this.latitudeCombo.setSelectedIndex(0);
        }
        this.latitudeDegreeField.setText(string2);
        this.latitudeMinuteField.setText(string3);
        this.latitudeSecondField.setText(string4);
        this.latitudeCentiSecondField.setText(string5);
        this.longitudeDegreeField = new JTextField(4);
        this.longitudeMinuteField = new JTextField(3);
        this.longitudeSecondField = new JTextField(3);
        this.longitudeCentiSecondField = new JTextField(4);
        this.longitudeDegreeField.setDocument(new HalfNumberDocument(3));
        this.longitudeMinuteField.setDocument(new HalfNumberDocument(2));
        this.longitudeSecondField.setDocument(new HalfNumberDocument(2));
        this.longitudeCentiSecondField.setDocument(new HalfNumberDocument(3));
        this.longitudeDegreeField.setHorizontalAlignment(4);
        this.longitudeMinuteField.setHorizontalAlignment(4);
        this.longitudeSecondField.setHorizontalAlignment(4);
        this.longitudeCentiSecondField.setHorizontalAlignment(4);
        string = "";
        string2 = "";
        string3 = "";
        string4 = "";
        string5 = "";
        stringTokenizer = new StringTokenizer(phoneBookEntry.getLongitude(), ".");
        if (stringTokenizer.countTokens() == 4) {
            try {
                string2 = stringTokenizer.nextToken();
                string = string2.substring(0, 1);
                string2 = string2.substring(1);
                string3 = stringTokenizer.nextToken();
                string4 = stringTokenizer.nextToken();
                string5 = stringTokenizer.nextToken();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string.equals("E")) {
            this.longitudeCombo.setSelectedIndex(1);
        } else if (string.equals("W")) {
            this.longitudeCombo.setSelectedIndex(2);
        } else {
            this.longitudeCombo.setSelectedIndex(0);
        }
        this.longitudeDegreeField.setText(string2);
        this.longitudeMinuteField.setText(string3);
        this.longitudeSecondField.setText(string4);
        this.longitudeCentiSecondField.setText(string5);
        this.altitudeField = new JTextField(20);
        this.altitudeField.setDocument(new DecimalDocument(11));
        this.altitudeField.setHorizontalAlignment(4);
        if (phoneBookEntry.getAltitude().length() == 0) {
            this.altitudeField.setText("0");
        } else {
            this.altitudeField.setText(phoneBookEntry.getAltitude());
        }
        try {
            if (Integer.parseInt(phoneBookEntry.getDatum()) == 0) {
                this.datumCombo.setSelectedIndex(1);
            } else if (Integer.parseInt(phoneBookEntry.getDatum()) == 1) {
                this.datumCombo.setSelectedIndex(2);
            } else {
                this.datumCombo.setSelectedIndex(0);
            }
        }
        catch (Exception exception) {
            this.datumCombo.setSelectedIndex(0);
        }
        Container container = this.getContentPane();
        container.setLayout(new FlowLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        JPanel jPanel7 = new JPanel();
        JPanel jPanel8 = new JPanel();
        JPanel jPanel9 = new JPanel();
        JPanel jPanel10 = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel3.setLayout(new GridLayout(6, 1));
        jPanel4.setLayout(new GridLayout(6, 1));
        jPanel6.setLayout(new FlowLayout(0));
        jPanel7.setLayout(new FlowLayout(0));
        jPanel8.setLayout(new FlowLayout(0));
        jPanel9.setLayout(new FlowLayout(0));
        jPanel10.setLayout(new FlowLayout(0));
        jPanel6.add(this.timestampYearField);
        jPanel6.add(jLabel13);
        jPanel6.add(this.timestampMonthField);
        jPanel6.add(jLabel14);
        jPanel6.add(this.timestampDayField);
        jPanel6.add(jLabel15);
        jPanel6.add(this.timestampHourField);
        jPanel6.add(jLabel16);
        jPanel6.add(this.timestampMinuteField);
        jPanel6.add(jLabel17);
        jPanel6.add(this.timestampSecondField);
        jPanel6.add(jLabel18);
        jPanel6.add(this.timestampMilliSecondField);
        jPanel7.add(this.accuracyNoneRadioButton);
        jPanel7.add(this.accuracyCoarseRadioButton);
        jPanel7.add(this.accuracyNormalRadioButton);
        jPanel7.add(this.accuracyFineRadioButton);
        jPanel8.add(this.latitudeCombo);
        jPanel8.add(this.latitudeDegreeField);
        jPanel8.add(jLabel7);
        jPanel8.add(this.latitudeMinuteField);
        jPanel8.add(jLabel8);
        jPanel8.add(this.latitudeSecondField);
        jPanel8.add(jLabel9);
        jPanel8.add(this.latitudeCentiSecondField);
        jPanel9.add(this.longitudeCombo);
        jPanel9.add(this.longitudeDegreeField);
        jPanel9.add(jLabel10);
        jPanel9.add(this.longitudeMinuteField);
        jPanel9.add(jLabel11);
        jPanel9.add(this.longitudeSecondField);
        jPanel9.add(jLabel12);
        jPanel9.add(this.longitudeCentiSecondField);
        jPanel10.add(this.altitudeField);
        jPanel3.add(this.getFlowPanel(jLabel, 2));
        jPanel3.add(this.getFlowPanel(jLabel2, 2));
        jPanel3.add(this.getFlowPanel(jLabel3, 2));
        jPanel3.add(this.getFlowPanel(jLabel4, 2));
        jPanel3.add(this.getFlowPanel(jLabel5, 2));
        jPanel3.add(this.getFlowPanel(jLabel6, 2));
        jPanel4.add(jPanel6);
        jPanel4.add(jPanel7);
        jPanel4.add(jPanel8);
        jPanel4.add(jPanel9);
        jPanel4.add(jPanel10);
        jPanel4.add(this.getFlowPanel(this.datumCombo, 0));
        jPanel5.add(this.setButton);
        jPanel5.add(this.deleteButton);
        jPanel5.add(this.cancelButton);
        jPanel2.add(jPanel3);
        jPanel2.add(jPanel4);
        jPanel.add("North", jPanel2);
        jPanel.add("South", jPanel5);
        container.add(jPanel);
        this.setButton.setActionCommand("set");
        this.deleteButton.setActionCommand("delete");
        this.cancelButton.setActionCommand("cancel");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.setButton.addActionListener(actionDispatcher);
        this.deleteButton.addActionListener(actionDispatcher);
        this.cancelButton.addActionListener(actionDispatcher);
        this.pack();
        this.setResizable(false);
    }

    private long parseTimestamp() {
        String string = this.timestampYearField.getText();
        String string2 = this.timestampMonthField.getText();
        String string3 = this.timestampDayField.getText();
        String string4 = this.timestampHourField.getText();
        String string5 = this.timestampMinuteField.getText();
        String string6 = this.timestampSecondField.getText();
        String string7 = this.timestampMilliSecondField.getText();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        try {
            n = Integer.parseInt(string);
            n2 = Integer.parseInt(string2);
            n3 = Integer.parseInt(string3);
            n4 = Integer.parseInt(string4);
            n5 = Integer.parseInt(string5);
            n6 = Integer.parseInt(string6);
            n7 = Integer.parseInt(string7);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Illegal params.");
        }
        if (n < 1 || n > 9999) {
            throw new IllegalArgumentException("Illegal params.");
        }
        if (n2 < 1 || n2 > 12) {
            throw new IllegalArgumentException("Illegal params.");
        }
        if (n3 < 1 || n3 > 31) {
            throw new IllegalArgumentException("Illegal params.");
        }
        if (n4 < 0 || n4 > 23) {
            throw new IllegalArgumentException("Illegal params.");
        }
        if (n5 < 0 || n5 > 59) {
            throw new IllegalArgumentException("Illegal params.");
        }
        if (n6 < 0 || n6 > 59) {
            throw new IllegalArgumentException("Illegal params.");
        }
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeZone(timeZone);
        gregorianCalendar.set(1, n);
        gregorianCalendar.set(2, n2 - 1);
        if (n3 > gregorianCalendar.getActualMaximum(5)) {
            throw new IllegalArgumentException("Illegal params.");
        }
        gregorianCalendar.set(5, n3);
        gregorianCalendar.set(11, n4);
        gregorianCalendar.set(12, n5);
        gregorianCalendar.set(13, n6);
        gregorianCalendar.set(14, n7);
        long l = gregorianCalendar.getTime().getTime();
        return l;
    }

    private String parseDmsLatitude() {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.latitudeCombo.getSelectedIndex();
        String string = ((String)this.latitudeCombo.getSelectedItem()).trim();
        String string2 = this.latitudeDegreeField.getText();
        String string3 = this.latitudeMinuteField.getText();
        String string4 = this.latitudeSecondField.getText();
        String string5 = this.latitudeCentiSecondField.getText();
        String string6 = null;
        try {
            if (string2.length() != 0) {
                n = Integer.parseInt(string2);
            } else {
                string2 = "  ";
            }
            if (n5 == 2) {
                n = -n;
            }
            if (string3.length() != 0) {
                n2 = Integer.parseInt(string3);
            } else {
                string3 = "  ";
            }
            if (string4.length() != 0) {
                n3 = Integer.parseInt(string4);
            } else {
                string4 = "  ";
            }
            if (string5.length() != 0) {
                n4 = Integer.parseInt(string5);
            } else {
                string5 = "   ";
            }
        }
        catch (Exception exception) {
            bl = true;
        }
        if (!bl) {
            if (n < -90 || n > 90) {
                bl = true;
            } else if (n2 < 0 || n2 > 59) {
                bl = true;
            } else if (n3 < 0 || n3 > 59) {
                bl = true;
            } else if (n4 < 0 || n4 > 999) {
                bl = true;
            } else if (Math.abs(n) == 90 && (n2 != 0 || n3 != 0 || n4 != 0)) {
                bl = true;
            } else {
                if (string2.length() == 1) {
                    string2 = "0" + string2;
                }
                if (string3.length() == 1) {
                    string3 = "0" + string3;
                }
                if (string4.length() == 1) {
                    string4 = "0" + string4;
                }
                if (string5.length() == 1) {
                    string5 = "00" + string5;
                } else if (string5.length() == 2) {
                    string5 = "0" + string5;
                }
                string6 = string + string2 + "." + string3 + "." + string4 + "." + string5;
            }
        }
        return string6;
    }

    private String parseDmsLongitude() {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.longitudeCombo.getSelectedIndex();
        String string = ((String)this.longitudeCombo.getSelectedItem()).trim();
        String string2 = this.longitudeDegreeField.getText();
        String string3 = this.longitudeMinuteField.getText();
        String string4 = this.longitudeSecondField.getText();
        String string5 = this.longitudeCentiSecondField.getText();
        String string6 = null;
        try {
            if (string2.length() != 0) {
                n = Integer.parseInt(string2);
            } else {
                string2 = "   ";
            }
            if (n5 == 2) {
                n = -n;
            }
            if (string3.length() != 0) {
                n2 = Integer.parseInt(string3);
            } else {
                string3 = "  ";
            }
            if (string4.length() != 0) {
                n3 = Integer.parseInt(string4);
            } else {
                string4 = "  ";
            }
            if (string5.length() != 0) {
                n4 = Integer.parseInt(string5);
            } else {
                string5 = "   ";
            }
        }
        catch (Exception exception) {
            bl = true;
        }
        if (!bl) {
            if (n < -180 || n >= 180) {
                bl = true;
            } else if (n2 < 0 || n2 > 59) {
                bl = true;
            } else if (n3 < 0 || n3 > 59) {
                bl = true;
            } else if (n4 < 0 || n4 > 999) {
                bl = true;
            } else if (n == -180 && (n2 != 0 || n3 != 0 || n4 != 0)) {
                bl = true;
            } else {
                if (string2.length() == 1) {
                    string2 = "00" + string2;
                } else if (string2.length() == 2) {
                    string2 = "0" + string2;
                }
                if (string3.length() == 1) {
                    string3 = "0" + string3;
                }
                if (string4.length() == 1) {
                    string4 = "0" + string4;
                }
                if (string5.length() == 1) {
                    string5 = "00" + string5;
                } else if (string5.length() == 2) {
                    string5 = "0" + string5;
                }
                string6 = string + string2 + "." + string3 + "." + string4 + "." + string5;
            }
        }
        return string6;
    }

    private String parseAltitude() {
        String string = this.altitudeField.getText();
        String string2 = null;
        int n = 0;
        try {
            n = Integer.parseInt(string);
            string2 = Integer.toString(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    void set() {
        long l = 0L;
        String string = this.parseDmsLatitude();
        String string2 = this.parseDmsLongitude();
        String string3 = "";
        String string4 = "";
        String string5 = this.parseAltitude();
        try {
            l = this.parseTimestamp();
        }
        catch (Exception exception) {
            this.parent.showDialog(Resource.format("WRNG_VAL_WNG", Resource.getString("LOCATION_INFO_TIMESTAMP")), this, 2);
            return;
        }
        if (string == null) {
            this.parent.showDialog(Resource.format("WRNG_VAL_WNG", Resource.getString("GPS_LATITUDE")), this, 2);
            return;
        }
        if (string2 == null) {
            this.parent.showDialog(Resource.format("WRNG_VAL_WNG", Resource.getString("GPS_LONGITUDE")), this, 2);
            return;
        }
        if (string5 == null) {
            this.parent.showDialog(Resource.format("WRNG_VAL_WNG", Resource.getString("GPS_ALTITUDE")), this, 2);
            return;
        }
        string3 = this.accuracyCoarseRadioButton.isSelected() ? String.valueOf(Integer.MAX_VALUE) : (this.accuracyNormalRadioButton.isSelected() ? String.valueOf(299) : (this.accuracyFineRadioButton.isSelected() ? String.valueOf(49) : String.valueOf(-1)));
        string4 = ((String)this.datumCombo.getSelectedItem()).trim();
        string4 = string4.equals("WGS84") ? "0" : (string4.equals("TOKYO") ? "1" : "-1");
        String string6 = phoneBookDir.getPath() + File.separator + this.entry.getMemoryNo() + "_" + this.entry.getFamilyName() + ".tel";
        try {
            this.entry.setTimeStamp(String.valueOf(l));
            this.entry.setAccuracy(string3);
            this.entry.setLatitude(string);
            this.entry.setLongitude(string2);
            this.entry.setAltitude(string5);
            this.entry.setDatum(string4);
            this.entry.save(string6);
            this.setVisible(false);
            this.dispose();
        }
        catch (IOException iOException) {
            System.err.println(Resource.format("WRITE_ERR", string6));
        }
    }

    void delete() {
        JOptionPane jOptionPane = new JOptionPane(Resource.getString("PHONEBOOK_GPS_DELETE_WNG"), 3, 0);
        JDialog jDialog = jOptionPane.createDialog(this, Resource.getString("CONFIRM"));
        jDialog.setResizable(false);
        jDialog.setVisible(true);
        Object object = jOptionPane.getValue();
        if (object instanceof Integer && (Integer)object == 0) {
            String string = phoneBookDir.getPath() + File.separator + this.entry.getMemoryNo() + "_" + this.entry.getFamilyName() + ".tel";
            try {
                this.entry.setTimeStamp("");
                this.entry.setAccuracy("");
                this.entry.setLatitude("");
                this.entry.setLongitude("");
                this.entry.setAltitude("");
                this.entry.setDatum("");
                this.entry.save(string);
                this.setVisible(false);
                this.dispose();
            }
            catch (IOException iOException) {
                System.err.println(Resource.format("WRITE_ERR", string));
            }
        }
    }

    void cancel() {
        this.setVisible(false);
        this.dispose();
    }

    private JPanel getFlowPanel(JComponent jComponent, int n) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(n));
        jPanel.add(jComponent);
        return jPanel;
    }
}

