/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.PhoneBookEntry;
import com.nttdocomo.dojaemu.ktoolbar.PhoneBookEntryWindow;
import com.nttdocomo.dojaemu.ktoolbar.PhoneBookLocationWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.TabPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

class PhoneBookWindow
extends TabPanel {
    private static final int FRAME_WIDTH = 480;
    private static final int FRAME_HEIGHT = 200;
    private static String[] phoneBookFiles;
    private JTable phoneBookTable;
    private Hashtable phoneBookHash;
    private int[] idList;
    private int next;
    private JScrollPane scrollpane;
    private JButton addButton;
    private JButton editButton;
    private JButton deleteButton;
    private JButton GPSinfoButton;
    private static final File phoneBookDir;

    PhoneBookWindow(AbstractWindow abstractWindow) {
        super(abstractWindow);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.addButton = new JButton(Resource.getString("ADD"));
        this.editButton = new JButton(Resource.getString("EDIT"));
        this.deleteButton = new JButton(Resource.getString("DELETE"));
        this.GPSinfoButton = new JButton(Resource.getString("LOCATION_INFO"));
        this.addButton.setActionCommand("add");
        this.editButton.setActionCommand("edit");
        this.deleteButton.setActionCommand("delete");
        this.GPSinfoButton.setActionCommand("gpsinfo");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.addButton.addActionListener(actionDispatcher);
        this.editButton.addActionListener(actionDispatcher);
        this.deleteButton.addActionListener(actionDispatcher);
        this.GPSinfoButton.addActionListener(actionDispatcher);
        jPanel2.add(this.addButton);
        jPanel2.add(this.editButton);
        jPanel2.add(this.deleteButton);
        jPanel2.add(this.GPSinfoButton);
        this.phoneBookTable = this.createPhoneBookTable();
        this.scrollpane = new JScrollPane(this.phoneBookTable);
        this.add("Center", this.scrollpane);
        this.add("South", jPanel2);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(480, 200);
    }

    private JTable createPhoneBookTable() {
        String string = "";
        phoneBookFiles = phoneBookDir.list(new PhoneBookFilter());
        String[] stringArray = new String[phoneBookFiles.length];
        this.phoneBookHash = new Hashtable();
        for (int i = 0; i < phoneBookFiles.length; ++i) {
            String string2 = phoneBookDir.getPath() + File.separator + phoneBookFiles[i];
            int n = phoneBookFiles[i].indexOf(95);
            try {
                int n2 = Integer.parseInt(phoneBookFiles[i].substring(0, n));
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            try {
                PhoneBookEntry phoneBookEntry = new PhoneBookEntry();
                phoneBookEntry.load(string2);
                this.phoneBookHash.put(new Integer(phoneBookEntry.getMemoryNo()), phoneBookEntry);
                continue;
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println(Resource.format("NOT_FOUND_ERR", string2));
                continue;
            }
            catch (IOException iOException) {
                System.err.println(Resource.format("READ_ERR", string2));
            }
        }
        this.idList = new int[this.phoneBookHash.size()];
        Enumeration enumeration = this.phoneBookHash.keys();
        for (int i = 0; i < this.idList.length; ++i) {
            this.idList[i] = (Integer)enumeration.nextElement();
        }
        Arrays.sort(this.idList);
        this.next = this.idList.length > 0 ? this.idList[this.idList.length - 1] + 1 : 1;
        String[] stringArray2 = new String[]{Resource.getString("PHONEBOOK_ENTRY_ID"), Resource.getString("PHONEBOOK_NAME"), Resource.getString("PHONEBOOK_KANA"), Resource.getString("PHONEBOOK_GROUP_ID"), Resource.getString("LOCATION_INFO")};
        PhoneBookTableModel phoneBookTableModel = new PhoneBookTableModel(stringArray2, 0);
        for (int i = 0; i < this.idList.length; ++i) {
            PhoneBookEntry phoneBookEntry = null;
            Object v = this.phoneBookHash.get(new Integer(this.idList[i]));
            if (v == null || !(v instanceof PhoneBookEntry)) continue;
            phoneBookEntry = (PhoneBookEntry)v;
            Vector<String> vector = new Vector<String>();
            vector.addElement(phoneBookEntry.getMemoryNo());
            vector.addElement(phoneBookEntry.getFamilyName() + " " + phoneBookEntry.getGivenName());
            vector.addElement(phoneBookEntry.getFamilyKana() + " " + phoneBookEntry.getGivenKana());
            vector.addElement(phoneBookEntry.getGroupID());
            String string3 = "";
            if (!phoneBookEntry.getTimeStamp().equals("")) {
                string3 = Resource.getString("SET_LOCATION_OK");
            }
            vector.addElement(string3);
            phoneBookTableModel.addRow(vector);
        }
        JTable jTable = new JTable(phoneBookTableModel);
        jTable.getTableHeader().setReorderingAllowed(false);
        jTable.getTableHeader().setResizingAllowed(false);
        jTable.setDefaultRenderer(Object.class, new PhoneBookTableCellRenderer());
        jTable.setSelectionMode(0);
        this.changeButtonEnabled();
        jTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    PhoneBookWindow.this.edit();
                }
            }
        });
        jTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    PhoneBookWindow.this.edit();
                }
            }
        });
        return jTable;
    }

    void add() {
        PhoneBookEntry phoneBookEntry = new PhoneBookEntry();
        phoneBookEntry.setMemoryNo(new Integer(this.next).toString());
        PhoneBookEntryWindow phoneBookEntryWindow = new PhoneBookEntryWindow(this.parent, phoneBookEntry, "PHONEBOOK_ENTRY_WINDOW_TITLE");
        phoneBookEntryWindow.setLocation(this.parent.getShowLocation(phoneBookEntryWindow.getWidth(), phoneBookEntryWindow.getHeight(), this.tabwin));
        phoneBookEntryWindow.setVisible(true);
        this.updateTable();
    }

    void edit() {
        int n = this.phoneBookTable.getSelectedRow();
        if (n != -1 && n < this.idList.length) {
            Object v = this.phoneBookHash.get(new Integer(this.idList[n]));
            PhoneBookEntry phoneBookEntry = null;
            if (v instanceof PhoneBookEntry) {
                phoneBookEntry = (PhoneBookEntry)v;
            }
            PhoneBookEntryWindow phoneBookEntryWindow = new PhoneBookEntryWindow(this.parent, phoneBookEntry, "PHONEBOOK_EDIT_WINDOW_TITLE");
            phoneBookEntryWindow.setLocation(this.parent.getShowLocation(phoneBookEntryWindow.getWidth(), phoneBookEntryWindow.getHeight(), this.tabwin));
            phoneBookEntryWindow.setVisible(true);
            this.updateTable();
        }
    }

    void delete() {
        int n = this.phoneBookTable.getSelectedRow();
        if (n != -1) {
            JOptionPane jOptionPane = new JOptionPane(Resource.getString("PHONEBOOK_DELETE_WNG"), 3, 0);
            JDialog jDialog = jOptionPane.createDialog(this, Resource.getString("CONFIRM"));
            jDialog.setResizable(false);
            jDialog.setVisible(true);
            Object object = jOptionPane.getValue();
            if (object instanceof Integer && (Integer)object == 0) {
                String string = String.valueOf(this.idList[n]) + "_" + ((PhoneBookEntry)this.phoneBookHash.get(new Integer(this.idList[n]))).getFamilyName() + ".tel";
                File file = new File(phoneBookDir, string);
                file.delete();
                this.updateTable();
            }
        }
    }

    void gpsinfo() {
        int n = this.phoneBookTable.getSelectedRow();
        if (n != -1) {
            PhoneBookEntry phoneBookEntry = (PhoneBookEntry)this.phoneBookHash.get(new Integer(this.idList[n]));
            PhoneBookLocationWindow phoneBookLocationWindow = new PhoneBookLocationWindow(this.parent, phoneBookEntry);
            phoneBookLocationWindow.setLocation(this.parent.getShowLocation(phoneBookLocationWindow.getWidth(), phoneBookLocationWindow.getHeight(), this.tabwin));
            phoneBookLocationWindow.setVisible(true);
            this.updateTable();
        }
    }

    void updateTable() {
        this.setVisible(false);
        this.remove(this.scrollpane);
        this.scrollpane = null;
        this.phoneBookTable = null;
        this.phoneBookTable = this.createPhoneBookTable();
        this.scrollpane = new JScrollPane(this.phoneBookTable);
        this.add("Center", this.scrollpane);
        this.setVisible(true);
    }

    @Override
    void cancel() {
    }

    @Override
    boolean set() {
        return true;
    }

    private void changeButtonEnabled() {
        if (this.idList != null && this.idList.length > 0) {
            this.editButton.setEnabled(true);
            this.deleteButton.setEnabled(true);
            this.GPSinfoButton.setEnabled(true);
        } else {
            this.editButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.GPSinfoButton.setEnabled(false);
        }
    }

    static {
        phoneBookDir = new File(System.getProperty("emu.home") + File.separator + "lib" + File.separator + "phonebook");
    }

    class PhoneBookTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        PhoneBookTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            switch (n2) {
                case 4: {
                    this.setHorizontalAlignment(0);
                    break;
                }
                default: {
                    this.setHorizontalAlignment(2);
                }
            }
            if (bl) {
                this.setBackground(Color.black);
                this.setForeground(Color.white);
            } else {
                if (n % 2 == 0) {
                    this.setBackground(Color.white);
                } else {
                    this.setBackground(new Color(238, 238, 238));
                }
                this.setForeground(Color.black);
            }
            this.setText((String)object);
            return this;
        }
    }

    class PhoneBookFilter
    implements FilenameFilter {
        PhoneBookFilter() {
        }

        @Override
        public boolean accept(File file, String string) {
            if (file.equals(phoneBookDir)) {
                return string.endsWith(".tel");
            }
            return false;
        }
    }

    class PhoneBookTableModel
    extends DefaultTableModel {
        PhoneBookTableModel(String[] stringArray, int n) {
            super(stringArray, n);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

