/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.CustomWindowsComboBoxUI;
import com.nttdocomo.dojaemu.ktoolbar.HalfNumberDocument;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.PhysicalActivityEntry;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.plaf.ComboBoxUI;

public class PhysicalActivityBasicInfoWindows
extends AbstractWindow {
    private static final String[] LIST_INTERVAL = new String[]{"60", "120", "180", "240", "300", "360", "480", "540", "600", "720", "900", "960", "1080", "1200", "1440", "1800", "1920", "2160", "2400", "2700", "2880", "3600", "4320", "4800", "5400", "5760", "7200", "8640", "9600", "10800", "14400", "17280", "21600", "28800", "43200", "86400"};
    private static final int MAX_LEN_DATE_YEAR = 4;
    private static final int MAX_LEN_DATE_MONTH = 2;
    private static final int MAX_LEN_DATE_DAY = 2;
    private static final int DATE_YEAR_WIDTH = 6;
    private static final int DATE_MONTH_WIDTH = 4;
    private static final int DATE_DAY_WIDTH = 4;
    private static final int ENABLED_WIDTH = 100;
    private static final int CMB_HEIGHT = 20;
    private static final int FLOW_HGAP = 10;
    private static final int FLOW_VGAP = 10;
    private static final int DAY_SECOND = 86400;
    private static final int YEAR_MAX = 9999;
    private static final int MONTH_MAX = 12;
    private static final int DAY_MAX = 31;
    private static final int DATE_MIN = 1;
    private JButton setButton = null;
    private JButton cancelButton = null;
    private JTextField txtDateYear = null;
    private JTextField txtDateMonth = null;
    private JTextField txtDateDay = null;
    private JComboBox cmbInterval = null;
    private Hashtable dispData = null;
    private PhysicalActivityEntry entry = null;

    public PhysicalActivityBasicInfoWindows(MainWindow mainWindow, Hashtable hashtable, PhysicalActivityEntry physicalActivityEntry) {
        super(mainWindow, Resource.getString("PHYSICAL_BASIC_INFO_WINDOW_TITLE"));
        this.parent = mainWindow;
        this.dispData = hashtable;
        this.entry = physicalActivityEntry;
        this.addWindowListener();
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        JPanel jPanel7 = new JPanel();
        JPanel jPanel8 = new JPanel();
        JPanel jPanel9 = new JPanel();
        JLabel jLabel = new JLabel(Resource.getString("PHYSICAL_LBL_DATE"));
        JLabel jLabel2 = new JLabel(" " + Resource.getString("YEAR") + " ");
        JLabel jLabel3 = new JLabel(" " + Resource.getString("MONTH") + " ");
        JLabel jLabel4 = new JLabel(" " + Resource.getString("DAY") + " ");
        JLabel jLabel5 = new JLabel(Resource.getString("PHYSICAL_E_LBL_INTERVAL"));
        JLabel jLabel6 = new JLabel(Resource.getString("PHYSICAL_E_LBL_INTERVAL_UNIT"));
        this.txtDateYear = new JTextField(6);
        this.txtDateYear.setDocument(new HalfNumberDocument(4));
        this.txtDateMonth = new JTextField(4);
        this.txtDateMonth.setDocument(new HalfNumberDocument(2));
        this.txtDateDay = new JTextField(4);
        this.txtDateDay.setDocument(new HalfNumberDocument(2));
        this.cmbInterval = new JComboBox<String>(LIST_INTERVAL);
        this.cmbInterval.setUI((ComboBoxUI)((Object)new CustomWindowsComboBoxUI()));
        this.cmbInterval.setPreferredSize(new Dimension(100, 20));
        this.setButton = new JButton(Resource.getString("SET"));
        this.cancelButton = new JButton(Resource.getString("CANCEL"));
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel2.setLayout(new GridLayout(1, 1));
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel5.setLayout(new FlowLayout(0, 10, 10));
        jPanel6.setLayout(new FlowLayout(0, 10, 10));
        jPanel7.setLayout(new FlowLayout(0, 10, 10));
        jPanel8.setLayout(new FlowLayout(0, 10, 10));
        jPanel9.setLayout(new FlowLayout(1));
        jPanel5.add(jLabel);
        jPanel6.add(jLabel5);
        jPanel3.add(jPanel5);
        jPanel3.add(jPanel6);
        jPanel7.add(this.txtDateYear);
        jPanel7.add(jLabel2);
        jPanel7.add(this.txtDateMonth);
        jPanel7.add(jLabel3);
        jPanel7.add(this.txtDateDay);
        jPanel7.add(jLabel4);
        jPanel8.add(this.cmbInterval);
        jPanel8.add(jLabel6);
        jPanel4.add(jPanel7);
        jPanel4.add(jPanel8);
        jPanel.add("West", jPanel3);
        jPanel.add("Center", jPanel4);
        jPanel9.add(this.setButton);
        jPanel9.add(this.cancelButton);
        jPanel2.add(jPanel9);
        container.add("North", jPanel);
        container.add("South", jPanel2);
        this.setButton.setActionCommand("set");
        this.cancelButton.setActionCommand("cancel");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.setButton.addActionListener(actionDispatcher);
        this.cancelButton.addActionListener(actionDispatcher);
        this.pack();
        this.setResizable(false);
    }

    public boolean set() {
        if (!this.inputCheaker()) {
            return false;
        }
        String string = this.txtDateYear.getText();
        String string2 = this.txtDateMonth.getText();
        String string3 = this.txtDateDay.getText();
        int n = Integer.parseInt(string);
        int n2 = Integer.parseInt(string2);
        int n3 = Integer.parseInt(string3);
        Calendar calendar = Calendar.getInstance();
        calendar.set(n, n2 - 1, n3, 0, 0);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd");
        String string4 = simpleDateFormat.format(calendar.getTime());
        Hashtable hashtable = this.entry.getData();
        if (hashtable != null && hashtable.containsKey(string4)) {
            this.parent.showDialog(Resource.getString("PHYSICAL_VAL_DATE_DUPLICATION"), this, 2);
            return false;
        }
        int n4 = this.cmbInterval.getSelectedIndex();
        String string5 = LIST_INTERVAL[n4];
        int n5 = Integer.parseInt(string5);
        int n6 = PhysicalActivityEntry.getNumOfFilter();
        int n7 = 86400 / n5 * n6;
        String[][] stringArray = new String[n7 / n6][1 + n6];
        calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("HH:mm");
        calendar.set(11, 0);
        calendar.set(12, 0);
        for (int i = 0; i < n7 / n6; ++i) {
            stringArray[i][0] = simpleDateFormat2.format(calendar.getTime());
            for (int j = 0; j < n6; ++j) {
                stringArray[i][1 + j] = "0";
            }
            calendar.add(13, n5);
        }
        this.dispData.put("EXERCISE_DATA", stringArray);
        this.dispData.put("EXERCISESIZE", new Integer(n7));
        this.dispData.put("INTERVAL", string5);
        this.dispData.put("EXERCISE_DATE", string4);
        this.dispData.put("YEAR", string);
        this.dispData.put("MONTH", string2);
        this.dispData.put("DATE", string3);
        this.setVisible(false);
        this.dispose();
        return true;
    }

    public void cancel() {
        this.setVisible(false);
        this.dispose();
    }

    private boolean inputCheaker() {
        String string = this.txtDateYear.getText();
        String string2 = this.txtDateMonth.getText();
        String string3 = this.txtDateDay.getText();
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0 || string3 == null || string3.length() == 0) {
            this.parent.showDialog(Resource.format("PHYSICAL_VAL_NOT_INPUT_WNG", Resource.getString("PHYSICAL_LBL_DATE")), this, 2);
            return false;
        }
        try {
            this.parse(string, string2, string3);
        }
        catch (Exception exception) {
            this.parent.showDialog(Resource.getString("PHYSICAL_VAL_DATE_INVALID_FORMAT"), this, 2);
            return false;
        }
        return true;
    }

    private Date parse(String string, String string2, String string3) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        try {
            n = Integer.parseInt(string);
            n2 = Integer.parseInt(string2);
            n3 = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Illegal params.");
        }
        if (n < 1 || n > 9999) {
            throw new IllegalArgumentException("Illegal params.");
        }
        if (n2 < 1 || n2 > 12) {
            throw new IllegalArgumentException("Illegal params.");
        }
        if (n3 < 1 || n3 > 31) {
            throw new IllegalArgumentException("Illegal params.");
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1, n);
        gregorianCalendar.set(2, n2 - 1);
        if (n3 > gregorianCalendar.getActualMaximum(5)) {
            throw new IllegalArgumentException("Illegal params.");
        }
        gregorianCalendar.set(5, n3);
        return gregorianCalendar.getTime();
    }
}

