/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher2;
import com.nttdocomo.dojaemu.ktoolbar.PlaylistBean;
import com.nttdocomo.dojaemu.ktoolbar.PlaylistEditWindow;
import com.nttdocomo.dojaemu.ktoolbar.PlaylistManager;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.TabPanel;
import com.nttdocomo.dojaemu.ktoolbar.swing.JButtonUtil;
import com.nttdocomo.dojaemu.ktoolbar.swing.JTableUtil;
import com.nttdocomo.dojaemu.ktoolbar.swing.WidthBean;
import java.awt.BorderLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class PlaylistWindow
extends TabPanel {
    private JTableUtil jtu;
    private static final int DIMENSION_HEIGHT = 500;
    private static final int DIMENSION_WIDTH = 200;
    private JTable tablePlaylist;
    private JScrollPane scrollPane;
    private JPanel alignPanel;
    private JButton buttonAdd;
    private JButton buttonEdit;
    private JButton buttonDelete;
    private List<PlaylistBean> playlistBeanList = null;
    private static final int COLUMN_WIDTH = 200;

    PlaylistWindow(AbstractWindow abstractWindow) {
        super(abstractWindow);
        this.setLayout(new BorderLayout());
        ActionDispatcher2 actionDispatcher2 = new ActionDispatcher2(this);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.buttonAdd = JButtonUtil.createBasicButton(Resource.getString("ADD"), "add", actionDispatcher2);
        jPanel2.add(this.buttonAdd);
        this.buttonEdit = JButtonUtil.createBasicButton(Resource.getString("EDIT"), "edit", actionDispatcher2);
        jPanel2.add(this.buttonEdit);
        this.buttonDelete = JButtonUtil.createBasicButton(Resource.getString("DELETE"), "delete", actionDispatcher2);
        jPanel2.add(this.buttonDelete);
        this.playlistBeanList = PlaylistManager.allPlaylistFind();
        this.createPlaylistTable();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.alignPanel = new JPanel();
        this.alignPanel.setBorder(new TitledBorder(new EtchedBorder(), ""));
        this.alignPanel.add(this.scrollPane);
        jPanel.add(this.alignPanel);
        this.add("Center", jPanel);
        this.add("South", jPanel2);
        this.changeButtonEnabled();
    }

    private List<Vector<String>> convertData(List<PlaylistBean> list) {
        ArrayList<Vector<String>> arrayList = new ArrayList<Vector<String>>();
        for (int i = 0; i < list.size(); ++i) {
            Vector<String> vector = new Vector<String>();
            try {
                vector.addElement(PlaylistManager.getPlaylistFileNameWithoutExt(list.get(i).getFileName()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            arrayList.add(vector);
        }
        return arrayList;
    }

    private void createPlaylistTable() {
        String[] stringArray = new String[]{Resource.getString("MusicPlayer.common.caption.playlistTitle")};
        ArrayList<WidthBean> arrayList = new ArrayList<WidthBean>();
        arrayList.add(new WidthBean(200, 200));
        this.jtu = new JTableUtil();
        this.tablePlaylist = this.jtu.createBasicTable(stringArray, arrayList, 0, this.convertData(this.playlistBeanList));
        this.tablePlaylist.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    PlaylistWindow.this.edit();
                }
            }
        });
        this.tablePlaylist.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    PlaylistWindow.this.edit();
                }
            }
        });
        this.scrollPane = JTableUtil.createBasicScrollPane(this.tablePlaylist, 200, 500);
    }

    private void updatePlaylistTable() {
        this.setVisible(false);
        this.alignPanel.remove(this.scrollPane);
        this.tablePlaylist = this.jtu.updateBasicTable(this.convertData(this.playlistBeanList));
        this.scrollPane = JTableUtil.createBasicScrollPane(this.tablePlaylist, 200, 500);
        this.alignPanel.add(this.scrollPane);
        this.setVisible(true);
    }

    void add() {
        PlaylistEditWindow playlistEditWindow = new PlaylistEditWindow(this.parent, this);
        playlistEditWindow.setLocation(this.parent.getShowLocation(playlistEditWindow.getWidth(), playlistEditWindow.getHeight(), this.tabwin));
        playlistEditWindow.setVisible(true);
        if (!playlistEditWindow.isCanceled()) {
            this.playlistBeanList.add(playlistEditWindow.getPlaylistBean());
            this.updatePlaylistTable();
        }
        this.changeButtonEnabled();
    }

    void edit() {
        int[] nArray = this.tablePlaylist.getSelectedRows();
        if (this.tablePlaylist.getSelectedRowCount() == 1) {
            PlaylistBean playlistBean = this.playlistBeanList.get(nArray[0]);
            PlaylistEditWindow playlistEditWindow = new PlaylistEditWindow(this.parent, this, playlistBean);
            playlistEditWindow.setLocation(this.parent.getShowLocation(playlistEditWindow.getWidth(), playlistEditWindow.getHeight(), this.tabwin));
            playlistEditWindow.setVisible(true);
            if (!playlistEditWindow.isCanceled()) {
                this.updatePlaylistTable();
            }
        }
        this.changeButtonEnabled();
    }

    void delete() {
        int[] nArray = this.tablePlaylist.getSelectedRows();
        if (this.tablePlaylist.getSelectedRowCount() == 1) {
            JOptionPane jOptionPane = new JOptionPane(Resource.getString("MusicPlayer.common.message.delete.info.playlist"), 3, 0);
            JDialog jDialog = jOptionPane.createDialog(this, Resource.getString("CONFIRM"));
            jDialog.setResizable(false);
            jDialog.setVisible(true);
            Object object = jOptionPane.getValue();
            if (object instanceof Integer && (Integer)object == 0) {
                try {
                    PlaylistManager.delete(this.playlistBeanList.get(nArray[0]));
                    this.playlistBeanList.remove(nArray[0]);
                    this.updatePlaylistTable();
                }
                catch (Exception exception) {
                    System.err.println(Resource.format("WRITE_ERR", this.playlistBeanList.get(nArray[0]).getFileName()));
                }
            }
        }
        this.changeButtonEnabled();
    }

    @Override
    void cancel() {
    }

    @Override
    boolean set() {
        return true;
    }

    private void changeButtonEnabled() {
        if (this.playlistBeanList != null && this.playlistBeanList.size() > 0) {
            this.buttonEdit.setEnabled(true);
            this.buttonDelete.setEnabled(true);
        } else {
            this.buttonEdit.setEnabled(false);
            this.buttonDelete.setEnabled(false);
        }
    }

    public List<PlaylistBean> getPlaylistBeanList() {
        return this.playlistBeanList;
    }
}

