/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.ProjectExplorerList;
import com.nttdocomo.dojaemu.ktoolbar.ProjectExplorerTree;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

class ProjectExplorerMain
extends JSplitPane {
    private MainWindow parent;
    private ProjectExplorerTree[] dirTree;
    private ProjectExplorerList fileList;
    private int idx = 0;

    ProjectExplorerMain(MainWindow mainWindow) {
        super(1);
        this.parent = mainWindow;
        this.dirTree = new ProjectExplorerTree[3];
        this.dirTree[0] = new ProjectExplorerTree(this);
        this.dirTree[1] = new ProjectExplorerTree(this);
        this.dirTree[2] = new ProjectExplorerTree(this);
        this.fileList = new ProjectExplorerList(this);
        this.createPane();
    }

    private void createPane() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2, 0, 0));
        jPanel.setBackground(Color.WHITE);
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 2, 0, 10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 16;
        jPanel.add((Component)this.dirTree[0], gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        jPanel.add((Component)this.dirTree[1], gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        jPanel.add((Component)this.dirTree[2], gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints.weighty = 100.0;
        jPanel2.setBackground(Color.WHITE);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        JScrollPane jScrollPane2 = new JScrollPane(this.fileList);
        this.setTopComponent(jScrollPane);
        this.setBottomComponent(jScrollPane2);
    }

    void createTree(String string) {
        if (this.parent.isMiniFullApp()) {
            String string2 = this.parent.getFullAppProjectName();
            String string3 = this.parent.getMiniAppProjectName();
            this.dirTree[1].setMiniFullIcon(this.parent.getProjectHome(), string2);
            this.dirTree[2].setMiniFullIcon(this.parent.getProjectHome(), string3);
            this.updateTree(string2, 1);
            this.updateTree(string3, 2);
            this.dirTree[1].clearSelection();
            this.dirTree[2].clearSelection();
            this.dirTree[0].setMiniFullIcon(this.parent.getProjectHome(), this.parent.getProjectName());
            this.updateTree(string, 0);
        } else {
            this.clearTree(1);
            this.clearTree(2);
            this.updateTree(string, 0);
            this.dirTree[0].setTreeIcon();
        }
    }

    void updateTree(String string) {
        if (this.parent.isMiniFullApp()) {
            if (this.parent.isFullAppUnderMiniFullApp(string)) {
                this.updateTree(string, 1);
            } else if (this.parent.isMiniAppUnderMiniFullApp(string)) {
                this.updateTree(string, 2);
            } else {
                this.updateTree(string, 0);
            }
        } else {
            this.updateTree(string, 0);
        }
    }

    void updateTree(String string, int n) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.dirTree[n].getModel();
        if (MainWindow.IS_OVER_JRE14) {
            defaultTreeModel.setRoot(null);
        }
        this.updateList("", "");
        if (string == null) {
            return;
        }
        if (string.length() == 0) {
            return;
        }
        File file = new File(this.parent.getProjectHome() + File.separator + string);
        this.dirTree[n].setRoot(file);
        if (file.exists()) {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
            this.dirTree[n].createNodes(defaultMutableTreeNode, file);
            defaultTreeModel.setRoot(defaultMutableTreeNode);
        }
        this.dirTree[n].setSelectionRow(0);
        this.dirTree[n].expandedState(true);
        this.dirTree[n].expandedState(false);
        this.dirTree[n].repaint();
    }

    void clearTree(int n) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.dirTree[n].getModel();
        if (MainWindow.IS_OVER_JRE14) {
            defaultTreeModel.setRoot(null);
        }
        this.dirTree[n].repaint();
    }

    void resetSelection(String string) {
        if (string == null) {
            return;
        }
        if (string.length() == 0) {
            return;
        }
        if (this.parent.isMiniFullApp()) {
            if (this.parent.isFullAppUnderMiniFullApp(string)) {
                this.dirTree[0].clearSelection();
                this.dirTree[2].clearSelection();
            } else if (this.parent.isMiniAppUnderMiniFullApp(string)) {
                this.dirTree[0].clearSelection();
                this.dirTree[1].clearSelection();
            } else {
                this.dirTree[1].clearSelection();
                this.dirTree[2].clearSelection();
            }
        }
    }

    void updateTree() {
        int n;
        TreePath treePath = this.dirTree[this.idx].getSelectionPath();
        Vector<TreePath> vector = new Vector<TreePath>();
        for (int i = 0; i < this.dirTree[this.idx].getRowCount(); ++i) {
            vector.addElement(this.dirTree[this.idx].getPathForRow(i));
        }
        String string = this.dirTree[this.idx].getRoot().getName();
        this.updateTree(string);
        this.dirTree[this.idx].expandedState(true);
        this.dirTree[this.idx].treeClose(vector);
        Vector<TreePath> vector2 = new Vector<TreePath>();
        for (n = 0; n < this.dirTree[this.idx].getRowCount(); ++n) {
            vector2.addElement(this.dirTree[this.idx].getPathForRow(n));
        }
        for (n = 0; n < vector2.size(); ++n) {
            TreePath treePath2 = (TreePath)vector2.get(n);
            if (!treePath2.toString().equals(treePath.toString())) continue;
            this.dirTree[this.idx].setSelectionRow(n);
        }
        this.dirTree[this.idx].repaint();
    }

    String getProjectHome() {
        return this.parent.getProjectHome();
    }

    void updateList(String string, String string2) {
        this.fileList.update(string, string2);
    }

    MainWindow getMainWindow() {
        return this.parent;
    }

    void showDialog(Component component, String string) {
        JOptionPane jOptionPane = new JOptionPane(string, 2);
        if (component == null) {
            component = this;
        }
        JDialog jDialog = jOptionPane.createDialog(component, Resource.getString("WNG"));
        jDialog.setResizable(false);
        jDialog.setVisible(true);
    }

    int showQuestionDialog(Component component, String string) {
        Object[] objectArray = new Object[]{Resource.getString("OK"), Resource.getString("CANCEL")};
        JOptionPane jOptionPane = new JOptionPane(string, 3, 2, null, objectArray);
        if (component == null) {
            component = this;
        }
        JDialog jDialog = jOptionPane.createDialog(component, Resource.getString("CONFIRM"));
        jDialog.setResizable(false);
        jDialog.setVisible(true);
        Object object = jOptionPane.getValue();
        if (object != null) {
            if (object.toString().equals(objectArray[0].toString())) {
                return 0;
            }
            return 2;
        }
        return 2;
    }
}

