/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.NativeDataEditWindow;
import com.nttdocomo.dojaemu.ktoolbar.PulsemeterEntryWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.TabPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

class PulsemeterWindow
extends TabPanel {
    private static final int DIMENSION_HEIGHT = 500;
    private static final int DIMENSION_WIDTH = 200;
    private static final String PULSEMETER_PATH = System.getProperty("emu.home") + File.separator + "lib" + File.separator + "pulsemeter" + File.separator + "pulsemeter.dat";
    private static List<Integer> pulseRates = new ArrayList<Integer>();
    private JTable pulsemeterTable;
    private JScrollPane scrollpane;
    private JPanel alignPanel;
    private JButton addButton;
    private JButton editButton;
    private JButton deleteButton;

    PulsemeterWindow(AbstractWindow abstractWindow) {
        super(abstractWindow);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.addButton = new JButton(Resource.getString("ADD"));
        this.editButton = new JButton(Resource.getString("EDIT"));
        this.deleteButton = new JButton(Resource.getString("DELETE"));
        this.addButton.setActionCommand("add");
        this.editButton.setActionCommand("edit");
        this.deleteButton.setActionCommand("delete");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.addButton.addActionListener(actionDispatcher);
        this.editButton.addActionListener(actionDispatcher);
        this.deleteButton.addActionListener(actionDispatcher);
        jPanel2.add(this.addButton);
        jPanel2.add(this.editButton);
        jPanel2.add(this.deleteButton);
        this.load();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.alignPanel = new JPanel();
        this.alignPanel.setBorder(new TitledBorder(new EtchedBorder(), ""));
        this.createTable();
        jPanel.add(this.alignPanel);
        this.add("Center", jPanel);
        this.add("South", jPanel2);
    }

    private void load() {
        pulseRates.clear();
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(PULSEMETER_PATH)));
            while ((string = bufferedReader.readLine()) != null) {
                pulseRates.add(new Integer(string));
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void save() {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(PULSEMETER_PATH)));
            for (int i = 0; i < pulseRates.size(); ++i) {
                bufferedWriter.write(pulseRates.get(i).toString() + "\n");
            }
            bufferedWriter.close();
        }
        catch (Exception exception) {
            this.parent.showDialog(Resource.format("WRITE_ERR", Resource.getString("PULSE_RATE")), this.parent, 2);
        }
    }

    private JTable createPulsemeterTable() {
        String[] stringArray = new String[]{Resource.getString("PULSE_RATE")};
        PulsemeterTableModel pulsemeterTableModel = new PulsemeterTableModel(stringArray, 0);
        for (int i = 0; i < pulseRates.size(); ++i) {
            Vector<String> vector = new Vector<String>();
            Integer n = pulseRates.get(i);
            vector.addElement(n.toString());
            pulsemeterTableModel.addRow(vector);
        }
        JTable jTable = new JTable(pulsemeterTableModel);
        jTable.getTableHeader().setReorderingAllowed(false);
        jTable.getTableHeader().setResizingAllowed(false);
        jTable.setDefaultRenderer(Object.class, new PulsemeterTableCellRenderer());
        jTable.setSelectionMode(2);
        this.changeButtonEnabled();
        jTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    PulsemeterWindow.this.edit();
                }
            }
        });
        jTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    PulsemeterWindow.this.edit();
                }
            }
        });
        return jTable;
    }

    void add() {
        PulsemeterEntryWindow pulsemeterEntryWindow = new PulsemeterEntryWindow(this.parent, -2, Resource.getString("SET_PULSEMETER"));
        pulsemeterEntryWindow.setLocation(this.parent.getShowLocation(pulsemeterEntryWindow.getWidth(), pulsemeterEntryWindow.getHeight(), this.tabwin));
        pulsemeterEntryWindow.setVisible(true);
        int n = pulsemeterEntryWindow.getPulseRate();
        if (n == -2) {
            return;
        }
        pulseRates.add(n);
        this.save();
        this.updateTable();
    }

    void edit() {
        int n = this.pulsemeterTable.getSelectedRow();
        if (n == -1) {
            return;
        }
        Integer n2 = pulseRates.get(n);
        PulsemeterEntryWindow pulsemeterEntryWindow = new PulsemeterEntryWindow(this.parent, n2, Resource.getString("SET_PULSEMETER"));
        pulsemeterEntryWindow.setLocation(this.parent.getShowLocation(pulsemeterEntryWindow.getWidth(), pulsemeterEntryWindow.getHeight(), this.tabwin));
        pulsemeterEntryWindow.setVisible(true);
        int n3 = pulsemeterEntryWindow.getPulseRate();
        if (n3 == -2) {
            return;
        }
        pulseRates.remove(n);
        pulseRates.add(n, n3);
        this.save();
        this.updateTable();
    }

    void delete() {
        int[] nArray = this.pulsemeterTable.getSelectedRows();
        if (this.pulsemeterTable.getSelectedRowCount() == 0) {
            return;
        }
        int n = JOptionPane.showConfirmDialog(this, Resource.format("PULSEMETER_DELETE_WNG", String.valueOf(this.pulsemeterTable.getSelectedRowCount())), Resource.getString("CONFIRM"), 0);
        if (n == 0) {
            for (int i = 0; i < this.pulsemeterTable.getSelectedRowCount(); ++i) {
                pulseRates.remove(nArray[i] - i);
            }
            this.save();
            this.updateTable();
        }
    }

    private void createTable() {
        this.pulsemeterTable = this.createPulsemeterTable();
        this.scrollpane = new JScrollPane(this.pulsemeterTable);
        this.scrollpane.getVerticalScrollBar().setEnabled(true);
        this.scrollpane.setWheelScrollingEnabled(true);
        this.scrollpane.setPreferredSize(new Dimension(200, 500));
        this.alignPanel.add(this.scrollpane);
    }

    private void updateTable() {
        this.setVisible(false);
        this.alignPanel.remove(this.scrollpane);
        this.scrollpane = null;
        this.pulsemeterTable = null;
        this.createTable();
        this.setVisible(true);
    }

    @Override
    void cancel() {
    }

    @Override
    boolean set() {
        return true;
    }

    private void changeButtonEnabled() {
        if (pulseRates.size() > 0) {
            this.editButton.setEnabled(true);
            this.deleteButton.setEnabled(true);
        } else {
            this.editButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
        }
    }

    static class PulsemeterTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        PulsemeterTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setOpaque(true);
            if (n2 == 0) {
                this.setHorizontalAlignment(0);
            } else {
                this.setHorizontalAlignment(2);
            }
            if (bl) {
                this.setBackground(Color.black);
                this.setForeground(Color.white);
            } else {
                if (n % 2 == 0) {
                    this.setBackground(Color.white);
                } else {
                    this.setBackground(NativeDataEditWindow.SELECTED_COLOR);
                }
                this.setForeground(Color.black);
            }
            this.setText((String)object);
            return this;
        }
    }

    static class PulsemeterTableModel
    extends DefaultTableModel {
        PulsemeterTableModel(String[] stringArray, int n) {
            super(stringArray, n);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

