/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.ADF;
import com.nttdocomo.dojaemu.ktoolbar.AppIcon;
import com.nttdocomo.dojaemu.ktoolbar.ProjectFilesPath;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.Setting;
import com.nttdocomo.dojaemu.ktoolbar.StarDoJaChecker;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

class ReadWindowTable
extends JTable {
    private static final int ORDER_ICON = 0;
    private static final int ORDER_APPICON = 1;
    private static final int ORDER_COMPATIICON = 2;
    private static final int ORDER_NAME = 3;
    private static final int ORDER_DATE = 4;
    private static final int ORDER_SIZE = 5;
    private static final int ORDER_INFO = 6;
    private static final int ICON_WIDTH = 34;
    private static final int NAME_WIDTH = 143;
    private static final int DATE_WIDTH = 97;
    private static final int SIZE_WIDTH = 84;
    private static final int INFO_WIDTH = 248;
    private static final int[] COLUMN_MAX = new int[]{34, 34, 34, 286, 97, 84, 248};
    private static final int ICON_COLUMN_MARGIN = 18;
    private static final int WEIGHT_NAME = 0;
    private static final int WEIGHT_DATE = 2;
    private static final int WEIGHT_SIZE = 4;
    private static final int WEIGHT_INFO = 6;
    private static final int SORT_UP = -1;
    private static final int SORT_DOWN = 1;
    private String projectHome;
    private int orderNo;
    private int sortFlag;
    private ArrayList files;
    private String projectName;
    private StarDoJaChecker sdc;
    private int[] columnWidth;
    private String filterStr = "";

    public ReadWindowTable(String string) {
        int n;
        int n2;
        this.projectHome = string;
        this.orderNo = 3;
        this.sortFlag = -1;
        this.files = new ArrayList();
        this.projectName = null;
        this.columnWidth = (int[])COLUMN_MAX.clone();
        this.setModel(new DirectoryModel(string));
        this.setShowHorizontalLines(false);
        this.setShowVerticalLines(false);
        this.setRowHeight(28);
        this.setAutoResizeMode(3);
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ReadWindowListSelectionListener());
        JTableHeader jTableHeader = this.getTableHeader();
        jTableHeader.addMouseListener(new SelectionHeader());
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.setResizingAllowed(true);
        this.setDefaultRenderer(Object.class, new ReadWindowCellRenderer());
        this.setSelectionMode(0);
        int n3 = this.getFontMetrics(this.getFont()).stringWidth(Resource.getString("ICONORDER")) + 18;
        if (n3 > this.columnWidth[0]) {
            this.columnWidth[0] = n3;
        }
        if ((n2 = this.getFontMetrics(this.getFont()).stringWidth(Resource.getString("APPTYPEICONORDER")) + 18) > this.columnWidth[1]) {
            this.columnWidth[1] = n2;
        }
        if ((n = this.getFontMetrics(this.getFont()).stringWidth(Resource.getString("APPTYPEICONORDER")) + 18) > this.columnWidth[2]) {
            this.columnWidth[2] = n;
        }
        this.columnWidth[3] = this.columnWidth[3] / 2;
        this.loadColumnWidth();
    }

    public ReadWindowTable(String string, int n) {
        int n2;
        this.projectHome = string;
        this.orderNo = 3;
        this.sortFlag = -1;
        this.files = new ArrayList();
        this.projectName = null;
        this.columnWidth = (int[])COLUMN_MAX.clone();
        this.setModel(new DirectoryModel(string, n));
        this.sdc = new StarDoJaChecker(string);
        this.setShowHorizontalLines(false);
        this.setShowVerticalLines(false);
        this.setRowHeight(28);
        this.setAutoResizeMode(3);
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ReadWindowListSelectionListener());
        JTableHeader jTableHeader = this.getTableHeader();
        jTableHeader.addMouseListener(new SelectionHeader());
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.setResizingAllowed(true);
        this.setDefaultRenderer(Object.class, new ReadWindowCellRenderer());
        this.setSelectionMode(0);
        int n3 = this.getFontMetrics(this.getFont()).stringWidth(Resource.getString("ICONORDER")) + 18;
        if (n3 > this.columnWidth[0]) {
            this.columnWidth[0] = n3;
        }
        if ((n2 = this.getFontMetrics(this.getFont()).stringWidth(Resource.getString("APPTYPEICONORDER")) + 18) > this.columnWidth[1]) {
            this.columnWidth[1] = n2;
        }
        this.columnWidth[2] = 0;
        this.columnWidth[3] = this.columnWidth[3] / 2;
        this.loadColumnWidth();
    }

    public void setSortStatus(int n) {
        if (n > 6) {
            this.orderNo = 6;
            n -= 6;
        } else if (n > 4) {
            this.orderNo = 5;
            n -= 4;
        } else if (n > 2) {
            this.orderNo = 4;
            n -= 2;
        } else {
            this.orderNo = 3;
            n += 0;
        }
        n = n == 1 ? -1 : 1;
    }

    public int getSortStatus() {
        int n = this.sortFlag == -1 ? 1 : 2;
        n = this.orderNo == 4 ? (n += 2) : (this.orderNo == 5 ? (n += 4) : (this.orderNo == 6 ? (n += 6) : (n += 0)));
        return n;
    }

    public int getProjectIndex(String string) {
        int n = -1;
        for (int i = 0; i < this.files.size(); ++i) {
            Object[] objectArray = (Object[])this.files.get(i);
            if ((String)objectArray[3] == null || !((String)objectArray[3]).equals(string)) continue;
            n = i;
            break;
        }
        return n;
    }

    public void setProjectIndex(int n) {
        try {
            if (n > this.getRowCount()) {
                return;
            }
            this.setRowSelectionInterval(n, n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    void saveColumnWidth() {
        for (int i = 0; i < this.columnWidth.length; ++i) {
            TableColumn tableColumn = this.getColumnModel().getColumn(i);
            this.columnWidth[i] = tableColumn.getWidth();
        }
    }

    void loadColumnWidth() {
        for (int i = 0; i < this.columnWidth.length - 1; ++i) {
            int n;
            TableColumn tableColumn = this.getColumnModel().getColumn(i);
            int n2 = COLUMN_MAX[i];
            if (i == 0) {
                n = this.getFontMetrics(this.getFont()).stringWidth(Resource.getString("ICONORDER")) + 18;
                if (n > n2) {
                    n2 = n;
                }
            } else if (i == 1) {
                n = this.getFontMetrics(this.getFont()).stringWidth(Resource.getString("APPTYPEICONORDER")) + 18;
                if (n > n2) {
                    n2 = n;
                }
            } else if (i == 2 && (n = this.getFontMetrics(this.getFont()).stringWidth(Resource.getString("APPTYPEICONORDER")) + 18) > n2) {
                n2 = n;
            }
            tableColumn.setMaxWidth(n2);
            tableColumn.setPreferredWidth(this.columnWidth[i]);
        }
    }

    public String getSelectedProject() {
        return this.projectName;
    }

    public void resetModel(String string) {
        this.projectHome = string;
        this.setModel(new DirectoryModel(string));
    }

    public void resetModel(String string, int n) {
        this.projectHome = string;
        this.setModel(new DirectoryModel(string, n));
    }

    public void setFilterText(String string) {
        this.filterStr = string;
    }

    public String getFilterText() {
        return this.filterStr;
    }

    class ReadWindowListSelectionListener
    implements ListSelectionListener {
        ReadWindowListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n;
            if (!listSelectionEvent.getValueIsAdjusting() && (n = ReadWindowTable.this.getSelectedRow()) != -1) {
                ReadWindowTable.this.projectName = (String)ReadWindowTable.this.getValueAt(n, 3);
            }
        }
    }

    class ReadWindowCellRenderer
    extends JLabel
    implements TableCellRenderer {
        ReadWindowCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (n2 == 5) {
                this.setHorizontalAlignment(4);
            } else if (n2 == 0 || n2 == 1 || n2 == 2) {
                this.setHorizontalAlignment(0);
            } else {
                this.setHorizontalAlignment(2);
            }
            this.setOpaque(true);
            if (bl) {
                this.setBackground(Color.black);
                this.setForeground(Color.white);
            } else {
                if (n % 2 == 0) {
                    this.setBackground(Color.white);
                } else {
                    this.setBackground(new Color(238, 238, 238));
                }
                this.setForeground(Color.black);
            }
            if (n2 == 0 || n2 == 1 || n2 == 2) {
                this.setText(null);
                if (object != null) {
                    this.setIcon((ImageIcon)object);
                }
            } else {
                this.setIcon(null);
                if (object != null) {
                    this.setText((String)object);
                }
            }
            return this;
        }
    }

    class SelectionHeader
    extends MouseAdapter {
        SelectionHeader() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
            int n = jTableHeader.columnAtPoint(mouseEvent.getPoint());
            if (n >= 0 && n < ReadWindowTable.this.columnWidth.length) {
                if (ReadWindowTable.this.orderNo == n) {
                    if (ReadWindowTable.this.sortFlag == -1) {
                        ReadWindowTable.this.sortFlag = 1;
                    } else {
                        ReadWindowTable.this.sortFlag = -1;
                    }
                } else {
                    ReadWindowTable.this.orderNo = n;
                    ReadWindowTable.this.sortFlag = -1;
                }
                ReadWindowTable.this.saveColumnWidth();
                ReadWindowTable.this.setModel(new DirectoryModel());
                ReadWindowTable.this.loadColumnWidth();
                for (int i = 0; i < ReadWindowTable.this.getRowCount(); ++i) {
                    if (!((String)ReadWindowTable.this.getValueAt(i, 3)).equals(ReadWindowTable.this.projectName)) continue;
                    ReadWindowTable.this.setRowSelectionInterval(i, i);
                }
            }
        }
    }

    class MyConparator
    implements Comparator {
        MyConparator() {
        }

        public int compare(Object object, Object object2) {
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = (Object[])object2;
            if (ReadWindowTable.this.orderNo == 3) {
                if (ReadWindowTable.this.sortFlag == -1) {
                    return ((String)objectArray[ReadWindowTable.this.orderNo]).compareToIgnoreCase((String)objectArray2[ReadWindowTable.this.orderNo]);
                }
                return ((String)objectArray2[ReadWindowTable.this.orderNo]).compareToIgnoreCase((String)objectArray[ReadWindowTable.this.orderNo]);
            }
            if (ReadWindowTable.this.orderNo == 4) {
                return Long.valueOf((String)objectArray[ReadWindowTable.this.orderNo]).compareTo(Long.valueOf((String)objectArray2[ReadWindowTable.this.orderNo])) * ReadWindowTable.this.sortFlag;
            }
            if (ReadWindowTable.this.orderNo == 5) {
                return Long.valueOf((String)objectArray[ReadWindowTable.this.orderNo]).compareTo(Long.valueOf((String)objectArray2[ReadWindowTable.this.orderNo])) * ReadWindowTable.this.sortFlag;
            }
            if (ReadWindowTable.this.orderNo == 0 || ReadWindowTable.this.orderNo == 1 || ReadWindowTable.this.orderNo == 2) {
                int n;
                int n2 = objectArray[ReadWindowTable.this.orderNo].hashCode();
                if (n2 == (n = objectArray2[ReadWindowTable.this.orderNo].hashCode())) {
                    return 0;
                }
                if (n2 > n) {
                    return ReadWindowTable.this.sortFlag == -1 ? 1 : -1;
                }
                return ReadWindowTable.this.sortFlag == -1 ? -1 : 1;
            }
            if (ReadWindowTable.this.sortFlag == -1) {
                return ((String)objectArray[ReadWindowTable.this.orderNo]).compareToIgnoreCase((String)objectArray2[ReadWindowTable.this.orderNo]);
            }
            return ((String)objectArray2[ReadWindowTable.this.orderNo]).compareToIgnoreCase((String)objectArray[ReadWindowTable.this.orderNo]);
        }
    }

    class DirectoryModel
    extends AbstractTableModel
    implements ActionListener {
        private ProjectFilesPath pfl;
        private AppIcon appIcon;

        public DirectoryModel(String string) {
            this.pfl = new ProjectFilesPath(ReadWindowTable.this.projectHome);
            this.appIcon = new AppIcon(ReadWindowTable.this.projectHome);
            if (string != null) {
                this.readProjectElements(string);
            }
            Object[] objectArray = ReadWindowTable.this.files.toArray();
            MyConparator myConparator = new MyConparator();
            Arrays.sort(objectArray, myConparator);
            ReadWindowTable.this.files.clear();
            for (int i = 0; i < objectArray.length; ++i) {
                ReadWindowTable.this.files.add(objectArray[i]);
            }
        }

        public DirectoryModel(String string, int n) {
            this.pfl = new ProjectFilesPath(ReadWindowTable.this.projectHome);
            this.appIcon = new AppIcon(ReadWindowTable.this.projectHome);
            if (string != null) {
                this.readProjectElements(string, n, ReadWindowTable.this.projectHome);
            }
            Object[] objectArray = ReadWindowTable.this.files.toArray();
            MyConparator myConparator = new MyConparator();
            Arrays.sort(objectArray, myConparator);
            ReadWindowTable.this.files.clear();
            for (int i = 0; i < objectArray.length; ++i) {
                ReadWindowTable.this.files.add(objectArray[i]);
            }
        }

        public DirectoryModel() {
            this(null);
        }

        private String getJarSize(String string) {
            String string2 = "0";
            File file = new File(this.pfl.getJarPath(string));
            if (file.exists()) {
                string2 = String.valueOf(file.length());
            }
            return string2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isCompati(String string) {
            boolean bl = true;
            File file = new File(this.pfl.getJarPath(string));
            if (file.exists()) {
                ZipFile zipFile = null;
                try {
                    zipFile = new JarFile(file, false, 1);
                    Manifest manifest = ((JarFile)zipFile).getManifest();
                    if (manifest != null) {
                        Attributes attributes = manifest.getMainAttributes();
                        bl = !"false".equals(attributes.getValue("preverified").toString());
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return bl;
        }

        private String getProjectInfo(String string) {
            String string2 = null;
            File file = new File(this.pfl.getPrpPath(string));
            try {
                Setting setting = new Setting(file);
                string2 = setting.getProperty("projectInfo");
                if (string2 == null || string2.length() == 0) {
                    ADF aDF = new ADF(new File(this.pfl.getJamPath(string)));
                    string2 = aDF.getProperty("AppName");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return string2 == null ? "" : "   " + string2;
        }

        private boolean checkAppType(String string, int n, String string2) {
            ReadWindowTable.this.sdc = new StarDoJaChecker(string2);
            try {
                if (n == ReadWindowTable.this.sdc.checkAppType(string)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }

        public void readProjectElements(String string) {
            String[] stringArray = new File(string).list();
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            ReadWindowTable.this.files.clear();
            String string2 = ReadWindowTable.this.getFilterText().toLowerCase();
            StarDoJaChecker starDoJaChecker = new StarDoJaChecker(ReadWindowTable.this.projectHome);
            int n = -1;
            for (int i = 0; i < stringArray.length; ++i) {
                Object object;
                String string3;
                File file = new File(this.pfl.getJamPath(stringArray[i]));
                if (!file.exists() || (string3 = stringArray[i].toLowerCase()).indexOf(string2) < 0 || (n = starDoJaChecker.checkAppType(stringArray[i])) == -1) continue;
                if (n == 8 || n == 16) {
                    try {
                        String string4;
                        Object object2;
                        object = new File(this.pfl.getPrpPath(stringArray[i]));
                        Setting setting = new Setting((File)object);
                        String string5 = setting.getProperty("FullApp");
                        if (string5 == "" || string5.length() == 0 || !((File)(object2 = new File(string4 = string + string5.substring(2)))).exists() || (string4 = setting.getProperty("MiniApp")) == "" || string4.length() == 0) continue;
                        object2 = string + string4.substring(2);
                        File file2 = new File((String)object2);
                        if (!file2.exists()) {
                        }
                    }
                    catch (Exception exception) {}
                    continue;
                }
                object = new Object[ReadWindowTable.this.columnWidth.length];
                object[0] = this.appIcon.getImageIcon(stringArray[i]);
                object[1] = this.appIcon.getAppTypeImageIcon(stringArray[i]);
                object[2] = this.appIcon.getIconCompati(this.isCompati(stringArray[i]));
                object[3] = stringArray[i];
                object[4] = new Long(file.lastModified()).toString();
                object[5] = this.getJarSize(stringArray[i]);
                object[6] = this.getProjectInfo(stringArray[i]);
                ReadWindowTable.this.files.add(object);
            }
        }

        public void readProjectElements(String string, int n, String string2) {
            String[] stringArray = new File(string).list();
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            ReadWindowTable.this.files.clear();
            String string3 = ReadWindowTable.this.getFilterText().toLowerCase();
            for (int i = 0; i < stringArray.length; ++i) {
                String string4;
                File file = new File(this.pfl.getJamPath(stringArray[i]));
                if (!file.exists() || !this.checkAppType(stringArray[i], n, string2) || (string4 = stringArray[i].toLowerCase()).indexOf(string3) < 0) continue;
                Object[] objectArray = new Object[ReadWindowTable.this.columnWidth.length];
                objectArray[0] = this.appIcon.getImageIcon(stringArray[i]);
                objectArray[1] = this.appIcon.getAppTypeImageIcon(stringArray[i]);
                objectArray[2] = this.appIcon.getIconCompati(true);
                objectArray[3] = stringArray[i];
                objectArray[4] = new Long(file.lastModified()).toString();
                objectArray[5] = this.getJarSize(stringArray[i]);
                objectArray[6] = this.getProjectInfo(stringArray[i]);
                ReadWindowTable.this.files.add(objectArray);
            }
        }

        @Override
        public int getRowCount() {
            return ReadWindowTable.this.files != null ? ReadWindowTable.this.files.size() : 0;
        }

        @Override
        public int getColumnCount() {
            return ReadWindowTable.this.files != null ? ReadWindowTable.this.columnWidth.length : 0;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (ReadWindowTable.this.files == null || ReadWindowTable.this.files.size() == 0) {
                return null;
            }
            Object[] objectArray = (Object[])ReadWindowTable.this.files.get(n);
            switch (n2) {
                case 0: {
                    return objectArray[0];
                }
                case 1: {
                    return objectArray[1];
                }
                case 2: {
                    return objectArray[2];
                }
                case 3: {
                    return (String)objectArray[3];
                }
                case 4: {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm");
                    return simpleDateFormat.format(new Date(Long.parseLong((String)objectArray[4])));
                }
                case 5: {
                    return NumberFormat.getNumberInstance().format(Long.parseLong((String)objectArray[5]));
                }
                case 6: {
                    return (String)objectArray[6];
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int n) {
            String string = "";
            String string2 = "";
            if (0 == n) {
                return Resource.getString("ICONORDER");
            }
            if (1 == n) {
                return Resource.getString("APPTYPEICONORDER");
            }
            if (2 == n) {
                return "";
            }
            if (3 == n) {
                string = "NAMEORDER";
            } else if (4 == n) {
                string = "DATEORDER";
            } else if (5 == n) {
                string = "SIZEORDER";
            } else if (6 == n) {
                string = "INFOORDER";
            }
            if (ReadWindowTable.this.orderNo == n) {
                string2 = ReadWindowTable.this.sortFlag == -1 ? "_UP" : "_DOWN";
            }
            return Resource.getString(string + string2);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DirectoryModel directoryModel = new DirectoryModel(ReadWindowTable.this.projectHome);
            ReadWindowTable.this.setModel(directoryModel);
        }
    }
}

