/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.ProjectExplorerList;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;

class RenameBox
extends JTextField
implements FocusListener,
ActionListener {
    String target = "";
    ProjectExplorerList list = null;

    RenameBox(ProjectExplorerList projectExplorerList, String string) {
        this.target = string;
        this.list = projectExplorerList;
        this.addActionListener(this);
        this.addFocusListener(this);
    }

    String getRenameFilePath() {
        return this.target;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.list.requestFocus();
        this.list.repaint();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (!focusEvent.isTemporary()) {
            String string = this.getRenameFilePath();
            String string2 = this.getText();
            if (string2.trim().length() == 0) {
                this.list.removeRenameBox(null);
                return;
            }
            this.list.doRename(string, string2);
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 38 || n == 40) {
            keyEvent.consume();
        } else if (n == 27) {
            this.setText("");
            this.list.removeRenameBox(null);
        } else {
            super.processKeyEvent(keyEvent);
        }
    }
}

