/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.DebugTraceWindow;
import com.nttdocomo.dojaemu.ktoolbar.JAMManager;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.MainWindowDoButtonControl;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class SelectedWordsWindow
extends AbstractWindow {
    private static final long serialVersionUID = 1L;
    private static final int DISP_SIZE_HEIGHT = 130;
    private static final int DISP_SIZE_WIDTH = 400;
    private static final int TXT_ROWS_MAX = 3;
    private static final int TXT_COLUMNS_MAX = 60;
    private JPanel jContentPane = null;
    private JPanel parameterPanel = null;
    private JLabel paramLabel = null;
    private JPanel buttonPanel = null;
    private JScrollPane paramTextScrollPane = null;
    private JTextArea paramTextArea;
    private JButton runButton = null;
    private JButton cancelButton = null;
    private MainWindow parent;
    private static final String PARAM_FILE_PATH = System.getProperty("emu.home") + File.separator + "lib" + File.separator + "copystring.dat";

    public SelectedWordsWindow(MainWindow mainWindow) {
        super(mainWindow, Resource.getString("DISP_SELECTED_WORDS"));
        this.parent = mainWindow;
        this.initialize();
        this.runButton.setActionCommand("exec");
        this.cancelButton.setActionCommand("cancel");
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.runButton.addActionListener(actionDispatcher);
        this.cancelButton.addActionListener(actionDispatcher);
        this.setResizable(true);
        this.pack();
    }

    void exec() {
        try {
            String string = this.paramTextArea.getText();
            if (string == null || string.length() == 0) {
                this.parent.showDialog(Resource.getString("SET_PARAM_WNG"), this, 2);
                return;
            }
            this.save(string);
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put(Resource.getString("FREEWORDS_PARAMETER_KEY"), string);
            JAMManager.invokeApplication(this.parent.getAppType(), this.parent.getAdfPath(), this.parent.getJarPath(), 27, JAMManager.getParams(hashtable), this.parent.getDeviceName(), this.parent.getAdfUrl(), this.parent.getProjectNameForBytes(), DebugTraceWindow.getDebugParam());
            this.parent.setEnabledDeviceMenu(false);
        }
        catch (Exception exception) {
            this.parent.showDialog(Resource.getString("NOT_LAUNCH_ERR"), this, 0);
        }
        MainWindowDoButtonControl.start(this.parent);
        this.dispose();
    }

    private void save(String string) throws Exception {
        File file = new File(PARAM_FILE_PATH);
        BufferedWriter bufferedWriter = null;
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            bufferedWriter = new BufferedWriter(new FileWriter(file, false));
            bufferedWriter.write(string);
            bufferedWriter.write(System.getProperty("line.separator"));
            bufferedWriter.flush();
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
        }
    }

    void cancel() {
        this.parent.closeWindow(this);
    }

    private void load() {
        File file = new File(PARAM_FILE_PATH);
        BufferedReader bufferedReader = null;
        String string = "";
        String string2 = null;
        if (file.exists() && file.isFile()) {
            try {
                bufferedReader = new BufferedReader(new FileReader(file));
                int n = 0;
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (n != 0) {
                        string = string + System.getProperty("line.separator");
                    }
                    string = string + string2;
                    ++n;
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        this.paramTextArea.setText(string);
    }

    private void initialize() {
        this.setSize(400, 130);
        this.jContentPane = new JPanel();
        this.jContentPane.setLayout(new BorderLayout());
        this.parameterPanel = new JPanel();
        this.paramLabel = new JLabel();
        this.paramLabel.setText(Resource.getString("SELECTED_WORDS_PARAM"));
        this.paramTextArea = new JTextArea();
        this.paramTextArea.setFont(new Font("Monospaced", this.paramTextArea.getFont().getStyle(), 12));
        this.paramTextArea.setRows(3);
        this.paramTextArea.setColumns(60);
        this.paramTextArea.setLineWrap(true);
        this.paramTextScrollPane = new JScrollPane(this.paramTextArea);
        this.parameterPanel.add((Component)this.paramLabel, null);
        this.parameterPanel.add((Component)this.paramTextScrollPane, null);
        this.buttonPanel = new JPanel();
        this.runButton = new JButton();
        this.runButton.setText(Resource.getString("LAUNCH_SELECTED_WORDS"));
        this.buttonPanel.add((Component)this.runButton, null);
        this.cancelButton = new JButton();
        this.cancelButton.setText(Resource.getString("CANCEL"));
        this.buttonPanel.add((Component)this.cancelButton, null);
        this.jContentPane.add((Component)this.parameterPanel, "Center");
        this.jContentPane.add((Component)this.buttonPanel, "South");
        this.setContentPane(this.jContentPane);
        this.load();
        this.paramTextArea.setCaretPosition(0);
    }
}

