/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.CustomWindowsComboBoxUI;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.ComboBoxUI;

class ShortcutKeyEditWindow
extends AbstractWindow {
    private static final int FRAME_WIDTH = 480;
    private static final int FRAME_HEIGHT = 200;
    private static final String[] KEY_LIST = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    private Hashtable shortcutKeyHash;
    private Vector commandTable;
    private Vector menuItemTable;
    private JMenuItem entry;
    private MainWindow parent;
    private JComboBox operationList;
    private JComboBox keyList;
    private JCheckBox ctrlCheckBox;
    private boolean edited;
    private final String INSHORTCUT_KEY_NAME = "DEVICE";

    ShortcutKeyEditWindow(MainWindow mainWindow, JMenuItem jMenuItem, Hashtable hashtable) {
        super(mainWindow, Resource.getString("SHORTCUT_KEY_EDIT_WINDOW_TITLE"));
        Serializable serializable;
        Object object;
        this.parent = mainWindow;
        this.shortcutKeyHash = hashtable;
        this.entry = jMenuItem;
        this.edited = false;
        this.addWindowListener();
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new FlowLayout(2));
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("OPERATION")));
        this.operationList = new JComboBox();
        this.operationList.setUI((ComboBoxUI)((Object)new CustomWindowsComboBoxUI()));
        this.getOperationList();
        jPanel.add(this.operationList);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.setBorder(new TitledBorder(new EtchedBorder(), Resource.getString("KEY_STROKE")));
        this.ctrlCheckBox = new JCheckBox(KeyEvent.getKeyModifiersText(2));
        jPanel2.add(this.ctrlCheckBox);
        this.keyList = new JComboBox<String>(KEY_LIST);
        this.keyList.setUI((ComboBoxUI)((Object)new CustomWindowsComboBoxUI()));
        jPanel2.add(this.keyList);
        if (jMenuItem != null) {
            object = null;
            serializable = jMenuItem.getAccelerator();
            if ((((AWTKeyStroke)serializable).getModifiers() & 2) == 2) {
                this.ctrlCheckBox.setSelected(true);
                object = KeyEvent.getKeyText(((AWTKeyStroke)serializable).getKeyCode());
            } else {
                this.ctrlCheckBox.setSelected(false);
                object = KeyEvent.getKeyText(((AWTKeyStroke)serializable).getKeyCode());
            }
            for (int i = 0; i < KEY_LIST.length; ++i) {
                if (!KEY_LIST[i].equals(object)) continue;
                this.keyList.setSelectedIndex(i);
            }
        }
        object = new JPanel(new FlowLayout(2));
        serializable = new JButton(Resource.getString("SET"));
        JButton jButton = new JButton(Resource.getString("CANCEL"));
        ((AbstractButton)serializable).setActionCommand("set");
        jButton.setActionCommand("cancel");
        ((AbstractButton)serializable).addActionListener(actionDispatcher);
        jButton.addActionListener(actionDispatcher);
        ((Container)object).add((Component)serializable);
        ((Container)object).add(jButton);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add(jPanel);
        jPanel3.add(jPanel2);
        JPanel jPanel4 = new JPanel();
        jPanel4.add((Component)object);
        container.add("Center", jPanel3);
        container.add("South", jPanel4);
        this.setResizable(true);
        this.pack();
    }

    void set() {
        if (-1 == this.operationList.getSelectedIndex() || -1 == this.keyList.getSelectedIndex()) {
            return;
        }
        try {
            String string = (String)this.commandTable.get(this.operationList.getSelectedIndex());
            String string2 = (String)this.keyList.getSelectedItem();
            this.entry = (JMenuItem)this.menuItemTable.get(this.operationList.getSelectedIndex());
            KeyStroke keyStroke = null;
            keyStroke = this.ctrlCheckBox.isSelected() ? KeyStroke.getKeyStroke((int)string2.toCharArray()[0], 2) : KeyStroke.getKeyStroke(string2);
            Enumeration enumeration = this.shortcutKeyHash.elements();
            while (enumeration.hasMoreElements()) {
                JMenuItem jMenuItem = null;
                Object v = enumeration.nextElement();
                if (v == null || !(v instanceof JMenuItem) || string.equals((jMenuItem = (JMenuItem)v).getActionCommand()) || !keyStroke.equals(jMenuItem.getAccelerator())) continue;
                this.parent.showDialog(Resource.getString("SETTING_DUPLICATION"), this, 2);
                return;
            }
            this.entry.setAccelerator(keyStroke);
            this.shortcutKeyHash.put(string, this.entry);
            this.edited = true;
            this.setVisible(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    boolean isEdited() {
        return this.edited;
    }

    void cancel() {
        this.setVisible(false);
    }

    private void getOperationList() {
        JMenuBar jMenuBar = this.parent.getJMenuBar();
        this.commandTable = new Vector();
        this.menuItemTable = new Vector();
        int n = 0;
        for (int i = 0; i < jMenuBar.getMenuCount(); ++i) {
            JMenu jMenu = jMenuBar.getMenu(i);
            if (jMenu.getName() != null && jMenu.getName().equals("DEVICE")) continue;
            for (int j = 0; j < jMenu.getItemCount(); ++j) {
                JMenuItem jMenuItem = jMenu.getItem(j);
                if (jMenuItem == null) continue;
                if (jMenuItem instanceof JMenu) {
                    for (int k = 0; k < ((JMenu)jMenuItem).getItemCount(); ++k) {
                        JMenuItem jMenuItem2 = ((JMenu)jMenuItem).getItem(k);
                        if (jMenuItem2 == null) continue;
                        n = this.setOperationList(jMenuItem2, n);
                    }
                    continue;
                }
                if (!(jMenuItem instanceof JMenuItem)) continue;
                JMenuItem jMenuItem3 = jMenuItem;
                n = this.setOperationList(jMenuItem3, n);
            }
        }
        this.operationList.setSelectedIndex(n);
        if (this.entry != null) {
            this.operationList.setEnabled(false);
        }
    }

    private int setOperationList(JMenuItem jMenuItem, int n) {
        this.menuItemTable.add(jMenuItem);
        this.operationList.addItem(jMenuItem.getText());
        this.commandTable.add(jMenuItem.getActionCommand());
        if (jMenuItem.equals(this.entry)) {
            n = this.operationList.getItemCount() - 1;
        }
        return n;
    }
}

