/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Properties;

class SoundSetting {
    private Properties prop = null;
    private int[][] setting;
    private String device;
    private int mode;
    private String libIndex;
    private final String filePath;

    public SoundSetting(String string) throws Exception {
        FileInputStream fileInputStream = null;
        this.filePath = string;
        try {
            fileInputStream = new FileInputStream(string);
            this.prop = new Properties();
            this.prop.load(fileInputStream);
            this.setting = this.getSubSoundSetting(this.prop);
            this.device = this.getDeviceSetting(this.prop);
            this.mode = this.getModeSetting(this.prop);
            this.libIndex = this.getLibrarySetting(this.prop);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.createProperties();
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    private void createProperties() {
        this.setting = new int[16][2];
        for (int i = 0; i < this.setting.length; ++i) {
            this.setting[i][0] = -1;
            this.setting[i][1] = -1;
        }
        this.device = null;
        this.mode = 0;
        this.libIndex = null;
        this.prop = new Properties();
    }

    private String getDeviceSetting(Properties properties) {
        return properties.getProperty("DEVICE", null);
    }

    private int getModeSetting(Properties properties) {
        int n;
        String string = properties.getProperty("MODE", null);
        if (string == null) {
            n = 0;
        } else {
            try {
                n = Integer.parseInt(string);
                if (n != 0 && n != 1) {
                    n = 0;
                }
            }
            catch (Exception exception) {
                n = 0;
            }
        }
        return n;
    }

    private int[][] getSubSoundSetting(Properties properties) {
        int[][] nArray = new int[16][2];
        String string = null;
        for (int i = 0; i < 16; ++i) {
            int n;
            nArray[i][0] = -1;
            nArray[i][1] = -1;
            string = properties.getProperty("CH_" + (i + 1));
            if (string == null || string.length() <= 3) continue;
            try {
                n = Integer.parseInt(string.substring(3));
            }
            catch (Exception exception) {
                continue;
            }
            if (string.startsWith("SM_")) {
                if (0 > n || n >= 128) continue;
                nArray[i][0] = n / 8;
                nArray[i][1] = n;
                continue;
            }
            if (!string.startsWith("PM_") || 0 > n || n >= 47) continue;
            nArray[i][0] = 16;
            nArray[i][1] = n;
        }
        return nArray;
    }

    public int getPlayMode() {
        return this.mode;
    }

    public void setPlayMode(int n) {
        if (n == 0 || n == 1) {
            this.mode = n;
        }
    }

    public String getDevice() {
        return this.device;
    }

    public void setDevice(String string) {
        this.device = string;
    }

    public int[][] getCurrentSetting() {
        return this.setting;
    }

    public int[] getCurrentSetting(int n) {
        return this.setting[n];
    }

    public void setCurrentSetting(int n, int[] nArray) {
        for (int i = 0; i < 2; ++i) {
            this.setting[n][i] = nArray[i];
        }
    }

    public void setCurrentSetting(int[][] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < 2; ++j) {
                this.setting[i][j] = nArray[i][j];
            }
        }
    }

    public void saveCurrentSetting() throws Exception {
        FileOutputStream fileOutputStream = null;
        this.prop.setProperty("MODE", Integer.toString(this.mode));
        this.prop.setProperty("DEVICE", this.device == null ? "null" : this.device);
        this.prop.setProperty("SOUNDLIB", this.libIndex == null ? "null" : this.libIndex);
        for (int i = 0; i < this.setting.length; ++i) {
            String string = "CH_" + (i + 1);
            String string2 = this.setting[i][0] == -1 ? "-1" : (this.setting[i][0] == 16 ? "PM_" + this.setting[i][1] : "SM_" + this.setting[i][1]);
            this.prop.setProperty(string, string2);
        }
        try {
            fileOutputStream = new FileOutputStream(this.filePath);
            this.prop.store(fileOutputStream, null);
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    private String getLibrarySetting(Properties properties) {
        return properties.getProperty("SOUNDLIB", null);
    }

    public String getLibraryIndex() {
        return this.libIndex;
    }

    public void setLibraryIndex(String string) {
        this.libIndex = string;
    }
}

