/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AbstractWindow;
import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.AttrWindow;
import com.nttdocomo.dojaemu.ktoolbar.IconViewWindow;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.ProjectFilesPath;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.ScrollablePicture;
import com.nttdocomo.dojaemu.ktoolbar.ViewWindowFileFormatCheck;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class StartupViewWindow
extends AbstractWindow {
    private AttrWindow adfWindow = null;
    private static final int STARTUP_IMAGE_VIEW = 480;
    private static final int STARTUP_IMAGE_MARGIN = 4;
    private static final int STARTUP_IMAGE_NAME_MAX_LENGTH = 256;
    private ProjectFilesPath pfl;
    private ImageIcon startupImage;
    private ScrollablePicture picture;
    private String title;

    StartupViewWindow(MainWindow mainWindow, AttrWindow attrWindow, String string) throws Exception {
        super(mainWindow, string);
        this.adfWindow = attrWindow;
        this.title = string;
        this.addWindowListener();
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        this.pfl = new ProjectFilesPath(mainWindow.getProjectHome());
        ImageIcon imageIcon = this.startupImage;
        imageIcon = this.getImageIcon("StartingAppImage");
        this.picture = new ScrollablePicture(imageIcon, Toolkit.getDefaultToolkit().getScreenResolution());
        JScrollPane jScrollPane = new JScrollPane(this.picture);
        jScrollPane.setPreferredSize(new Dimension(484, 484));
        jScrollPane.setViewportBorder(BorderFactory.createLineBorder(Color.black));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 1));
        jPanel.add(jScrollPane);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add(jPanel);
        JButton jButton = new JButton(Resource.getString("CLOSE"));
        jButton.setActionCommand("cancel");
        jButton.addActionListener(actionDispatcher);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(jButton);
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        container.add("Center", jPanel2);
        container.add("South", jPanel3);
        this.pack();
        this.setResizable(true);
        this.setIconImage(null);
    }

    void cancel() {
        this.parent.closeWindow(this);
    }

    public ImageIcon getImageIcon(String string) throws Exception {
        ImageIcon imageIcon = this.startupImage;
        String string2 = this.parent.getProjectName();
        String string3 = null;
        String string4 = null;
        try {
            string3 = this.adfWindow.getKeyValue(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (string3 == null || string3.equals("")) {
            throw new Exception(Resource.getString("adfSetting.ktoolbar.message.error.startupImageSettingIsNotExists"));
        }
        if (string3.getBytes().length >= 256) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ",", true);
        if (stringTokenizer.countTokens() > 0) {
            String string5 = this.getNextToken(stringTokenizer);
            if (string5.equals(",")) {
                string5 = null;
            }
            if (this.title.equals(Resource.getString("adfSetting.ktoolbar.caption.startupHorizontalImageViewTitle"))) {
                if (string5 != null) {
                    this.getNextToken(stringTokenizer);
                }
                if ((string5 = this.getNextToken(stringTokenizer)) != null && string5.equals(",")) {
                    string5 = null;
                }
            }
            if (string5 == null) {
                throw new Exception(Resource.getString("adfSetting.ktoolbar.message.error.startupImageSettingIsNotExists"));
            }
            boolean bl = false;
            stringTokenizer = new StringTokenizer(string5, ".");
            String string6 = null;
            while (stringTokenizer.hasMoreTokens()) {
                string6 = stringTokenizer.nextToken();
            }
            if (string6.equalsIgnoreCase("jpeg") || string6.equalsIgnoreCase("jpg")) {
                string4 = "jpeg";
            } else if (string6.equalsIgnoreCase("bmp")) {
                string4 = "bmp";
                bl = true;
            } else if (string6.equalsIgnoreCase("gif")) {
                string4 = "gif";
            } else if (string6.equalsIgnoreCase("png")) {
                string4 = "png";
            } else {
                throw new Exception(Resource.format("adfSetting.ktoolbar.message.error.startupImageFileFormatError", string5));
            }
            imageIcon = this.getImageIconFromRes(string2, string5, bl);
            if (!ViewWindowFileFormatCheck.checkFormat(IconViewWindow.pfl.getResPath(string2) + string5, string4)) {
                throw new Exception(Resource.format("adfSetting.ktoolbar.message.error.startupImageFileFormatError", string5));
            }
            String string7 = this.pfl.getJarPath(string2);
            byte[] byArray = IconViewWindow.getIconBytes(string7, string5);
            if (byArray == null) {
                this.parent.showDialog(Resource.format("adfSetting.ktoolbar.message.warn.startupImageFileIsNotExistsInJar", string5), this, 2);
            }
        }
        return imageIcon;
    }

    private ImageIcon getImageIconFromRes(String string, String string2, boolean bl) throws Exception {
        String string3 = this.pfl.getResPath(string) + string2;
        if (bl) {
            BufferedImage bufferedImage = null;
            try {
                bufferedImage = ImageIO.read(new File(string3));
            }
            catch (IOException iOException) {
                throw new Exception(Resource.format("adfSetting.ktoolbar.message.error.startupImageFileIsNotExists", string2));
            }
            if (bufferedImage == null) {
                throw new Exception(Resource.format("adfSetting.ktoolbar.message.error.startupImageFileFormatError", string2));
            }
            return new ImageIcon(bufferedImage);
        }
        byte[] byArray = IconViewWindow.getIconBytes(string3);
        if (byArray == null) {
            throw new Exception(Resource.format("adfSetting.ktoolbar.message.error.startupImageFileIsNotExists", string2));
        }
        return new ImageIcon(byArray);
    }

    private String getNextToken(StringTokenizer stringTokenizer) {
        try {
            String string = stringTokenizer.nextToken();
            if (string.equals("")) {
                return null;
            }
            return string;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

