/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.AppIconException;
import com.nttdocomo.dojaemu.ktoolbar.IconViewWindow;
import java.io.ByteArrayInputStream;

public final class ViewWindowFileFormatCheck {
    private static final int TRAILER = 59;
    private static final int IMAGE_BLOCK = 44;
    private static final int EXTENSION_INTRODUCER = 33;
    private static final int PLAIN_TEXT_EXTENTION = 1;
    private static final int GRAPHIC_CONTROL_EXTENTION = 249;
    private static final int COMMENT_EXTENTION = 254;
    private static final int APPLICATION_EXTENTION = 255;
    public static final String FORMAT_JPEG = "jpeg";
    public static final String FORMAT_GIF = "gif";
    public static final String FORMAT_PNG = "png";
    public static final String FORMAT_BMP = "bmp";

    private ViewWindowFileFormatCheck() {
    }

    public static boolean checkFormat(String string, String string2, int n) {
        byte[] byArray = IconViewWindow.getIconBytes(string);
        if (string2.equals(FORMAT_JPEG)) {
            return ViewWindowFileFormatCheck.checkJpegFormat(byArray, n);
        }
        if (string2.equals(FORMAT_GIF)) {
            return ViewWindowFileFormatCheck.checkGifFormat(byArray, n);
        }
        if (string2.equals(FORMAT_PNG)) {
            return ViewWindowFileFormatCheck.checkPngFormat(byArray, n);
        }
        return false;
    }

    public static boolean checkFormat(String string, String string2) {
        byte[] byArray = IconViewWindow.getIconBytes(string);
        if (string2.equals(FORMAT_JPEG)) {
            return ViewWindowFileFormatCheck.checkJpegFormat(byArray);
        }
        if (string2.equals(FORMAT_GIF)) {
            return ViewWindowFileFormatCheck.checkGifFormat(byArray);
        }
        if (string2.equals(FORMAT_PNG)) {
            return ViewWindowFileFormatCheck.checkPngFormat(byArray);
        }
        if (string2.equals(FORMAT_BMP)) {
            return ViewWindowFileFormatCheck.checkBmpFormat(byArray);
        }
        return false;
    }

    private static boolean checkJpegFormat(byte[] byArray, int n) {
        boolean bl = false;
        if (byArray.length > 2 && (byArray[0] & 0xFF) == 255 && (byArray[1] & 0xFF) == 216) {
            for (int i = 2; i < byArray.length - 8; ++i) {
                int n2;
                int n3 = byArray[i] & 0xFF;
                int n4 = byArray[i + 1] & 0xFF;
                if (n3 != 255) continue;
                if (n4 == 192 || n4 == 193 || n4 == 194 || n4 == 195 || n4 == 197 || n4 == 198 || n4 == 199 || n4 == 201 || n4 == 202 || n4 == 203 || n4 == 205 || n4 == 206 || n4 == 207) {
                    n2 = (byArray[i + 7] << 8) + (byArray[i + 8] & 0xFF);
                    int n5 = (byArray[i + 5] << 8) + (byArray[i + 6] & 0xFF);
                    if (n != n2 || n != n5) break;
                    bl = true;
                    break;
                }
                n2 = (byArray[i + 2] << 8) + (byArray[i + 3] & 0xFF);
                i += n2 + 1;
            }
        }
        return bl;
    }

    private static boolean checkJpegFormat(byte[] byArray) {
        boolean bl = false;
        if (byArray.length > 2 && (byArray[0] & 0xFF) == 255 && (byArray[1] & 0xFF) == 216) {
            for (int i = 2; i < byArray.length - 8; ++i) {
                int n = byArray[i] & 0xFF;
                int n2 = byArray[i + 1] & 0xFF;
                if (n != 255) continue;
                if (n2 == 192 || n2 == 193 || n2 == 194 || n2 == 195 || n2 == 197 || n2 == 198 || n2 == 199 || n2 == 201 || n2 == 202 || n2 == 203 || n2 == 205 || n2 == 206 || n2 == 207) {
                    bl = true;
                    break;
                }
                int n3 = (byArray[i + 2] << 8) + (byArray[i + 3] & 0xFF);
                i += n3 + 1;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkGifFormat(byte[] byArray, int n) {
        boolean bl = true;
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            ViewWindowFileFormatCheck.checkGifHeader(byteArrayInputStream, n);
            while (true) {
                int n2;
                if ((n2 = byteArrayInputStream.read()) == 59) {
                } else {
                    if (n2 == 44) {
                        ViewWindowFileFormatCheck.checkImageBlock(byteArrayInputStream);
                        continue;
                    }
                    if (n2 == 33) {
                        int n3 = byteArrayInputStream.read();
                        if (n3 == 1) {
                            ViewWindowFileFormatCheck.checkPlaneText(byteArrayInputStream);
                            continue;
                        }
                        if (n3 == 249) {
                            ViewWindowFileFormatCheck.checkGraphicControl(byteArrayInputStream);
                            continue;
                        }
                        if (n3 == 254) {
                            ViewWindowFileFormatCheck.checkComment(byteArrayInputStream);
                            continue;
                        }
                        if (n3 == 255) {
                            ViewWindowFileFormatCheck.checkApplication(byteArrayInputStream);
                            continue;
                        }
                    }
                }
                break;
            }
        }
        catch (AppIconException appIconException) {
            bl = false;
        }
        catch (Exception exception) {
            bl = false;
        }
        finally {
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkGifFormat(byte[] byArray) {
        boolean bl = true;
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            ViewWindowFileFormatCheck.checkGifHeader(byteArrayInputStream);
            while (true) {
                int n;
                if ((n = byteArrayInputStream.read()) == 59) {
                } else {
                    if (n == 44) {
                        ViewWindowFileFormatCheck.checkImageBlock(byteArrayInputStream);
                        continue;
                    }
                    if (n == 33) {
                        int n2 = byteArrayInputStream.read();
                        if (n2 == 1) {
                            ViewWindowFileFormatCheck.checkPlaneText(byteArrayInputStream);
                            continue;
                        }
                        if (n2 == 249) {
                            ViewWindowFileFormatCheck.checkGraphicControl(byteArrayInputStream);
                            continue;
                        }
                        if (n2 == 254) {
                            ViewWindowFileFormatCheck.checkComment(byteArrayInputStream);
                            continue;
                        }
                        if (n2 == 255) {
                            continue;
                        }
                    }
                }
                break;
            }
        }
        catch (AppIconException appIconException) {
            bl = false;
        }
        catch (Exception exception) {
            bl = false;
        }
        finally {
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return bl;
    }

    private static boolean checkPngFormat(byte[] byArray, int n) {
        boolean bl = false;
        if (ViewWindowFileFormatCheck.checkPngFormat(byArray) && ViewWindowFileFormatCheck.pngImageSizeComp(byArray, n)) {
            bl = true;
        }
        return bl;
    }

    private static boolean checkPngFormat(byte[] byArray) {
        boolean bl = false;
        if (byArray.length > 15 && byArray[0] == -119 && byArray[1] == 80 && byArray[2] == 78 && byArray[3] == 71 && byArray[4] == 13 && byArray[5] == 10 && byArray[6] == 26 && byArray[7] == 10 && byArray[8] == 0 && byArray[9] == 0 && byArray[10] == 0 && byArray[11] == 13 && byArray[12] == 73 && byArray[13] == 72 && byArray[14] == 68 && byArray[15] == 82) {
            bl = true;
        }
        return bl;
    }

    private static boolean checkBmpFormat(byte[] byArray) {
        return byArray.length >= 2 && (byArray[0] & 0xFF) == 66 && (byArray[1] & 0xFF) == 77;
    }

    private static boolean pngImageSizeComp(byte[] byArray, int n) {
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        if (byArray.length >= 23) {
            n2 |= (byArray[16] & 0xFF) << 32;
            n2 |= (byArray[17] & 0xFF) << 16;
            n2 |= (byArray[18] & 0xFF) << 8;
            n3 |= (byArray[20] & 0xFF) << 32;
            n3 |= (byArray[21] & 0xFF) << 16;
            n3 |= (byArray[22] & 0xFF) << 8;
            if ((n2 |= byArray[19] & 0xFF) == n && (n3 |= byArray[23] & 0xFF) == n) {
                bl = true;
            }
        }
        return bl;
    }

    private static void checkGifHeader(ByteArrayInputStream byteArrayInputStream) throws Exception {
        int n = 0;
        byte[] byArray = new byte[6];
        byteArrayInputStream.read(byArray);
        String string = new String(byArray);
        if (!string.equals("GIF87a") && !string.equals("GIF89a")) {
            throw new AppIconException(2, "Invalid signature or version");
        }
        byte by = (byte)byteArrayInputStream.read();
        if ((by & 0x80) != 0) {
            int n2 = (by & 7) + 1;
            n = (int)Math.pow(2.0, n2) * 3;
        }
        byteArrayInputStream.skip(2 + n);
    }

    private static void checkGifHeader(ByteArrayInputStream byteArrayInputStream, int n) throws Exception {
        int n2 = 0;
        byte[] byArray = new byte[6];
        byteArrayInputStream.read(byArray);
        String string = new String(byArray);
        if (!string.equals("GIF87a") && !string.equals("GIF89a")) {
            throw new AppIconException(2, "Invalid signature or version");
        }
        byArray = null;
        byte[] byArray2 = new byte[4];
        byteArrayInputStream.read(byArray2);
        int n3 = (byArray2[1] << 8) + (byArray2[0] & 0xFF);
        int n4 = (byArray2[3] << 8) + (byArray2[2] & 0xFF);
        if (n != n3 || n != n4) {
            throw new AppIconException(3, "Invalid logical screen size");
        }
        byte by = (byte)byteArrayInputStream.read();
        if ((by & 0x80) != 0) {
            int n5 = (by & 7) + 1;
            n2 = (int)Math.pow(2.0, n5) * 3;
        }
        byteArrayInputStream.skip(2 + n2);
    }

    private static void checkImageBlock(ByteArrayInputStream byteArrayInputStream) throws Exception {
        int n;
        int n2 = 0;
        byteArrayInputStream.skip(8L);
        byte by = (byte)((byte)byteArrayInputStream.read() & 0xFF);
        if ((by & 0x40) != 0) {
            throw new AppIconException(4, "Interlace image");
        }
        if ((by & 0x80) != 0) {
            n = (by & 7) + 1;
            n2 = (int)Math.pow(2.0, n) * 3;
        }
        byteArrayInputStream.skip(n2 + 1);
        while ((n = byteArrayInputStream.read()) != 0) {
            byteArrayInputStream.skip(n);
        }
    }

    private static void checkPlaneText(ByteArrayInputStream byteArrayInputStream) throws Exception {
        int n;
        byteArrayInputStream.skip(byteArrayInputStream.read() & 0xFF);
        while ((n = byteArrayInputStream.read()) != 0) {
            byteArrayInputStream.skip(n);
        }
    }

    private static void checkGraphicControl(ByteArrayInputStream byteArrayInputStream) throws Exception {
        byteArrayInputStream.skip(byteArrayInputStream.read() & 0xFF);
        if ((byteArrayInputStream.read() & 0xFF) != 0) {
            throw new AppIconException(1, "Invalid Block Terminator");
        }
    }

    private static void checkComment(ByteArrayInputStream byteArrayInputStream) throws Exception {
        int n;
        while ((n = byteArrayInputStream.read()) != 0) {
            byteArrayInputStream.skip(n);
        }
    }

    private static void checkApplication(ByteArrayInputStream byteArrayInputStream) throws Exception {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        byteArrayInputStream.skip(1L);
        byte[] byArray = new byte[11];
        byteArrayInputStream.read(byArray);
        String string = new String(byArray);
        if (string.equals("NETSCAPE2.0") || string.equals("ANIMEXTS1.0")) {
            bl = true;
        }
        while ((n = byteArrayInputStream.read()) != 0) {
            if (n == 3) {
                byte[] byArray2 = new byte[n];
                byteArrayInputStream.read(byArray2);
                if (byArray2[0] != 1) continue;
                bl2 = true;
                continue;
            }
            byteArrayInputStream.skip(n);
        }
        if (bl && bl2) {
            throw new AppIconException(5, "Animation GIF");
        }
    }
}

