/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar;

import com.nttdocomo.dojaemu.ktoolbar.ActionDispatcher;
import com.nttdocomo.dojaemu.ktoolbar.MainWindow;
import com.nttdocomo.dojaemu.ktoolbar.Resource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import javax.swing.text.StyleConstants;

class VirtualFeliCaEditWindow
extends JDialog {
    private JTextField systemCd;
    private JTextField serviceID;
    private JTextArea nodeCode;
    private final int SYSTEM_CODE_LENGTH = 4;
    private final int SYSTEM_CODE_NUM = 1;
    private final int SERVIVE_ID_LENGTH = 8;
    private final int SERVIVE_ID_NUM = 2;
    private final int NODE_CODE_LENGTH = 8;
    private final int NODE_CODE_NUM = 20;
    private String[] nodeData;
    private boolean saveFlag;

    VirtualFeliCaEditWindow(String string, MainWindow mainWindow, String[] stringArray) {
        super(mainWindow, string, true);
        this.nodeData = stringArray;
        this.saveFlag = false;
        ActionDispatcher actionDispatcher = new ActionDispatcher(this);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel(Resource.getString("SET_FELICA_SYSTEM_CODE"));
        JLabel jLabel2 = new JLabel(Resource.getString("SET_FELICA_SERVICE_ID"));
        JLabel jLabel3 = new JLabel(Resource.getString("SET_FELICA_NODE_CODE"));
        this.systemCd = new JTextField(4);
        this.serviceID = new JTextField(17);
        this.nodeCode = new JTextArea(4, 54);
        this.nodeCode.setFont(new Font("Monospaced", this.nodeCode.getFont().getStyle(), 12));
        this.nodeCode.setLineWrap(true);
        this.nodeCode.setBorder(new LineBorder(Color.lightGray));
        this.systemCd.setDocument(new LimitedHexDocument(4, 1));
        this.serviceID.setDocument(new LimitedHexDocument(8, 2));
        this.nodeCode.setDocument(new LimitedHexDocument(8, 20));
        if (stringArray[0] == null) {
            this.systemCd.setText("");
        } else {
            this.systemCd.setText(stringArray[0]);
        }
        if (stringArray[1] == null) {
            this.serviceID.setText("");
        } else {
            this.serviceID.setText(stringArray[1]);
        }
        if (stringArray[2] == null) {
            this.nodeCode.setText("");
        } else {
            this.nodeCode.setText(stringArray[2]);
        }
        JButton jButton = new JButton(Resource.getString("SET"));
        JButton jButton2 = new JButton(Resource.getString("CANCEL"));
        jButton.addActionListener(actionDispatcher);
        jButton2.addActionListener(actionDispatcher);
        jButton.setActionCommand("set");
        jButton2.setActionCommand("cancel");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.add(jLabel);
        jPanel2.add(this.systemCd);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0));
        jPanel3.add(jLabel2);
        jPanel3.add(this.serviceID);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(0));
        jPanel4.add(jLabel3);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(0));
        jPanel5.add(this.nodeCode);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        jPanel.add(jPanel4);
        jPanel.add(jPanel5);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new FlowLayout(1));
        jPanel6.add(jButton);
        jPanel6.add(jButton2);
        container.add("North", new JPanel());
        container.add("West", new JPanel());
        container.add("Center", jPanel);
        container.add("East", new JPanel());
        container.add("South", jPanel6);
        this.pack();
        this.setSize(new Dimension(mainWindow.getWidth(), this.getHeight()));
        this.setResizable(false);
    }

    void set() {
        try {
            this.valueCheck(this.systemCd.getText(), 4, 1);
        }
        catch (Exception exception) {
            this.dispDaialog(Resource.getString("SET_FELICA_SYSTEM_CODE"), exception);
            this.systemCd.requestFocus();
            return;
        }
        try {
            this.valueCheck(this.serviceID.getText(), 8, 2);
        }
        catch (Exception exception) {
            this.dispDaialog(Resource.getString("SET_FELICA_SERVICE_ID"), exception);
            this.serviceID.requestFocus();
            return;
        }
        try {
            this.valueCheck(this.nodeCode.getText(), 8, 20);
        }
        catch (Exception exception) {
            this.dispDaialog(Resource.getString("SET_FELICA_NODE_CODE"), exception);
            this.nodeCode.requestFocus();
            return;
        }
        this.nodeData[0] = this.systemCd.getText().toUpperCase();
        this.nodeData[1] = this.serviceID.getText().toUpperCase();
        this.nodeData[2] = this.nodeCode.getText().toUpperCase();
        for (int i = 0; i < this.nodeData.length; ++i) {
            StringBuffer stringBuffer = new StringBuffer(this.nodeData[i]);
            int n = this.nodeData[i].length();
            if (stringBuffer.lastIndexOf(",") != n - 1) continue;
            this.nodeData[i] = stringBuffer.substring(0, n - 1);
        }
        this.saveFlag = true;
        this.dispose();
    }

    void dispDaialog(String string, Exception exception) {
        JOptionPane jOptionPane = new JOptionPane(exception.getMessage(), 2);
        JDialog jDialog = jOptionPane.createDialog(this, string);
        jDialog.setResizable(false);
        jDialog.setVisible(true);
    }

    private void valueCheck(String string, int n, int n2) throws Exception {
        int n3 = (n + 1) * n2 - 1;
        if (string == null || string.equals("")) {
            throw new Exception(Resource.getString("SET_FELICA_NODE_WNG_NOT_INPUT"));
        }
        String[] stringArray = string.split(",");
        if (stringArray.length > n2) {
            throw new Exception("" + (n2 + 1) + Resource.getString("SET_FELICA_NODE_WNG_OVER_INPUT"));
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() != n) {
                throw new Exception(Resource.getString("SET_FELICA_NODE_WNG_LENGTH_INPUT"));
            }
            try {
                Long.parseLong(stringArray[i], 16);
                continue;
            }
            catch (Exception exception) {
                throw new Exception(Resource.getString("SET_FELICA_NODE_WNG_NOT_HEX_INPUT"));
            }
        }
    }

    void cancel() {
        this.dispose();
    }

    public boolean showWindow() {
        this.setVisible(true);
        this.dispose();
        return this.saveFlag;
    }

    private class LimitedHexDocument
    extends PlainDocument {
        int limit;
        int length;
        int num;

        LimitedHexDocument(int n, int n2) {
            this.length = n;
            this.num = n2;
            this.limit = (n + ",".length()) * n2 - ",".length();
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) {
            try {
                if (null != attributeSet && attributeSet.isDefined(StyleConstants.ComposedTextAttribute)) {
                    super.insertString(n, string, attributeSet);
                    return;
                }
                if (this.getLength() + string.length() > this.limit) {
                    return;
                }
                if (string != null) {
                    byte[] byArray = string.getBytes();
                    int n2 = string.length();
                    if (n2 != byArray.length) {
                        return;
                    }
                    try {
                        if (string.length() > 1) {
                            String[] stringArray = string.split(",");
                            if (stringArray.length > this.num) {
                                return;
                            }
                            for (int i = 0; i < stringArray.length; ++i) {
                                if (stringArray[i].length() <= 0) continue;
                                Long.parseLong(stringArray[i], 16);
                            }
                        } else {
                            int n3 = -1;
                            if (n == this.length) {
                                n3 = 0;
                            }
                            if (n > this.length + 1) {
                                n3 = ((short)n + 1) % (this.length + 1);
                            }
                            if (n3 == 0) {
                                if (string.equals(",")) {
                                    super.insertString(n, string, attributeSet);
                                    return;
                                }
                                return;
                            }
                            Integer.parseInt(string, 16);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        return;
                    }
                }
                super.insertString(n, string, attributeSet);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

