/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar.felica;

import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipViewerBlock;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipViewerParam;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public abstract class FaverChipData
implements FaverChipViewerParam {
    public int realDataSize;
    protected int managementSize;
    public int beginEditArea;
    public int endEditArea;
    protected File fcFile;
    protected byte[] originData;
    protected StringBuffer editData;
    protected byte[] originManagementInfo;
    protected byte[] editManagementInfo;
    protected byte[] savedata = null;
    public boolean editflag;

    protected void init() {
        int n = this.originData.length;
        String string = "";
        this.editData = new StringBuffer(n);
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.originManagementInfo);
            this.editManagementInfo = new byte[this.originManagementInfo.length];
            byteArrayInputStream.read(this.editManagementInfo, 0, this.editManagementInfo.length);
            byteArrayInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < n; ++i) {
            int n2 = this.originData[i] < 0 ? 256 + this.originData[i] : this.originData[i];
            string = Integer.toHexString(n2);
            if (string.length() == 1) {
                this.editData.append("0");
            }
            this.editData.append(string.toUpperCase());
        }
    }

    public String getHexString(int n, int n2) {
        if (n2 <= 0 || n < 0 || this.originData.length < n + n2) {
            return "";
        }
        return this.editData.substring(n * 2, n * 2 + n2 * 2);
    }

    private byte hexStrToByte(String string) {
        if (string == null) {
            return 0;
        }
        char[] cArray = string.toCharArray();
        int n = 1;
        int n2 = 0;
        for (int i = string.length() - 1; i >= 0; --i) {
            if ((cArray[i] & 0xF0) == 48) {
                n2 += n * (cArray[i] & 0xF);
            } else if ((cArray[i] & 0xF0) == 64) {
                n2 += n * ((cArray[i] & 0xF) + 9);
            } else if ((cArray[i] & 0xF0) == 96) {
                n2 += n * ((cArray[i] & 0xF) + 9);
            }
            n *= 16;
        }
        return (byte)n2;
    }

    public byte[] hexStrToByteArray(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (n == 0) {
            return null;
        }
        int n2 = n / 2;
        byte[] byArray = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            byArray[i] = this.hexStrToByte(string.substring(2 * i, 2 * i + 2));
        }
        return byArray;
    }

    public void update(String string, byte[] byArray) {
        int n = string.length();
        this.editData.replace(0, n, string);
        this.editManagementInfo = byArray;
        this.createSaveData();
    }

    public void save() throws FileNotFoundException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(this.fcFile);
        fileOutputStream.write(this.savedata, 0, this.savedata.length);
        fileOutputStream.close();
    }

    public byte[] getSaveData() {
        return this.savedata;
    }

    public byte[] getOriginData() {
        return this.originData;
    }

    public byte[] getManagementInfo() {
        return this.originManagementInfo;
    }

    public void setSaveData(byte[] byArray) {
        this.savedata = byArray;
    }

    public byte[] getBlockToByte(FaverChipViewerBlock[] faverChipViewerBlockArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = null;
        try {
            for (int i = 0; i < faverChipViewerBlockArray.length; ++i) {
                byteArrayOutputStream.write(faverChipViewerBlockArray[i].blocktype);
                byteArrayOutputStream.write(faverChipViewerBlockArray[i].belong, 0, faverChipViewerBlockArray[i].belong.length);
                byteArrayOutputStream.write(faverChipViewerBlockArray[i].authority);
                byArray = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byArray;
    }

    public void resetEditFlag(FaverChipViewerBlock[] faverChipViewerBlockArray) {
        for (int i = 0; i < faverChipViewerBlockArray.length; ++i) {
            faverChipViewerBlockArray[i].editflag = false;
        }
    }

    public abstract void createSaveData();

    public abstract void create(File var1) throws IOException;

    public abstract boolean verification();

    public abstract void setSaveData();

    public abstract FaverChipViewerBlock[] getBlockInfo();

    public abstract void resetBlockInfo(FaverChipViewerBlock[] var1);
}

