/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar.felica.ver20;

import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipData;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipViewerBlock;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipViewerLabelInfo;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20.FaverChipCheck;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20.ViewerBlock;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class FaverChipDataCon
extends FaverChipData {
    final int REAL_DATA_SIZE = 16384;
    final int MANAGEMENT_SIZE = 6144;
    final int BEGIN_EDIT_AREA = 128;
    final int END_EDIT_AREA = 15615;
    final boolean ENABLE_RIGTH_CLICK = true;
    FaverChipCheck fcc;
    private String[] blockName = new String[]{"Container ID", "Pmm", "Container Issue Information", "IDm (Shared area)", "IDi (Shared area)", "PMi (Shared area)", "System define block (Shared area)", "Area define block (Shared area)", "PIN service block", "PIN data block", "Shared area", "IDm (Free area)", "IDi (Free area)", "PMi (Free area)", "System define block (Free area)", "Area define block (Free area)", "PIN service block", "PIN data block", "Area define block (Free area 0001)", "PIN service block", "PIN data block", "Service block 1 (Free area 0001)", "PIN service block", "PIN data block", "CPID data block (Free area 0001)", "Service block 2 (Free area 0001)", "PIN service block (Free area 0001)", "PIN data block (Free area 0001)", "Data block 0 (Free area 0001)", "Data block 1 (Free area 0001)", "Data block 2 (Free area 0001)", "Data block 3 (Free area 0001)", "Area define block (Free area 0002)", "PIN service block", "PIN data block", "Service block 1 (Free area 0002)", "PIN service block", "PIN data block", "CPID data block (Free area 0002)", "Service block 2 (Free area 0002)", "PIN service block (Free area 0002)", "PIN data block (Free area 0002)", "Data block 0 (Free area 0002)", "Data block 1 (Free area 0002)", "Data block 2 (Free area 0002)", "Data block 3 (Free area 0002)", "Area define block (Free area 0003)", "PIN service block", "PIN data block", "Service block 1 (Free area 0003)", "PIN service block", "PIN data block", "CPID data block (Free area 0003)", "Service block 2 (Free area 0003)", "PIN service block (Free area 0003)", "PIN data block (Free area 0003)", "Data block 0 (Free area 0003)", "Data block 1 (Free area 0003)", "Data block 2 (Free area 0003)", "Data block 3 (Free area 0003)"};

    @Override
    public void createSaveData() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = this.hexStrToByteArray(this.editData.toString());
            byteArrayOutputStream.write(byArray, 0, byArray.length);
            byteArrayOutputStream.write(this.editManagementInfo, 0, this.editManagementInfo.length);
            this.savedata = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String[] getBlockName() {
        return this.blockName;
    }

    @Override
    public FaverChipViewerLabelInfo[] getLabelInfo() {
        int n;
        ArrayList<FaverChipViewerLabelInfo> arrayList = new ArrayList<FaverChipViewerLabelInfo>();
        arrayList.add(new FaverChipViewerLabelInfo(0, 0, 8));
        arrayList.add(new FaverChipViewerLabelInfo(1, 8, 8));
        arrayList.add(new FaverChipViewerLabelInfo(2, 16, 16));
        arrayList.add(new FaverChipViewerLabelInfo(3, 32, 8));
        arrayList.add(new FaverChipViewerLabelInfo(4, 48, 8));
        arrayList.add(new FaverChipViewerLabelInfo(5, 56, 8));
        arrayList.add(new FaverChipViewerLabelInfo(6, 64, 16));
        arrayList.add(new FaverChipViewerLabelInfo(7, 80, 16));
        arrayList.add(new FaverChipViewerLabelInfo(8, 96, 16));
        arrayList.add(new FaverChipViewerLabelInfo(9, 112, 16));
        for (n = 128; n <= 15615; n += 16) {
            arrayList.add(new FaverChipViewerLabelInfo(10, n, 16));
        }
        arrayList.add(new FaverChipViewerLabelInfo(11, 15616, 8));
        arrayList.add(new FaverChipViewerLabelInfo(12, 15632, 8));
        arrayList.add(new FaverChipViewerLabelInfo(13, 15640, 8));
        arrayList.add(new FaverChipViewerLabelInfo(14, 15648, 16));
        arrayList.add(new FaverChipViewerLabelInfo(15, 15664, 16));
        arrayList.add(new FaverChipViewerLabelInfo(16, 15680, 16));
        arrayList.add(new FaverChipViewerLabelInfo(17, 15696, 16));
        n = 18;
        int n2 = 0;
        while (n < this.blockName.length) {
            arrayList.add(new FaverChipViewerLabelInfo(n, 15712 + n2 * 16, 16));
            ++n;
            ++n2;
        }
        return arrayList.toArray(new FaverChipViewerLabelInfo[0]);
    }

    @Override
    public boolean isEnabledRightClick() {
        return true;
    }

    @Override
    public void create(File file) throws IOException {
        this.realDataSize = 16384;
        this.managementSize = 6144;
        this.beginEditArea = 128;
        this.endEditArea = 15615;
        if (!file.canRead()) {
            throw new IOException(Resource.getString("FC_READ_ERR"));
        }
        int n = (int)file.length();
        if (n < this.realDataSize + this.managementSize) {
            throw new IOException(Resource.getString("FC_DIFFERENT_VERSION"));
        }
        if (n > this.realDataSize + this.managementSize) {
            throw new IOException(Resource.getString("FC_FILE_BREAKS"));
        }
        this.originData = new byte[16384];
        this.originManagementInfo = new byte[6144];
        FileInputStream fileInputStream = new FileInputStream(file);
        fileInputStream.read(this.originData, 0, 16384);
        fileInputStream.read(this.originManagementInfo, 0, 6144);
        fileInputStream.close();
        this.fcFile = file;
        this.editflag = false;
        this.init();
    }

    @Override
    public boolean verification() {
        this.fcc = new FaverChipCheck(this.savedata);
        boolean bl = this.fcc.verification();
        if (!bl) {
            System.out.println(Resource.getString("NG_EDITING") + this.fcc.getErrorMessage());
        } else {
            System.out.println(Resource.getString("OK_EDITING"));
        }
        return bl;
    }

    @Override
    public void setSaveData() {
        this.savedata = this.fcc.getUpdatedData();
    }

    @Override
    public FaverChipViewerBlock[] getBlockInfo() {
        FaverChipViewerBlock[] faverChipViewerBlockArray = null;
        ArrayList<ViewerBlock> arrayList = new ArrayList<ViewerBlock>();
        if (this.originManagementInfo != null) {
            int n = 0;
            int n2 = 0;
            while (n < this.originManagementInfo.length) {
                byte[] byArray = new byte[6];
                byte[] byArray2 = new byte[4];
                System.arraycopy(this.originManagementInfo, n, byArray, 0, byArray.length);
                System.arraycopy(this.originData, n + 10 * n2, byArray2, 0, byArray2.length);
                ViewerBlock viewerBlock = new ViewerBlock(arrayList.size() * 16, byArray, byArray2);
                arrayList.add(viewerBlock);
                n += 6;
                ++n2;
            }
            faverChipViewerBlockArray = arrayList.toArray(new ViewerBlock[0]);
        }
        return faverChipViewerBlockArray;
    }

    @Override
    public void resetBlockInfo(FaverChipViewerBlock[] faverChipViewerBlockArray) {
        int n = 0;
        if (this.originManagementInfo != null) {
            for (int i = 0; i < faverChipViewerBlockArray.length; ++i) {
                n = i * 6;
                byte[] byArray = new byte[6];
                byte[] byArray2 = new byte[4];
                System.arraycopy(this.originManagementInfo, n, byArray, 0, byArray.length);
                System.arraycopy(this.originData, n + 10 * i, byArray2, 0, byArray2.length);
                faverChipViewerBlockArray[i].set(byArray, byArray2);
            }
        }
    }
}

