/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar.felica.ver20h;

import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipNode;
import com.nttdocomo.dojaemu.ktoolbar.felica.FaverChipNodeException;
import com.nttdocomo.dojaemu.ktoolbar.felica.NodeCode;
import com.nttdocomo.dojaemu.ktoolbar.felica.NodeCodeCheck;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.BlockManager;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.NodeCodeArea;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.NodeCodeManager;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.NodeCodeService;
import com.nttdocomo.dojaemu.ktoolbar.felica.ver20h.NodeCodeSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class FaverChipNodeGen
extends FaverChipNode {
    final int FULL_DATA_SIZE = 22528;
    final int REAL_DATA_SIZE = 736;
    int MANAGEMENT_SIZE = 276;
    final int OFFSET_REAL_DATA = 15648;
    final int OFFSET_MANAGEMENT = 22252;
    final int BEGIN_EDIT_AREA = -1;
    final int END_EDIT_AREA = -1;
    byte[] allDataByte = null;
    private final int SAVE_OFFSET = 64;
    private final int BLOCK_SIZE = 16;
    NodeCodeManager manager;

    @Override
    public void create(File file) throws IOException {
        this.realDataSize = 736;
        this.managementSize = this.MANAGEMENT_SIZE;
        this.beginEditArea = -1;
        this.endEditArea = -1;
        if (!file.canRead()) {
            throw new IOException(Resource.getString("FC_READ_ERR"));
        }
        int n = (int)file.length();
        if (n < 22528) {
            throw new IOException(Resource.getString("FC_DIFFERENT_VERSION"));
        }
        if (n > 22528) {
            throw new IOException(Resource.getString("FC_FILE_BREAKS"));
        }
        this.allDataByte = new byte[22528];
        this.originData = new byte[736];
        this.originManagementInfo = new byte[this.MANAGEMENT_SIZE];
        FileInputStream fileInputStream = new FileInputStream(file);
        fileInputStream.read(this.allDataByte);
        fileInputStream.close();
        System.arraycopy(this.allDataByte, 15648, this.originData, 0, 736);
        System.arraycopy(this.allDataByte, 22252, this.originManagementInfo, 0, this.MANAGEMENT_SIZE);
        BlockManager blockManager = new BlockManager(this.originData, this.originManagementInfo, 1);
        this.manager = blockManager.getNodeCodeManager();
        this.fcFile = file;
        this.editflag = false;
    }

    @Override
    public NodeCode getRootNodeCode() {
        return this.manager.getRootNodeCode();
    }

    @Override
    public NodeCode getNodeCodeByPath(Object[] objectArray) throws FaverChipNodeException {
        return this.manager.getNodeCodeByPath(objectArray);
    }

    @Override
    public void update() {
        this.savedata = this.manager.update(1);
        System.arraycopy(this.allDataByte, 0, this.savedata, 0, 15648);
        System.arraycopy(this.allDataByte, 16384, this.savedata, 16384, 5868);
    }

    @Override
    public NodeCodeCheck getNodeCodeCheck() {
        return this.manager.getNodeCodeCheck();
    }

    @Override
    public void addPINNodeCode(NodeCode nodeCode, int n) throws FaverChipNodeException {
        this.manager.makeNewPINNode(nodeCode, n);
    }

    @Override
    public void deleteNodeCode(NodeCode nodeCode) {
        this.manager.deleteNodeCode(nodeCode);
    }

    @Override
    public void changeNodeCode(NodeCode nodeCode, String string) {
        this.manager.changeNodeCode(nodeCode, string);
    }

    @Override
    public void changeUserData(NodeCode nodeCode, String[] stringArray) throws FaverChipNodeException {
        this.manager.changeUserData((NodeCodeService)nodeCode, stringArray);
    }

    @Override
    public void changePINNode(NodeCode nodeCode) {
        this.manager.changePINNode(nodeCode);
    }

    @Override
    public void reorganization(NodeCode nodeCode) {
        this.manager.reorganization(nodeCode);
    }

    @Override
    public NodeCode getInitialNode(int n) {
        return this.manager.getInitialNode(n);
    }

    @Override
    public void removeNode(NodeCode nodeCode, String string) throws FaverChipNodeException {
        this.manager.removeNode(nodeCode, string);
    }

    @Override
    public void checkFreeBlock(NodeCode nodeCode, int n) throws FaverChipNodeException {
        this.manager.checkFreeBlock(nodeCode, n);
    }

    @Override
    public void setSystemBlocks(NodeCode nodeCode) throws FaverChipNodeException {
        this.manager.setSystemBlocks((NodeCodeSystem)nodeCode);
    }

    @Override
    public void compareUnusedBlock(NodeCode nodeCode, String string) throws FaverChipNodeException {
        this.manager.compareUnusedBlock((NodeCodeArea)nodeCode, string);
    }
}

