/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar.iapplibrary;

import com.nttdocomo.dojaemu.ktoolbar.iapplibrary.IAppLibFileList;
import com.nttdocomo.dojaemu.ktoolbar.iapplibrary.IAppLibFileToStr;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;

class IAppLibManager {
    private Vector wholeList = null;
    private TreeSet forwardingList = null;
    private ArrayList forwardingCmpList = null;
    private ArrayList backlogList = null;
    private ArrayList backlogCmpList = null;
    private String rootDir = null;
    private static final String CLASS_EXTENSION = ".class";
    private static final char PACKAGE_SEPARATE = '/';
    static final int WHOLE_LIST = 0;
    static final int BACKLOG_LIST = 1;
    static final int FORWARDING_LIST = 2;

    IAppLibManager(String string) {
        this.rootDir = string + File.separator;
        try {
            IAppLibFileList iAppLibFileList = new IAppLibFileList(string);
            ArrayList arrayList = iAppLibFileList.getFileList(CLASS_EXTENSION);
            this.init(arrayList);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    private void init(Collection collection) {
        this.wholeList = new Vector(collection);
        this.forwardingList = new TreeSet();
        this.forwardingCmpList = new ArrayList();
        this.backlogList = new ArrayList();
        this.backlogCmpList = new ArrayList();
        Enumeration enumeration = this.wholeList.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (this.backlogList.contains(string)) continue;
            this.backlogList.add(string);
        }
        this.createBackLogCmpList();
    }

    boolean forwarding(String string) {
        boolean bl = false;
        if (string == null || string.length() == 0) {
            return bl;
        }
        int n = this.backlogList.indexOf(string);
        if (n != -1) {
            this.backlogList.remove(n);
            this.removeBackLogCmpList(string);
            this.forwardingList.add(string);
            this.addForwardingCmpList(string);
            bl = true;
        }
        return bl;
    }

    private void createBackLogCmpList() {
        Iterator iterator = this.backlogList.iterator();
        while (iterator.hasNext()) {
            String string = IAppLibFileToStr.getCutName((String)iterator.next(), this.rootDir, CLASS_EXTENSION);
            string = string.replace(File.separatorChar, '/');
            this.backlogCmpList.add(string);
        }
    }

    private void addForwardingCmpList(String string) {
        String string2 = IAppLibFileToStr.getCutName(string, this.rootDir, CLASS_EXTENSION);
        string2 = string2.replace(File.separatorChar, '/');
        this.forwardingCmpList.add(string2);
    }

    private void createForwardinCmpList() {
        Iterator iterator = this.forwardingList.iterator();
        while (iterator.hasNext()) {
            String string = IAppLibFileToStr.getCutName((String)iterator.next(), this.rootDir, CLASS_EXTENSION);
            string = string.replace(File.separatorChar, '/');
            this.forwardingCmpList.add(string);
        }
    }

    private void removeBackLogCmpList(String string) {
        String string2 = IAppLibFileToStr.getCutName(string, this.rootDir, CLASS_EXTENSION);
        int n = this.backlogCmpList.indexOf(string2 = string2.replace(File.separatorChar, '/'));
        if (n != -1) {
            this.backlogCmpList.remove(n);
        } else {
            this.backlogCmpList.clear();
            this.createBackLogCmpList();
        }
    }

    String[] getListForCompare(int n) {
        String[] stringArray = null;
        switch (n) {
            case 0: {
                break;
            }
            case 2: {
                stringArray = this.getForwardingCmpList();
                break;
            }
            case 1: {
                stringArray = this.getBacklogCmpList();
            }
        }
        return stringArray;
    }

    String[] getList(int n) {
        String[] stringArray = null;
        switch (n) {
            case 0: {
                stringArray = this.getWholeList();
                break;
            }
            case 1: {
                stringArray = this.getBacklogList();
                break;
            }
            case 2: {
                stringArray = this.getForwardingList();
            }
        }
        return stringArray;
    }

    int size() {
        return this.size(0);
    }

    int size(int n) {
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = this.wholeList.size();
                break;
            }
            case 2: {
                n2 = this.forwardingList.size();
                break;
            }
            case 1: {
                n2 = this.backlogList.size();
            }
        }
        return n2;
    }

    boolean contains(int n, String string) {
        boolean bl = false;
        switch (n) {
            case 0: {
                bl = this.wholeList.contains(string);
                break;
            }
            case 2: {
                bl = this.forwardingList.contains(string);
                break;
            }
            case 1: {
                bl = this.backlogList.contains(string);
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    boolean containsCmp(int n, String string) {
        boolean bl = false;
        switch (n) {
            case 0: {
                bl = false;
                break;
            }
            case 2: {
                bl = this.forwardingCmpList.contains(string);
                break;
            }
            case 1: {
                bl = this.backlogCmpList.contains(string);
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private String[] getWholeList() {
        return this.wholeList.toArray(new String[0]);
    }

    private String[] getForwardingList() {
        return this.forwardingList.toArray(new String[0]);
    }

    private String[] getForwardingCmpList() {
        return this.forwardingCmpList.toArray(new String[0]);
    }

    private String[] getBacklogList() {
        return this.backlogList.toArray(new String[0]);
    }

    private String[] getBacklogCmpList() {
        return this.backlogCmpList.toArray(new String[0]);
    }

    void clearList(int n) {
        switch (n) {
            case 0: {
                this.wholeList.clear();
                break;
            }
            case 2: {
                this.forwardingList.clear();
                this.forwardingCmpList.clear();
                break;
            }
            case 1: {
                this.backlogList.clear();
                this.backlogCmpList.clear();
            }
        }
    }

    String getRootDir() {
        return this.rootDir.substring(0, this.rootDir.length() - 1);
    }
}

