/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar.scratchpad;

import com.nttdocomo.dojaemu.ktoolbar.scratchpad.SPEditManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

class SPWindowData {
    private File spFile;
    private byte[] originData;
    private StringBuffer editData;
    private byte[] saveData = null;
    public boolean editflag;
    private SPEditManager manager;

    public SPWindowData(File file) throws IOException {
        if (!file.canRead()) {
            throw new IOException("Illegal Data");
        }
        int n = (int)file.length();
        this.originData = new byte[n];
        FileInputStream fileInputStream = new FileInputStream(file);
        fileInputStream.read(this.originData, 0, n);
        fileInputStream.close();
        this.spFile = file;
        this.editflag = false;
        this.init();
    }

    public SPWindowData(SPEditManager sPEditManager) {
        this.manager = sPEditManager;
        int n = sPEditManager.getCurrentLength();
        this.originData = new byte[n];
        this.originData = sPEditManager.getDataByteArray();
        this.editflag = false;
        this.init();
    }

    public void init() {
        int n = this.originData.length;
        String string = "";
        this.editData = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            int n2 = this.originData[i] < 0 ? 256 + this.originData[i] : this.originData[i];
            string = Integer.toHexString(n2);
            if (string.length() == 1) {
                this.editData.append("0");
            }
            this.editData.append(string.toUpperCase());
        }
    }

    public String getHexString(int n, int n2) {
        if (n2 <= 0 || n < 0 || this.originData.length < n + n2) {
            return "";
        }
        return this.editData.substring(n * 2, n * 2 + n2 * 2);
    }

    public byte hexStrToByte(String string) {
        if (string == null) {
            return 0;
        }
        char[] cArray = string.toCharArray();
        int n = 1;
        int n2 = 0;
        for (int i = string.length() - 1; i >= 0; --i) {
            switch (cArray[i]) {
                case '0': {
                    n2 += n * 0;
                    break;
                }
                case '1': {
                    n2 += n * 1;
                    break;
                }
                case '2': {
                    n2 += n * 2;
                    break;
                }
                case '3': {
                    n2 += n * 3;
                    break;
                }
                case '4': {
                    n2 += n * 4;
                    break;
                }
                case '5': {
                    n2 += n * 5;
                    break;
                }
                case '6': {
                    n2 += n * 6;
                    break;
                }
                case '7': {
                    n2 += n * 7;
                    break;
                }
                case '8': {
                    n2 += n * 8;
                    break;
                }
                case '9': {
                    n2 += n * 9;
                    break;
                }
                case 'A': 
                case 'a': {
                    n2 += n * 10;
                    break;
                }
                case 'B': 
                case 'b': {
                    n2 += n * 11;
                    break;
                }
                case 'C': 
                case 'c': {
                    n2 += n * 12;
                    break;
                }
                case 'D': 
                case 'd': {
                    n2 += n * 13;
                    break;
                }
                case 'E': 
                case 'e': {
                    n2 += n * 14;
                    break;
                }
                case 'F': 
                case 'f': {
                    n2 += n * 15;
                }
            }
            n *= 16;
        }
        return (byte)n2;
    }

    public byte[] hexStrToByteArray(String string) {
        if (string == null) {
            return new byte[0];
        }
        int n = string.length();
        if (n == 0) {
            return new byte[0];
        }
        int n2 = n / 2;
        byte[] byArray = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            byArray[i] = this.hexStrToByte(string.substring(2 * i, 2 * i + 2));
        }
        return byArray;
    }

    public void dataReplace(int n, String string) {
        if (string == null) {
            return;
        }
        try {
            this.editData.replace(n, n + string.length(), string.toUpperCase());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void update(String string) {
        int n = string.length();
        this.editData.replace(0, n, string.toUpperCase());
        this.saveData = this.hexStrToByteArray(this.editData.toString());
        this.manager.setDataByteArray(this.saveData);
    }

    public void updateSaveData() {
        this.saveData = this.hexStrToByteArray(this.editData.toString());
    }

    public void save() throws FileNotFoundException, IOException {
        this.manager.storeToFile(this.saveData);
    }

    public byte[] getOriginData() {
        return this.originData;
    }
}

