/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar.starfileschecker;

import com.nttdocomo.dojaemu.ktoolbar.classFileStructure.Code;
import com.nttdocomo.dojaemu.ktoolbar.classFileStructure.ConstantPool;
import com.nttdocomo.dojaemu.ktoolbar.classFileStructure.JavaClass;
import com.nttdocomo.dojaemu.ktoolbar.classFileStructure.Method;
import com.nttdocomo.dojaemu.ktoolbar.classFileStructure.ParentInfo;
import com.nttdocomo.dojaemu.ktoolbar.starfileschecker.ClassFileAttribute;
import com.nttdocomo.dojaemu.ktoolbar.starfileschecker.DetectVariousKeyWordInfo;
import com.nttdocomo.dojaemu.ktoolbar.starfileschecker.KeyWord;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

class AnalysisUseKeyWord {
    final int CP_TAG_UTF8 = 1;
    final int CP_TAG_INTEGER = 3;
    final int CP_TAG_FLOAT = 4;
    final int CP_TAG_LONG = 5;
    final int CP_TAG_DOUBLE = 6;
    final int CP_TAG_CLASS = 7;
    final int CP_TAG_STRING = 8;
    final int CP_TAG_FIELD_REF = 9;
    final int CP_TAG_METHOD_REF = 10;
    final int CP_TAG_INTERFACE_REF = 11;
    final int CP_TAG_NAME_AND_TYPE = 12;
    final int INVOKE_INDEX_NUMBER = 0;
    final int INVOKE_INDEX_MNEMONIC = 1;
    final int INVOKE_INDEX_CLASS = 2;
    final int INVOKE_INDEX_METHOD = 3;
    final int INVOKE_INDEX_TYPE = 4;
    final int ANALYSIS_CP = 1;
    final int ANALYSIS_METHOD = 2;
    final int ANALYSIS_METHOD_STATIC = 3;
    private ArrayList targetList;
    private ArrayList workList;
    private ArrayList resultList;
    private ArrayList keyWordList;
    private Hashtable entryList;
    final String DELIMITER_SLASH = "/";
    private final int INDEX_METHOD_NAME = 0;
    private final int INDEX_METHOD_PARAMETER = 1;
    private final String[][] CHECK_PARAMETER_METHOD = new String[][]{{"use", "([Lcom/docomostar/media/MediaSound;Z)V"}};
    private final int INDEX_CLASS_CHILD = 0;
    private final int INDEX_CLASS_ABSTRACT = 1;
    private final String[][] CHECK_ABSTRACT_METHOD = new String[][]{{"com/docomostar/ui/Canvas", "com/docomostar/ui/Frame"}};

    AnalysisUseKeyWord(ArrayList arrayList) {
        this.targetList = arrayList;
        this.keyWordList = new ArrayList();
        this.workList = null;
        this.resultList = null;
        this.entryList = null;
    }

    void addKeyWord(KeyWord keyWord) {
        this.keyWordList.add(keyWord);
    }

    void analysis() {
        ClassFileAttribute classFileAttribute = null;
        Object var3_2 = null;
        this.workList = new ArrayList();
        int n = this.targetList.size();
        Hashtable hashtable = this.preAnalysis();
        for (int i = 0; i < n; ++i) {
            classFileAttribute = (ClassFileAttribute)this.targetList.get(i);
            this.analysis(classFileAttribute, hashtable);
        }
        this.eliminateOverlap();
    }

    void analysis(ClassFileAttribute classFileAttribute, Hashtable hashtable) {
        this.analysisConstantPool(classFileAttribute, hashtable);
        this.analysisMethod(classFileAttribute, hashtable);
    }

    private void analysisConstantPool(ClassFileAttribute classFileAttribute, Hashtable hashtable) {
        String string = null;
        String[] stringArray = null;
        ConstantPool constantPool = null;
        DetectVariousKeyWordInfo detectVariousKeyWordInfo = null;
        JavaClass javaClass = null;
        String[] stringArray2 = null;
        ParentInfo parentInfo = null;
        javaClass = classFileAttribute.getClassObject();
        if (javaClass == null) {
            return;
        }
        string = javaClass.getClassName();
        int n = javaClass.getConstantPoolCount();
        block8: for (int i = 0; i < n; ++i) {
            constantPool = javaClass.getConstantPool(i);
            if (constantPool == null) continue;
            int n2 = constantPool.getTag();
            switch (n2) {
                case 1: 
                case 9: 
                case 12: {
                    int n3;
                    stringArray = this.parseClassName(constantPool.getDetailString());
                    for (n3 = 0; n3 < stringArray.length; ++n3) {
                        if (stringArray[n3] == null) continue;
                        detectVariousKeyWordInfo = new DetectVariousKeyWordInfo(101);
                        detectVariousKeyWordInfo.setTargetLibName(classFileAttribute.getLibrary());
                        detectVariousKeyWordInfo.setTargetClassName(string);
                        detectVariousKeyWordInfo.setTargetClassFile(classFileAttribute.getName());
                        detectVariousKeyWordInfo.setClassName(stringArray[n3]);
                        this.workList.add(detectVariousKeyWordInfo);
                    }
                    continue block8;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    continue block8;
                }
                case 7: {
                    int n3;
                    if (this.isHit(1, constantPool.getDetailString())) {
                        detectVariousKeyWordInfo = new DetectVariousKeyWordInfo(101);
                        detectVariousKeyWordInfo.setTargetLibName(classFileAttribute.getLibrary());
                        detectVariousKeyWordInfo.setTargetClassName(string);
                        detectVariousKeyWordInfo.setTargetClassFile(classFileAttribute.getName());
                        detectVariousKeyWordInfo.setClassName(constantPool.getDetailString());
                        this.workList.add(detectVariousKeyWordInfo);
                    }
                    if (!hashtable.containsKey(constantPool.getDetailString())) {
                        return;
                    }
                    parentInfo = (ParentInfo)hashtable.get(constantPool.getDetailString());
                    stringArray2 = parentInfo.getParentInterfaceNameArray();
                    for (n3 = 0; n3 < stringArray2.length; ++n3) {
                        if (!this.isHit(1, stringArray2[n3])) continue;
                        detectVariousKeyWordInfo = new DetectVariousKeyWordInfo(1);
                        detectVariousKeyWordInfo.setTargetLibName(classFileAttribute.getLibrary());
                        detectVariousKeyWordInfo.setTargetClassName(string);
                        detectVariousKeyWordInfo.setTargetClassFile(classFileAttribute.getName());
                        detectVariousKeyWordInfo.setClassName(stringArray2[n3]);
                        this.workList.add(detectVariousKeyWordInfo);
                    }
                    continue block8;
                }
                case 8: {
                    continue block8;
                }
                case 10: {
                    continue block8;
                }
                case 11: {
                    continue block8;
                }
            }
        }
    }

    private void analysisMethod(ClassFileAttribute classFileAttribute, Hashtable hashtable) {
        Method[] methodArray = null;
        Code code = null;
        DetectVariousKeyWordInfo detectVariousKeyWordInfo = null;
        JavaClass javaClass = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        Object var10_10 = null;
        ParentInfo parentInfo = null;
        boolean bl = false;
        int n = -1;
        javaClass = classFileAttribute.getClassObject();
        if (javaClass == null) {
            return;
        }
        string2 = javaClass.getClassName();
        methodArray = javaClass.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            code = methodArray[i].getCodes();
            string = methodArray[i].getMethodSignature();
            if (code == null) continue;
            Vector vector = code.getDetailArray();
            Iterator iterator = vector.iterator();
            String string4 = "";
            while (iterator.hasNext()) {
                Vector vector2 = (Vector)iterator.next();
                String string5 = vector2.get(1).toString();
                if (string5.startsWith("invoke")) {
                    if (hashtable.containsKey(vector2.get(2).toString())) {
                        parentInfo = (ParentInfo)hashtable.get(vector2.get(2).toString());
                        string3 = parentInfo.getParentClassName();
                    } else {
                        string3 = vector2.get(2).toString();
                    }
                    if ((n = this.isHit(2, string3, vector2.get(3).toString(), vector2.get(4).toString())) == -1) continue;
                    detectVariousKeyWordInfo = new DetectVariousKeyWordInfo(1);
                    detectVariousKeyWordInfo.setTargetLibName(classFileAttribute.getLibrary());
                    detectVariousKeyWordInfo.setTargetClassName(string2);
                    detectVariousKeyWordInfo.setTargetClassFile(classFileAttribute.getName());
                    detectVariousKeyWordInfo.setTargetMethodName(string);
                    detectVariousKeyWordInfo.setClassName(string3);
                    if (n == 3) {
                        detectVariousKeyWordInfo.setMethodName(vector2.get(3).toString());
                    }
                    detectVariousKeyWordInfo.setMethodType(vector2.get(4).toString());
                    this.workList.add(detectVariousKeyWordInfo);
                    continue;
                }
                if (string5.startsWith("instanceof")) {
                    if (!this.isHit(2, vector2.get(2).toString())) continue;
                    detectVariousKeyWordInfo = new DetectVariousKeyWordInfo(2);
                    detectVariousKeyWordInfo.setTargetLibName(classFileAttribute.getLibrary());
                    detectVariousKeyWordInfo.setTargetClassName(string2);
                    detectVariousKeyWordInfo.setTargetClassFile(classFileAttribute.getName());
                    detectVariousKeyWordInfo.setTargetMethodName(string);
                    detectVariousKeyWordInfo.setClassName(vector2.get(2).toString());
                    this.workList.add(detectVariousKeyWordInfo);
                    continue;
                }
                if (string5.startsWith("checkcast")) {
                    if (!this.isHit(2, vector2.get(2).toString())) continue;
                    detectVariousKeyWordInfo = new DetectVariousKeyWordInfo(3);
                    detectVariousKeyWordInfo.setTargetLibName(classFileAttribute.getLibrary());
                    detectVariousKeyWordInfo.setTargetClassName(string2);
                    detectVariousKeyWordInfo.setTargetClassFile(classFileAttribute.getName());
                    detectVariousKeyWordInfo.setTargetMethodName(string);
                    detectVariousKeyWordInfo.setClassName(vector2.get(2).toString());
                    this.workList.add(detectVariousKeyWordInfo);
                    continue;
                }
                if (!string5.equals("putstatic") && !string5.equals("getstatic") || !this.isHit(3, vector2)) continue;
                detectVariousKeyWordInfo = new DetectVariousKeyWordInfo(4);
                detectVariousKeyWordInfo.setTargetLibName(classFileAttribute.getLibrary());
                detectVariousKeyWordInfo.setTargetClassName(string2);
                detectVariousKeyWordInfo.setTargetClassFile(classFileAttribute.getName());
                detectVariousKeyWordInfo.setTargetMethodName(string);
                String string6 = vector2.get(3).toString();
                string6 = string6.substring("class$".length());
                string6 = string6.replace('$', '/');
                detectVariousKeyWordInfo.setClassName(string6);
                this.workList.add(detectVariousKeyWordInfo);
            }
        }
    }

    private String[] parseClassName(String string) {
        int n = this.keyWordList.size();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null || string.length() < 1) {
            return new String[0];
        }
        for (int i = 0; i < n; ++i) {
            KeyWord keyWord = (KeyWord)this.keyWordList.get(i);
            int n2 = keyWord.getType();
            String string2 = keyWord.getKey();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                int n3 = string3.indexOf("L" + string2);
                if (n3 == -1) continue;
                if (n2 == 1) {
                    arrayList.add(string3.substring(n3 + 1));
                    continue;
                }
                if (n2 != 2 || !string2.equals(string3.substring(n3 + 1))) continue;
                arrayList.add(string3.substring(n3 + 1));
            }
        }
        return arrayList.toArray(new String[0]);
    }

    private boolean isHit(int n, Vector vector) {
        boolean bl = false;
        if (n == 3) {
            int n2 = this.keyWordList.size();
            if (!vector.get(4).toString().equals("Ljava/lang/Class;")) {
                return false;
            }
            String string = vector.get(3).toString();
            for (int i = 0; i < n2; ++i) {
                KeyWord keyWord = (KeyWord)this.keyWordList.get(i);
                int n3 = keyWord.getType();
                String string2 = keyWord.getKey();
                string2 = "class$" + string2.replace('/', '$');
                if (!(n3 == 1 ? string.startsWith(string2) : n3 == 2 && string.equals(string2))) continue;
                return true;
            }
        }
        return bl;
    }

    private boolean isHit(int n, String string) {
        boolean bl;
        block3: {
            block2: {
                bl = false;
                if (n != 1) break block2;
                int n2 = this.keyWordList.size();
                for (int i = 0; i < n2; ++i) {
                    KeyWord keyWord = (KeyWord)this.keyWordList.get(i);
                    int n3 = keyWord.getType();
                    String string2 = keyWord.getKey();
                    if (!(n3 == 1 ? string.startsWith(string2) : n3 == 2 && string.equals(string2))) continue;
                    return true;
                }
                break block3;
            }
            if (n != 2) break block3;
            int n4 = this.keyWordList.size();
            for (int i = 0; i < n4; ++i) {
                KeyWord keyWord = (KeyWord)this.keyWordList.get(i);
                int n5 = keyWord.getType();
                String string3 = keyWord.getKey();
                if (!(n5 == 1 ? string.startsWith(string3) : n5 == 2 && string.equals(string3))) continue;
                return true;
            }
        }
        return bl;
    }

    private int isHit(int n, String string, String string2, String string3) {
        int n2;
        block3: {
            block2: {
                n2 = -1;
                if (n != 1) break block2;
                int n3 = this.keyWordList.size();
                for (int i = 0; i < n3; ++i) {
                    KeyWord keyWord = (KeyWord)this.keyWordList.get(i);
                    int n4 = keyWord.getType();
                    String string4 = keyWord.getKey();
                    if (!(n4 == 1 ? string.startsWith(string4) : (n4 == 2 ? string.equals(string4) : n4 == 3 && this.isHitMethod(string4, string, string2, string3)))) continue;
                    return n4;
                }
                break block3;
            }
            if (n != 2) break block3;
            int n5 = this.keyWordList.size();
            for (int i = 0; i < n5; ++i) {
                KeyWord keyWord = (KeyWord)this.keyWordList.get(i);
                int n6 = keyWord.getType();
                String string5 = keyWord.getKey();
                if (!(n6 == 1 ? string.startsWith(string5) : (n6 == 2 ? string.equals(string5) : n6 == 3 && this.isHitMethod(string5, string, string2, string3)))) continue;
                return n6;
            }
        }
        return n2;
    }

    private boolean isHitMethod(String string, String string2, String string3, String string4) {
        boolean bl = false;
        if ((string2 + "/" + string3).equals(string)) {
            for (int i = 0; i < this.CHECK_PARAMETER_METHOD.length; ++i) {
                if (string3.equals(this.CHECK_PARAMETER_METHOD[i][0])) {
                    if (!string4.equals(this.CHECK_PARAMETER_METHOD[i][1])) continue;
                    return true;
                }
                return true;
            }
        }
        return bl;
    }

    void setLibHashtable(Hashtable hashtable) {
        this.entryList = hashtable;
    }

    private void eliminateOverlap() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        this.resultList = new ArrayList();
        if (this.entryList != null) {
            for (int i = 0; i < this.workList.size(); ++i) {
                DetectVariousKeyWordInfo detectVariousKeyWordInfo = (DetectVariousKeyWordInfo)this.workList.get(i);
                String string = detectVariousKeyWordInfo.getTargetClassName();
                String string2 = detectVariousKeyWordInfo.getClassName();
                String string3 = detectVariousKeyWordInfo.getMethodName();
                if (string == null || string2 == null || !this.entryList.containsKey(string + ".class")) continue;
                String string4 = (String)this.entryList.get(string + ".class");
                if (string3 != null) {
                    if (hashtable.put(string + string2 + string3, "ok") != null) continue;
                    detectVariousKeyWordInfo.setTargetLibName(string4);
                    this.resultList.add(detectVariousKeyWordInfo);
                    continue;
                }
                if (hashtable.put(string + string2, "ok") != null) continue;
                detectVariousKeyWordInfo.setTargetLibName(string4);
                this.resultList.add(detectVariousKeyWordInfo);
            }
        } else {
            for (int i = 0; i < this.workList.size(); ++i) {
                DetectVariousKeyWordInfo detectVariousKeyWordInfo = (DetectVariousKeyWordInfo)this.workList.get(i);
                String string = detectVariousKeyWordInfo.getTargetClassName();
                String string5 = detectVariousKeyWordInfo.getClassName();
                String string6 = detectVariousKeyWordInfo.getMethodName();
                if (string == null || string5 == null) continue;
                if (string6 != null) {
                    if (hashtable.put(string + string5 + string6, "ok") != null) continue;
                    this.resultList.add(detectVariousKeyWordInfo);
                    continue;
                }
                if (hashtable.put(string + string5, "ok") != null) continue;
                this.resultList.add(detectVariousKeyWordInfo);
            }
        }
    }

    ArrayList getResultList() {
        return this.resultList;
    }

    private Hashtable preAnalysis() {
        Object object;
        String[] stringArray;
        Object object2;
        Object object3;
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        Hashtable<String[], Object> hashtable2 = new Hashtable<String[], Object>();
        Hashtable<String[], String[]> hashtable3 = new Hashtable<String[], String[]>();
        for (int i = 0; i < this.targetList.size(); ++i) {
            object3 = (ClassFileAttribute)this.targetList.get(i);
            object2 = ((ClassFileAttribute)object3).getClassObject();
            stringArray = ((JavaClass)object2).getClassName();
            object = ((JavaClass)object2).getSuperClassName();
            String[] stringArray2 = ((JavaClass)object2).getSuperInterfaceName();
            for (int j = 0; j < this.CHECK_ABSTRACT_METHOD.length; ++j) {
                if (!((String)object).equals(this.CHECK_ABSTRACT_METHOD[j][0])) continue;
                object = this.CHECK_ABSTRACT_METHOD[j][1];
            }
            hashtable2.put(stringArray, object);
            if (stringArray2 == null) continue;
            hashtable3.put(stringArray, stringArray2);
        }
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            object3 = (String)enumeration.nextElement();
            object2 = this.findParentClass(hashtable2, (String)object3);
            stringArray = this.findParentInterface(hashtable3, (String)object3);
            object = new ParentInfo((String)object2, stringArray);
            hashtable.put(object3, object);
        }
        return hashtable;
    }

    private String findParentClass(Hashtable hashtable, String string) {
        if (hashtable.containsKey(string)) {
            String string2 = (String)hashtable.get(string);
            string = this.findParentClass(hashtable, string2);
        }
        return string;
    }

    private String[] findParentInterface(Hashtable hashtable, String string) {
        String[] stringArray = null;
        String[] stringArray2 = null;
        Vector<String> vector = new Vector<String>();
        if (hashtable.containsKey(string)) {
            int n;
            String[] stringArray3 = (String[])hashtable.get(string);
            for (int i = 0; i < stringArray3.length; ++i) {
                stringArray = this.findParentInterface(hashtable, stringArray3[i]);
                for (n = 0; n < stringArray.length; ++n) {
                    vector.addElement(stringArray[n]);
                }
            }
            stringArray2 = new String[vector.size()];
            Enumeration enumeration = vector.elements();
            n = 0;
            while (enumeration.hasMoreElements()) {
                stringArray2[n] = (String)enumeration.nextElement();
                ++n;
            }
        } else {
            stringArray2 = new String[]{string};
        }
        return stringArray2;
    }
}

