/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar.starfileschecker;

import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.classFileStructure.JavaClass;
import com.nttdocomo.dojaemu.ktoolbar.starfileschecker.AbstractChecker;
import com.nttdocomo.dojaemu.ktoolbar.starfileschecker.AnalysisUseKeyWord;
import com.nttdocomo.dojaemu.ktoolbar.starfileschecker.CheckException;
import com.nttdocomo.dojaemu.ktoolbar.starfileschecker.ClassFileAttribute;
import com.nttdocomo.dojaemu.ktoolbar.starfileschecker.DetectVariousKeyWordInfo;
import com.nttdocomo.dojaemu.ktoolbar.starfileschecker.KeyWord;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.TreeSet;
import java.util.Vector;

class CheckUseMiniAppDisableClass
extends AbstractChecker {
    protected final String PAC_DOCOMOSTAR = "com/docomostar/";
    protected final String PAC_DEVICE = "com/docomostar/device/";
    protected final String PAC_FELICA = "com/docomostar/device/felica/";
    protected final String PAC_GESTUREREADER = "com/docomostar/device/gesturereader/";
    protected final String PAC_LOCATION = "com/docomostar/device/location/";
    protected final String PAC_FS = "com/docomostar/fs/";
    protected final String PAC_SD = "com/docomostar/fs/sd/";
    protected final String PAC_IO = "com/docomostar/io/";
    protected final String PAC_LANG = "com/docomostar/lang/";
    protected final String PAC_MEDIA = "com/docomostar/media/";
    protected final String PAC_AVCONTENT = "com/docomostar/media/avcontent/";
    protected final String PAC_SECURITY = "com/docomostar/security/";
    protected final String PAC_SYSTEM = "com/docomostar/system/";
    protected final String PAC_UI = "com/docomostar/ui/";
    protected final String PAC_AVPLAYER = "com/docomostar/ui/avplayer/";
    protected final String PAC_FLASH = "com/docomostar/ui/flashplayer/";
    protected final String PAC_G3D = "com/docomostar/ui/graphics3d/";
    protected final String PAC_OGL = "com/docomostar/ui/ogl/";
    protected final String PAC_MATH = "com/docomostar/ui/ogl/math/";
    protected final String PAC_S3D = "com/docomostar/ui/sound3d/";
    protected final String PAC_U3D = "com/docomostar/ui/util3d/";
    protected final String PAC_OPT = "com/docomostar/opt/";
    protected final String PAC_OPT_DEVICE = "com/docomostar/opt/device/";
    protected final String PAC_OPT_LOCATION = "com/docomostar/opt/device/location/";
    protected final String PAC_OPT_SYSTEM = "com/docomostar/opt/system/";
    protected final String PAC_OPT_FORMANL = "com/docomostar/opt/system/formanalyzer/";
    protected final String PAC_OPT_UI = "com/docomostar/opt/ui/";
    protected final String PAC_OPT_ERUPTION = "com/docomostar/opt/ui/eruption/";
    protected final String PAC_OPT_UI_J3D = "com/docomostar/opt/ui/j3d/";
    protected final String PAC_OPT_UI_OGL = "com/docomostar/opt/ui/ogl/";
    protected final String PAC_OPT_STEREO = "com/docomostar/opt/ui/stereoscope/";
    protected final String CLASS_REMOTEDEVICE = "RemoteDevice/";
    protected final String CLASS_ADHOC = "AdhocDataTransfer/";
    protected final String CLASS_TRKLISTENER = "TrackingListener/";
    protected final String CLASS_AVATARDATA = "AvatarData/";
    protected final String CLASS_MEDIAMOVIE = "MediaMovie/";
    protected final String CLASS_MEDIASOUND = "MediaSound/";
    protected final String CLASS_PHBOOKPARAM = "PhoneBookParam/";
    protected final String CLASS_SCHEDLPARAM = "ScheduleParam/";
    protected final String CLASS_TOUCHEVENT = "TouchEventObject/";
    protected final String CLASS_SAM = "StarApplicationManager/";
    protected final String CLASS_FELICA = "Felica/";
    protected final String CLASS_MEDIAMANAGER = "MediaManager/";
    protected final String CLASS_PHONEBOOK = "PhoneBook/";
    protected final String CLASS_PHONESYSTEM = "PhoneSystem/";
    protected final String CLASS_SCHEDULE = "Schedule/";
    protected final String CLASS_FRAME = "Frame/";
    protected final String CLASS_GRAPHICS = "Graphics/";
    protected final String[] KEY_WORD_PAC = new String[]{"com/docomostar/device/gesturereader/", "com/docomostar/fs/", "com/docomostar/fs/sd/", "com/docomostar/media/avcontent/", "com/docomostar/security/", "com/docomostar/ui/avplayer/", "com/docomostar/ui/flashplayer/", "com/docomostar/ui/graphics3d/", "com/docomostar/ui/ogl/", "com/docomostar/ui/ogl/math/", "com/docomostar/ui/sound3d/", "com/docomostar/ui/util3d/", "com/docomostar/opt/device/location/", "com/docomostar/opt/system/formanalyzer/", "com/docomostar/opt/ui/", "com/docomostar/opt/ui/eruption/", "com/docomostar/opt/ui/j3d/", "com/docomostar/opt/ui/ogl/", "com/docomostar/opt/ui/stereoscope/"};
    protected final String[] KEY_WORD_CLASS = new String[]{"com/docomostar/AudioOutputEvent", "com/docomostar/CalledByDTVEvent", "com/docomostar/FelicaAdhocEvent", "com/docomostar/InvitedEvent", "com/docomostar/device/BTStateListener", "com/docomostar/device/SpeechListener", "com/docomostar/device/SpeechResult", "com/docomostar/device/Bluetooth", "com/docomostar/device/BluetoothConnectionEvent", "com/docomostar/device/BluetoothEvent", "com/docomostar/device/Camera", "com/docomostar/device/CodeReader", "com/docomostar/device/DeviceDiscoveryResult", "com/docomostar/device/RawImageCapture", "com/docomostar/device/SpeechAssistantInformation", "com/docomostar/device/SpeechFeatureData", "com/docomostar/device/SpeechRecognizer", "com/docomostar/device/SpeechResultInformation", "com/docomostar/device/SpeechResultNBEST", "com/docomostar/device/StorageDevice", "com/docomostar/device/TouchDevice", "com/docomostar/device/BluetoothException", "com/docomostar/device/felica/FelicaPushedEvent", "com/docomostar/device/felica/ConnectionRefusedException", "com/docomostar/device/location/AccelerationEventListener", "com/docomostar/device/location/AccelerationData", "com/docomostar/device/location/AccelerationSensor", "com/docomostar/device/location/Compass", "com/docomostar/device/location/GyroData", "com/docomostar/device/location/GyroSensor", "com/docomostar/device/location/WalkingNavigation", "com/docomostar/device/location/WalkingNavigationData", "com/docomostar/io/BTConnection", "com/docomostar/io/ClientObexConnection", "com/docomostar/io/DDPConnection", "com/docomostar/io/HDPConnection", "com/docomostar/io/ObexConnection", "com/docomostar/io/RandomAccessible", "com/docomostar/io/ServerObexConnection", "com/docomostar/io/SocketConnection", "com/docomostar/io/SPPConnection", "com/docomostar/io/UDPDatagramConnection", "com/docomostar/io/FelicaClientObexConnection", "com/docomostar/io/FelicaServerObexConnection", "com/docomostar/io/FileDataInput", "com/docomostar/io/FileDataOutput", "com/docomostar/io/FileEntity", "com/docomostar/io/IrClientObexConnection", "com/docomostar/io/IrServerObexConnection", "com/docomostar/io/MCAPDataEndPoint", "com/docomostar/lang/ByteArrayClassLoader", "com/docomostar/lang/MemoryManager", "com/docomostar/media/EncodedImage", "com/docomostar/system/ApplicationStore", "com/docomostar/system/AutoPositioning", "com/docomostar/system/AutoPositioningParam", "com/docomostar/system/AvatarStore", "com/docomostar/system/Bookmark", "com/docomostar/system/CertificateStore", "com/docomostar/system/Contents", "com/docomostar/system/ContentsDownloader", "com/docomostar/system/DataBoxFolder", "com/docomostar/system/ImageStore", "com/docomostar/system/Invitation", "com/docomostar/system/InvitationParam", "com/docomostar/system/Message", "com/docomostar/system/MessageAgent", "com/docomostar/system/MessageDraft", "com/docomostar/system/MessageFolderChangedEvent", "com/docomostar/system/MessageReceived", "com/docomostar/system/MessageSent", "com/docomostar/system/MovieStore", "com/docomostar/system/NativeMoviePlayer", "com/docomostar/system/PhoneBookGroup", "com/docomostar/system/PhoneTheme", "com/docomostar/system/SoundStore", "com/docomostar/system/Toruca", "com/docomostar/system/TorucaStore", "com/docomostar/system/ContentsException", "com/docomostar/system/InvitationException", "com/docomostar/ui/Audio3DListener", "com/docomostar/ui/Audio3DLocalization", "com/docomostar/ui/ComponentListener", "com/docomostar/ui/FocusManager", "com/docomostar/ui/Interactable", "com/docomostar/ui/KeyListener", "com/docomostar/ui/LayoutManager", "com/docomostar/ui/MediaListener", "com/docomostar/ui/MediaPresenter", "com/docomostar/ui/SoftKeyListener", "com/docomostar/ui/AnchorButton", "com/docomostar/ui/Audio3D", "com/docomostar/ui/AudioPresenter", "com/docomostar/ui/AudioTrackPresenter", "com/docomostar/ui/Button", "com/docomostar/ui/Component", "com/docomostar/ui/Dialog", "com/docomostar/ui/HTMLLayout", "com/docomostar/ui/ImageButton", "com/docomostar/ui/ImageEncoder", "com/docomostar/ui/ImageLabel", "com/docomostar/ui/Label", "com/docomostar/ui/ListBox", "com/docomostar/ui/Panel", "com/docomostar/ui/Synthesizer", "com/docomostar/ui/TextBox", "com/docomostar/ui/Ticker", "com/docomostar/ui/VisualPresenter", "com/docomostar/opt/device/Pulsemeter", "com/docomostar/opt/device/CameraFinder", "com/docomostar/opt/device/CameraPulsemeter", "com/docomostar/opt/device/CodeReader2", "com/docomostar/opt/device/FingerprintAuthenticator", "com/docomostar/opt/device/GyroData", "com/docomostar/opt/device/GyroSensor", "com/docomostar/opt/device/IrReceiver", "com/docomostar/opt/device/IrReceiverParam", "com/docomostar/opt/device/MediaPlayer", "com/docomostar/opt/system/AttachmentData", "com/docomostar/opt/system/MailAgent2", "com/docomostar/opt/system/PhoneSystem2", "com/docomostar/opt/system/AttachmentDataException"};
    protected final String[] KEY_WORD_METHOD = new String[]{"com/docomostar/device/RemoteDevice/SNIFF_MODE", "com/docomostar/device/RemoteDevice/accept", "com/docomostar/device/RemoteDevice/changePowerMode", "com/docomostar/device/RemoteDevice/connect", "com/docomostar/device/RemoteDevice/dispose", "com/docomostar/device/RemoteDevice/getAddress", "com/docomostar/device/RemoteDevice/getDeviceClass", "com/docomostar/device/RemoteDevice/getDeviceDiscoveryResult", "com/docomostar/device/RemoteDevice/getDeviceName", "com/docomostar/device/RemoteDevice/interruptAcceptance", "com/docomostar/device/RemoteDevice/isAvailable", "com/docomostar/device/felica/AdhocDataTransfer/REPLY_ACCEPT", "com/docomostar/device/felica/AdhocDataTransfer/REPLY_REJECT", "com/docomostar/device/felica/AdhocDataTransfer/getAdhocState", "com/docomostar/device/felica/AdhocDataTransfer/getIDm", "com/docomostar/device/felica/AdhocDataTransfer/reply", "com/docomostar/device/felica/AdhocDataTransfer/setup", "com/docomostar/device/felica/AdhocDataTransfer/terminateAdhoc", "com/docomostar/device/location/TrackingListener/locationReceived", "com/docomostar/media/AvatarData/use", "com/docomostar/media/MediaMovie/MP4_AUDIOTRACK", "com/docomostar/media/MediaMovie/MP4_TEXTTRACK", "com/docomostar/media/MediaMovie/MP4_VIDEOTRACK", "com/docomostar/media/MediaMovie/getHeight", "com/docomostar/media/MediaMovie/getWidth", "com/docomostar/media/MediaMovie/use", "com/docomostar/media/MediaSound/AUDIO_3D_RESOURCES", "com/docomostar/media/MediaSound/use", "com/docomostar/system/PhoneBookParam/addMailAddress", "com/docomostar/system/PhoneBookParam/addPhoneNumber", "com/docomostar/system/PhoneBookParam/getGroupId", "com/docomostar/system/PhoneBookParam/getGroupName", "com/docomostar/system/PhoneBookParam/getKana", "com/docomostar/system/PhoneBookParam/getLocation", "com/docomostar/system/PhoneBookParam/getMailAddress", "com/docomostar/system/PhoneBookParam/getMailAddresses", "com/docomostar/system/PhoneBookParam/getName", "com/docomostar/system/PhoneBookParam/getPhoneNumber", "com/docomostar/system/PhoneBookParam/getPhoneNumbers", "com/docomostar/system/PhoneBookParam/setGroupId", "com/docomostar/system/PhoneBookParam/setGroupName", "com/docomostar/system/PhoneBookParam/setKana", "com/docomostar/system/PhoneBookParam/setLocation", "com/docomostar/system/PhoneBookParam/setMailAddresses", "com/docomostar/system/PhoneBookParam/setName", "com/docomostar/system/PhoneBookParam/setPhoneNumbers", "com/docomostar/system/ScheduleParam/getAlarm", "com/docomostar/system/ScheduleParam/getDate", "com/docomostar/system/ScheduleParam/getDescription", "com/docomostar/system/ScheduleParam/getLocation", "com/docomostar/system/ScheduleParam/getSummary", "com/docomostar/system/ScheduleParam/setAlarm", "com/docomostar/system/ScheduleParam/setDate", "com/docomostar/system/ScheduleParam/setDescription", "com/docomostar/system/ScheduleParam/setLocation", "com/docomostar/system/ScheduleParam/setSummary", "com/docomostar/ui/TouchEventObject/TOUCH_MOVED", "com/docomostar/ui/TouchEventObject/TOUCH_PRESSED", "com/docomostar/ui/TouchEventObject/TOUCH_RELEASED", "com/docomostar/ui/TouchEventObject/getPointerId", "com/docomostar/ui/TouchEventObject/getType", "com/docomostar/ui/TouchEventObject/getX", "com/docomostar/ui/TouchEventObject/getY", "com/docomostar/ui/TouchEventObject/getY", "com/docomostar/StarApplicationManager/setLaunchTime", "com/docomostar/StarApplicationManager/getLaunchTime", "com/docomostar/StarApplicationManager/upgrade", "com/docomostar/StarApplicationManager/addRemoteLauncher", "com/docomostar/StarApplicationManager/getRemoteLauncherList", "com/docomostar/StarApplicationManager/removeRemoteLauncher", "com/docomostar/StarApplicationManager/allowAudioOutput", "com/docomostar/StarApplicationManager/isAllowedAudioOutput", "com/docomostar/device/felica/Felica/getAdhocDataTransfer", "com/docomostar/media/MediaManager/getSound", "com/docomostar/media/MediaManager/getAvatarData", "com/docomostar/media/MediaManager/getMovie", "com/docomostar/media/MediaManager/use", "com/docomostar/media/MediaManager/createMediaSound", "com/docomostar/system/PhoneBook/addEntry", "com/docomostar/system/PhoneSystem/playSound", "com/docomostar/system/PhoneSystem/measureRSInfo", "com/docomostar/system/PhoneSystem/getRSCP", "com/docomostar/system/PhoneSystem/getEcNo", "com/docomostar/system/PhoneSystem/setAutoLaunch", "com/docomostar/system/PhoneSystem/getAutoLaunch", "com/docomostar/system/Schedule/getSupportedTypes", "com/docomostar/system/Schedule/getMultiRepeatableTypes", "com/docomostar/system/Schedule/addEntry", "com/docomostar/ui/Frame/setSoftLabelVisible", "com/docomostar/ui/Graphics/drawRawImage", "com/docomostar/ui/Graphics/drawScaledRawImage"};
    protected Hashtable entryList;
    protected ArrayList targetList;
    protected final String DELIMITER_SHARP = "#";

    protected CheckUseMiniAppDisableClass() {
    }

    CheckUseMiniAppDisableClass(String string) throws CheckException {
        this(string, null);
    }

    CheckUseMiniAppDisableClass(String string, Hashtable hashtable) throws CheckException {
        File[] fileArray = null;
        this.path = string;
        this.entryList = hashtable;
        fileArray = this.getFileList(new File(this.path));
        if (fileArray != null) {
            this.targetList = this.getClassList(fileArray);
        }
    }

    @Override
    public String[] doCheck() {
        int n;
        AnalysisUseKeyWord analysisUseKeyWord = null;
        KeyWord keyWord = null;
        ArrayList arrayList = null;
        String[] stringArray = null;
        if (this.targetList == null) {
            return new String[0];
        }
        analysisUseKeyWord = new AnalysisUseKeyWord(this.targetList);
        analysisUseKeyWord.setLibHashtable(this.entryList);
        for (n = 0; n < this.KEY_WORD_PAC.length; ++n) {
            keyWord = new KeyWord(1, this.KEY_WORD_PAC[n]);
            analysisUseKeyWord.addKeyWord(keyWord);
        }
        for (n = 0; n < this.KEY_WORD_CLASS.length; ++n) {
            keyWord = new KeyWord(2, this.KEY_WORD_CLASS[n]);
            analysisUseKeyWord.addKeyWord(keyWord);
        }
        for (n = 0; n < this.KEY_WORD_METHOD.length; ++n) {
            keyWord = new KeyWord(3, this.KEY_WORD_METHOD[n]);
            analysisUseKeyWord.addKeyWord(keyWord);
        }
        analysisUseKeyWord.analysis();
        arrayList = analysisUseKeyWord.getResultList();
        stringArray = this.makeWarningMessage(arrayList);
        return stringArray;
    }

    protected ArrayList getClassList(File[] fileArray) throws CheckException {
        String string = null;
        ArrayList<ClassFileAttribute> arrayList = null;
        JavaClass javaClass = null;
        ClassFileAttribute classFileAttribute = null;
        arrayList = new ArrayList<ClassFileAttribute>();
        for (int i = 0; i < fileArray.length; ++i) {
            string = fileArray[i].getPath();
            javaClass = this.createJavaClass(string);
            classFileAttribute = new ClassFileAttribute(null, string, javaClass);
            arrayList.add(classFileAttribute);
        }
        return arrayList;
    }

    private File[] getFileList(File file) {
        Vector<File> vector = null;
        File[] fileArray = null;
        vector = new Vector<File>();
        fileArray = file.listFiles();
        if (fileArray == null) {
            return null;
        }
        if (fileArray.length == 0) {
            return null;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                File[] fileArray2 = this.getFileList(fileArray[i]);
                if (fileArray2 == null) continue;
                for (int j = 0; j < fileArray2.length; ++j) {
                    vector.addElement(fileArray2[j]);
                }
                continue;
            }
            vector.addElement(fileArray[i]);
        }
        vector.trimToSize();
        if (vector.size() == 0) {
            return null;
        }
        return vector.toArray(new File[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JavaClass createJavaClass(String string) throws CheckException {
        byte[] byArray = null;
        int n = 0;
        long l = 0L;
        File file = null;
        JavaClass javaClass = null;
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        file = new File(string);
        l = file.length();
        if (l <= 0L) {
            return null;
        }
        byArray = new byte[(int)l];
        try {
            fileInputStream = new FileInputStream(string);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            while ((long)(n += bufferedInputStream.read(byArray, n, (int)l - n)) < l) {
            }
            javaClass = new JavaClass(byArray);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new CheckException(1, 1, string);
        }
        catch (IOException iOException) {
            throw new CheckException(1, 3, string);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return javaClass;
    }

    private String[] makeWarningMessage(ArrayList arrayList) {
        int n = arrayList.size();
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < n; ++i) {
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            Object[] objectArray = null;
            String string5 = null;
            DetectVariousKeyWordInfo detectVariousKeyWordInfo = (DetectVariousKeyWordInfo)arrayList.get(i);
            string = detectVariousKeyWordInfo.getTargetLibName();
            string2 = detectVariousKeyWordInfo.getTargetClassName();
            string3 = detectVariousKeyWordInfo.getClassName();
            string4 = detectVariousKeyWordInfo.getMethodName();
            if (string == null) {
                if (string4 == null) {
                    objectArray = new String[]{string2, string3};
                    string5 = Resource.format("WARNING_DISABLED_MINI_APP_IN_STARAPP", objectArray);
                } else {
                    objectArray = new String[]{string2, string3 + "#" + string4};
                    string5 = Resource.format("WARNING_DISABLED_MINI_APP_METHOD_IN_STARAPP", objectArray);
                }
            } else if (string4 == null) {
                objectArray = new String[]{string, string2, string3};
                string5 = Resource.format("WARNING_DISABLED_MINI_APP_IN_STARLIB", objectArray);
            } else {
                objectArray = new String[]{string, string2, string3 + "#" + string4};
                string5 = Resource.format("WARNING_DISABLED_MINI_APP_METHOD_IN_STARLIB", objectArray);
            }
            treeSet.add(string5);
        }
        return treeSet.toArray(new String[0]);
    }
}

