/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar.starfileschecker;

import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.classFileStructure.JavaClass;
import com.nttdocomo.dojaemu.ktoolbar.starfileschecker.CheckException;
import com.nttdocomo.dojaemu.ktoolbar.starfileschecker.CheckUseMiniAppDisableClass;
import com.nttdocomo.dojaemu.ktoolbar.starfileschecker.ClassFileAttribute;
import com.nttdocomo.dojaemu.ktoolbar.starfileschecker.DetectVariousKeyWordInfo;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;

class CheckUseMiniAppDisableJar
extends CheckUseMiniAppDisableClass {
    CheckUseMiniAppDisableJar(String string) throws CheckException {
        this.path = string;
        this.targetList = this.getClassList();
    }

    private void unpack(String string, String string2, boolean bl) throws CheckException {
        FileInputStream fileInputStream = null;
        ZipInputStream zipInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        FileOutputStream fileOutputStream = null;
        String string3 = null;
        try {
            fileInputStream = new FileInputStream(string);
            zipInputStream = new JarInputStream(fileInputStream);
            bufferedInputStream = new BufferedInputStream(zipInputStream);
            JarEntry jarEntry = null;
            byte[] byArray = null;
            int n = 0;
            int n2 = 0;
            File file = null;
            File file2 = null;
            while ((jarEntry = ((JarInputStream)zipInputStream).getNextJarEntry()) != null) {
                string3 = jarEntry.getName();
                n = (int)jarEntry.getSize();
                if (string3.toUpperCase().startsWith("META-INF/")) continue;
                if (jarEntry.isDirectory()) {
                    if (!bl) continue;
                    file = new File(string2 + File.separator + string3);
                    file.mkdir();
                    continue;
                }
                file2 = new File(string2 + File.separator + string3);
                byArray = new byte[n];
                while ((n2 = bufferedInputStream.read(byArray, 0, n)) >= n) {
                    byArray = new byte[n];
                }
                zipInputStream.closeEntry();
                fileOutputStream = new FileOutputStream(file2);
                if (n2 == -1) {
                    n2 = 0;
                }
                fileOutputStream.write(byArray, 0, n2);
                fileOutputStream.flush();
                fileOutputStream.close();
                fileOutputStream = null;
            }
        }
        catch (ZipException zipException) {
            throw new CheckException(2, 2, string3);
        }
        catch (IOException iOException) {
            throw new CheckException(2, 3, string3);
        }
        catch (Exception exception) {
            throw new CheckException(2, 0, string3);
        }
        finally {
            if (zipInputStream != null) {
                try {
                    zipInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private ArrayList getClassList() throws CheckException {
        ArrayList<ClassFileAttribute> arrayList = null;
        JarFile jarFile = null;
        JarEntry jarEntry = null;
        InputStream inputStream = null;
        Enumeration<JarEntry> enumeration = null;
        byte[] byArray = null;
        int n = 0;
        String string = null;
        long l = 0L;
        JavaClass javaClass = null;
        ClassFileAttribute classFileAttribute = null;
        arrayList = new ArrayList<ClassFileAttribute>();
        try {
            jarFile = new JarFile(new File(this.path));
            enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                jarEntry = enumeration.nextElement();
                if (jarEntry.isDirectory() || !(string = jarEntry.getName()).endsWith(".class")) continue;
                l = jarEntry.getSize();
                byArray = new byte[(int)l];
                inputStream = jarFile.getInputStream(jarEntry);
                n = 0;
                while ((long)(n += inputStream.read(byArray, n, (int)l - n)) < l) {
                }
                inputStream.close();
                inputStream = null;
                javaClass = new JavaClass(byArray);
                classFileAttribute = new ClassFileAttribute(this.path, string, javaClass);
                arrayList.add(classFileAttribute);
            }
        }
        catch (ZipException zipException) {
            throw new CheckException(2, 2, string);
        }
        catch (IOException iOException) {
            throw new CheckException(2, 3, string);
        }
        catch (Exception exception) {
            throw new CheckException(2, 0, string);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return arrayList;
    }

    private String[] makeWarningMessage(ArrayList arrayList) {
        int n = arrayList.size();
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < n; ++i) {
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            Object[] objectArray = null;
            String string5 = null;
            DetectVariousKeyWordInfo detectVariousKeyWordInfo = (DetectVariousKeyWordInfo)arrayList.get(i);
            string = detectVariousKeyWordInfo.getTargetLibName();
            string2 = detectVariousKeyWordInfo.getTargetClassName();
            string3 = detectVariousKeyWordInfo.getClassName();
            if (string4 == null) {
                objectArray = new String[]{string, string2, string3};
                string5 = Resource.format("WARNING_DISABLED_MINI_APP_IN_EXE", objectArray);
            } else {
                objectArray = new String[]{string, string2, string3 + "#" + string4};
                string5 = Resource.format("WARNING_DISABLED_MINI_APP_METHOD_IN_EXE", objectArray);
            }
            treeSet.add(string5);
        }
        return treeSet.toArray(new String[0]);
    }
}

