/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar.starfileschecker;

import com.nttdocomo.dojaemu.ktoolbar.Resource;
import com.nttdocomo.dojaemu.ktoolbar.starfileschecker.AbstractChecker;
import com.nttdocomo.dojaemu.ktoolbar.starfileschecker.CheckUseMiniAppDisableClass;
import com.nttdocomo.dojaemu.ktoolbar.starfileschecker.CheckUseMiniAppDisableJar;
import com.nttdocomo.dojaemu.ktoolbar.starfileschecker.StarFilesCheckerException;
import java.util.Hashtable;

public final class StarFilesChecker {
    public static final int ID_UNDEFINED = 0;
    public static final int ID_CLASS_FILES = 1;
    public static final int ID_JAR_FILES = 2;
    public static final int ID_ADF_FILE = 3;
    public static final int ID_SDF_FILE = 4;
    public static final int TYPE_UNDEFINED = 0;
    public static final int TYPE_APP_CLASS = 1;
    public static final int TYPE_LIB_CLASS = 2;
    private int id;
    private int type;
    private String path;
    private Object param;
    private AbstractChecker checkObject;

    public StarFilesChecker() throws StarFilesCheckerException {
        this(0, 0, null, null);
    }

    public StarFilesChecker(int n, int n2, String string, Object object) throws StarFilesCheckerException {
        this.id = n;
        this.type = n2;
        this.path = string;
        this.param = object;
        this.checkObject = null;
        this.init();
    }

    private void init() throws StarFilesCheckerException {
        try {
            switch (this.id) {
                case 1: {
                    if (this.type == 1) {
                        this.checkObject = new CheckUseMiniAppDisableClass(this.path);
                        break;
                    }
                    if (this.type != 2 || !(this.param instanceof Hashtable)) break;
                    this.checkObject = new CheckUseMiniAppDisableClass(this.path, (Hashtable)this.param);
                    break;
                }
                case 2: {
                    if (this.path == null) break;
                    this.checkObject = new CheckUseMiniAppDisableJar(this.path);
                    break;
                }
            }
        }
        catch (Exception exception) {
            String string = "";
            if (this.id == 1) {
                if (this.type == 1) {
                    string = Resource.getString("MINI_APPLI");
                } else if (this.type == 2) {
                    string = Resource.getString("STAR_LIBRARY");
                }
            } else if (this.id == 2) {
                string = Resource.getString("JAVA_LIBRARY");
            }
            throw new StarFilesCheckerException(Resource.format("WARNING_DISABLED_MINI_APP_PROC_ERROR", new String[]{string}));
        }
    }

    public String[] doCheck() {
        String[] stringArray = null;
        String[] stringArray2 = null;
        if (this.checkObject == null) {
            return new String[0];
        }
        stringArray2 = this.checkObject.doCheck();
        if (stringArray2.length > 0) {
            stringArray = new String[stringArray2.length + 1];
            if (this.id == 1) {
                if (this.type == 1) {
                    Object[] objectArray = new String[]{Resource.getString("MINI_APPLI")};
                    stringArray[0] = Resource.format("WARNING_DISABLED_MINI_APP_DETECED", objectArray);
                } else if (this.type == 2) {
                    Object[] objectArray = new String[]{Resource.getString("STAR_LIBRARY")};
                    stringArray[0] = Resource.format("WARNING_DISABLED_MINI_APP_DETECED", objectArray);
                }
            } else if (this.id == 2) {
                if (this.type == 1) {
                    Object[] objectArray = new String[]{Resource.getString("MINI_APPLI")};
                    stringArray[0] = Resource.format("WARNING_DISABLED_MINI_APP_DETECED", objectArray);
                } else {
                    Object[] objectArray = new String[]{Resource.getString("JAVA_LIBRARY")};
                    stringArray[0] = Resource.format("WARNING_DISABLED_MINI_APP_DETECED", objectArray);
                }
            }
            System.arraycopy(stringArray2, 0, stringArray, 1, stringArray2.length);
        }
        return stringArray;
    }
}

