/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar.swing.document;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import javax.swing.text.StyleConstants;

public class HalfLetterAndNumberDocument
extends PlainDocument {
    private int limit;

    public HalfLetterAndNumberDocument(int n) {
        this.limit = n;
    }

    @Override
    public void insertString(int n, String string, AttributeSet attributeSet) {
        String string2 = null;
        int n2 = this.getLength();
        try {
            if (null != attributeSet && attributeSet.isDefined(StyleConstants.ComposedTextAttribute)) {
                super.insertString(n, string, attributeSet);
                return;
            }
            if (n2 >= this.limit) {
                return;
            }
            if (string != null) {
                byte[] byArray = string.getBytes();
                int n3 = string.length();
                if (n3 != byArray.length) {
                    return;
                }
                char[] cArray = string.toCharArray();
                for (int i = 0; i < cArray.length; ++i) {
                    if (Character.isLetterOrDigit(cArray[i])) continue;
                    return;
                }
                string2 = n2 + n3 > this.limit ? string.substring(0, this.limit - n2) : string;
            }
            super.insertString(n, string2, attributeSet);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }
}

