/*
 * Decompiled with CFR 0.152.
 */
package com.nttdocomo.dojaemu.ktoolbar.swing.document;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import javax.swing.text.StyleConstants;

public class LimitedHexDocument
extends PlainDocument {
    public static final int NO_LIMIT = -1;
    private int limit;

    public LimitedHexDocument(int n) {
        this.limit = n;
    }

    @Override
    public void insertString(int n, String string, AttributeSet attributeSet) {
        try {
            if (null != attributeSet && attributeSet.isDefined(StyleConstants.ComposedTextAttribute)) {
                super.insertString(n, string, attributeSet);
                return;
            }
            if (this.limit != -1 && this.getLength() >= this.limit) {
                return;
            }
            if (string != null) {
                byte[] byArray = string.getBytes();
                int n2 = string.length();
                if (n2 != byArray.length) {
                    return;
                }
                try {
                    Integer.parseInt(string, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
            }
            super.insertString(n, string, attributeSet);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }
}

